/*
 * PairingStatus.h
 *
 *  Created on: Jul 06, 2015
 *  Author: Tharani -tnh5cob
 */

#ifndef _PAIRING_STATUS_H_
#define _PAIRING_STATUS_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class PairingStatus
   {
   public:

      PairingStatus();

      PairingStatus(const PairingState& pairingState, const BdAddress& remoteBdAddress,
            const BdName& remoteBdName, const PairingType& pairingType, const PairingPinType& pin,
            const PairingRequestOrigin& origin, const UserConfirmationRequired& userConfirmation,
            const PairingResult& result);

      PairingStatus(const PairingStatus& other);

      ~PairingStatus();

      friend void swap(PairingStatus& first, PairingStatus& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      PairingStatus& operator=(PairingStatus other);

      bool operator==(const PairingStatus& rhs) const;

      bool operator!=(const PairingStatus& rhs) const;

      PairingState _state;
      BdAddress _remoteBdAddress;
      BdName _remoteBdName;
      PairingType _pairingType;
      PairingPinType _pin;
      PairingRequestOrigin _origin;
      UserConfirmationRequired _userConfirmationRequired;
      PairingResult _result;

   private:

   };

} // namespace bmcore

#endif /* _PAIRING_STATUS_H_ */
