#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PairingStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "PairingStatus.h"
#include "FunctionTracer.h"

namespace bmcore
{
   PairingStatus::PairingStatus() :
         _state(BM_PAIRING_STATE_IDLE),
         _remoteBdAddress(""),
         _remoteBdName(""),
         _pairingType(BM_PAIRING_TYPE_UNKNOWN),
         _pin(""),
         _origin(BM_PAIRING_REQUEST_ORIGIN_UNKNOWN),
         _userConfirmationRequired(BM_USER_CONFIRMATION_UNKNOWN),
         _result(BM_PAIRING_RESULT_UNKNOWN)
   {
      ENTRY_INTERNAL

   }

   PairingStatus::PairingStatus(const PairingState& pairingState,const BdAddress& remoteBdAddress,
         const BdName& remoteBdName,const PairingType& pairingType,
         const PairingPinType& pin, const PairingRequestOrigin& origin,
         const UserConfirmationRequired& userConfirmation, const PairingResult& result) :
         _state(pairingState),
         _remoteBdAddress(remoteBdAddress),
         _remoteBdName(remoteBdName),
         _pairingType(pairingType),
         _pin(pin),
         _origin(origin),
         _userConfirmationRequired(userConfirmation),
         _result(result)
   {
      ENTRY_INTERNAL
   }

   PairingStatus::PairingStatus(const PairingStatus& other):
         _state(other._state),
         _remoteBdAddress(other._remoteBdAddress),
         _remoteBdName(other._remoteBdName),
         _pairingType(other._pairingType),
         _pin(other._pin),
         _origin(other._origin),
         _userConfirmationRequired(other._userConfirmationRequired),
         _result(other._result)
   {
      ENTRY_INTERNAL
   }

   PairingStatus::~PairingStatus()
   {
      ENTRY_INTERNAL

   }

   void swap(PairingStatus& first, PairingStatus& second)
   {
      using std::swap;

      swap(first._state, second._state);
      swap(first._remoteBdAddress, second._remoteBdAddress);
      swap(first._remoteBdName, second._remoteBdName);
      swap(first._pairingType, second._pairingType);
      swap(first._pin, second._pin);
      swap(first._origin, second._origin);
      swap(first._userConfirmationRequired, second._userConfirmationRequired);
      swap(first._result, second._result);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   PairingStatus& PairingStatus::operator=(PairingStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool PairingStatus::operator==(const PairingStatus& rhs) const
   {
       return ((this->_state == rhs._state)
             && (this->_remoteBdAddress == rhs._remoteBdAddress)
             && (this->_remoteBdName == rhs._remoteBdName)
             && (this->_pairingType == rhs._pairingType)
             && (this->_pin == rhs._pin)
             && (this->_origin == rhs._origin)
             && (this->_userConfirmationRequired == rhs._userConfirmationRequired)
             && (this->_result == rhs._result));
   }

   bool PairingStatus::operator!=(const PairingStatus& rhs) const
   {
       return (!((this->_state == rhs._state)
             && (this->_remoteBdAddress == rhs._remoteBdAddress)
             && (this->_remoteBdName == rhs._remoteBdName)
             && (this->_pairingType == rhs._pairingType)
             && (this->_pin == rhs._pin)
             && (this->_origin == rhs._origin)
             && (this->_userConfirmationRequired == rhs._userConfirmationRequired)
             && (this->_result == rhs._result)));
   }
}


