/*
 * PairingPin.h
 *
 *  Created on: Jul 6, 2015
 *      Author: tnh5cob - Tharani
 */

#ifndef _PAIRING_PIN_H_
#define _PAIRING_PIN_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class PairingPin 
   {
   public:
      PairingPin();

      PairingPin(const PairingPinType& pairingPin);

      PairingPin(const PairingPin& other);

      ~PairingPin();

      friend void swap(PairingPin& first, PairingPin& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      PairingPin& operator=(PairingPin other);

      bool operator==(const PairingPin& rhs) const;

      bool operator!=(const PairingPin& rhs) const;

      PairingPinType _pin;

   private:

   };

} // namespace bmcore


#endif /* _PAIRING_PIN_H_ */
