#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PairingPin.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "PairingPin.h"
#include "FunctionTracer.h"


namespace bmcore
{
   PairingPin::PairingPin(): _pin("")
   {
      ENTRY_INTERNAL

   }
   PairingPin::PairingPin(const PairingPinType& pairingPin): _pin(pairingPin)
   {
      ENTRY_INTERNAL
   }
   PairingPin::PairingPin(const PairingPin& other): _pin(other._pin)
   {
      ENTRY_INTERNAL
   }

   PairingPin::~PairingPin()
   {
      ENTRY_INTERNAL

   }

   void swap(PairingPin& first, PairingPin& second)
   {
      using std::swap;

      swap(first._pin, second._pin);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   PairingPin& PairingPin::operator=(PairingPin other)
   {
      swap(*this, other);

      return *this;
   }

   bool PairingPin::operator==(const PairingPin& rhs) const
   {
      return ((this->_pin == rhs._pin));
   }

   bool PairingPin::operator!=(const PairingPin& rhs) const
   {
      return (!(this->_pin == rhs._pin));
   }
}




