#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PairedDeviceList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "PairedDeviceList.h"
#include "FunctionTracer.h"

namespace bmcore
{
   PairedDeviceList::PairedDeviceList() : _deviceBaseInfoList()
   {
      ENTRY_INTERNAL
   }

   PairedDeviceList::PairedDeviceList(const DeviceBaseInfoList& deviceBaseInfoList) : _deviceBaseInfoList(deviceBaseInfoList)
   {
      ENTRY_INTERNAL
   }

   PairedDeviceList::PairedDeviceList(const PairedDeviceList& other): _deviceBaseInfoList(other._deviceBaseInfoList)
   {
      ENTRY_INTERNAL
   }

   PairedDeviceList::~PairedDeviceList()
   {
      ENTRY_INTERNAL
   }

   void swap(PairedDeviceList& first, PairedDeviceList& second)
   {
      using std::swap;

      swap(first._deviceBaseInfoList, second._deviceBaseInfoList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   PairedDeviceList& PairedDeviceList::operator=(PairedDeviceList other)
   {
      swap(*this, other);

      return *this;
   }

   bool PairedDeviceList::operator==(const PairedDeviceList& rhs) const
   {
      return ((this->_deviceBaseInfoList == rhs._deviceBaseInfoList));
   }

   bool PairedDeviceList::operator!=(const PairedDeviceList& rhs) const
   {
      return (!(this->_deviceBaseInfoList == rhs._deviceBaseInfoList));
   }
}
