
#ifndef _OVERALL_DEVICE_BLOCK_STATUS_H_
#define _OVERALL_DEVICE_BLOCK_STATUS_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class OverallDeviceBlockStatus
   {
   public:
      OverallDeviceBlockStatus();

      OverallDeviceBlockStatus(const OverallBlockState blockState, const BdAddress& bdAddress);

      OverallDeviceBlockStatus(const OverallDeviceBlockStatus& other);

      virtual ~OverallDeviceBlockStatus();

      friend void swap(OverallDeviceBlockStatus& first, OverallDeviceBlockStatus& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      OverallDeviceBlockStatus& operator=(OverallDeviceBlockStatus other);

      bool operator==(const OverallDeviceBlockStatus& rhs) const;

      bool operator!=(const OverallDeviceBlockStatus& rhs) const;

      OverallBlockState _blockState;
      BdAddress         _bdAddress;
   };
}

#endif /* _OVERALL_DEVICE_BLOCK_STATUS_H_ */
