
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/OverallDeviceBlockStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "FunctionTracer.h"
#include "OverallDeviceBlockStatus.h"

namespace bmcore
{
   OverallDeviceBlockStatus::OverallDeviceBlockStatus() : _blockState(BM_OVERALL_BLOCK_STATE_UNBLOCKED), _bdAddress("")
   {
      ENTRY_INTERNAL
   }

   OverallDeviceBlockStatus::OverallDeviceBlockStatus(const OverallBlockState blockState, const BdAddress& bdAddress) :
      _blockState(blockState),
      _bdAddress(bdAddress)
   {
      ENTRY_INTERNAL
   }

   OverallDeviceBlockStatus::OverallDeviceBlockStatus(const OverallDeviceBlockStatus& other) :
      _blockState(other._blockState),
      _bdAddress(other._bdAddress)
   {
      ENTRY_INTERNAL
   }

   OverallDeviceBlockStatus::~OverallDeviceBlockStatus()
   {
      ENTRY_INTERNAL
   }

   void swap(OverallDeviceBlockStatus& first, OverallDeviceBlockStatus& second)
   {
      using std::swap;

      swap(first._blockState, second._blockState);
      swap(first._bdAddress, second._bdAddress);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   OverallDeviceBlockStatus& OverallDeviceBlockStatus::operator=(OverallDeviceBlockStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool OverallDeviceBlockStatus::operator==(const OverallDeviceBlockStatus& rhs) const
   {
      return ((this->_blockState == rhs._blockState)
            && (this->_bdAddress == rhs._bdAddress));
   }

   bool OverallDeviceBlockStatus::operator!=(const OverallDeviceBlockStatus& rhs) const
   {
      return (!((this->_blockState == rhs._blockState)
            && (this->_bdAddress == rhs._bdAddress)));
   }
}

