#ifndef _LOCAL_INFO_H_
#define _LOCAL_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include "ProtocolInfo.h"
#include "DeviceIdentification.h"

namespace bmcore
{
   class LocalInfo 
   {
   public:
      LocalInfo();

      LocalInfo(const BtModuleName& moduleName, const BdAddress& bdAddress,
            const LocalFriendlyNameType& friendlyName, const ProtocolInfoMap& protocolInfoMap,
            const DeviceIdentification& vehicleIdentification, const bool& stackInitialized);

      LocalInfo(const LocalInfo& other);

      ~LocalInfo();

      friend void swap(LocalInfo& first, LocalInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      LocalInfo& operator=(LocalInfo other);

      bool operator==(const LocalInfo& rhs) const;

      bool operator!=(const LocalInfo& rhs) const;

      BtModuleName _moduleName;
      BdAddress _bdAddress;
      LocalFriendlyNameType _bdName;
      ProtocolInfoMap _protocolInfos;
      DeviceIdentification _vehicleIdentification;
      bool _stackInitialized;

   private:

   };
}

#endif /* _LOCAL_INFO_H_ */
