
#ifndef _LINK_QUALITY_INFO_H_
#define _LINK_QUALITY_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include <map>

namespace bmcore
{
   class LinkQualityInfo
   {
   public:
      LinkQualityInfo();

      LinkQualityInfo(const Rssi& rssi, const LinkQualityType& linkQuality);

      LinkQualityInfo(const LinkQualityInfo& other);

      virtual ~LinkQualityInfo();

      friend void swap(LinkQualityInfo& first, LinkQualityInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      LinkQualityInfo& operator=(LinkQualityInfo other);

      bool operator==(const LinkQualityInfo& rhs) const;

      Rssi            _rssi;
      LinkQualityType _linkQuality;
   };

   typedef std::map<DeviceId, LinkQualityInfo> LinkQualityInfoList;
}

#endif // _LINK_QUALITY_INFO_H_
