/****************************************************************************
*FILE:         LinkQuality.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  LinkQuality Property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/LinkQuality.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "LinkQuality.h"
#include "FunctionTracer.h"

namespace bmcore
{
   LinkQuality::LinkQuality() :  _linkQualityInfoList()
   {
      ENTRY_INTERNAL
   }

   LinkQuality::LinkQuality(IN const LinkQualityInfoList& linkQualityInfoList) :_linkQualityInfoList(linkQualityInfoList)
   {
      ENTRY_INTERNAL
   }

   LinkQuality::LinkQuality(const LinkQuality& other): _linkQualityInfoList(other._linkQualityInfoList)
   {
      ENTRY_INTERNAL
   }

   LinkQuality::~LinkQuality()
   {
      ENTRY_INTERNAL
   }

   void swap(LinkQuality& first, LinkQuality& second)
   {
      using std::swap;

      swap(first._linkQualityInfoList, second._linkQualityInfoList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   LinkQuality& LinkQuality::operator=(LinkQuality other)
   {
      swap(*this, other);

      return *this;
   }

   bool LinkQuality::operator==(const LinkQuality& rhs) const
   {
      return ((this->_linkQualityInfoList == rhs._linkQualityInfoList));
   }

   bool LinkQuality::operator!=(const LinkQuality& rhs) const
   {
      return (!(this->_linkQualityInfoList == rhs._linkQualityInfoList));
   }
}
