
#ifndef _LIMITATION_MODE_H_
#define _LIMITATION_MODE_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class LimitationMode
   {
   public:
      LimitationMode();

      LimitationMode(const LimitationFeature limitationFeature, const LimitationCommunicationIf limitationCommunicationIf);

      LimitationMode(const LimitationMode& other);

      virtual ~LimitationMode();

      friend void swap(LimitationMode& first, LimitationMode& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      LimitationMode& operator=(LimitationMode other);

      bool operator==(const LimitationMode& rhs) const;

      bool operator!=(const LimitationMode& rhs) const;

      LimitationFeature         _limitationFeature;
      LimitationCommunicationIf _limitationCommunicationIf;
   };
}

#endif // _LIMITATION_MODE_H_
