#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/KdsInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "KdsInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   KdsInfo::KdsInfo() :
      _key(0), _read(false), _serviceName(""), _byte(0), _bit(0), _length(0)
   {
      ENTRY_INTERNAL
   }

   KdsInfo::KdsInfo(const uint16_t& key, bool& read, const ServiceName& serviceName, const uint8_t& byte, const uint8_t& bit, const uint8_t& length ) :
      _key(key), _read(read), _serviceName(serviceName), _byte(byte), _bit(bit), _length(length)
   {
      ENTRY_INTERNAL
   }

   KdsInfo::KdsInfo(const KdsInfo& other) :
      _key(other._key), _read(other._read), _serviceName(other._serviceName), _byte(other._byte), _bit(other._bit), _length(other._length)
   {
      ENTRY_INTERNAL
   }

   KdsInfo::~KdsInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(KdsInfo& first, KdsInfo& second)
   {
      using std::swap;

      swap(first._key, second._key);
      swap(first._read, second._read);
      swap(first._serviceName, second._serviceName);
      swap(first._byte, second._byte);
      swap(first._bit, second._bit);
      swap(first._length, second._length);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   KdsInfo& KdsInfo::operator=(KdsInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool KdsInfo::operator==(const KdsInfo& rhs) const
   {
      return ((this->_key == rhs._key)
            &&(this->_read == rhs._read)
            && (this->_serviceName == rhs._serviceName)
            && (this->_byte == rhs._byte)
            && (this->_bit == rhs._bit)
            && (this->_length == rhs._length));
   }
}
