
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/IssueInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "IssueInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   IssueInfo::IssueInfo() : _conflictType(BM_CONFLICT_TYPE_GENERIC), _deviceID(0u), _protocol(),
         _profileUsageType(BT_PROFILE_USAGE_NONE), _conflictState(BM_CONFLICT_STATE_LAST)
   {
      ENTRY_INTERNAL
   }

   IssueInfo::IssueInfo(const ConflictType conflictType, const DeviceId deviceID,
           const Protocol& protocol, const BTProfileUsageType btProfileUsageType, const ConflictState conflictState) :
         _conflictType(conflictType), _deviceID(deviceID), _protocol(protocol), _profileUsageType(btProfileUsageType),
         _conflictState(conflictState)
   {
      ENTRY_INTERNAL
   }

   IssueInfo::IssueInfo(const IssueInfo& other) : _conflictType(other._conflictType), _deviceID(other._deviceID),
         _protocol(other._protocol), _profileUsageType(other._profileUsageType), _conflictState(other._conflictState)
   {
      ENTRY_INTERNAL
   }

   IssueInfo::~IssueInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(IssueInfo& first, IssueInfo& second)
   {
	   using std::swap;

	   swap(first._conflictType, second._conflictType);
	   swap(first._deviceID, second._deviceID);
	   swap(first._protocol, second._protocol);
	   swap(first._profileUsageType, second._profileUsageType);
	   swap(first._conflictState, second._conflictState);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   IssueInfo& IssueInfo::operator=(IssueInfo rhs)
   {
	   swap(*this, rhs);
	   return *this;
   }

   bool IssueInfo::operator==(const IssueInfo& rhs) const
   {
	   return ((this->_conflictType == rhs._conflictType)
			   && (this->_deviceID == rhs._deviceID)
			   && (this->_protocol == rhs._protocol)
			   && (this->_profileUsageType == rhs._profileUsageType)
			   && (this->_conflictState == rhs._conflictState));
    }
}
