#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DiscoveredDeviceList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "DiscoveredDeviceList.h"
#include "FunctionTracer.h"

namespace bmcore
{
   DiscoveredDeviceList::DiscoveredDeviceList() : _discoveredDeviceInfoList()
   {
      ENTRY_INTERNAL
   }

   DiscoveredDeviceList::DiscoveredDeviceList(const DiscoveredDeviceInfoList& discoveredDeviceInfoList) :
         _discoveredDeviceInfoList(discoveredDeviceInfoList)
   {
      ENTRY_INTERNAL
   }

   DiscoveredDeviceList::DiscoveredDeviceList(const DiscoveredDeviceList& other):
         _discoveredDeviceInfoList(other._discoveredDeviceInfoList)
   {
      ENTRY_INTERNAL
   }

   DiscoveredDeviceList::~DiscoveredDeviceList()
   {
      ENTRY_INTERNAL
   }

   void swap(DiscoveredDeviceList& first, DiscoveredDeviceList& second)
   {
      using std::swap;

      swap(first._discoveredDeviceInfoList, second._discoveredDeviceInfoList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   DiscoveredDeviceList& DiscoveredDeviceList::operator=(DiscoveredDeviceList other)
   {
      swap(*this, other);

      return *this;
   }

   bool DiscoveredDeviceList::operator==(const DiscoveredDeviceList& rhs) const
   {
      return ((this->_discoveredDeviceInfoList == rhs._discoveredDeviceInfoList));
   }

   bool DiscoveredDeviceList::operator!=(const DiscoveredDeviceList& rhs) const
   {
      return (!(this->_discoveredDeviceInfoList == rhs._discoveredDeviceInfoList));
   }
}
