
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DiscoveredDeviceInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "FunctionTracer.h"
#include "DiscoveredDeviceInfo.h"
#include "LocalSpm.h"

namespace bmcore
{
   DiscoveredDeviceInfo::DiscoveredDeviceInfo() :
         _deviceHandle(0u), _bdAddress(""), _bdName(""), _majorDeviceClass(BTS_COD_MAJORDC_UNCATEGORIZED),
         _minorDeviceClass(BTS_COD_MINORDC_UNCATEGORIZED), _protocolInfo(), _connectionStatus(BM_CONNECTION_STATUS_DISCONNECTED),
         _lastDiscoveredTimestamp(0ull)
   {
      ENTRY_INTERNAL

      LocalSpm::getDataProvider().getProtocolInfos(_protocolInfo, false, false, true);
   }

   DiscoveredDeviceInfo::DiscoveredDeviceInfo(const DeviceId deviceHandle, const BdAddress& bdAddress,
         const BdName& bdName, const BTSMajorDeviceClass majorDeviceClass, const BTSMinorDeviceClass minorDeviceClass,
         const ProtocolInfoMap& protocolInfo, const ConnectionStatus connectionStatus, const LastDiscoveredTimestamp lastDiscoveredTimestamp) :
         _deviceHandle(deviceHandle), _bdAddress(bdAddress), _bdName(bdName), _majorDeviceClass(majorDeviceClass),
         _minorDeviceClass(minorDeviceClass), _connectionStatus(connectionStatus),
         _lastDiscoveredTimestamp(lastDiscoveredTimestamp)
   {
      ENTRY_INTERNAL

      LocalSpm::getDataProvider().getProtocolInfos(_protocolInfo, false, false, false);

      ProtocolInfoMap::const_iterator it;
      ProtocolInfoMap::iterator it2;

      for(it = protocolInfo.begin(); it != protocolInfo.end(); it++)
      {
         it2 = _protocolInfo.find(it->first);

         if(_protocolInfo.end() != it2)
         {
            it2->second._version = it->second._version;
            it2->second._isSupported = it->second._isSupported;
         }
      }
   }

   DiscoveredDeviceInfo::DiscoveredDeviceInfo(const DiscoveredDeviceInfo& other) :
         _deviceHandle(other._deviceHandle),
         _bdAddress(other._bdAddress),
         _bdName(other._bdName),
         _majorDeviceClass(other._majorDeviceClass),
         _minorDeviceClass(other._minorDeviceClass),
         _protocolInfo(other._protocolInfo),
         _connectionStatus(other._connectionStatus),
         _lastDiscoveredTimestamp(other._lastDiscoveredTimestamp)
   {
      ENTRY_INTERNAL
   }

   DiscoveredDeviceInfo::~DiscoveredDeviceInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(DiscoveredDeviceInfo& first, DiscoveredDeviceInfo& second)
   {
      using std::swap;

      swap(first._deviceHandle, second._deviceHandle);
      swap(first._bdAddress, second._bdAddress);
      swap(first._bdName, second._bdName);
      swap(first._majorDeviceClass, second._majorDeviceClass);
      swap(first._minorDeviceClass, second._minorDeviceClass);
      swap(first._protocolInfo, second._protocolInfo);
      swap(first._connectionStatus, second._connectionStatus);
      swap(first._lastDiscoveredTimestamp, second._lastDiscoveredTimestamp);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   DiscoveredDeviceInfo& DiscoveredDeviceInfo::operator=(DiscoveredDeviceInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool DiscoveredDeviceInfo::operator==(const DiscoveredDeviceInfo& rhs) const
   {
      return ((this->_deviceHandle == rhs._deviceHandle)
            && (this->_bdAddress == rhs._bdAddress)
            && (this->_bdName == rhs._bdName)
            && (this->_majorDeviceClass == rhs._majorDeviceClass)
            && (this->_minorDeviceClass == rhs._minorDeviceClass)
            && (this->_protocolInfo == rhs._protocolInfo)
            && (this->_connectionStatus == rhs._connectionStatus)
            && (this->_lastDiscoveredTimestamp == rhs._lastDiscoveredTimestamp));
   }
} /* namespace bmcore */
