
#ifndef _DEVICE_IDENTIFICATION_HPP_
#define _DEVICE_IDENTIFICATION_HPP_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class DeviceIdentification
   {
   public:
      DeviceIdentification();

      DeviceIdentification(const unsigned short int& specificationId,
            const unsigned short int& vendorId, const unsigned short int& vendorIdSource,
            unsigned short int& productId, unsigned short int& version);

      DeviceIdentification(const DeviceIdentification& other);

      virtual ~DeviceIdentification();

      friend void swap(DeviceIdentification& first, DeviceIdentification& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      DeviceIdentification& operator=(DeviceIdentification other);

      bool operator==(const DeviceIdentification& rhs) const;

      void reset();

      unsigned short int _specificationId;
      unsigned short int _vendorId;
      unsigned short int _vendorIdSource;
      unsigned short int _productId;
      unsigned short int _version;
   };
}

#endif /* _DEVICE_IDENTIFICATION_HPP_ */
