#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DeviceIdentification.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "DeviceIdentification.h"
#include "FunctionTracer.h"

namespace bmcore
{
   DeviceIdentification::DeviceIdentification() :
         _specificationId(0u), _vendorId(0u), _vendorIdSource(0u), _productId(0u), _version(0u)
   {
      ENTRY_INTERNAL
   }

   DeviceIdentification::DeviceIdentification(const unsigned short int& specificationId,
         const unsigned short int& vendorId, const unsigned short int& vendorIdSource, unsigned short int& productId,
         unsigned short int& version) :
         _specificationId(specificationId), _vendorId(vendorId), _vendorIdSource(vendorIdSource), _productId(productId),
         _version(version)
   {
      ENTRY_INTERNAL
   }

   DeviceIdentification::DeviceIdentification(const DeviceIdentification& other) :
      _specificationId(other._specificationId), _vendorId(other._vendorId), _vendorIdSource(other._vendorIdSource),
      _productId(other._productId), _version(other._version)
   {
      ENTRY_INTERNAL
   }

   DeviceIdentification::~DeviceIdentification()
   {
      ENTRY_INTERNAL
   }

   void swap(DeviceIdentification& first, DeviceIdentification& second)
   {
      using std::swap;

      swap(first._specificationId, second._specificationId);
      swap(first._vendorId, second._vendorId);
      swap(first._vendorIdSource, second._vendorIdSource);
      swap(first._productId, second._productId);
      swap(first._version, second._version);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   DeviceIdentification& DeviceIdentification::operator=(DeviceIdentification other)
   {
      swap(*this, other);

      return *this;
   }

   bool DeviceIdentification::operator==(const DeviceIdentification& rhs) const
   {
      return ((this->_specificationId == rhs._specificationId)
            && (this->_vendorId == rhs._vendorId)
            && (this->_vendorIdSource == rhs._vendorIdSource)
            && (this->_productId == rhs._productId)
            && (this->_version == rhs._version));
   }

   void DeviceIdentification::reset()
   {
      ENTRY

      _specificationId = 0u;
      _vendorId = 0u;
      _vendorIdSource = 0u;
      _productId = 0u;
      _version = 0u;
   }
}
