/**
 * @headerfile DeviceConnectionStatusList.h
 * @brief This class implements Device Connection status List
 * @date  Jul 21, 2015
 * @author tnh5cob-Tharani
 */

#ifndef _DEVICE_CONNECTION_STATUS_LIST_H_
#define _DEVICE_CONNECTION_STATUS_LIST_H_

#include "DeviceConnectionInfo.h"

namespace bmcore
{
   class DeviceConnectionStatusList 
   {
   public:

      DeviceConnectionStatusList();

      DeviceConnectionStatusList(const DeviceConnectionInfoList& deviceConnectionInfoList);

      DeviceConnectionStatusList(const DeviceConnectionStatusList& other);

      ~DeviceConnectionStatusList();

      friend void swap(DeviceConnectionStatusList& first, DeviceConnectionStatusList& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      DeviceConnectionStatusList& operator=(DeviceConnectionStatusList other);

      bool operator==(const DeviceConnectionStatusList& rhs) const;

      bool operator!=(const DeviceConnectionStatusList& rhs) const;

      DeviceConnectionInfoList _deviceConnectionInfoList;

   private:

   };

} // namespace bmcore

#endif /* _DEVICE_CONNECTION_STATUS_LIST_H_ */
