#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DeviceConnectionStatusList.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "DeviceConnectionStatusList.h"
#include "FunctionTracer.h"

namespace bmcore
{
   DeviceConnectionStatusList::DeviceConnectionStatusList() : _deviceConnectionInfoList()
   {
      ENTRY_INTERNAL
   }

   DeviceConnectionStatusList::DeviceConnectionStatusList(const DeviceConnectionInfoList& deviceConnectionInfoList) :_deviceConnectionInfoList(deviceConnectionInfoList)
   {
      ENTRY_INTERNAL
   }

   DeviceConnectionStatusList::DeviceConnectionStatusList(const DeviceConnectionStatusList& other) :
        _deviceConnectionInfoList(other._deviceConnectionInfoList)
   {
      ENTRY_INTERNAL
   }

   DeviceConnectionStatusList::~DeviceConnectionStatusList()
   {
      ENTRY_INTERNAL
   }

   void swap(DeviceConnectionStatusList& first, DeviceConnectionStatusList& second)
   {
      using std::swap;

      swap(first._deviceConnectionInfoList, second._deviceConnectionInfoList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   DeviceConnectionStatusList& DeviceConnectionStatusList::operator=(DeviceConnectionStatusList other)
   {
      swap(*this, other);

      return *this;
   }

   bool DeviceConnectionStatusList::operator==(const DeviceConnectionStatusList& rhs) const
   {
      return ((this->_deviceConnectionInfoList == rhs._deviceConnectionInfoList));
   }

   bool DeviceConnectionStatusList::operator!=(const DeviceConnectionStatusList& rhs) const
   {
      return (!(this->_deviceConnectionInfoList == rhs._deviceConnectionInfoList));
   }
}
