
#ifndef _DEVICE_CONNECTION_INFO_H_
#define _DEVICE_CONNECTION_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include "ConnectionOrderInfo.h"
#include "ProtocolConnectionInfo.h"

namespace bmcore
{
   class DeviceConnectionInfo
   {
   public:
      DeviceConnectionInfo();

      DeviceConnectionInfo(const DeviceId& deviceHandle, const ConnectionStatus& connectionStatus,
            const DisconnectedReason& disconnectedReason, const ConnectionOrderInfo& connectionOrderInfo,
            const ProtocolConnectionInfoMap& protocolConnectionInfo, const SppConnectionInfoMap& sppConnectionInfo);

      DeviceConnectionInfo(const DeviceConnectionInfo& other);

      virtual ~DeviceConnectionInfo();

      friend void swap(DeviceConnectionInfo& first, DeviceConnectionInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      DeviceConnectionInfo& operator=(DeviceConnectionInfo other);

      bool operator==(const DeviceConnectionInfo& rhs) const;

      bool operator!=(const DeviceConnectionInfo& rhs) const;

      static bool compConnectionIndex(const DeviceConnectionInfo& a, const DeviceConnectionInfo& b);

      inline DeviceId getDeviceHandle() const
      {
         return _deviceHandle;
      }

      DeviceId                  _deviceHandle;
      ConnectionStatus          _connectionStatus;
      DisconnectedReason        _disconnectedReason;
      ConnectionOrderInfo       _connectionOrderInfo;
      ProtocolConnectionInfoMap _protocolConnectionInfo;
      SppConnectionInfoMap      _sppConnectionInfo;
   };

   typedef std::vector<DeviceConnectionInfo> DeviceConnectionInfoList;
}

#endif /* _DEVICE_CONNECTION_INFO_H_ */
