
#ifndef _DEVICE_BASE_INFO_H_
#define _DEVICE_BASE_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include "BtStackIfTypes.h"
#include "DeviceIdentification.h"
#include "ConnectionOrderInfo.h"
#include "ProtocolInfo.h"
#include "time.h"
#include "stdint.h"
#include <list>

using namespace ::btstackif;

namespace bmcore
{
   class DeviceBaseInfo
   {
   public:
      DeviceBaseInfo();

      DeviceBaseInfo(const DeviceId deviceHandle, const BdAddress& bdAddress,
            const BdName& bdName,
            const BTSMajorDeviceClass majorDeviceClass,
            const DeviceIdentification& deviceIdentification,
            const FavoriteIndex favoriteIndex,
            const RemoteConnectable remoteConnectable,
            const UsagePreference usagePreference,
            const ProtocolInfoMap& protocolInfo,
            const InbandRingtoneSupport inbandRingtoneSupport,
            const AbsoluteVolumeSupport absoluteVolumeSupport,
            const ConnectionStatus connectionStatus,
            const DisconnectedReason disconnectedReason,
            const ConnectionOrderInfo& connectionOrderInfo,
            const ConnectionOrderInfo& pairingOrderInfo,
            const bool& iAPoverBTSupported);

      DeviceBaseInfo(const DeviceBaseInfo& other);

      virtual ~DeviceBaseInfo();

      friend void swap(DeviceBaseInfo& first, DeviceBaseInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      DeviceBaseInfo& operator=(DeviceBaseInfo other);

      bool operator==(const DeviceBaseInfo& rhs) const;

      static bool compConnectionIndex(const DeviceBaseInfo& a, const DeviceBaseInfo& b);

      inline DeviceId getDeviceHandle() const
      {
         return _deviceHandle;
      }

      DeviceId              _deviceHandle;
      BdAddress             _bdAddress;
      BdName                _bdName;
      BTSMajorDeviceClass   _majorDeviceClass;
      DeviceIdentification  _deviceIdentification;
      FavoriteIndex         _favoriteIndex;
      RemoteConnectable     _remoteConnectable;
      UsagePreference       _usagePreference;
      ProtocolInfoMap       _protocolInfo;
      InbandRingtoneSupport _inbandRingtoneSupport;
      AbsoluteVolumeSupport _absoluteVolumeSupport;
      ConnectionStatus      _connectionStatus;
      DisconnectedReason    _disconnectedReason;
      ConnectionOrderInfo   _connectionOrderInfo;
      ConnectionOrderInfo   _pairingOrderInfo;
      bool                  _iAPoverBTSupported;
   };

   typedef std::list<DeviceBaseInfo> DeviceBaseInfoList;
} /* namespace bmcore */

#endif /* _DEVICE_BASE_INFO_H_ */
