/*
 * DeviceBaseInfo.cpp
 *
 *  Created on: Jul 10, 2015
 *      Author: mom1hi
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DeviceBaseInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "FunctionTracer.h"
#include "DeviceBaseInfo.h"
#include "LocalSpm.h"

namespace bmcore
{
   DeviceBaseInfo::DeviceBaseInfo() :
         _deviceHandle(0u), _bdAddress(""), _bdName(""), _majorDeviceClass(BTS_COD_MAJORDC_UNCATEGORIZED),
         _deviceIdentification(), _favoriteIndex(0u), _remoteConnectable(true), _usagePreference(BM_UP_UNDECIDED), _protocolInfo(), _inbandRingtoneSupport(BM_INBAND_RINGTONE_SUPPORT_UNKNOWN),
         _absoluteVolumeSupport(BM_ABSOLUTE_VOLUME_SUPPORT_UNKNOWN),
         _connectionStatus(BM_CONNECTION_STATUS_DISCONNECTED), _disconnectedReason(BM_DISCONNECTED_REASON_NORMAL_LOSS_LOCAL),
         _connectionOrderInfo(),_pairingOrderInfo(), _iAPoverBTSupported(false)
   {
      ENTRY_INTERNAL

      LocalSpm::getDataProvider().getProtocolInfos(_protocolInfo, false, false, true);
   }

   DeviceBaseInfo::DeviceBaseInfo(const DeviceId deviceHandle, const BdAddress& bdAddress, const BdName& bdName,
         const BTSMajorDeviceClass majorDeviceClass, const DeviceIdentification& deviceIdentification,
         const FavoriteIndex favoriteIndex, const RemoteConnectable remoteConnectable, const UsagePreference usagePreference,
         const ProtocolInfoMap& protocolInfo, const InbandRingtoneSupport inbandRingtoneSupport,
         const AbsoluteVolumeSupport absoluteVolumeSupport, const ConnectionStatus connectionStatus,
         const DisconnectedReason disconnectedReason, const ConnectionOrderInfo& connectionOrderInfo, const ConnectionOrderInfo& pairingOrderInfo,
         const bool& iAPoverBTSupported) : _deviceHandle(deviceHandle), _bdAddress(bdAddress), _bdName(bdName), _majorDeviceClass(majorDeviceClass),
         _deviceIdentification(deviceIdentification), _favoriteIndex(favoriteIndex), _remoteConnectable(remoteConnectable),
         _usagePreference(usagePreference), _inbandRingtoneSupport(inbandRingtoneSupport),
         _absoluteVolumeSupport(absoluteVolumeSupport), _connectionStatus(connectionStatus),
         _disconnectedReason(disconnectedReason), _connectionOrderInfo(connectionOrderInfo),_pairingOrderInfo(pairingOrderInfo), _iAPoverBTSupported(iAPoverBTSupported)
   {
      ENTRY_INTERNAL

      LocalSpm::getDataProvider().getProtocolInfos(_protocolInfo, false, false, false);

      ProtocolInfoMap::const_iterator it;
      ProtocolInfoMap::iterator it2;

      for(it = protocolInfo.begin(); it != protocolInfo.end(); it++)
      {
         it2 = _protocolInfo.find(it->first);

         if(_protocolInfo.end() != it2)
         {
            it2->second._version = it->second._version;
            it2->second._isSupported = it->second._isSupported;
            it2->second._favoriteIndex = it->second._favoriteIndex;
         }
      }
   }

   DeviceBaseInfo::DeviceBaseInfo(const DeviceBaseInfo& other) :
         _deviceHandle(other._deviceHandle),
         _bdAddress(other._bdAddress),
         _bdName(other._bdName),
         _majorDeviceClass(other._majorDeviceClass),
         _deviceIdentification(other._deviceIdentification),
         _favoriteIndex(other._favoriteIndex),
         _remoteConnectable(other._remoteConnectable),
         _usagePreference(other._usagePreference),
         _protocolInfo(other._protocolInfo),
         _inbandRingtoneSupport(other._inbandRingtoneSupport),
         _absoluteVolumeSupport(other._absoluteVolumeSupport),
         _connectionStatus(other._connectionStatus),
         _disconnectedReason(other._disconnectedReason),
         _connectionOrderInfo(other._connectionOrderInfo),
         _pairingOrderInfo(other._pairingOrderInfo),
         _iAPoverBTSupported(other._iAPoverBTSupported)
   {
      ENTRY_INTERNAL
   }

   DeviceBaseInfo::~DeviceBaseInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(DeviceBaseInfo& first, DeviceBaseInfo& second)
   {
      using std::swap;

      swap(first._deviceHandle, second._deviceHandle);
      swap(first._bdAddress, second._bdAddress);
      swap(first._bdName, second._bdName);
      swap(first._majorDeviceClass, second._majorDeviceClass);
      swap(first._deviceIdentification, second._deviceIdentification);
      swap(first._favoriteIndex, second._favoriteIndex);
      swap(first._remoteConnectable, second._remoteConnectable);
      swap(first._usagePreference, second._usagePreference);
      swap(first._protocolInfo, second._protocolInfo);
      swap(first._inbandRingtoneSupport, second._inbandRingtoneSupport);
      swap(first._absoluteVolumeSupport, second._absoluteVolumeSupport);
      swap(first._connectionStatus, second._connectionStatus);
      swap(first._disconnectedReason, second._disconnectedReason);
      swap(first._connectionOrderInfo, second._connectionOrderInfo);
      swap(first._pairingOrderInfo, second._pairingOrderInfo);
      swap(first._iAPoverBTSupported, second._iAPoverBTSupported);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   DeviceBaseInfo& DeviceBaseInfo::operator=(DeviceBaseInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool DeviceBaseInfo::operator==(const DeviceBaseInfo& rhs) const
   {
      return ((this->_deviceHandle == rhs._deviceHandle)
            && (this->_bdAddress == rhs._bdAddress)
            && (this->_bdName == rhs._bdName)
            && (this->_majorDeviceClass == rhs._majorDeviceClass)
            && (this->_deviceIdentification == rhs._deviceIdentification)
            && (this->_favoriteIndex == rhs._favoriteIndex)
            && (this->_remoteConnectable == rhs._remoteConnectable)
            && (this->_usagePreference == rhs._usagePreference)
            && (this->_protocolInfo == rhs._protocolInfo)
            && (this->_inbandRingtoneSupport == rhs._inbandRingtoneSupport)
            && (this->_absoluteVolumeSupport == rhs._absoluteVolumeSupport)
            && (this->_connectionStatus == rhs._connectionStatus)
            && (this->_disconnectedReason == rhs._disconnectedReason)
            && (this->_connectionOrderInfo == rhs._connectionOrderInfo)
            && (this->_pairingOrderInfo == rhs._pairingOrderInfo)
            && (this->_iAPoverBTSupported == rhs._iAPoverBTSupported));
   }

   bool DeviceBaseInfo::compConnectionIndex(const DeviceBaseInfo& a, const DeviceBaseInfo& b)
   {
      ENTRY

      //used to sort Devices based on ConnectionOrderInfo Index as following:
      //1.sort connected Devices in ascending order
      //2.sort other devices in descending order
      //3.connected devices come before other connection statuses

      bool ret = false;

      if(BM_CONNECTION_STATUS_CONNECTED == a._connectionStatus && BM_CONNECTION_STATUS_CONNECTED == b._connectionStatus)
      {
         ret = a._connectionOrderInfo._index < b._connectionOrderInfo._index;
      }
      else if(BM_CONNECTION_STATUS_CONNECTED != a._connectionStatus && BM_CONNECTION_STATUS_CONNECTED != b._connectionStatus)
      {
         //2.sort other devices in descending order based on pairingorderinfo
         if((a._connectionOrderInfo._index == 0)  && ((b._connectionOrderInfo._index == 0)))
         {
            ret = a._pairingOrderInfo._index > b._pairingOrderInfo._index;
         }
         else
         {
            ret = a._connectionOrderInfo._index > b._connectionOrderInfo._index;
         }
      }
      else if(BM_CONNECTION_STATUS_CONNECTED == a._connectionStatus && BM_CONNECTION_STATUS_CONNECTED != b._connectionStatus)
      {
         ret = true;
      }
      else
      {
         //BM_CONNECTION_STATUS_CONNECTED != a._connectionStatus && BM_CONNECTION_STATUS_CONNECTED == b._connectionStatus
         ret = false;
      }

      return ret;
   }
} /* namespace bmcore */
