#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ConnectionOrderInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "ConnectionOrderInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   ConnectionOrderInfo::ConnectionOrderInfo() :
         _index(0u), _seconds(0), _nanoseconds(0)
   {
      ENTRY_INTERNAL
   }

   ConnectionOrderInfo::ConnectionOrderInfo(const unsigned int& index, const time_t& seconds, const long& nanoseconds) :
         _index(index), _seconds(seconds), _nanoseconds(nanoseconds)
   {
      ENTRY_INTERNAL
   }

   ConnectionOrderInfo::ConnectionOrderInfo(const ConnectionOrderInfo& other) :
      _index(other._index), _seconds(other._seconds), _nanoseconds(other._nanoseconds)
   {
      ENTRY_INTERNAL
   }

   ConnectionOrderInfo::~ConnectionOrderInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(ConnectionOrderInfo& first, ConnectionOrderInfo& second)
   {
      using std::swap;

      swap(first._index, second._index);
      swap(first._seconds, second._seconds);
      swap(first._nanoseconds, second._nanoseconds);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   ConnectionOrderInfo& ConnectionOrderInfo::operator=(ConnectionOrderInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool ConnectionOrderInfo::operator==(const ConnectionOrderInfo& rhs) const
   {
      return ((this->_index == rhs._index)
            && (this->_seconds == rhs._seconds)
            && (this->_nanoseconds == rhs._nanoseconds));
   }

   bool ConnectionOrderInfo::operator!=(const ConnectionOrderInfo& rhs) const
   {
      return (!((this->_index == rhs._index)
            && (this->_seconds == rhs._seconds)
            && (this->_nanoseconds == rhs._nanoseconds)));
   }
}
