#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BtSystemState.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "FunctionTracer.h"
#include "BtSystemState.h"

namespace bmcore
{
   BtSystemState::BtSystemState() : _bluetoothSystemState(BM_BT_SYSTEM_STATE_BLOCK)
   {
      ENTRY_INTERNAL
   }

   BtSystemState::BtSystemState(const BluetoothSystemState bluetoothSystemState) :  _bluetoothSystemState(bluetoothSystemState)
   {
      ENTRY_INTERNAL
   }

   BtSystemState::BtSystemState(const BtSystemState& other) : _bluetoothSystemState(other._bluetoothSystemState)
   {
      ENTRY_INTERNAL
   }

   BtSystemState::~BtSystemState()
   {
      ENTRY_INTERNAL
   }

   void swap(BtSystemState& first, BtSystemState& second)
   {
      using std::swap;

      swap(first._bluetoothSystemState, second._bluetoothSystemState);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BtSystemState& BtSystemState::operator=(BtSystemState other)
   {
      swap(*this, other);

      return *this;
   }

   bool BtSystemState::operator==(const BtSystemState& rhs) const
   {
      return ((this->_bluetoothSystemState == rhs._bluetoothSystemState));
   }

   bool BtSystemState::operator!=(const BtSystemState& rhs) const
   {
      return (!(this->_bluetoothSystemState == rhs._bluetoothSystemState));
   }
}
