
#ifndef _BT_LIMITATION_MODE_INFO_H_
#define _BT_LIMITATION_MODE_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include "LimitationMode.h"

namespace bmcore
{
   class BtLimitationModeInfo
   {
   public:
      BtLimitationModeInfo();

      BtLimitationModeInfo(const BdAddress& bdAddress, const BdName& bdName, const LimitationMode& limitationMode, const LimitationState limitationState);

      BtLimitationModeInfo(const BtLimitationModeInfo& other);

      virtual ~BtLimitationModeInfo();

      friend void swap(BtLimitationModeInfo& first, BtLimitationModeInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      BtLimitationModeInfo& operator=(BtLimitationModeInfo other);

      bool operator==(const BtLimitationModeInfo& rhs) const;

      bool operator!=(const BtLimitationModeInfo& rhs) const;

      BdAddress       _bdAddress;
      BdName          _bdName;
      LimitationMode  _limitationMode;
      LimitationState _limitationState;
   };

   typedef std::vector<BtLimitationModeInfo> BtLimitationModeInfoList;
}

#endif // _BT_LIMITATION_MODE_INFO_H_
