#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BtLimitationMode.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "BtLimitationMode.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BtLimitationMode::BtLimitationMode() :  _btLimitationModeInfoList()
   {
      ENTRY_INTERNAL
   }

   BtLimitationMode::BtLimitationMode(const BtLimitationModeInfoList& btLimitationModeInfoList) :
          _btLimitationModeInfoList(btLimitationModeInfoList)
   {
      ENTRY_INTERNAL
   }

   BtLimitationMode::BtLimitationMode(const BtLimitationMode& other) :
          _btLimitationModeInfoList(other._btLimitationModeInfoList)
   {
      ENTRY_INTERNAL
   }

   BtLimitationMode::~BtLimitationMode()
   {
      ENTRY_INTERNAL
   }

   void swap(BtLimitationMode& first, BtLimitationMode& second)
   {
      using std::swap;

      swap(first._btLimitationModeInfoList, second._btLimitationModeInfoList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BtLimitationMode& BtLimitationMode::operator=(BtLimitationMode other)
   {
      swap(*this, other);

      return *this;
   }

   bool BtLimitationMode::operator==(const BtLimitationMode& rhs) const
   {
      return ((this->_btLimitationModeInfoList == rhs._btLimitationModeInfoList));
   }

   bool BtLimitationMode::operator!=(const BtLimitationMode& rhs) const
   {
      return (!(this->_btLimitationModeInfoList == rhs._btLimitationModeInfoList));
   }
}
