/****************************************************************************
*FILE:         BmConfigData.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  BmConfigData Property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BmConfigData.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "BmServiceAvailability.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BmServiceAvailability::BmServiceAvailability() :  _serviceAvailability(BM_SERVICE_UNAVAILABLE)
   {
      ENTRY_INTERNAL
   }

   BmServiceAvailability::BmServiceAvailability(IN const ServiceAvailability serviceAvailability) : _serviceAvailability(serviceAvailability)
   {
      ENTRY_INTERNAL
   }

   BmServiceAvailability::BmServiceAvailability(const BmServiceAvailability& other) : _serviceAvailability(other._serviceAvailability)
   {
      ENTRY_INTERNAL
   }

   BmServiceAvailability::~BmServiceAvailability()
   {
      ENTRY_INTERNAL
   }

   void swap(BmServiceAvailability& first, BmServiceAvailability& second)
   {
      using std::swap;

      swap(first._serviceAvailability, second._serviceAvailability);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmServiceAvailability& BmServiceAvailability::operator=(BmServiceAvailability other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmServiceAvailability::operator==(const BmServiceAvailability& rhs) const
   {
      return ((this->_serviceAvailability == rhs._serviceAvailability));
   }

   bool BmServiceAvailability::operator!=(const BmServiceAvailability& rhs) const
   {
      return (!(this->_serviceAvailability == rhs._serviceAvailability));
   }
}

