
#ifndef _BM_CORE_CONFIGURATION_H_
#define _BM_CORE_CONFIGURATION_H_

#include "BmInterfaceTypesInternal.h"
#include "ProtocolSupportInfo.h"
#include "WifiHealthinessIndicatorInfo.h"
#include "SppServiceInfo.h"
#include "BaseTypes.h"
#include "KdsInfo.h"

namespace bmcore
{
   class BmCoreConfiguration
   {
   public:

      BmCoreConfiguration();

      BmCoreConfiguration(const BmCoreConfiguration& other);

      virtual ~BmCoreConfiguration();

      friend void swap(BmCoreConfiguration& first, BmCoreConfiguration& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      BmCoreConfiguration& operator=(BmCoreConfiguration other);

      bool operator==(const BmCoreConfiguration& rhs) const;

      std::string _btModuleName;
      std::string _btLocalFriendlyName;
      std::string _btLocalBdAddress;
      uint16_t _didSpecificationId;
      uint16_t _didVendorId;
      uint16_t _didProductId;
      uint16_t _didVersion;
      uint16_t _didVendorIdSource;
      std::string _didClientExecutableUrl;
      std::string _didServiceDescription;
      std::string _didClientDocumentationUrl;
      bool _carPlayWirelessSupported;
      bool _androidAutoWirelessSupported;
      bool _wideBandSpeechEnabled;
      bool _pbdlViaPbapEnabled;
      bool _pbdlViaHfpEnabled;
      bool _pbdlViaSppEnabled;
      bool _pbdlViaSyncMlEnabled;
      bool _voiceRecognitionEnabled;
      bool _enhancedCallControlEnabled;
      bool _avrcpBrowsingEnabled;
      bool _audioCodecMp3Enabled;
      bool _audioCodecAacEnabled;
      ProtocolSupportInformation _protocolSupportInformation;
      uint32_t _maxNumPairedDevices;
      uint8_t _maxNumConnectedDevices;
      TargetSwitchState _defaultBtStatus;
      TargetSwitchState _defaultLocalPairableMode;
      TargetSwitchState _defaultLocalConnectableMode;
      uint32_t _localPairableTimeoutSeconds;
      uint32_t _localConnectableTimeoutSeconds;
      bool _useFixedPinLegacyPairing;
      uint8_t _pinLengthLegacyPairing;
      std::string _defaultFixedPinLegacyPairing;
      bool _autoConfirmRemoteLegacyPairingRequest;
      bool _autoConfirmLocalLegacyPairingRequest;
      bool _autoConfirmRemoteSecureSimplePairingRequest;
      bool _autoConfirmLocalSecureSimplePairingRequest;
      bool _allowLegacyPairingRetry;
      uint32_t _lostDeviceConnectionRetryDelayMilliSeconds;
      uint32_t _localProtocolConnectingDelaySeconds;
      uint32_t _protocolDisconnectingTimeoutSeconds;
      StandardAutoConnectionType _defaultStandardAutoConnectionType;
      bool _startAutoConnectionOnStartUp;
      uint32_t _linkQualityRequestTimeOut;
      bool _blockAllProtocolsForNonProjectionDevices;
      bool _connectAfterPairing;
      bool _iapEnabled;
      TargetSwitchState _defaultmultiHFPSupport;
      bool _systemWideRingtoneEnabled;
      uint32_t _blockDeviceRemoteConnectionsTimeoutSeconds;
      bool _updateConflictDuringCPWOOBPairing;
      uint32_t _CPWReconnectTimeoutInSecs;
      bool _enableDefaultActionAtEndOfBtLimitation;
      UserConfirmationRequired _deleteDeviceDuringOOBTPairing;
      uint32_t _serviceSearchTimeoutSeconds;
      PageTimeout _defaultConnectionPageTimeoutMilliSeconds;
      WifiHealthinessIndicatorInformation _wifiHealthinessIndicatorInformation;
      uint8_t _delayAutoConnectionAtEndOfBtLimitationInSec;
      SppServiceInformation _sppServiceInformation;
      KdsInformation _kdsInformation;
      bool _btOnOffSupport;
   };

} // namespace bmcore

#endif // _BM_CORE_CONFIGURATION_H_
