#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BmCoreConfiguration.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "BmCoreConfiguration.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BmCoreConfiguration::BmCoreConfiguration() :
      _btModuleName(""),
      _btLocalFriendlyName("MyVehicleDefault"),
      _btLocalBdAddress("000000000000"),
      _didSpecificationId(0x0103u),
      _didVendorId(0xFFFFu),
      _didProductId(0x0001u),
      _didVersion(0x0101u),
      _didVendorIdSource(0x0001u),
      _didClientExecutableUrl(""),
      _didServiceDescription(""),
      _didClientDocumentationUrl(""),
      _carPlayWirelessSupported(false),
      _androidAutoWirelessSupported(false),
      _wideBandSpeechEnabled(true),
      _pbdlViaPbapEnabled(true),
      _pbdlViaHfpEnabled(false),
      _pbdlViaSppEnabled(false),
      _pbdlViaSyncMlEnabled(false),
      _voiceRecognitionEnabled(true),
      _enhancedCallControlEnabled(true),
      _avrcpBrowsingEnabled(false),
      _audioCodecMp3Enabled(false),
      _audioCodecAacEnabled(false),
      _protocolSupportInformation(),
      _maxNumPairedDevices(10u),
      _maxNumConnectedDevices(1u),
      _defaultBtStatus(TARGET_SWITCH_STATE_SWITCHED_OFF),
      _defaultLocalPairableMode(TARGET_SWITCH_STATE_SWITCHED_OFF),
      _defaultLocalConnectableMode(TARGET_SWITCH_STATE_SWITCHED_OFF),
      _localPairableTimeoutSeconds(300u),
      _localConnectableTimeoutSeconds(10u),
      _useFixedPinLegacyPairing(false),
      _pinLengthLegacyPairing(4u),
      _defaultFixedPinLegacyPairing("1234"),
      _autoConfirmRemoteLegacyPairingRequest(true),
      _autoConfirmLocalLegacyPairingRequest(true),
      _autoConfirmRemoteSecureSimplePairingRequest(true),
      _autoConfirmLocalSecureSimplePairingRequest(true),
      _allowLegacyPairingRetry(false),
      _lostDeviceConnectionRetryDelayMilliSeconds(300u),
      _localProtocolConnectingDelaySeconds(5u),
      _protocolDisconnectingTimeoutSeconds(60u),
      _defaultStandardAutoConnectionType(BM_STANDARD_AUTO_CONNECTION_LAST_CONNECTED_DEVICES),
      _startAutoConnectionOnStartUp(true),
      _linkQualityRequestTimeOut(5u),
      _blockAllProtocolsForNonProjectionDevices(false),
      _connectAfterPairing(true),
      _iapEnabled(true),
      _defaultmultiHFPSupport(TARGET_SWITCH_STATE_SWITCHED_OFF),
      _systemWideRingtoneEnabled(true),
      _blockDeviceRemoteConnectionsTimeoutSeconds(10u),
      _updateConflictDuringCPWOOBPairing(false),
      _CPWReconnectTimeoutInSecs(60u),
      _enableDefaultActionAtEndOfBtLimitation(true),
      _deleteDeviceDuringOOBTPairing(BM_USER_CONFIRMATION_UNKNOWN),
      _serviceSearchTimeoutSeconds(5u),
      _defaultConnectionPageTimeoutMilliSeconds(10240u),
      _wifiHealthinessIndicatorInformation(),
      _delayAutoConnectionAtEndOfBtLimitationInSec(0u),
      _sppServiceInformation(),
      _kdsInformation(),
      _btOnOffSupport(true)
   {
      ENTRY_INTERNAL

      _protocolSupportInformation.insert(std::pair<ProtocolId, ProtocolSupportInfo>(BM_PROTOCOL_ID_HFP, ProtocolSupportInfo("HFP", 0u, 1u, BM_PROTOCOL_DEPENDENCY_LEVEL_MASTER, BM_MASTER_PROTOCOLS_SELECTOR_NONE, true)));
      _protocolSupportInformation.insert(std::pair<ProtocolId, ProtocolSupportInfo>(BM_PROTOCOL_ID_AVP, ProtocolSupportInfo("AVP", 0u, 1u, BM_PROTOCOL_DEPENDENCY_LEVEL_MASTER, BM_MASTER_PROTOCOLS_SELECTOR_NONE, true)));
      _protocolSupportInformation.insert(std::pair<ProtocolId, ProtocolSupportInfo>(BM_PROTOCOL_ID_PBDL, ProtocolSupportInfo("PBDL", 0u, 1u, BM_PROTOCOL_DEPENDENCY_LEVEL_SLAVE, BM_MASTER_PROTOCOLS_SELECTOR_HFP, false)));
      _protocolSupportInformation.insert(std::pair<ProtocolId, ProtocolSupportInfo>(BM_PROTOCOL_ID_MSG, ProtocolSupportInfo("MSG", 0u, 1u, BM_PROTOCOL_DEPENDENCY_LEVEL_SLAVE, BM_MASTER_PROTOCOLS_SELECTOR_HFP, false)));
      _protocolSupportInformation.insert(std::pair<ProtocolId, ProtocolSupportInfo>(BM_PROTOCOL_ID_PAN, ProtocolSupportInfo("PAN", 0u, 1u, BM_PROTOCOL_DEPENDENCY_LEVEL_STAND_ALONE, BM_MASTER_PROTOCOLS_SELECTOR_NONE, false)));
      _protocolSupportInformation.insert(std::pair<ProtocolId, ProtocolSupportInfo>(BM_PROTOCOL_ID_SPP, ProtocolSupportInfo("SPP", 0u, 1u, BM_PROTOCOL_DEPENDENCY_LEVEL_SLAVE, BM_MASTER_PROTOCOLS_SELECTOR_ALL_OTHERS, false)));
   }

   BmCoreConfiguration::BmCoreConfiguration(const BmCoreConfiguration& other) :
      _btModuleName(other._btModuleName),
      _btLocalFriendlyName(other._btLocalFriendlyName),
      _btLocalBdAddress(other._btLocalBdAddress),
      _didSpecificationId(other._didSpecificationId),
      _didVendorId(other._didVendorId),
      _didProductId(other._didProductId),
      _didVersion(other._didVersion),
      _didVendorIdSource(other._didVendorIdSource),
      _didClientExecutableUrl(other._didClientExecutableUrl),
      _didServiceDescription(other._didServiceDescription),
      _didClientDocumentationUrl(other._didClientDocumentationUrl),
      _carPlayWirelessSupported(other._carPlayWirelessSupported),
      _androidAutoWirelessSupported(other._androidAutoWirelessSupported),
      _wideBandSpeechEnabled(other._wideBandSpeechEnabled),
      _pbdlViaPbapEnabled(other._pbdlViaPbapEnabled),
      _pbdlViaHfpEnabled(other._pbdlViaHfpEnabled),
      _pbdlViaSppEnabled(other._pbdlViaSppEnabled),
      _pbdlViaSyncMlEnabled(other._pbdlViaSyncMlEnabled),
      _voiceRecognitionEnabled(other._voiceRecognitionEnabled),
      _enhancedCallControlEnabled(other._enhancedCallControlEnabled),
      _avrcpBrowsingEnabled(other._avrcpBrowsingEnabled),
      _audioCodecMp3Enabled(other._audioCodecMp3Enabled),
      _audioCodecAacEnabled(other._audioCodecAacEnabled),
      _protocolSupportInformation(other._protocolSupportInformation),
      _maxNumPairedDevices(other._maxNumPairedDevices),
      _maxNumConnectedDevices(other._maxNumConnectedDevices),
      _defaultBtStatus(other._defaultBtStatus),
      _defaultLocalPairableMode(other._defaultLocalPairableMode),
      _defaultLocalConnectableMode(other._defaultLocalConnectableMode),
      _localPairableTimeoutSeconds(other._localPairableTimeoutSeconds),
      _localConnectableTimeoutSeconds(other._localConnectableTimeoutSeconds),
      _useFixedPinLegacyPairing(other._useFixedPinLegacyPairing),
      _pinLengthLegacyPairing(other._pinLengthLegacyPairing),
      _defaultFixedPinLegacyPairing(other._defaultFixedPinLegacyPairing),
      _autoConfirmRemoteLegacyPairingRequest(other._autoConfirmRemoteLegacyPairingRequest),
      _autoConfirmLocalLegacyPairingRequest(other._autoConfirmLocalLegacyPairingRequest),
      _autoConfirmRemoteSecureSimplePairingRequest(other._autoConfirmRemoteSecureSimplePairingRequest),
      _autoConfirmLocalSecureSimplePairingRequest(other._autoConfirmLocalSecureSimplePairingRequest),
      _allowLegacyPairingRetry(other._allowLegacyPairingRetry),
      _lostDeviceConnectionRetryDelayMilliSeconds(other._lostDeviceConnectionRetryDelayMilliSeconds),
      _localProtocolConnectingDelaySeconds(other._localProtocolConnectingDelaySeconds),
      _protocolDisconnectingTimeoutSeconds(other._protocolDisconnectingTimeoutSeconds),
      _defaultStandardAutoConnectionType(other._defaultStandardAutoConnectionType),
      _startAutoConnectionOnStartUp(other._startAutoConnectionOnStartUp),
      _linkQualityRequestTimeOut(other._linkQualityRequestTimeOut),
      _blockAllProtocolsForNonProjectionDevices(other._blockAllProtocolsForNonProjectionDevices),
      _connectAfterPairing(other._connectAfterPairing),
      _iapEnabled(other._iapEnabled),
      _defaultmultiHFPSupport(other._defaultmultiHFPSupport),
      _systemWideRingtoneEnabled(other._systemWideRingtoneEnabled),
      _blockDeviceRemoteConnectionsTimeoutSeconds(other._blockDeviceRemoteConnectionsTimeoutSeconds),
      _updateConflictDuringCPWOOBPairing(other._updateConflictDuringCPWOOBPairing),
      _CPWReconnectTimeoutInSecs(other._CPWReconnectTimeoutInSecs),
      _enableDefaultActionAtEndOfBtLimitation(other._enableDefaultActionAtEndOfBtLimitation),
      _deleteDeviceDuringOOBTPairing(other._deleteDeviceDuringOOBTPairing),
      _serviceSearchTimeoutSeconds(other._serviceSearchTimeoutSeconds),
      _defaultConnectionPageTimeoutMilliSeconds(other._defaultConnectionPageTimeoutMilliSeconds),
      _wifiHealthinessIndicatorInformation(other._wifiHealthinessIndicatorInformation),
      _delayAutoConnectionAtEndOfBtLimitationInSec(other._delayAutoConnectionAtEndOfBtLimitationInSec),
      _sppServiceInformation(other._sppServiceInformation),
      _kdsInformation(other._kdsInformation),
      _btOnOffSupport(other._btOnOffSupport)

   {
      ENTRY_INTERNAL
   }

   BmCoreConfiguration::~BmCoreConfiguration()
   {
      ENTRY_INTERNAL
   }

   void swap(BmCoreConfiguration& first, BmCoreConfiguration& second)
   {
      using std::swap;

      swap(first._btModuleName, second._btModuleName);
      swap(first._btLocalFriendlyName, second._btLocalFriendlyName);
      swap(first._btLocalBdAddress, second._btLocalBdAddress);
      swap(first._didSpecificationId, second._didSpecificationId);
      swap(first._didVendorId, second._didVendorId);
      swap(first._didProductId, second._didProductId);
      swap(first._didVersion, second._didVersion);
      swap(first._didVendorIdSource, second._didVendorIdSource);
      swap(first._didClientExecutableUrl, second._didClientExecutableUrl);
      swap(first._didServiceDescription, second._didServiceDescription);
      swap(first._didClientDocumentationUrl, second._didClientDocumentationUrl);
      swap(first._carPlayWirelessSupported, second._carPlayWirelessSupported);
      swap(first._androidAutoWirelessSupported, second._androidAutoWirelessSupported);
      swap(first._wideBandSpeechEnabled, second._wideBandSpeechEnabled);
      swap(first._pbdlViaPbapEnabled, second._pbdlViaPbapEnabled);
      swap(first._pbdlViaHfpEnabled, second._pbdlViaHfpEnabled);
      swap(first._pbdlViaSppEnabled, second._pbdlViaSppEnabled);
      swap(first._pbdlViaSyncMlEnabled, second._pbdlViaSyncMlEnabled);
      swap(first._voiceRecognitionEnabled, second._voiceRecognitionEnabled);
      swap(first._enhancedCallControlEnabled, second._enhancedCallControlEnabled);
      swap(first._avrcpBrowsingEnabled, second._avrcpBrowsingEnabled);
      swap(first._audioCodecMp3Enabled, second._audioCodecMp3Enabled);
      swap(first._audioCodecAacEnabled, second._audioCodecAacEnabled);
      swap(first._protocolSupportInformation, second._protocolSupportInformation);
      swap(first._maxNumPairedDevices, second._maxNumPairedDevices);
      swap(first._maxNumConnectedDevices, second._maxNumConnectedDevices);
      swap(first._defaultBtStatus, second._defaultBtStatus);
      swap(first._defaultLocalPairableMode, second._defaultLocalPairableMode);
      swap(first._defaultLocalConnectableMode, second._defaultLocalConnectableMode);
      swap(first._localPairableTimeoutSeconds, second._localPairableTimeoutSeconds);
      swap(first._localConnectableTimeoutSeconds, second._localConnectableTimeoutSeconds);
      swap(first._useFixedPinLegacyPairing, second._useFixedPinLegacyPairing);
      swap(first._pinLengthLegacyPairing, second._pinLengthLegacyPairing);
      swap(first._defaultFixedPinLegacyPairing, second._defaultFixedPinLegacyPairing);
      swap(first._autoConfirmRemoteLegacyPairingRequest, second._autoConfirmRemoteLegacyPairingRequest);
      swap(first._autoConfirmLocalLegacyPairingRequest, second._autoConfirmLocalLegacyPairingRequest);
      swap(first._autoConfirmRemoteSecureSimplePairingRequest, second._autoConfirmRemoteSecureSimplePairingRequest);
      swap(first._autoConfirmLocalSecureSimplePairingRequest, second._autoConfirmLocalSecureSimplePairingRequest);
      swap(first._allowLegacyPairingRetry, second._allowLegacyPairingRetry);
      swap(first._lostDeviceConnectionRetryDelayMilliSeconds, second._lostDeviceConnectionRetryDelayMilliSeconds);
      swap(first._localProtocolConnectingDelaySeconds, second._localProtocolConnectingDelaySeconds);
      swap(first._protocolDisconnectingTimeoutSeconds, second._protocolDisconnectingTimeoutSeconds);
      swap(first._defaultStandardAutoConnectionType, second._defaultStandardAutoConnectionType);
      swap(first._startAutoConnectionOnStartUp, second._startAutoConnectionOnStartUp);
      swap(first._linkQualityRequestTimeOut, second._linkQualityRequestTimeOut);
      swap(first._blockAllProtocolsForNonProjectionDevices, second._blockAllProtocolsForNonProjectionDevices);
      swap(first._connectAfterPairing, second._connectAfterPairing);
      swap(first._iapEnabled, second._iapEnabled);
      swap(first._defaultmultiHFPSupport, second._defaultmultiHFPSupport);
      swap(first._systemWideRingtoneEnabled, second._systemWideRingtoneEnabled);
      swap(first._blockDeviceRemoteConnectionsTimeoutSeconds, second._blockDeviceRemoteConnectionsTimeoutSeconds);
      swap(first._updateConflictDuringCPWOOBPairing, second._updateConflictDuringCPWOOBPairing);
      swap(first._CPWReconnectTimeoutInSecs, second._CPWReconnectTimeoutInSecs);
      swap(first._enableDefaultActionAtEndOfBtLimitation, second._enableDefaultActionAtEndOfBtLimitation);
      swap(first._deleteDeviceDuringOOBTPairing, second._deleteDeviceDuringOOBTPairing);
      swap(first._serviceSearchTimeoutSeconds, second._serviceSearchTimeoutSeconds);
      swap(first._defaultConnectionPageTimeoutMilliSeconds, second._defaultConnectionPageTimeoutMilliSeconds);
      swap(first._wifiHealthinessIndicatorInformation, second._wifiHealthinessIndicatorInformation);
      swap(first._delayAutoConnectionAtEndOfBtLimitationInSec, second._delayAutoConnectionAtEndOfBtLimitationInSec);
      swap(first._sppServiceInformation, second._sppServiceInformation);
      swap(first._kdsInformation, second._kdsInformation);
      swap(first._btOnOffSupport, second._btOnOffSupport);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreConfiguration& BmCoreConfiguration::operator=(BmCoreConfiguration other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreConfiguration::operator==(const BmCoreConfiguration& rhs) const
   {
      return ((this->_btModuleName == rhs._btModuleName)
            && (this->_btLocalFriendlyName == rhs._btLocalFriendlyName)
            && (this->_btLocalBdAddress == rhs._btLocalBdAddress)
            && (this->_didSpecificationId == rhs._didSpecificationId)
            && (this->_didVendorId == rhs._didVendorId)
            && (this->_didProductId == rhs._didProductId)
            && (this->_didVersion == rhs._didVersion)
            && (this->_didVendorIdSource == rhs._didVendorIdSource)
            && (this->_didClientExecutableUrl == rhs._didClientExecutableUrl)
            && (this->_didServiceDescription == rhs._didServiceDescription)
            && (this->_didClientDocumentationUrl == rhs._didClientDocumentationUrl)
            && (this->_carPlayWirelessSupported == rhs._carPlayWirelessSupported)
            && (this->_androidAutoWirelessSupported == rhs._androidAutoWirelessSupported)
            && (this->_wideBandSpeechEnabled == rhs._wideBandSpeechEnabled)
            && (this->_pbdlViaPbapEnabled == rhs._pbdlViaPbapEnabled)
            && (this->_pbdlViaHfpEnabled == rhs._pbdlViaHfpEnabled)
            && (this->_pbdlViaSppEnabled == rhs._pbdlViaSppEnabled)
            && (this->_pbdlViaSyncMlEnabled == rhs._pbdlViaSyncMlEnabled)
            && (this->_voiceRecognitionEnabled == rhs._voiceRecognitionEnabled)
            && (this->_enhancedCallControlEnabled == rhs._enhancedCallControlEnabled)
            && (this->_avrcpBrowsingEnabled == rhs._avrcpBrowsingEnabled)
            && (this->_audioCodecMp3Enabled == rhs._audioCodecMp3Enabled)
            && (this->_audioCodecAacEnabled == rhs._audioCodecAacEnabled)
            && (this->_protocolSupportInformation == rhs._protocolSupportInformation)
            && (this->_maxNumPairedDevices == rhs._maxNumPairedDevices)
            && (this->_maxNumConnectedDevices == rhs._maxNumConnectedDevices)
            && (this->_defaultBtStatus == rhs._defaultBtStatus)
            && (this->_defaultLocalPairableMode == rhs._defaultLocalPairableMode)
            && (this->_defaultLocalConnectableMode == rhs._defaultLocalConnectableMode)
            && (this->_localPairableTimeoutSeconds == rhs._localPairableTimeoutSeconds)
            && (this->_localConnectableTimeoutSeconds == rhs._localConnectableTimeoutSeconds)
            && (this->_useFixedPinLegacyPairing == rhs._useFixedPinLegacyPairing)
            && (this->_pinLengthLegacyPairing == rhs._pinLengthLegacyPairing)
            && (this->_defaultFixedPinLegacyPairing == rhs._defaultFixedPinLegacyPairing)
            && (this->_autoConfirmRemoteLegacyPairingRequest == rhs._autoConfirmRemoteLegacyPairingRequest)
            && (this->_autoConfirmLocalLegacyPairingRequest == rhs._autoConfirmLocalLegacyPairingRequest)
            && (this->_autoConfirmRemoteSecureSimplePairingRequest == rhs._autoConfirmRemoteSecureSimplePairingRequest)
            && (this->_autoConfirmLocalSecureSimplePairingRequest == rhs._autoConfirmLocalSecureSimplePairingRequest)
            && (this->_allowLegacyPairingRetry == rhs._allowLegacyPairingRetry)
            && (this->_lostDeviceConnectionRetryDelayMilliSeconds == rhs._lostDeviceConnectionRetryDelayMilliSeconds)
            && (this->_localProtocolConnectingDelaySeconds == rhs._localProtocolConnectingDelaySeconds)
            && (this->_protocolDisconnectingTimeoutSeconds == rhs._protocolDisconnectingTimeoutSeconds)
            && (this->_defaultStandardAutoConnectionType == rhs._defaultStandardAutoConnectionType)
            && (this->_startAutoConnectionOnStartUp == rhs._startAutoConnectionOnStartUp)
            && (this->_linkQualityRequestTimeOut == rhs._linkQualityRequestTimeOut)
            && (this->_blockAllProtocolsForNonProjectionDevices == rhs._blockAllProtocolsForNonProjectionDevices)
            && (this->_connectAfterPairing == rhs._connectAfterPairing)
            && (this->_iapEnabled == rhs._iapEnabled)
            && (this->_defaultmultiHFPSupport == rhs._defaultmultiHFPSupport)
            && (this->_systemWideRingtoneEnabled == rhs._systemWideRingtoneEnabled)
            && (this->_blockDeviceRemoteConnectionsTimeoutSeconds == rhs._blockDeviceRemoteConnectionsTimeoutSeconds)
            && (this->_updateConflictDuringCPWOOBPairing == rhs._updateConflictDuringCPWOOBPairing)
            && (this->_CPWReconnectTimeoutInSecs == rhs._CPWReconnectTimeoutInSecs)
            && (this->_enableDefaultActionAtEndOfBtLimitation == rhs._enableDefaultActionAtEndOfBtLimitation)
            && (this->_deleteDeviceDuringOOBTPairing == rhs._deleteDeviceDuringOOBTPairing)
            && (this->_serviceSearchTimeoutSeconds == rhs._serviceSearchTimeoutSeconds)
            && (this->_defaultConnectionPageTimeoutMilliSeconds == rhs._defaultConnectionPageTimeoutMilliSeconds)
            && (this->_wifiHealthinessIndicatorInformation == rhs._wifiHealthinessIndicatorInformation)
            && (this->_delayAutoConnectionAtEndOfBtLimitationInSec == rhs._delayAutoConnectionAtEndOfBtLimitationInSec)
            && (this->_sppServiceInformation == rhs._sppServiceInformation)
            && (this->_kdsInformation == rhs._kdsInformation)
            && (this->_btOnOffSupport == rhs._btOnOffSupport));
   }
}
