
#ifndef _BLOCK_STATUS_H_
#define _BLOCK_STATUS_H_

#include "OverallDeviceBlockStatus.h"
#include "DeviceBlockStatus.h"
#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class BlockStatus
   {
   public:

      BlockStatus();

      BlockStatus(const OverallDeviceBlockStatus overallDeviceBlockStatus, const DeviceBlockStatusList& deviceBlockStatusList);

      BlockStatus(const BlockStatus& other);

      ~BlockStatus();

      friend void swap(BlockStatus& first, BlockStatus& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      BlockStatus& operator=(BlockStatus other);

      bool operator==(const BlockStatus& rhs) const;

      bool operator!=(const BlockStatus& rhs) const;

      OverallDeviceBlockStatus _overallDeviceBlockStatus;
      DeviceBlockStatusList    _deviceBlockStatusList;

   private:

   };

} // namespace bmcore

#endif /* _BLOCK_STATUS_H_ */

