/****************************************************************************
*FILE:         AutoConnectionType.cpp 
*SW-COMPONENT: bmcore
*DESCRIPTION:  AutoConnectionType Property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AutoConnectionType.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "AutoConnectionType.h"
#include "FunctionTracer.h"

namespace bmcore
{
   AutoConnectionType::AutoConnectionType() : _type(BM_STANDARD_AUTO_CONNECTION_UNKNOWN)
   {
      ENTRY_INTERNAL
   }

   AutoConnectionType::AutoConnectionType(const StandardAutoConnectionType type) :  _type(type)
   {
      ENTRY_INTERNAL
   }

   AutoConnectionType::AutoConnectionType(const AutoConnectionType& other): _type(other._type)
   {
      ENTRY_INTERNAL
   }

   AutoConnectionType::~AutoConnectionType()
   {
      ENTRY_INTERNAL

   }

   void swap(AutoConnectionType& first, AutoConnectionType& second)
   {
      using std::swap;

      swap(first._type, second._type);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   AutoConnectionType& AutoConnectionType::operator=(AutoConnectionType other)
   {
      swap(*this, other);

      return *this;
   }

   bool AutoConnectionType::operator==(const AutoConnectionType& rhs) const
   {
      return ((this->_type == rhs._type));
   }

   bool AutoConnectionType::operator!=(const AutoConnectionType& rhs) const
   {
      return (!(this->_type == rhs._type));
   }
}

