
#ifndef _AUTO_CONNECTION_STATUS_H_
#define _AUTO_CONNECTION_STATUS_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class AutoConnectionStatus
   {
   public:

      AutoConnectionStatus();

      AutoConnectionStatus(const AutoConnectionState& autoConnectionState, const DeviceId _deviceIdInProgress);

      AutoConnectionStatus(const AutoConnectionStatus& other);

      friend void swap(AutoConnectionStatus& first, AutoConnectionStatus& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      AutoConnectionStatus& operator=(AutoConnectionStatus other);

      bool operator==(const AutoConnectionStatus& rhs) const;

      bool operator!=(const AutoConnectionStatus& rhs) const;

      ~AutoConnectionStatus();

      AutoConnectionState _autoConnectionState;
      DeviceId _deviceIdInProgress;

   private:

   };

} // namespace bmcore

#endif // _AUTO_CONNECTION_STATUS_H_
