#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/AutoConnectionStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "AutoConnectionStatus.h"
#include "FunctionTracer.h"

namespace bmcore
{
   AutoConnectionStatus::AutoConnectionStatus() : _autoConnectionState(), _deviceIdInProgress(0u)
   {
      ENTRY_INTERNAL
   }

   AutoConnectionStatus::AutoConnectionStatus(const AutoConnectionState& autoConnectionState,
         const DeviceId deviceIdInProgress) :
    _autoConnectionState(autoConnectionState),
    _deviceIdInProgress(deviceIdInProgress)
   {
      ENTRY_INTERNAL
   }

   AutoConnectionStatus::AutoConnectionStatus(const AutoConnectionStatus& other) :
         _autoConnectionState(other._autoConnectionState),
         _deviceIdInProgress(other._deviceIdInProgress)
   {
      ENTRY_INTERNAL
   }

   AutoConnectionStatus::~AutoConnectionStatus()
   {
      ENTRY_INTERNAL
   }

   void swap(AutoConnectionStatus& first, AutoConnectionStatus& second)
   {
      using std::swap;

      swap(first._autoConnectionState, second._autoConnectionState);
      swap(first._deviceIdInProgress, second._deviceIdInProgress);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   AutoConnectionStatus& AutoConnectionStatus::operator=(AutoConnectionStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool AutoConnectionStatus::operator==(const AutoConnectionStatus& rhs) const
   {
      return ((this->_autoConnectionState == rhs._autoConnectionState)
            && (this->_deviceIdInProgress == rhs._deviceIdInProgress));
   }

   bool AutoConnectionStatus::operator!=(const AutoConnectionStatus& rhs) const
   {
      return (!(this->operator ==(rhs)));
   }
}
