
#ifndef _I_BM_CORE_CALLBACK_IF_H_
#define _I_BM_CORE_CALLBACK_IF_H_

#include "BmCoreIfTypes.h"

namespace bmcore
{
   class IBmCoreCallbackIf
   {

   public:

       IBmCoreCallbackIf()
       {

       };

       virtual ~IBmCoreCallbackIf()
       {

       };

       virtual void updateConfiguration(INOUT BmCoreConfiguration& bmCoreConfiguration) = 0;

       virtual void stateChangeNormalResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void stateChangeOffResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onBtSystemStateChanged(IN const BtSystemState& btSystemState) = 0;

       virtual void setProtocolUserAvailabilityResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void setAutoConnectionTypeResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void switchLocalPairableModeResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onLocalPairableModeChanged(IN const SwitchStatus& localPairableMode) = 0;

       virtual void switchLocalConnectableModeResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onLocalConnectableModeChanged(IN const SwitchStatus& localConnectableMode) = 0;

       virtual void switchDiscoveryStatusResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onDiscoveryStatusChanged(IN const SwitchStatus& discoveryStatus) = 0;

       virtual void onDiscoveredDeviceChanged(IN const BdAddress& bdAddress, IN const BdName& btDeviceName) = 0;

       virtual void onDiscoveredDeviceListChanged(IN const DiscoveredDeviceList& discoveredDeviceList) = 0;

       virtual void switchBtStatusResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onBtStatusChanged(IN const SwitchStatus& bluetoothStatus) = 0;

       virtual void onBtLocalFriendlyNameChanged(IN const LocalFriendlyName& btLocalFriendlyName) = 0;

       virtual void onBtLocalInfoChanged(IN const LocalInfo& btLocalInfo) = 0;

       virtual void onPairingStatusChanged(IN const PairingStatus& btPairingStatus) = 0;

       virtual void onPairingPinChanged(IN const PairingPin& pairingPin) = 0;

       virtual void rejectPairingRequestResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void acceptPairingRequestResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void setPairingPinResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void addOobPairedDeviceResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onPairedDeviceListChanged(IN const PairedDeviceList& pairedDeviceList) = 0;

       virtual void onDeviceConnectionStatusListChanged(IN const DeviceConnectionStatusList& deviceConnectionStatusList) = 0;

       virtual void cancelPairingResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void startPairingResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onAutoConnectionStatusChanged(IN const AutoConnectionStatus& autoConnectionStatus) = 0;

       virtual void connectDeviceResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void disconnectDeviceResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void deleteDeviceResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void blockDeviceResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void unblockDeviceResponse(IN const DeviceId deviceHandle,IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void connectProfilesResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void disconnectProfilesResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void storeDeviceRingtoneIdInDbResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void readDeviceRingtoneIdFromDbResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void storeSystemWideRingtoneIdInDbResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void readSystemWideRingtoneIdFromDbResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void blockProfilesResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void unblockProfilesResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onBlockStatusChanged(IN const BlockStatus& blockStatus) = 0;

       virtual void setFavoriteResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void clearFavoriteResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void startServiceSearchResponse (IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void stopServiceSearchResponse (IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void switchMultiHFPSupportResponse (IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void setDeviceUsagePreferenceResponse (IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onMultiHFPSupportStatusChanged(IN const SwitchStatus& multiHFPSupportStatus) = 0;

       virtual void onAutoConnectionTypeChanged(IN const AutoConnectionType& autoConnectionType) = 0;

       virtual void startAutoConnectSequenceResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void stopAutoConnectSequenceResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onBmConfigDataChanged(IN const BmConfigData& bmConfigData) = 0;

       virtual void onBmServiceAvailabilityChanged(IN const BmServiceAvailability& bmServiceAvailability) = 0;

       virtual void onLinkQualityChanged(IN const LinkQuality& linkQuality) = 0;

       virtual void updateLinkQualityResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void setBtLimitationModeResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void replaceBtLimitationModeResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onBtLimitationModeChanged(IN const BtLimitationMode& btLimitationMode) = 0;

       virtual void onUserDecisionRequiredSignal(IN const IssueInfoList& issueInfoList) = 0;

       virtual void notifyUserDecisionResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void resetToDefaultResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onResetToDefaultStatusChanged(IN const ResetToDefaultStatus& status) = 0;

       virtual void switchTestModeResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;

       virtual void onTestModeChanged(IN const SwitchStatus& testMode) = 0;

       virtual void requestTestModeLinkQualityResponse(IN const BmResult bmResult, IN const LinkQualityInfo& linkQualityInfo,
             IN const ActType act = 0u) = 0;

       virtual void onLinkQualityTestModeChanged(IN const TestModeLinkQuality& linkQuality) = 0;

       virtual void setPrimaryHfpDeviceResponse(IN const BmResult bmResult) = 0;

       virtual void onBtProfileUsageInfoChanged(IN const ProfileUsageList& btProfileUsageList) = 0;

       virtual void setBtProfileUsageInfoResponse(IN const BmResult bmResult, IN const ActType act = 0u) = 0;
   };
}

#endif // _I_BM_CORE_CALLBACK_IF_H_
