/**
 * @file BtStackIfWblRequestIfWrapper.h
 * 
 * @swcomponent BluetoothConnectionManagerCore
 *
 * @brief This file contains the declaration of the class BtStackIfWblRequestIfWrapper
 * 
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmControllerModule
 *
 */

#ifndef _BT_STACK_IF_WBL_REQUEST_IF_WRAPPER_H_
#define _BT_STACK_IF_WBL_REQUEST_IF_WRAPPER_H_

#include "BtStackIfTypes.h"

using namespace ::btstackif;

// class forward declaration
namespace btstackif
{
   class IBtStackIfWblRequest;
   class IBtStackIfWblCallback;
} // btstackif

namespace bmcore
{
   /**
    * @class BtStackIfWblRequestIfWrapper
    * @ingroup BmControllerModule
    * 
    * @brief
    * 
    */
   class BtStackIfWblRequestIfWrapper
   {
   public:

	   /**
       * @brief Constructor of class BtStackIfWblRequestIfWrapper which creates an instance
       *
       * @return void
       */
       explicit BtStackIfWblRequestIfWrapper();

       /**
       * @brief Destructor of class BtStackIfWblRequestIfWrapper
       *
       * @return void
       */
       virtual ~BtStackIfWblRequestIfWrapper();

      /**************************************************************************
       General interfaces
       **************************************************************************/
       /**
       * Register callback instance.
       *
       * @param[in] callback: callback instance
       */
      void registerCallback(IBtStackIfWblCallback* callback);

      /**
       * Requests a session handle to be used for communication between BtStackIf user and BtStackIf library itself.
       * The session handle provides the possibility to distinguish different BtStackIf users while accessing same BtStackIf request interface.
       * The session handle 0 indicates a common interface call without session relation.
       *
       * @return = session handle, always > 0
       */
      BTSSessionHandle getSessionHandle(void) const;

      /**
       * Initialize the BtStackIf library.
       * - opens/prepares DBUS communication
       * - starts internal threads
       *
       * @return != BTS_OK: error,
       * @return  = BTS_OK: OK
       */
      BTSErrorCode init(IN const BTSLocalWblConfiguration& configuration) const;

      /**
       * Deinitialize the BtStackIf library.
       * - stops internal threads
       * - closes DBUS communication
       *
       * @return != BTS_OK: error,
       * @return  = BTS_OK: OK
       */
      BTSErrorCode deInit(void) const;

      /**************************************************************************
       Wbl management related interfaces
       **************************************************************************/
      void setWblDummy(void);

      void allowWblCommunication(void);

      void blockWblCommunication(void);

      void getWblCommunicationStatus(void);

      void getWblLastIntendedMode(void);

   private:


      BtStackIfWblRequestIfWrapper& operator=(const BtStackIfWblRequestIfWrapper &other);

      BtStackIfWblRequestIfWrapper(const BtStackIfWblRequestIfWrapper &other);

      IBtStackIfWblRequest* _btStackIfWblRequestIf;
   };
}

#endif // _BT_STACK_IF_WBL_REQUEST_IF_WRAPPER_H_

