/**
 * @file BtStackIfWblCallbackIf.h
 * 
 * @swcomponent BluetoothConnectionManagerCore
 *
 * @brief This file contains the declaration of the class BtStackIfWblCallbackIf
 * 
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmControllerModule
 *
 */

#ifndef _BT_STACK_IF_WBL_CALLBACK_IF_H_
#define _BT_STACK_IF_WBL_CALLBACK_IF_H_

#include "IBtStackIfWblCallback.h"

using namespace ::btstackif;

namespace bmcore
{
   class BmCoreMainController;

   /**
    * @class BtStackIfWblCallbackIf
    * @ingroup BmControllerModule
    * 
    * @brief
    * 
    */
   class BtStackIfWblCallbackIf : public IBtStackIfWblCallback
   {
   public:
      /**
       * @brief Constructor of class BtStackIfWblCallbackIf which creates an instance
       *
       * @return void
       */
      explicit BtStackIfWblCallbackIf(BmCoreMainController& bmCoreMainController);

      /**
       * @brief Destructor of class BtStackIfWblCallbackIf
       *
       * @return void
       */
      virtual ~BtStackIfWblCallbackIf();

      // ***********************************
      // * Overridden methods of BtStackIf *
      // ***********************************

      void fbWblInitializedCB(IN const BTSRequestResult btsResult);

      void setWblDummyResultCB(IN const BTSRequestResult btsResult);

      void allowWblCommunicationResultCB(void);

      void blockWblCommunicationResultCB(void);

      void wblCommunicationStatusCB(IN const bool btsEnabled);

      void wblServiceAvailabilityCB(IN const bool btsServiceAvailable);

      void wblLastIntendedModeCB(IN const BTSWblLastIntendedModeList& btsLastIntendedModeList);

      void wblSupportedRestrictionsCB(IN const BTSWblSupportedRestrictionEntryList& btsSupportedRestrictionList);

      void wblWiFiSetupStatusCB(IN const BTSWblWiFiSetupStatusEntryList& btsWifiSetupStatusList);

      void wblHealthinessIndicatorCB(IN const BTSWblHealthinessIndicator btsValue);

   private:

      BmCoreMainController& _bmCoreMainController;
      bool _blockCallback;
   };
}

#endif // _BT_STACK_IF_WBL_CALLBACK_IF_H_

