/**
 * @file BtStackIfConnectionCallbackIf.h
 * 
 * @swcomponent BluetoothConnectionManagerCore
 *
 * @brief This file contains the declaration of the class BtStackIfConnectionCallbackIf
 * 
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmControllerModule
 *
 */

#ifndef _BT_STACK_IF_CONNECTION_CALLBACK_IF_H_
#define _BT_STACK_IF_CONNECTION_CALLBACK_IF_H_

#include "IBtStackIfConnectionCallback.h"

using namespace ::btstackif;

namespace bmcore
{
   class BmCoreMainController;

   /**
    * @class BtStackIfConnectionCallbackIf
    * @ingroup BmControllerModule
    * 
    * @brief
    * 
    */
   class BtStackIfConnectionCallbackIf :  public IBtStackIfConnectionCallback
   {
   public:
      /**
       * @brief Constructor of class BtStackIfConnectionCallbackIf which creates an instance
       *
       * @return void
       */
      explicit BtStackIfConnectionCallbackIf(BmCoreMainController& bmCoreMainController);

      /**
       * @brief Destructor of class BtStackIfConnectionCallbackIf
       *
       * @return void
       */
      virtual ~BtStackIfConnectionCallbackIf();

      // ***********************************
      // * Overridden methods of BtStackIf *
      // ***********************************

      void fbConnectionInitializedCB(IN const BTSRequestResult btsResult);

      void localVersionInfoCB(IN const BTSLocalVersionInfo& btsVersionInfo);

      void switchBluetoothOnOffResultCB(IN const BTSRequestResult btsResult);

      void currentBluetoothOnOffStatusCB(IN const BTSBluetoothMode btsBluetoothMode,
            IN const BTSBluetoothOffReason btsBluetoothOffReason, IN const BTSAdapterMode btsAdapterMode,
            IN const BTSBDAddress& btsLocalDeviceAddress);

      void switchBluetoothHardwareOnOffResultCB(IN const BTSRequestResult btsResult);

      void setLocalBtNameResultCB(IN const BTSRequestResult btsResult);

      void currentLocalBtNameCB(IN const BTSDeviceName& btsAdapterName);

      void currentDeviceForRestrictedPairingConnectingCB(IN const BTSBDAddress& btsExpectedDeviceAddress,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void setLocalAdapterModesResultCB(IN const BTSRequestResult btsResult, IN const BTSSessionHandle btsSessionHandle = 0);

      void currentDiscoverableModeCB(IN const BTSLocalMode btsDiscoverableMode, IN const BTSLocalModeOffReason btsOffReason,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void currentConnectableModeCB(IN const BTSLocalMode btsConnectableMode, IN const BTSLocalModeOffReason btsOffReason,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void startDiscoveryResultCB(IN const BTSRequestResult btsResult, IN const BTSSessionHandle btsSessionHandle = 0);

      void stopDiscoveryResultCB(IN const BTSRequestResult btsResult, IN const BTSSessionHandle btsSessionHandle = 0);

      void discoveringStatusCB(IN const BTSDiscoveringStatus btsDiscoveringStatus, IN const BTSSessionHandle btsSessionHandle = 0);

      void discoveredDeviceFoundCB(IN const BTSDiscoveredDeviceInfo& btsDiscoveredDevice, IN const BTSSessionHandle btsSessionHandle = 0);

      void startPairingResultCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSRequestResult btsResult,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void pinCodeRequestedCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSDeviceName& btsDeviceName,
            IN const BTSPairConnectOriginator pairingOriginator, IN const BTSSessionHandle btsSessionHandle = 0);

      void secureSimplePairingRequestedCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSDeviceName& btsDeviceName,
            IN const BTSSspMode btsSspMode, IN const BTSNumericValue& btsNumericValue,
            IN const BTSPairConnectOriginator btsPairingOriginator, IN const BTSSessionHandle btsSessionHandle = 0);

      void pairingFinishedCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSRequestResult btsResult,
            IN const BTSLinkKeyType btsLinkKeyType, IN const BTSLinkKey& btsLinkKey, IN const BTSDLinkKey& btsDLinkKey,
            IN const BTSMajorServiceClass& btsMajorServiceClass, IN const BTSMajorDeviceClass btsMajorDeviceClass,
            IN const BTSMinorDeviceClass btsMinorDeviceClass, IN const BTSDeviceName& btsDeviceName,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void linkKeyRequestedCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSSessionHandle btsSessionHandle = 0);

      void connectProtocolResultCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSRequestResult btsResult,
            IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid, IN const BTSMasInstanceName& btsMasInstance,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void remoteProtocolConnectRequestCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSProtocolId btsProtocolId,
            IN const BTSUuid& btsSppUuid, IN const BTSSessionHandle btsSessionHandle = 0);

      void disconnectProtocolResultCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSRequestResult btsResult,
            IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid, IN const BTSMasInstanceName& btsMasInstance,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void disconnectDeviceResultCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSRequestResult btsResult,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void protocolConnectionStatusCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSConnectionStatus btsConnectionStatus,
            IN const BTSDisconnectReason btsDisconnectReason, IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid,
            IN const BTSMasInstanceName& btsMasInstance, IN const BTSDeviceName& btsRfCommDevice,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void deviceConnectionStatusCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSConnectionStatus btsConnectionStatus,
            IN const BTSDisconnectReason btsDisconnectReason, IN const BTSSessionHandle btsSessionHandle = 0);

      void deviceCapabilitiesCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSDeviceCapabilities& btsDeviceCapabilities,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void remoteSupportedServicesCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSRequestResult btsResult,
            IN const BTSSupportedServices& btsSupportedServices, IN const BTSServiceInfoList& btsServiceInfoList,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void remoteSppCapabilitiesCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSRequestResult btsResult,
            IN const BTSSppCapabilityList& btsSppCapabilities, IN const BTSSessionHandle btsSessionHandle = 0);

      void remoteDeviceIdServiceRecordsCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSRequestResult btsResult,
            IN const BTSDeviceIdServiceRecordList& btsDeviceIdServiceRecords, IN const BTSSessionHandle btsSessionHandle = 0);

      void remoteServiceSearchResultCB(IN const BTSBDAddress& btsBdAddress, IN const BTSRequestResult btsSupportedServicesResult,
            IN const BTSRequestResult btsSppCapabilitiesResult, IN const BTSRequestResult btsDeviceIdServiceRecordsResult,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void remoteNameResultCB(IN const BTSBDAddress& btsBdAddress, IN const BTSRequestResult btsResult,
            IN const BTSDeviceName& btsBdName, IN const BTSSessionHandle btsSessionHandle = 0);

      void remoteNameStatusCB(IN const BTSBDAddress& btsBdAddress, IN const BTSDeviceName& btsDeviceName,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void linkQualityResultCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSRequestResult btsResult,
            IN const BTSRssi btsRssi, IN const BTSLinkQuality btsLinkQuality, IN const BTSSessionHandle btsSessionHandle = 0);

      void startTestModeResultCB(IN const BTSRequestResult btsResult, IN const BTSSessionHandle btsSessionHandle = 0);

      void stopTestModeResultCB(IN const BTSRequestResult btsResult, IN const BTSSessionHandle btsSessionHandle = 0);

      void testModeStatusCB(IN const BTSBDAddress& btsDeviceAddress, IN const BTSConnectionStatus btsConnectionStatus,
            IN const BTSSessionHandle btsSessionHandle = 0);

      void testModeLinkQualityResultCB(IN const BTSRequestResult btsResult, IN const BTSRssi btsRssi,
            IN const BTSLinkQuality btsLinkQuality, IN const BTSSessionHandle btsSessionHandle = 0);

   private:

      BmCoreMainController& _bmCoreMainController;
      bool _blockCallback;
   };
}

#endif // _BT_STACK_IF_CONNECTION_CALLBACK_IF_H_

