#ifndef _BM_CORE_REQUEST_IF_H_
#define _BM_CORE_REQUEST_IF_H_

#include "IBmCoreRequestIf.h"
#include "BaseTypes.h"
#include "Lock.h"

namespace bmcore
{
   class BmInterface : public IBmCoreRequestIf
   {
   public:
      /**
       * Function to create a singleton for the BmInterface
       *
       * @return pointer to instance of BmInterface object
       */
//      static IBmCoreInterface& getInstance(void);

      /**
       * @brief Destroys singleton instance of this class
       *
       *
       * @return void
       */
//      static void destroyInstance();

      BmInterface();

      virtual ~BmInterface();

      // ***********************************************
      // * Implementation of IBmCoreRequestIf *
      // ***********************************************

      // synchronous
      BmResult registerBmCoreCallbackIf(IBmCoreCallbackIf* bmCoreCallbackIf);

      // synchronous
      BmResult initializeBmCore(void);

      // synchronous
      BmResult stateChangeNormal(IN const ActType act = 0u);

      // synchronous
      BmResult stateChangeOff(IN const ActType act = 0u);

      // synchronous
      BmResult setBtSystemState(IN const BtSystemState& btSystemState, IN const ActType act = 0u);

      // synchronous
      BmResult getBtSystemState(OUT BtSystemState& btSystemState);

      // asynchronous
      BmResult setProtocolUserAvailability(IN const Protocol& protocol, IN const bool available, IN const ActType act = 0u);

      // asynchronous
      BmResult switchBtStatus(IN const TargetSwitchState targetSwitchState,
            IN const bool suppressAutoConnectionAfterSwitchedOn = false, IN const bool delayBtOnRequest = false, IN const ActType act = 0u);

      // synchronous
      BmResult getBtStatus(OUT SwitchStatus& bluetoothStatus);

      // asynchronous
      BmResult switchLocalPairableMode(IN const TargetSwitchState targetSwitchState, IN const BdAddress& bdAddress,
            IN const ActType act = 0u);

      // synchronous
      BmResult getLocalPairableMode(OUT SwitchStatus& localPairableMode);

      // asynchronous
      BmResult switchLocalConnectableMode(IN const TargetSwitchState targetSwitchState, IN const BdAddress& bdAddress,
            IN const ActType act = 0u);

      // synchronous
      BmResult getLocalConnectableMode(OUT SwitchStatus& localConnectableMode);

      // asynchronous
      BmResult switchDiscoveryStatus(IN const TargetSwitchState targetSwitchState, IN const ActType act = 0u);

      // synchronous
      BmResult getDiscoveryStatus(OUT SwitchStatus& discoveryStatus);

      // synchronous
      BmResult getDiscoveredDeviceList(OUT DiscoveredDeviceList& discoveredDeviceList);

      // asynchronous
      BmResult setBtLocalFriendlyName(IN const LocalFriendlyName& localFriendlyName, IN const ActType act = 0u);

      // synchronous
      BmResult getBtLocalFriendlyName(OUT LocalFriendlyName& localFriendlyName);

      // synchronous
      BmResult getBtLocalInfo(OUT LocalInfo& localInfo);

      BmResult startPairing(IN const BdAddress& bdAddress, IN const ActType act = 0u);

      BmResult cancelPairing(IN const ActType act = 0u);

      BmResult acceptPairingRequest(IN const ActType act = 0u);

      BmResult rejectPairingRequest(IN const ActType act = 0u);

      // synchronous
      BmResult getPairingStatus(OUT PairingStatus& btPairingStatus);

      BmResult setPairingPin(IN const PairingPin& pairingPin, IN const ActType act = 0u);

      // synchronous
      BmResult getPairingPin(OUT PairingPin& pairingPin);

      // synchronous
      BmResult getPairedDeviceList(OUT PairedDeviceList& pairedDeviceList);

      // asynchronous
      BmResult addOobPairedDevice(IN const BdAddress& bdAddress, IN const BdName& bdName,
            IN const LinkKey& linkKey, IN const OobType oobType, IN const ActType act = 0u);

      BmResult deleteDevice(IN const DeviceId deviceHandle, IN const DeviceHandleType deviceHandleType,
            IN const ActType act = 0u);

      BmResult connectDevice(IN const DeviceId deviceHandle, IN const ActType act = 0u);

      BmResult disconnectDevice(IN const DeviceId deviceHandle, IN const DeviceHandleType deviceHandleType,
            IN const ActType act = 0u);

      BmResult connectProfiles(IN const DeviceId deviceId, IN const ProtocolList& protocolList,
            IN const ActType act = 0u);

      BmResult disconnectProfiles(IN const DeviceId deviceId, IN const ProtocolList& protocolList,
            IN const ActType act = 0u);

      // synchronous
      BmResult storeDeviceRingtoneIdInDb(IN const DeviceId deviceHandle, IN const RingtoneId ringtoneId,
            IN const ActType act = 0u);

      // synchronous
      BmResult readDeviceRingtoneIdFromDb(OUT RingtoneId& ringtoneId, IN const DeviceId deviceHandle);

      // synchronous
      BmResult storeSystemWideRingtoneIdInDb(IN const RingtoneId ringtoneId, IN const ActType act = 0u);

      // synchronous
      BmResult readSystemWideRingtoneIdFromDb(OUT RingtoneId& ringtoneId);

      // synchronous
      BmResult getRemoteDeviceInfo(OUT RemoteDeviceInfo& remoteDeviceInfo, IN const DeviceId deviceHandle);

      // synchronous
      BmResult getDeviceConnectionStatusList(OUT DeviceConnectionStatusList& deviceConnectionStatusList);

      BmResult blockDevice(IN const DeviceId deviceHandle, IN const DeviceHandleType deviceHandleType,
            IN const ActType act = 0u);

      BmResult unblockDevice(IN const DeviceId deviceHandle, IN const DeviceHandleType deviceHandleType,
            IN const ActType act = 0u);

      BmResult blockProfiles(IN const DeviceId deviceHandle, IN const ProtocolList& protocolList,
            IN const ActType act = 0u);

      BmResult unblockProfiles(IN const DeviceId deviceHandle, IN const ProtocolList& protocolList,
            IN const ActType act = 0u);

      // synchronous
      BmResult getBlockStatus(OUT BlockStatus& blockStatus);

      // asynchronous
      BmResult setFavorite(IN const DeviceId deviceHandle, IN const FavoriteType favoriteType,
            IN const FavoriteIndex favoriteIndex, IN const ActType act = 0u);

      // asynchronous
      BmResult clearFavorite(IN const DeviceId deviceHandle, IN const FavoriteType favoriteType,
            IN const ActType act = 0u);

      // asynchronous
      BmResult startServiceSearch (IN const DeviceId deviceHandle, IN const ActType act = 0u);

      // asynchronous
      BmResult stopServiceSearch (IN const DeviceId deviceHandle, IN const ActType act = 0u);

      BmResult setAutoConnectionType(IN const AutoConnectionType autoConnectionType, IN const ActType act = 0u);

      // synchronous
      BmResult getAutoConnectionType(OUT AutoConnectionType& autoConnectionType);

      BmResult startAutoConnectSequence(IN const TemporaryAutoConnectionType autoConnectionType,
            IN const ActType act = 0u);

      BmResult stopAutoConnectSequence(IN const ActType act = 0u);

      // synchronous
      BmResult getBmConfigData(OUT BmConfigData& bmConfigData);

      // asynchronous
      void updateLinkQuality(IN const ActType act = 0u);

      // synchronous
      BmResult getLinkQuality(OUT LinkQuality& linkQuality);

      // asynchronous
      void setBtLimitationMode(IN const BdAddress& bdAddress, IN const BdName& bdName, IN const LimitationMode& limitationMode,
            IN const LimitationAction limitationAction, IN const ActType act = 0u);

      // synchronous
      BmResult getBtLimitationMode(OUT BtLimitationMode& btLimitationMode);

      void notifyUserDecision(IN const UserDecisionInfo userDecisionInfo, IN const ActType act = 0u);

      BmResult resetToDefault(IN const bool factorySettingsChanged = true, IN const ActType act = 0u);

      // synchronous
      BmResult getResetToDefaultStatus(OUT ResetToDefaultStatus& resetToDefaultStatus);

      // asynchronous
      BmResult switchTestMode(IN const TargetSwitchState& targetSwitchState, IN const BdAddress& bdAddress,
            IN const ActType act = 0u);

      // synchronous
      BmResult getTestMode(OUT SwitchStatus& testMode);

      BmResult requestTestModeLinkQuality(IN const ActType act = 0u);

      BmResult getLinkQualityTestMode(OUT TestModeLinkQuality& linkQuality);

      // asynchronous
      BmResult setPrimaryHfpDevice(IN const DeviceId deviceHandle);

      // asynchronous
      BmResult switchMultiHFPSupport(IN const TargetSwitchState targetSwitchState, IN const ActType act = 0u);

      // asynchronous
      void setBtProfileUsageInfo(IN const ProfileUsageList& profileUsageInfoList, IN const ActType act = 0u);

      // synchronous
      BmResult getMultiHFPSupport(OUT SwitchStatus& multiHFPSupport);

      // asynchronous
      BmResult setDeviceUsagePreference(IN const DeviceId deviceHandle, IN const UsagePreference usagePreference, IN const ActType act = 0u);

      // synchronous
      BmResult getDeviceUsagePreference(OUT UsagePreference& usagePreference, IN const DeviceId deviceHandle);

      // asynchronous
      void replaceBtLimitationMode(IN const BtLimitationModeInfo& limitationModeToBeReplaced, IN const BdAddress& bdAddress,
            IN const BdName& bdName, IN const LimitationMode& limitationMode, IN const LimitationAction limitationAction, IN const ActType act = 0u);

   private:

      /**
       * @brief Default constructor of this class
       * @note Constructor is private since this class is a singleton.
       *
       * @return void
       */
//      BmInterface();

      /**
       * @brief Destructor of this class
       * @note Destructor is private since this class is a singleton.
       *
       * @return void
       */
//      virtual ~BmInterface();

      /**
       * @brief Copy constructor of this class
       * @note Copy constructor explicitly declared to prevent from unintentional misuse.
       *
       * @return void
       */
//      BmInterface(const BmInterface&);

      /**
       * @brief Assignment operator
       * @note Assignment operator explicitly declared to prevent from unintentional misuse.
       *
       * @return void
       */
//      const BmInterface& operator=(const BmInterface&);

   protected:

//      static BmInterface* _bmInterface; /**< pointer to singleton instance of this class */

      /* BmInterface is created */
      bool _isInitialized;

      LockForeverAndNonReentrant _interfaceLock;

   };
}

#endif // _BM_CORE_REQUEST_IF_H_
