/**
 * @file ServiceSearchController.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of the class ServiceSearchController
 *
 * @copyright (c) 2017 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _SERVICE_SEARCH_CONTROLLER_H_
#define _SERVICE_SEARCH_CONTROLLER_H_

#include "BmAllTypesInternal.h"
#include "BaseTypes.h"
#include "DeviceServiceSearchControl.h"

namespace bmcore
{
   class BmCoreMainController;

   class ServiceSearchController
   {
   public:

      explicit ServiceSearchController(BmCoreMainController& bmCoreMainController);

      ~ServiceSearchController();

      Result addDeviceForServiceSearch(const DeviceId deviceHandle);

      Result removeDeviceFromServiceSearch(const DeviceId deviceHandle);

      Result startServiceSearchTimer(const DeviceId deviceHandle);

      Result stopServiceSearchTimer(const DeviceId deviceHandle);

      Result serviceSearchFinished(const DeviceId deviceHandle);

   private:

      ServiceSearchController(const ServiceSearchController& other);

      ServiceSearchController& operator=(const ServiceSearchController& rhs);

      BmCoreMainController& _bmCoreMainController;

      DeviceServiceSearchControlList _deviceServiceSearchControlList;
   };
}

#endif // _SERVICE_SEARCH_CONTROLLER_H_
