/**
 * @file BlockRemoteConnectionsController.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of the class BlockRemoteConnectionsController
 *
 * @copyright (c) 2017 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _BLOCK_REMOTE_CONNECTIONS_CONTROLLER_H_
#define _BLOCK_REMOTE_CONNECTIONS_CONTROLLER_H_

#include "BmAllTypesInternal.h"
#include "BaseTypes.h"
#include "DeviceBlockRemoteConnectionsControl.h"

namespace bmcore
{
   class BmCoreMainController;

   class BlockRemoteConnectionsController
   {
   public:

      explicit BlockRemoteConnectionsController(BmCoreMainController& bmCoreMainController);

      ~BlockRemoteConnectionsController();

      Result initializeDeviceRemoteConnectableControlList(const DeviceIdList& pairedDeviceHandles);

      Result addDeviceRemoteConnectableControl(const DeviceId deviceHandle);

      Result removeDeviceRemoteConnectableControl(const DeviceId deviceHandle);

      Result startBlockRemoteConnectionsTimer(const DeviceId deviceHandle);

      Result stopBlockRemoteConnectionsTimer(const DeviceId deviceHandle);

   private:

      BlockRemoteConnectionsController(const BlockRemoteConnectionsController& other);

      BlockRemoteConnectionsController& operator=(const BlockRemoteConnectionsController& rhs);

      BmCoreMainController& _bmCoreMainController;

      DeviceBlockRemoteConnectionsControlList _deviceBlockRemoteConnectionsControlList;
   };
}

#endif // _BLOCK_REMOTE_CONNECTIONS_CONTROLLER_H_
