#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_DBMANAGER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DbManager.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_DBMANAGER
#endif
#endif

#include "DbManager.h"
#include "BmAllTypes.h"
#include "FunctionTracer.h"
#include "LocalSpm.h"
#include "DataProvider.h"
#include "Database.h"
#include <TimeTrace.h>
#include "ElapsedTimer.h"
#include "BmVarTrace.h"
#include "BmCoreIfMessagesCreator.h"
#include "BmUtils.h"

#include <stdarg.h>
#include <cstring>
#include <sys/stat.h>
#include <fstream>
#include <time.h>
#include <sys/time.h>
#include <ctype.h>
#include <glib.h>
#include <algorithm>

namespace bmcore
{
   using std::__basic_file;

   //#define ENTRY           FunctionTracer  _t(ETG_DEFAULT_TRACE_CLASS,__PRETTY_FUNCTION__);

   /*lint -save -e774 */

   DbManager::DbManager(ComponentId componentID) :
         ILocalSpm(componentID),
         _db(0),
         _databaseAccessSwitchedOn(false),
         _newDeviceProtocolBlockStatusTemplate(),
         _protocolconnectionsmhandlemapp(),
         _protocollist(),
         _lockAssignProtocol()
   {
      ENTRY_INTERNAL

      ETG_TRACE_USR1(("DbManager: being created"));

   }

   DbManager::~DbManager()
   {
      ENTRY_INTERNAL

      _db = 0;
   }

   // Methods implementation
   void DbManager::create()
   {
       ENTRY

       ETG_TRACE_USR1(("create"));

       _db = NULL;
       if(_newDeviceProtocolBlockStatusTemplate.empty() == true)
       {
          // UNKNOWN USB non-projection devices (all protocols unblocked)
          ProtocolBlockStatusMap protocolBlockStatusMap;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_HFP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PBDL, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_MSG, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PAN, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_SPP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_UNKNOWN,
                BM_LIMITATION_COMMUNICATION_IF_USB), false)] = protocolBlockStatusMap;

          // AAP/CarLife/Oncar/ML/mySPIN USB projection device
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_HFP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PBDL, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_MSG, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PAN, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_SPP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_ANDROID_AUTO,
                BM_LIMITATION_COMMUNICATION_IF_USB), true)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_CAR_LIFE,
                BM_LIMITATION_COMMUNICATION_IF_USB), true)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_CAR_LIFE_IOS,
                BM_LIMITATION_COMMUNICATION_IF_USB), true)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_ON_CAR,
                BM_LIMITATION_COMMUNICATION_IF_USB), true)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_MIRROR_LINK,
                BM_LIMITATION_COMMUNICATION_IF_USB), true)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_MY_SPIN,
                BM_LIMITATION_COMMUNICATION_IF_USB), true)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_MY_SPIN_IOS,
                BM_LIMITATION_COMMUNICATION_IF_USB), true)] = protocolBlockStatusMap;

          // AAP/CarLife/Oncar/ML/mySPIN USB non-projection device
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_HFP, "")] = BM_BLOCK_STATE_BLOCKED;
          if (true == LocalSpm::getDataProvider().getBmCoreConfiguration()._blockAllProtocolsForNonProjectionDevices)
          {
             protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_BLOCKED;
          }
          else
          {
             protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          }
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PBDL, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_MSG, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PAN, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_SPP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_ANDROID_AUTO,
                BM_LIMITATION_COMMUNICATION_IF_USB), false)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_CAR_LIFE,
                BM_LIMITATION_COMMUNICATION_IF_USB), false)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_CAR_LIFE_IOS,
                BM_LIMITATION_COMMUNICATION_IF_USB), false)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_ON_CAR,
                BM_LIMITATION_COMMUNICATION_IF_USB), false)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_MIRROR_LINK,
                BM_LIMITATION_COMMUNICATION_IF_USB), false)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_MY_SPIN,
                BM_LIMITATION_COMMUNICATION_IF_USB), false)] = protocolBlockStatusMap;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_MY_SPIN_IOS,
                BM_LIMITATION_COMMUNICATION_IF_USB), false)] = protocolBlockStatusMap;

          // CP USB projection device
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_HFP, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PBDL, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_MSG, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PAN, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_SPP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_CAR_PLAY,
                BM_LIMITATION_COMMUNICATION_IF_USB), true)] = protocolBlockStatusMap;

          // CP USB non-projection device
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_HFP, "")] = BM_BLOCK_STATE_BLOCKED;
          if (true == LocalSpm::getDataProvider().getBmCoreConfiguration()._blockAllProtocolsForNonProjectionDevices)
          {
             protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_BLOCKED;
          }
          else
          {
             protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          }
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PBDL, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_MSG, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PAN, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_SPP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_CAR_PLAY,
                BM_LIMITATION_COMMUNICATION_IF_USB), false)] = protocolBlockStatusMap;

          // CP Wifi 2.4 GHz non-projection device
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_HFP, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PBDL, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_MSG, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PAN, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_SPP, "")] = BM_BLOCK_STATE_BLOCKED;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_CAR_PLAY,
                BM_LIMITATION_COMMUNICATION_IF_WIFI_2_4), false)] = protocolBlockStatusMap;

          // CP Wifi 5 GHz non-projection device
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_HFP, "")] = BM_BLOCK_STATE_BLOCKED;
          if (true == LocalSpm::getDataProvider().getBmCoreConfiguration()._blockAllProtocolsForNonProjectionDevices)
          {
             protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_BLOCKED;
          }
          else
          {
             protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          }
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PBDL, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_MSG, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PAN, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_SPP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_CAR_PLAY,
                BM_LIMITATION_COMMUNICATION_IF_WIFI_5), false)] = protocolBlockStatusMap;

          // AA Wifi 5 GHz non-projection device
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_HFP, "")] = BM_BLOCK_STATE_BLOCKED;
          if (true == LocalSpm::getDataProvider().getBmCoreConfiguration()._blockAllProtocolsForNonProjectionDevices)
          {
             protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_BLOCKED;
          }
          else
          {
             protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_AVP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          }
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PBDL, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_MSG, "")] = BM_BLOCK_STATE_BLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_PAN, "")] = BM_BLOCK_STATE_UNBLOCKED;
          protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_SPP, "")] = BM_BLOCK_STATE_UNBLOCKED;
          _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_ANDROID_AUTO,
                BM_LIMITATION_COMMUNICATION_IF_WIFI_5), false)] = protocolBlockStatusMap;
       }
       else
       {
          //do nothing
       }
       return ILocalSpm::create();
   }

   Result DbManager::init(InitReason reason)
   {
       ENTRY

       ETG_TRACE_USR1(("init"));

       /* init the DB (if needed) */
       if(!_db)
       {
           _db = new Database();
       }

       if (0 != _db)
       {
          this->switchOnDatabaseAccess();

       /* set members */

       /* remove all triggers from the data base from the run before if any !*/
       //DbTriggerManager::GetInstance().TriggerCleanupDB();

       resetAllTables();
       }

      // Perform the parent class (ILocalSpm) specific initialization.
      return ILocalSpm::init(reason);
   }

   Result DbManager::run()
   {
       ENTRY

       ETG_TRACE_USR1(("run"));

       return ILocalSpm::run();
   }

   Result DbManager::stop()
   {
       ENTRY

       ETG_TRACE_USR1(("stop"));

       return ILocalSpm::stop();
   }

   Result DbManager::done()
   {
       ENTRY

       ETG_TRACE_USR1(("done"));

       FW_NORMAL_ASSERT(0 != _db);

       if (0 != _db)
       {
       /* shutdown the database progresses (may take up to 3 seconds) */
       _db->Shutdown(1);

       // de init the data base (triggers will be removed, all cached connections will be closed, trigger manager will be detached)
       _db->DeInit();

       // last call...
       delete _db;
          _db = 0;
       }

      // Perform the parent class (ILocalSpm) specific cleanup.
      return ILocalSpm::done();
   }

   int DbManager::statistics(OUT Statistics stat)
   {
      ENTRY

      (void) stat;

      return 0;
   }

   void DbManager::switchOnDatabaseAccess()
   {
      ETG_TRACE_USR1(("switchOnDatabaseAccess"));

      _databaseAccessSwitchedOn = true;
   }

   void DbManager::switchOffDatabaseAccess()
   {
      ETG_TRACE_USR1(("switchOffDatabaseAccess"));

      _databaseAccessSwitchedOn = false;
   }

   bool DbManager::isDatabaseAccessSwitchedOn()
   {
      return _databaseAccessSwitchedOn;
   }

   Result DbManager::createDevice(OUT DeviceId& deviceId, IN const BdName& bdName, IN const BdAddress& bdAddress,
         IN const BTSLinkKeyType linkKeyType,IN const BTSLinkKey& linkKey, IN const BTSDLinkKey& dLinkKey,
         IN const BTSMajorServiceClass& majorServiceClass, IN const BTSMajorDeviceClass majorDeviceClass,
         IN const BTSMinorDeviceClass minorDeviceClass, IN const ProtocolIdVersionList& supportedProtocols,
         IN const UuidList& supportedSppUuids, IN const DeviceIdentification& deviceIdentification)
   {
      ENTRY

      ETG_TRACE_USR1(("createDevice: bdAddress = \"%50s\", bdName = \"%50s\", linkKeyType = %d, linkKey = \"%50s\"",
            bdAddress.c_str(), bdName.c_str(), ETG_CENUM(BTSLinkKeyType, linkKeyType), linkKey.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("createDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      unsigned long long int lastPairedTimeStamp(0ull);
      unsigned int lastPairedIndicator(0u);

      deviceId = DEVICE_ID_NOT_SET;
      DeviceId deviceHandle = DEVICE_HANDLE_NOT_SET;

      // try to get the device id by using the bd address, if error: new device will be created
      result = query.Select(LTY_DEVICES, IN 0, "it", IN 0, IN bdAddress.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): Select failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("i", OUT &deviceId);

      if ((CC_ERR_INT_NO_ERROR != result) && (CC_ERR_INT_DB_END_OF_LIST != result))
      {
         ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): Get failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      // is it a new device?
      if ((CC_ERR_INT_DB_END_OF_LIST == result) || (DEVICE_ID_NOT_SET == deviceId))
      {
         // create a new device
         result = query.Insert(LTY_DEVICES_INSERT);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): Insert failed (error = %d)", bdAddress.c_str(),
                  ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         result = query.Put(IN "t-i", IN bdAddress.c_str(), DEVICE_HANDLE_TMP_VAL); // if a device with that BD address already exists, this insert will be ignored

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): Put failed (error = %d)", bdAddress.c_str(),
                  ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         // get this new entry by bdAddress and set device id as return value
         result = getDeviceId(OUT deviceId, IN bdAddress);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): could not get device ID for device with given BD address from DB (error = %d)",
                  bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         result = getUnassignedDeviceHandle(OUT deviceHandle);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): could not get an unassigned DeviceHandle value for device with given BD address from DB (error = %d)",
                  bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         result = query.Insert(LTY_DEVICEPROTOCOLS_INSERT);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): Insert failed (error = %d)", bdAddress.c_str(),
                  ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         ProtocolBlockStatusMap protocolBlockStatusMap;
         (void) this->getProtocolBlockStatusTemplateMap(protocolBlockStatusMap, bdAddress, bdName);

         VARTRACE(protocolBlockStatusMap);

         ProtocolInfoMap locallySupportedProtocols;
         result = LocalSpm::getDataProvider().getProtocolInfos(locallySupportedProtocols, true);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): could not get local protocol infos (error = %d)",
                  bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         ProtocolVersion protocolVersion(0u);
         ProtocolVersion sppProtocolVersion(0u);
         bool protocolSupported(false);
         bool sppProtocolSupported(false);
         ProtocolInfoMap::iterator itCurr;

         for (itCurr = locallySupportedProtocols.begin(); itCurr != locallySupportedProtocols.end(); ++itCurr)
         {
            if (true == supportedProtocols.empty())
            {
               protocolSupported = true;

               if (BM_PROTOCOL_ID_SPP == itCurr->first)
               {
                  sppProtocolSupported = true;
                  sppProtocolVersion = protocolVersion;
               }
            }
            else
            {
               ProtocolIdVersionList::const_iterator itNew;
               for (itNew = supportedProtocols.begin(); itNew != supportedProtocols.end(); ++itNew)
               {
                  if (itCurr->first == itNew->first)
                  {
                     // found locally supported protocol in given list of protocols supported by remote device
                     break;
                  }
               }

               if (supportedProtocols.end() != itNew)
               {
                  // found locally supported protocol in given list of protocols supported by remote device
                  protocolSupported = true;
                  protocolVersion = (0xFFFFu != itNew->second) ? itNew->second : 0u;

                  if (BM_PROTOCOL_ID_SPP == itCurr->first)
                  {
                     sppProtocolSupported = true;
                     sppProtocolVersion = protocolVersion;
                  }
               }
               else
               {
                  // locally supported protocol not found in given list of protocols supported by remote device
                  protocolVersion = 0u;
                  protocolSupported = false;
               }
            }

            result = query.Put(IN "iitii---i-ii",
                  IN deviceId, IN itCurr->first,
                  IN (BM_PROTOCOL_ID_SPP == itCurr->first) ? IN SPPMAGICUUID : IN "",
                  IN BM_CONNECTION_STATUS_DISCONNECTED,
                  IN BM_DISCONNECTED_REASON_NORMAL_LOSS_LOCAL,
                  IN protocolBlockStatusMap[Protocol(itCurr->first, "")],
                  IN static_cast<unsigned int>(protocolVersion),
                  IN protocolSupported ? 1u : 0u);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): Put failed (error = %d)", bdAddress.c_str(),
                     ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
         }

         UuidList::const_iterator iter;
         for (iter = supportedSppUuids.begin(); iter != supportedSppUuids.end(); ++iter)
         {
            result = query.Put(IN "iitii---i-ii",
                  IN deviceId, IN BM_PROTOCOL_ID_SPP, IN iter->c_str(),
                  IN BM_CONNECTION_STATUS_DISCONNECTED,
                  IN BM_DISCONNECTED_REASON_NONE,
                  IN protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_SPP, "")],
                  IN (0xFFFFu != sppProtocolVersion) ? static_cast<unsigned int>(sppProtocolVersion) : 0u,
                  IN sppProtocolSupported ? 1u : 0u);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): Put failed (error = %d)", bdAddress.c_str(),
                     ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
         }

         //store current time in lastPairedTimeStamp
         struct timespec lastPairedTS;
         clock_gettime(CLOCK_REALTIME , &lastPairedTS);
         lastPairedTimeStamp = lastPairedTS.tv_sec;

         //get the MAX(LastConnectedIndicator) in Devices table and store MAX(lastConnectedIndicator)+1
         result = getMaxLastPairedIndicator(lastPairedIndicator);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): could not get last paired indicator maximum from DB (error = %d)",
                  bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         lastPairedIndicator++;
      }

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): Update failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("--itii--iiititiiiiiiiiiiiiiiiiiiii------iiii--iiiiiiiliiiiii",
            IN 0, IN bdName.c_str(),
            IN (DEVICE_HANDLE_NOT_SET == deviceHandle) ? 1 : 0, IN deviceHandle,
            IN 0, IN linkKeyType,
            IN 0, IN linkKey.c_str(),
            IN 0, IN dLinkKey.c_str(),
            IN 0, IN majorDeviceClass,
            IN 0, IN minorDeviceClass,
            IN 0, IN majorServiceClass.getData(),
            IN 0, IN (unsigned int) deviceIdentification._specificationId,
            IN 0, IN (unsigned int) deviceIdentification._vendorId,
            IN 0, IN (unsigned int) deviceIdentification._productId,
            IN 0, IN (unsigned int) deviceIdentification._version,
            IN 0, IN (unsigned int) deviceIdentification._vendorIdSource,
            IN 0, IN BM_CONNECTION_STATUS_DISCONNECTED,
            IN 0, IN BM_DISCONNECTED_REASON_TEMPORARILY,
            IN 0, IN BM_INBAND_RINGTONE_SUPPORT_UNKNOWN,
            IN 0, IN -1, // ringtoneId
            IN 0, IN BM_UP_UNDECIDED,
            IN 0, IN 0,
            IN 0, IN 0,
            IN (0llu == lastPairedTimeStamp) ? 1 : 0, IN lastPairedTimeStamp,
            IN (0u == lastPairedIndicator) ? 1 : 0, IN lastPairedIndicator,
            IN 0, IN 0, // LastConnectedPANDevice
            IN 0, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("createDevice(bdAddress = \"%50s\"): Change failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      _db->fSync();

      return result;
   }

   Result DbManager::isDeviceInDb(OUT bool& inDb, IN const BdAddress& bdAddress)
   {
      ETG_TRACE_USR1(("isDeviceInDb: bdAddress = \"%50s\"", bdAddress.c_str()));

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      DeviceId deviceId(DEVICE_ID_NOT_SET);

      inDb = false;

      result = query.Select(LTY_DEVICES, IN 0, "it", IN 0, IN bdAddress.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("isDeviceInDb(bdAddress = \"%50s\"): Select failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("i", OUT &deviceId);

      if (CC_ERR_INT_NO_ERROR == result)
      {
         ETG_TRACE_USR1(("isDeviceInDb(bdAddress = \"%50s\"): found device in DB (device ID = %d)", bdAddress.c_str(),
               deviceId));
         inDb = true;
      }
      else if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         ETG_TRACE_USR1(("isDeviceInDb(bdAddress = \"%50s\"): device not found in DB", bdAddress.c_str()));
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("isDeviceInDb(bdAddress = \"%50s\"): Get failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::updateOobPairingInfo(IN const BdAddress& bdAddress, IN const BdName& bdName, IN const LinkKey& linkKey)
   {
      ETG_TRACE_USR1(("updateOobPairingInfo: bdAddress = \"%50s\", bdName = \"%50s\", linkKey = \"%50s\"",
            bdAddress.c_str(), bdName.c_str(), linkKey.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("updateOobPairingInfo(bdAddress = \"%50s\"): database access is currently not allowed",
               bdAddress.c_str()));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      DeviceId deviceId(DEVICE_ID_NOT_SET);
      Result result = getDeviceId(OUT deviceId, IN bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateOobPairingInfo(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      Query query;
      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateOobPairingInfo(bdAddress = \"%50s\"): Update failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("--it------it----------------------------------------------ii",
            IN 0, IN bdName.c_str(),
            IN 0, IN linkKey.c_str(),
            IN 0, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateOobPairingInfo(bdAddress = \"%50s\"): Change failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::updateProtocolSupport(IN const BdAddress& bdAddress, IN const ProtocolIdVersionList& supportedProtocols, IN const bool partialUpdate)
   {
      ENTRY

      ETG_TRACE_USR1(("updateProtocolSupport: bdAddress = \"%50s\", partialUpdate = %10s", bdAddress.c_str(), partialUpdate ? "true": "false"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("updateProtocolSupport: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      // get protocols supported by local device

      ProtocolInfoMap locallySupportedProtocols;
      result = LocalSpm::getDataProvider().getProtocolInfos(locallySupportedProtocols, true);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateProtocolSupport(bdAddress = \"%50s\"): could not get local protocol infos (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      // update remote device's protocol support and version info in DB

      // get the device ID from the Devices table for the given BD address
      DeviceId deviceId;
      result = getDeviceId(OUT deviceId, IN bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateProtocolSupport(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateProtocolSupport(bdAddress = \"%50s\"): Update failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      bool protocolSupported(false);
      ProtocolVersion protocolVersion(0u);
      bool removeSppUuids(false);

      ProtocolInfoMap::iterator itLoc;

      for (itLoc = locallySupportedProtocols.begin(); itLoc != locallySupportedProtocols.end(); ++itLoc)
      {
         ProtocolIdVersionList::const_iterator itRem;
         for (itRem = supportedProtocols.begin(); itRem != supportedProtocols.end(); ++itRem)
         {
            if (itLoc->first == itRem->first)
            {
               // found locally supported protocol in given list of protocols supported by remote device
               break;
            }
         }

         if (supportedProtocols.end() != itRem)
         {
            // found locally supported protocol in given list of protocols supported by remote device
            protocolSupported = true;
            protocolVersion = (0xFFFFu != itRem->second) ? itRem->second : 0u;
         }
         else
         {
            // locally supported protocol not found in given list of protocols supported by remote device
            protocolSupported = false;
            protocolVersion = 0u;
         }

         // Updating the protcol support and the version info of the device in the DB
         if(((true == protocolSupported) && (true == partialUpdate)) || (false == partialUpdate))
         {
            result = query.Change("--------------------iiii----iiii",
                  IN 0, IN static_cast<unsigned int>(protocolVersion),
                  IN 0, IN protocolSupported ? 1u : 0u,
                        IN 0, IN deviceId,
                        IN 0, IN itLoc->first);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("updateProtocolSupport(bdAddress = \"%50s\"): Change failed (error = %d)", bdAddress.c_str(),
                     ETG_CENUM(CcErrorInternal, result)));
               return result;
            }

            if ((BM_PROTOCOL_ID_SPP == itLoc->first) && (false == protocolSupported))
            {
               removeSppUuids = true;
            }
         }
      }

      if (true == removeSppUuids)
      {
         // SPP is not supported (anymore), so the rows with supported SPP UUIDs have to be removed
         // from DeviceProtocols table

         // get the device ID from the Devices table for the given BD address
         DeviceId deviceId(0u);
         result = getDeviceId(OUT deviceId, IN bdAddress);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("updateProtocolSupport(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
                  bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         // get a list of SPP UUIDs from DeviceProtocols table for given device
         UuidList currentUuidList;
         result = getDeviceSppUuidSupport(OUT currentUuidList, IN deviceId);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("updateProtocolSupport(bdAddress = \"%50s\"): could not get supported SPP UUIDs from DB (error = %d)",
                  bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

            return result;
         }

         if (false == currentUuidList.empty())
         {
            // there are supported SPP UUIDs in the DeviceProtocols table
            result = query.Delete(LTY_DEVICEPROTOCOLS_DELETE);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("updateProtocolSupport(bdAddress = \"%50s\"): Delete failed (error = %d)",
                     bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

               return result;
            }

            UuidList::const_iterator it;

            for (it = currentUuidList.begin(); it != currentUuidList.end(); it++)
            {
               result = query.Remove("iiiiit", IN 0, deviceId, IN 0, BM_PROTOCOL_ID_SPP, IN 0, IN it->c_str());

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("updateProtocolSupport(bdAddress = \"%50s\"): Remove failed (error = %d)",
                        bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

                  return result;
               }
            }
         }
      }

      return CC_ERR_INT_NO_ERROR;
   }

   Result DbManager::updateSppUuidSupport(IN const BdAddress& bdAddress, IN const UuidList& supportedSppUuids, IN const ProtocolVersion sppVersion)
   {
      ENTRY

      ETG_TRACE_USR1(("updateSppUuidSupport: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("updateSppUuidSupport: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;
      DeviceId deviceId;
      ConnectionStatus connectionStatus;
      DisconnectedReason disconnectedReason;
      UuidList updateDisconnectedReasonUuidList;

      //get the device ID from the Devices table for the given BD address
      result = getDeviceId(OUT deviceId, IN bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      // get a list of SPP UUIDs from DeviceProtocols table for this device ID
      UuidList currentUuidList;
      result = getDeviceSppUuidSupport(OUT currentUuidList, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): could not get supported SPP UUIDs from DB (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      //1.for each UUID in currentUuidList that does not exist in supportedSppUuids delete the
      //corresponding row from DeviceProtocols table (in case of SPP all rows corresponding to SPP have to be deleted)

      //2.for each UUID in supportedSppUuids that does not exist in currentUuidList add a
      //corresponding row to DeviceProtocols table
      result = query.Insert(LTY_DEVICEPROTOCOLS_INSERT);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): Insert failed (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      ProtocolBlockStatusMap protocolBlockStatusMap;
      (void) this->getProtocolBlockStatusTemplateMap(protocolBlockStatusMap, bdAddress);

      UuidList::iterator iter_old;
      UuidList::const_iterator it;

      // Add the UUID to DB if the UUID is supported in remote device
      for (it = supportedSppUuids.begin(); it != supportedSppUuids.end(); ++it)
      {
         Uuid uuid = *it;
         iter_old = std::find(currentUuidList.begin(), currentUuidList.end(), uuid);

         if (iter_old == currentUuidList.end())
         {
            result = query.Put(IN "iitii---i",
                  IN deviceId, IN BM_PROTOCOL_ID_SPP, IN uuid.c_str(),
                  IN BM_CONNECTION_STATUS_DISCONNECTED,
                  IN BM_DISCONNECTED_REASON_NONE,
                  IN protocolBlockStatusMap[Protocol(BM_PROTOCOL_ID_SPP, "")]);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): Put failed (error = %d)",
                     bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
            }
         }
         else
         {
            // this list will hold the items that need to be deleted from database
            // remove the elements that are common in both old and new supported UUID lists
            currentUuidList.erase(iter_old);

            result = getProtocolConnectionStatus(connectionStatus, disconnectedReason, deviceId, BM_PROTOCOL_ID_SPP, uuid);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): read protocol connection status is failed (error = %d)",
                     bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
            }
            else
            {
               // Update the disconnected reason as NONE if the connection status as DISCONNECTED and reason is not NONE.
               // It will indicates to client to trigger for connection request if the disconnected reason is changed to NONE.
               if((BM_CONNECTION_STATUS_DISCONNECTED == connectionStatus) && (BM_DISCONNECTED_REASON_NONE != disconnectedReason))
               {
                  updateDisconnectedReasonUuidList.push_back(uuid);

                  ETG_TRACE_USR3(("updateSppUuidSupport(deviceId = %d, uuid = \"%50s\"): uuid is added in disconnectionreasonlist", deviceId, uuid.c_str()));
               }
            }
         }
      }

      // Remove the UUID from DB if the UUID is no more supported in remote device
      if (false == currentUuidList.empty())
      {
         result = query.Delete(LTY_DEVICEPROTOCOLS_DELETE);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): Delete failed (error = %d)",
                  bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

            return result;
         }

         bool removeUuid = false;

         for (iter_old = currentUuidList.begin(); iter_old != currentUuidList.end(); ++iter_old)
         {
            Uuid uuid = *iter_old;

            removeUuid = true;

            // Check the SPP profile which are supporting from HU side
            // Remove the UUID from DB only if that uuid is not supported bu HU side
            for (SppServiceInformation::const_iterator it = LocalSpm::getDataProvider().getBmCoreConfiguration()._sppServiceInformation.begin();
                  it != LocalSpm::getDataProvider().getBmCoreConfiguration()._sppServiceInformation.end(); ++it)
            {
               if(0 == (strcmp(it->_remoteUuid.c_str(), uuid.c_str())))
               {
                  ETG_TRACE_USR4(("updateSppUuidSupport(bdAddress = \"%50s\"): %50s remote uuid is supported from HU so it is not removed from db",
                        bdAddress.c_str(), it->_serviceName.c_str()));
                  removeUuid = false;
                  break;
               }
               else if(0 == (strcmp(it->_localUuid.c_str(), uuid.c_str())))
               {
                  ETG_TRACE_USR4(("updateSppUuidSupport(bdAddress = \"%50s\"): %50s local uuid is supported by HU so it is not removed from db",
                        bdAddress.c_str(), it->_serviceName.c_str()));
                  removeUuid = false;
                  break;
               }
            }

            if(true == removeUuid)
            {
               result = getProtocolConnectionStatus(connectionStatus, disconnectedReason, deviceId, BM_PROTOCOL_ID_SPP, *iter_old);

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): read protocol connection status is failed (error = %d)",
                        bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
               }
               else
               {
                  ETG_TRACE_USR3(("updateSppUuidSupport(deviceId = %d, uuid = \"%50s\"): connectionStatus = %d",
                        deviceId, iter_old->c_str(), ETG_CENUM(ConnectionStatus, connectionStatus)));

                  //Remove the UUID from DB only if protocol connection status as DISCONNECTED.
                  if(BM_CONNECTION_STATUS_DISCONNECTED == connectionStatus)
                  {
                     // remove the element(iter_old) from the database
                     result = query.Remove("iiiiit",IN 0, deviceId, IN 0, BM_PROTOCOL_ID_SPP, IN 0, IN iter_old->c_str());

                     if (CC_ERR_INT_NO_ERROR != result)
                     {
                        ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): Remove failed (error = %d)",
                              bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
                     }
                  }
                  else
                  {
                     ETG_TRACE_USR4(("updateSppUuidSupport(deviceId = %d, uuid = \"%50s\"): uuid is not removed from DB"
                           " because connection status is not disconnected", deviceId, iter_old->c_str()));
                  }
               }
            }
         }
      }

      result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): Update failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("--------------------ii------iiii",
            IN 0, IN static_cast<unsigned int>(sppVersion),
            IN 0, IN 1u,
            IN 0, IN deviceId,
            IN 0, IN BM_PROTOCOL_ID_SPP);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): Change failed (error = %d)", bdAddress.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      // Update the disconnected reason as NONE if the connection status as DISCONNECTED and reason is not NONE.
      // It will indicates to client to trigger for connection request if the disconnected reason is changed to NONE.
      for (iter_old = updateDisconnectedReasonUuidList.begin(); iter_old != updateDisconnectedReasonUuidList.end(); ++iter_old)
      {
         result = query.Change("--------ii------------------iiiiit",
               IN 0, IN BM_DISCONNECTED_REASON_NONE,
               IN 0, IN deviceId,
               IN 0, IN BM_PROTOCOL_ID_SPP,
               IN 0, IN iter_old->c_str());

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("updateSppUuidSupport(bdAddress = \"%50s\"): update disconnected reason is failed (error = %d)", bdAddress.c_str(),
                  ETG_CENUM(CcErrorInternal, result)));
         }
      }

      return result;
   }

   Result DbManager::updateDeviceIdentification(IN const BdAddress& bdAddress, IN const DeviceIdentification& deviceIdentification)
   {
      ENTRY

      ETG_TRACE_USR1(("updateDeviceIdentification: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("updateDeviceIdentification: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;
      DeviceId deviceId;
      DeviceId deviceHandle;

      /*get the device ID from the Devices table for the given BD address*/
      result = getDeviceId(OUT deviceId, IN bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateDeviceIdentification(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = getDeviceHandle(OUT deviceHandle, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateDeviceIdentification(bdAddress = \"%50s\"): could not get device handle from DB (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateDeviceIdentification(bdAddress = \"%50s\"): Update failed (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("--------------------iiiiiiiiii----------------------------ii",
            IN 0, IN (unsigned int) deviceIdentification._specificationId,
            IN 0, IN (unsigned int) deviceIdentification._vendorId,
            IN 0, IN (unsigned int) deviceIdentification._productId,
            IN 0, IN (unsigned int) deviceIdentification._version,
            IN 0, IN (unsigned int) deviceIdentification._vendorIdSource,
            IN 0, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("updateDeviceIdentification(bdAddress = \"%50s\"): Change failed (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getDeviceIdentification(OUT const DeviceIdentification& deviceIdentification, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceIdentification: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceIdentification: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceIdentification(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("-----------iiiii",
            OUT &deviceIdentification._specificationId,
            OUT &deviceIdentification._vendorId,
            OUT &deviceIdentification._productId,
            OUT &deviceIdentification._version,
            OUT &deviceIdentification._vendorIdSource);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceIdentification(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getDeviceId(OUT DeviceId& deviceId, IN const BdAddress& bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceId: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceId: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      deviceId = 0u;

      // Always convert bdAddress into lowercase
      BdAddress bDAddress(bdAddress);
      std::transform(bDAddress.begin(), bDAddress.end(), bDAddress.begin(), ::tolower);

      /*get the device ID from the Devices table for the given BD address*/
      result = query.Select(LTY_DEVICES, IN 0, "it", IN 0, IN bDAddress.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceId(bdAddress = \"%50s\"): Select failed (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("i", OUT &deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceId(bdAddress = \"%50s\"): Get failed (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      if (0u == deviceId)
      {
         result = CC_ERR_INT_DB_UNEXPECTED;
      }

      return result;
   }

   Result DbManager::getDeviceId(OUT DeviceId& deviceId, IN const DeviceId deviceHandle)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceId: deviceHandle = %d", deviceHandle));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceId: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      deviceId = 0u;

      result = query.Select(LTY_DEVICES, IN 0, "--ii", IN 0, IN deviceHandle);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceId(deviceHandle = %d): Select failed (error = %d)", deviceHandle, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("i", OUT &deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceId(deviceHandle = %d): Get failed (error = %d)", deviceHandle, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      if (0u == deviceId)
      {
         result = CC_ERR_INT_DB_UNEXPECTED;
      }

      return result;
   }

   Result DbManager::getDeviceSupportedProtocols(OUT ProtocolInfoMap& protocolInfomap, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceSupportedProtocols: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceSupportedProtocols: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Query query;
      Result result(CC_ERR_INT_NO_ERROR);

      result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceSupportedProtocols: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      protocolInfomap.clear();
      ProtocolInfo protocolInfo;
      ProtocolId protocolId;
      UuidChrArr uuidCharArr;
      std::string uuid;
      unsigned int protocolVersion;
      unsigned int protocolSupported(0u);
      bool spp_added = false;
      FavoriteIndex favoriteIndex;
      unsigned int primary;

      while(1)
      {
         result = query.Get(IN "-it-------iiii", OUT &protocolId, OUT &uuidCharArr, OUT &protocolVersion,
               OUT &protocolSupported, OUT &primary, OUT &favoriteIndex);

         if (result) break;

         if (protocolSupported != 0u)
         {
            if (BM_PROTOCOL_ID_SPP == protocolId)
         {
            uuid = uuidCharArr;

               if (!spp_added && (SPPMAGICUUID == uuid))
               {
                  //protocolIdList.push_back(std::make_pair(protocolId, static_cast<ProtocolVersion>(protocolVersion)));

                  protocolInfo._version = static_cast<ProtocolVersion>(protocolVersion);
                  protocolInfo._favoriteIndex = favoriteIndex;
                  protocolInfomap[protocolId] = protocolInfo;
                  spp_added = true;
               }
         }
         else
         {
            //protocolIdList.push_back(std::make_pair(protocolId, static_cast<ProtocolVersion>(protocolVersion)));
            protocolInfo._version = static_cast<ProtocolVersion>(protocolVersion);
            protocolInfo._favoriteIndex = favoriteIndex;
            protocolInfomap[protocolId] = protocolInfo;
         }
         }
      }

      return CC_ERR_INT_NO_ERROR;
   }

   Result DbManager::getDeviceSppUuidSupport(OUT UuidList& uuidList, IN const BdAddress& bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceSppUuidSupport: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceSppUuidSupport: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      DeviceId deviceId(0u);
      Result result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceSppUuidSupport(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = this->getDeviceSppUuidSupport(uuidList, deviceId);

      return result;
   }


   Result DbManager::getDeviceSppUuidSupport(OUT UuidList& uuidList, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceSppUuidSupport: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceSppUuidSupport: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      uuidList.clear();

      result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "ii", IN 0, IN BM_PROTOCOL_ID_SPP);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceSppUuidSupport(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      Uuid uuid;

      while(1)
      {
         UuidChrArr uuidChrArr;

         result = query.Get("--T", OUT uuidChrArr, IN sizeof(uuidChrArr));

         if (result) break;

         uuid = uuidChrArr;
         if(SPPMAGICUUID != uuid)
         {
            uuidList.push_back(uuid);
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getDeviceSppUuidSupport(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getDeviceBlockStatusList(OUT DeviceBlockStatusList& deviceBlockStatusList)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceBlockStatusList"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceBlockStatusList: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      deviceBlockStatusList.clear();

      DeviceIdList deviceIds;
      result = getAllDeviceIds(deviceIds);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceBlockStatusList: could not get all device IDs from DB (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      for (size_t devIdx = 0u; devIdx < deviceIds.size(); devIdx++)
      {
         DeviceBlockStatus deviceBlockStatus;
         result = getDeviceBlockStatus(deviceBlockStatus, deviceIds[devIdx]);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getDeviceBlockStatusList: could not get device block status for device ID = %d from DB (error = %d)", deviceIds[devIdx], ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         deviceBlockStatusList.push_back(deviceBlockStatus);
      }

      return result;
   }

   Result DbManager::setDeviceBlockState(IN const DeviceId deviceId, IN const BlockState blockState)
   {
      ENTRY

      ETG_TRACE_USR1(("setDeviceBlockState: deviceId = %d, blockState = %d", deviceId, ETG_CENUM(BlockState, blockState)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setDeviceBlockState: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceBlockState(deviceId = %d): Update failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("--------------------------------------ii------------------ii",
            IN 0, IN blockState,
            IN 0, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceBlockState(deviceId = %d): Change failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      //Update Properties
      DeviceId devHandle;
      result = getDeviceHandle(devHandle, deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceBlockState(deviceId = %d): Cannot get device Handle (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      BlockStatus blkStatus;
      DeviceBlockStatus devBlockStatus;
      devBlockStatus._blockState = blockState;
      devBlockStatus._deviceHandle = devHandle;
      blkStatus._deviceBlockStatusList.push_back(devBlockStatus);

      LocalSpm::getBmCoreMainController().updateBlockStatus(devHandle, blkStatus, BM_BLOCK_STATUS_UPDATE_TYPE_DEVICE);

      return result;
   }

   Result DbManager::getDeviceBlockState(OUT BlockState& blockState, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceBlockState: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceBlockState: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceBlockState(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("--------------------i", OUT &blockState);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceBlockState(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getDeviceBlockState(OUT BlockState& blockState, IN const BdAddress& bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceBlockState: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceBlockState: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      DeviceId deviceId(0u);
      Result result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR == result)
      {
         result = this->getDeviceBlockState(blockState, deviceId);
      }
      else
      {
         ETG_TRACE_ERR(("getDeviceBlockState(bdAddress = \"%50s\"): could not get device ID for device with given BD address (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getDeviceBlockStatus(OUT DeviceBlockStatus& devBlockStatus, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceBlockStatus: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceBlockStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      devBlockStatus._deviceHandle = 0u;
      devBlockStatus._blockState = BM_BLOCK_STATE_UNBLOCKED;
      devBlockStatus._protocolBlockStatusMap.clear();

      //get Device Handle
      result = getDeviceHandle(devBlockStatus._deviceHandle, deviceId);
      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceBlockStatus(deviceId = %d): couldn't get Device Handle (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }
      //get Device Block State
      result = getDeviceBlockState(devBlockStatus._blockState, deviceId);
      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceBlockStatus(deviceId = %d): couldn't get Device Block State (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      //get Device Protocols Block State
      result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceBlockStatus(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      UuidChrArr uuidChrArr;
      BlockState blockState;
      Protocol protocol;

      while(1)
      {
         result = query.Get(IN "-iT-----i", OUT &protocol._protocolId, OUT uuidChrArr, IN sizeof(uuidChrArr), OUT &blockState);

         if (result) break;

         protocol._uuid = (BM_PROTOCOL_ID_SPP == protocol._protocolId) ? uuidChrArr : "";

         if (SPPMAGICUUID != protocol._uuid)
         {
            //don't include the SPP record with Magic UUID
            devBlockStatus._protocolBlockStatusMap[protocol] = blockState;
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getDeviceBlockStatus(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::setProtocolBlockState(IN const DeviceId deviceId, IN const ProtocolId protocolId, IN const Uuid& uuid, IN const BlockState blockState)
   {
      ENTRY

      ETG_TRACE_USR1(("setProtocolBlockState: deviceId = %d, protocolId = %d, uuid = \"%50s\", blockState = %d", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(BlockState, blockState)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setProtocolBlockState: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setProtocolBlockState: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("----------------ii----------iiiiit",
            IN 0, IN blockState,
            IN 0, IN deviceId,
            IN 0, IN protocolId,
            IN ((BM_PROTOCOL_ID_SPP == protocolId) ? 0 : 1), IN uuid.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setProtocolBlockState: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      //Update Properties
      DeviceId devHandle;
      result = getDeviceHandle(devHandle, deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setProtocolBlockState(deviceId = %d): Cannot get device Handle (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      BlockStatus blkStatus;
      DeviceBlockStatus devBlockStatus;
      Protocol protocol(protocolId, uuid);
      devBlockStatus._protocolBlockStatusMap[protocol] = blockState;
      blkStatus._deviceBlockStatusList.push_back(devBlockStatus);

      LocalSpm::getBmCoreMainController().updateBlockStatus(devHandle, blkStatus,
            BM_BLOCK_STATUS_UPDATE_TYPE_DEVICE_PROTOCOL_BLOCK_STATE);

      return result;
   }

   Result DbManager::getProtocolBlockState(OUT BlockState& blockState, IN const DeviceId deviceId, IN const Protocol& protocol)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolBlockState: deviceId = %d, protocol = (%d, \"%50s\")", deviceId,
            ETG_CENUM(ProtocolId, protocol._protocolId), protocol._uuid.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getProtocolBlockState: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "iiit",
            IN 0, IN protocol._protocolId,
            IN ((BM_PROTOCOL_ID_SPP == protocol._protocolId) ? 0 : 1), IN protocol._uuid.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getProtocolBlockState(deviceId = %d, protocol = (%d, \"%50s\")): Select failed (error = %d)",
               deviceId, ETG_CENUM(ProtocolId, protocol._protocolId), protocol._uuid.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("--------i", OUT &blockState);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getProtocolBlockState(deviceId = %d, protocol = (%d, \"%50s\")): Get failed (error = %d)",
               deviceId, ETG_CENUM(ProtocolId, protocol._protocolId), protocol._uuid.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getProtocolBlockState(OUT BlockState& blockState, IN const BdAddress& bdAddress, IN const Protocol& protocol)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolBlockState: bdAddress = \"%50s\", protocol = (%d, \"%50s\")",
            bdAddress.c_str(), ETG_CENUM(ProtocolId, protocol._protocolId), protocol._uuid.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getProtocolBlockState: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      DeviceId deviceId(0u);
      Result result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR == result)
      {
         result = this->getProtocolBlockState(blockState, deviceId, protocol);
      }
      else
      {
         ETG_TRACE_ERR(("getProtocolBlockState(bdAddress = \"%50s\", protocol = (%d, \"%50s\")): could not get device ID for device with given BD address (error = %d)",
               bdAddress.c_str(), ETG_CENUM(ProtocolId, protocol._protocolId), protocol._uuid.c_str(),
               ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getDeviceBaseInfo(OUT DeviceBaseInfo& deviceBaseInfo, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceBaseInfo: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceBaseInfo: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      DeviceBaseInfoList deviceBaseInfoList;
      Result result = privGetDeviceBaseInfo(deviceBaseInfoList, deviceId);

      if ((CC_ERR_INT_NO_ERROR == result) && (1u == deviceBaseInfoList.size()))
      {
         deviceBaseInfo = deviceBaseInfoList.front();
      }

      return result;
   }

   Result DbManager::getDeviceBaseInfo(OUT DeviceBaseInfo& deviceBaseInfo, IN const BdAddress& bdAddress)
   {
      ETG_TRACE_USR1(("getDeviceBaseInfo: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceBaseInfo(bdAddress = \"%50s\"): database access is currently not allowed",
               bdAddress.c_str()));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      DeviceBaseInfoList deviceBaseInfoList;
      Result result = privGetDeviceBaseInfo(deviceBaseInfoList, bdAddress);

      if ((CC_ERR_INT_NO_ERROR == result) && (1u == deviceBaseInfoList.size()))
      {
         deviceBaseInfo = deviceBaseInfoList.front();
      }

      return result;
   }

   Result DbManager::getAllDeviceBaseInfo(OUT DeviceBaseInfoList& deviceBaseInfoList)
   {
      ENTRY

      ETG_TRACE_USR1(("getAllDeviceBaseInfo"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getAllDeviceBaseInfo: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      return privGetDeviceBaseInfo(deviceBaseInfoList, 0);
   }

   Result DbManager::getRemoteDeviceInfo(OUT RemoteDeviceInfo& remoteDeviceInfo, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getRemoteDeviceInfo: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getRemoteDeviceInfo: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);

      result = getDeviceBaseInfo(remoteDeviceInfo._deviceBaseInfo, deviceId);

      if (CC_ERR_INT_NO_ERROR == result)
      {
         LinkKey linkKey;
         result = getLinkKey(linkKey, deviceId);

         if (CC_ERR_INT_NO_ERROR == result)
         {
            remoteDeviceInfo._linkKey = linkKey;

            result = getProtocolConnectionInfos(remoteDeviceInfo._protocolConnectionInfo, remoteDeviceInfo._sppConnectionInfo, deviceId);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("getRemoteDeviceInfo(deviceId = %d): could not get protocol connection infos from DB (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            }
         }
         else
         {
            ETG_TRACE_ERR(("getRemoteDeviceInfo(deviceId = %d): could not get link key from DB (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         }
      }
      else
      {
         ETG_TRACE_ERR(("getRemoteDeviceInfo(deviceId = %d): could not get device base infos from DB (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getLinkKey(OUT LinkKey& linkKey, IN const DeviceId deviceId)
   {
       ENTRY

       ETG_TRACE_USR1(("getLinkKey: deviceId = %d", deviceId));

       if (false == this->isDatabaseAccessSwitchedOn())
       {
          ETG_TRACE_ERR(("getLinkKey: database access is currently not allowed"));

          return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
       }

       Result result(CC_ERR_INT_NO_ERROR);
       Query query;

       /* get the linkkey to the deviceId */
       result = query.Select(LTY_DEVICES, IN deviceId, "");

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("getLinkKey(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       LinkKeyChrArr linkKeyChrArr;

       result = query.Get("------T", OUT linkKeyChrArr, IN sizeof(LinkKeyChrArr));

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("getLinkKey(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       linkKey = linkKeyChrArr;

       return result;
   }

   Result DbManager::getLinkKeyInformation(OUT BTSLinkKeyType& linkKeyType, OUT BTSLinkKey& linkKey, OUT BTSDLinkKey& dLinkKey, IN const BdAddress& bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("getLinkKeyInformation: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getLinkKeyInformation: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      LinkKeyChrArr linkKeyChrArr;
      DLinkKeyChrArr dlinkKeyChrArr;

      DeviceId deviceId(0u);

      /*get the device ID from the Devices table for the given BD address*/
      result = getDeviceId(OUT deviceId, IN bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLinkKeyInformation(bdAddress = \"%50s\"): could not get device ID for given BD address (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      /* get the linkKeyType, linkkey dlinkKey to the deviceId */
      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLinkKeyInformation(bdAddress = \"%50s\"): Select failed (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("-----iTT",
            OUT &linkKeyType,
            OUT linkKeyChrArr, IN sizeof(LinkKeyChrArr),
            OUT dlinkKeyChrArr, IN sizeof(DLinkKeyChrArr));

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLinkKeyInformation(bdAddress = \"%50s\"): Get failed (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      linkKey = linkKeyChrArr;
      dLinkKey = dlinkKeyChrArr;

      return result;
   }

   Result DbManager::setDeviceInbandRingtoneSupport(IN const DeviceId deviceId, IN const InbandRingtoneSupport inbandRingtoneSupport)
   {
      ENTRY

      ETG_TRACE_USR1(("setDeviceInbandRingtoneSupport: deviceId = %d, inbandRingtoneSupport = %d", deviceId, ETG_CENUM(InbandRingtoneSupport, inbandRingtoneSupport)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setDeviceInbandRingtoneSupport: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      DeviceId deviceHandle;
      result = getDeviceHandle(OUT deviceHandle, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceInbandRingtoneSupport(deviceId = %d): could not get device handle from DB (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceInbandRingtoneSupport(deviceId = %d): Update failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("----------------------------------------ii----------------ii",
            IN 0, IN inbandRingtoneSupport,
            IN (0u != deviceId) ? 0 : 1, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceInbandRingtoneSupport(deviceId = %d): Change failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::setDeviceInbandRingtoneSupport(IN const BdAddress& bdAddress, IN const InbandRingtoneSupport inbandRingtoneSupport)
   {
      ENTRY

      ETG_TRACE_USR1(("setDeviceInbandRingtoneSupport: bdAddress = \"%50s\", inbandRingtoneSupport = %d", bdAddress.c_str(), ETG_CENUM(InbandRingtoneSupport, inbandRingtoneSupport)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setDeviceInbandRingtoneSupport: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      DeviceId deviceId(0u);
      Result result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceInbandRingtoneSupport(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = setDeviceInbandRingtoneSupport(deviceId, inbandRingtoneSupport);

      return result;
   }

   Result DbManager::getDeviceInbandRingtoneSupport(OUT InbandRingtoneSupport& inbandRingtoneSupport, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceInbandRingtoneSupport: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceInbandRingtoneSupport: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      inbandRingtoneSupport = BM_INBAND_RINGTONE_SUPPORT_UNKNOWN;

      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceInbandRingtoneSupport(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("---------------------i", OUT &inbandRingtoneSupport);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceInbandRingtoneSupport(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::setDeviceRingtoneId(IN const DeviceId deviceId, IN const RingtoneId ringtoneId)
   {
      ENTRY

      ETG_TRACE_USR1(("setDeviceRingtoneId: deviceId = %d, ringtoneId = %d", deviceId, ringtoneId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setDeviceRingtoneId: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceRingtoneId(deviceId = %d): Update failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("------------------------------------------ii--------------ii",
            IN 0, IN ringtoneId,
            IN (0u != deviceId) ? 0 : 1, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceRingtoneId(deviceId = %d): Change failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getDeviceRingtoneId(OUT RingtoneId& ringtoneId, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceRingtoneId: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceRingtoneId: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      ringtoneId = -1;

      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceRingtoneId(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("----------------------i", OUT &ringtoneId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceRingtoneId(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::setSystemWideRingtoneId(IN const RingtoneId ringtoneId)
   {
      ENTRY

      ETG_TRACE_USR1(("setSystemWideRingtoneId: ringtoneId = %d", ringtoneId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setSystemWideRingtoneId: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_GENERAL_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setSystemWideRingtoneId: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("----------ii", IN 0, IN ringtoneId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setSystemWideRingtoneId: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getSystemWideRingtoneId(OUT RingtoneId& ringtoneId)
   {
      ENTRY

      ETG_TRACE_USR1(("getSystemWideRingtoneId"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getSystemWideRingtoneId: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      ringtoneId = -1;

      result = query.Select(LTY_GENERAL, 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getSystemWideRingtoneId: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("-----i", OUT &ringtoneId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getSystemWideRingtoneId: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::setDeviceDisconnectedReason(IN const DeviceId deviceId, IN const DisconnectedReason reason)
   {
      ENTRY

      ETG_TRACE_USR1(("setDeviceDisconnectedReason: deviceId = %d, disconnectedReason = %d", deviceId, ETG_CENUM(DisconnectedReason, reason)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setDeviceDisconnectedReason: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceDisconnectedReason(deviceId = %d): Update failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      /* set the (new) disconnected reason */
      result = query.Change("--------------------------------ii------------------------ii",
            IN 0, IN reason,
            IN 0, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceDisconnectedReason(deviceId = %d): Change failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getDeviceDisconnectedReason(OUT DisconnectedReason& disconnectedReason, IN const DeviceId deviceId)
   {
       ENTRY

       ETG_TRACE_USR1(("getDeviceDisconnectedReason: deviceId = %d", deviceId));

       if (false == this->isDatabaseAccessSwitchedOn())
       {
          ETG_TRACE_ERR(("getDeviceDisconnectedReason: database access is currently not allowed"));

          return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
       }

       Result result(CC_ERR_INT_NO_ERROR);
       Query query;

       /* get the state to the deviceId */
       result = query.Select(LTY_DEVICES, IN deviceId, "");

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("getDeviceDisconnectedReason(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       result = query.Get("-----------------i", OUT &disconnectedReason);

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("getDeviceDisconnectedReason(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       return result;
   }

   Result DbManager::getDeviceLastConnectedInfo(OUT ConnectionOrderInfo& connectionOrderInfo, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceLastConnectedInfo: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceLastConnectedInfo: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Query query;
      Result res = CC_ERR_INT_NO_ERROR;

      res = query.Select(LTY_DEVICES, IN deviceId, "");

      if (res) return res;

      unsigned long long int lastConnectedTimeStamp;
      unsigned int lastConnectedIndex;

      res = query.Get("------------------li", OUT &lastConnectedTimeStamp, OUT &lastConnectedIndex);
      if (res) return res;

      connectionOrderInfo._seconds = lastConnectedTimeStamp;
      connectionOrderInfo._index = lastConnectedIndex;

      return CC_ERR_INT_NO_ERROR;
   }

   Result DbManager::setDeviceConnectionStatus(IN const DeviceId deviceId, IN const ConnectionStatus connectionStatus,
         IN const DisconnectedReason disconnectedReason)
   {
      ENTRY

      ETG_TRACE_USR1(("setDeviceConnectionStatus: deviceId = %d, connectionStatus = %d, disconnectedReason = %d", deviceId, ETG_CENUM(ConnectionStatus, connectionStatus), ETG_CENUM(DisconnectedReason, disconnectedReason)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setDeviceConnectionStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      return setDeviceConnectionStatus(deviceId, connectionStatus, disconnectedReason, false);
   }

   Result DbManager::getDeviceConnectionStatus(OUT ConnectionStatus& connectionStatus,
         OUT DisconnectedReason& disconnectedReason, IN const DeviceId deviceId)
   {
       ENTRY

       ETG_TRACE_USR1(("getDeviceConnectionStatus: deviceId = %d", deviceId));

       if (false == this->isDatabaseAccessSwitchedOn())
       {
          ETG_TRACE_ERR(("getDeviceConnectionStatus: database access is currently not allowed"));

          return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
       }

       Result result(CC_ERR_INT_NO_ERROR);
       Query query;

       result = query.Select(LTY_DEVICES, IN deviceId, "");

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("getDeviceConnectionStatus(deviceId = %d): Select failed (error = %d)", deviceId,
                ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       result = query.Get("----------------ii", OUT &connectionStatus, OUT &disconnectedReason);

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("getDeviceConnectionStatus(deviceId = %d): Get failed (error = %d)", deviceId,
                ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       return result;
   }

   Result DbManager::getDeviceConnectionStatus(OUT ConnectionStatus& connectionStatus,
         OUT DisconnectedReason& disconnectedReason, IN const BdAddress& bdAddress)
   {
       ENTRY

       ETG_TRACE_USR1(("getDeviceConnectionStatus: bdAddress = \"%50s\"", bdAddress.c_str()));

       if (false == this->isDatabaseAccessSwitchedOn())
       {
          ETG_TRACE_ERR(("getDeviceConnectionStatus: database access is currently not allowed"));

          return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
       }

       DeviceId deviceId(0u);
       Result result = getDeviceId(deviceId, bdAddress);

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("getDeviceConnectionStatus(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
                bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       result = this->getDeviceConnectionStatus(connectionStatus, disconnectedReason, deviceId);

       return result;
   }

   Result DbManager::getBdAddress(OUT BdAddress& bdAddress, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getBdAddress: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getBdAddress: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      bdAddress = "";

      BdAddressChrArr bdAddressChrArr;
      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getBdAddress(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("-T", OUT bdAddressChrArr, IN sizeof(BdAddressChrArr));

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getBdAddress(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      bdAddress = bdAddressChrArr;

      return result;
   }

   Result DbManager::getBdAddressByDeviceHandle(OUT BdAddress& bdAddress, IN const DeviceId deviceHandle)
   {
      ENTRY

      ETG_TRACE_USR1(("getBdAddressByDeviceHandle: deviceHandle = %d", deviceHandle));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getBdAddressByDeviceHandle: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      DeviceId devId;
      Result result(CC_ERR_INT_NO_ERROR);

      result = getDeviceId(devId, deviceHandle);
      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getBdAddressByDeviceHandle(deviceHandle = %d): getDeviceId failed (error = %d)", deviceHandle, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return getBdAddress(bdAddress, devId);
   }

   Result DbManager::getDeviceHandle(OUT DeviceId& devHandle, IN const BdAddress bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceHandle: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceHandle: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      DeviceId devId;
      Result result(CC_ERR_INT_NO_ERROR);

      result = getDeviceId(devId, bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceHandle(bdAddress = \"%50s\"): getDeviceId failed (error = %d)",  bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return getDeviceHandle(devHandle, devId);
   }

   Result DbManager::getDeviceHandle(OUT DeviceId& devHandle, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceHandle: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceHandle: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      devHandle = 0u;

      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceHandle(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("---i", OUT &devHandle);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceHandle(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getAllDeviceIds(OUT DeviceIdList& deviceIdList)
   {
      ENTRY

      ETG_TRACE_USR1(("getAllDeviceIds"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getAllDeviceIds: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      deviceIdList.clear();

      /* get all rows */
      result = query.Select(LTY_DEVICES, IN 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getAllDeviceIds: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceId deviceId;

      while(1)
      {
         result = query.Get("i", OUT &deviceId);

         if (result) break;

         deviceIdList.push_back(deviceId);
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getAllDeviceIds: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getAllBdAddresses(OUT BdAddressList& bdAddressList)
   {
      ENTRY

      ETG_TRACE_USR1(("getAllBdAddresses"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getAllBdAddresses: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      bdAddressList.clear();

      /* get all rows */
      result = query.Select(LTY_DEVICES, IN 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getAllBdAddresses: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      BdAddressChrArr bdAddress;

      while(1)
      {
         result = query.Get("-T", OUT bdAddress, IN sizeof(BdAddressChrArr));

         if (result) break;

         bdAddressList.push_back(bdAddress);
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getAllBdAddresses: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::setDeviceConnectionController(IN const DeviceId deviceId, IN const DeviceConnectionController* dccInstance)
   {
      ENTRY

      ETG_TRACE_USR1(("setDeviceConnectionController: deviceId = %d, dccInstance = 0x%p", deviceId, (const void*) dccInstance));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setDeviceConnectionController: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      SmHandle dccHandle(0);
      Query query;

      dccHandle = reinterpret_cast<SmHandle>(dccInstance);

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceConnectionController(deviceId = %d): Update failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("------il--------------------------------------------------ii",
            IN 0, IN dccHandle,
            IN 0, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceConnectionController(deviceId = %d): Change failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getDeviceConnectionController(OUT DeviceConnectionController** dccInstance, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceConnectionController: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceConnectionController: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      SmHandle dccHandle(0);
      Query query;

      *dccInstance = 0;

      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceConnectionController(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("----l", OUT &dccHandle);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceConnectionController(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      if (0 == dccHandle)
      {
         ETG_TRACE_ERR(("getDeviceConnectionController(deviceId = %d): no device connection controller handle found for device with device ID = %d", deviceId, deviceId));
         return CC_ERR_INT_DB_DCC_HANDLE_NOT_FOUND;
      }

      *dccInstance = reinterpret_cast<DeviceConnectionController*>(dccHandle);

      if (0 == *dccInstance)
      {
         ETG_TRACE_ERR(("getDeviceConnectionController(deviceId = %d): casting device connection controller handle = %d to pointer failed", deviceId, dccHandle));
         return CC_ERR_INT_DB_CASTING_ERROR;
      }

      ETG_TRACE_USR1(("getDeviceConnectionController(deviceId = %d): found DCC instance, dccInstance = 0x%p", deviceId, *dccInstance));

      return result;
   }

   Result DbManager::getDeviceConnectionController(OUT DeviceConnectionController** dccInstance, IN const BdAddress& bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceConnectionController: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceConnectionController: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      SmHandle dccHandle(0);
      Query query;

      *dccInstance = 0;

      result = query.Select(LTY_DEVICES, IN 0, "it", IN 0, bdAddress.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceConnectionController(bdAddress = \"%50s\"): Select failed (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("----l", OUT &dccHandle);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceConnectionController(bdAddress = \"%50s\"): Get failed (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      if (0 == dccHandle)
      {
         ETG_TRACE_ERR(("getDeviceConnectionController(bdAddress = \"%50s\"): no device connection controller handle found for device with BD address = \"%50s\"", bdAddress.c_str(), bdAddress.c_str()));
         return CC_ERR_INT_DB_DCC_HANDLE_NOT_FOUND;
      }

      *dccInstance = reinterpret_cast<DeviceConnectionController*>(dccHandle);

      if (0 == *dccInstance)
      {
         ETG_TRACE_ERR(("getDeviceConnectionController(bdAddress = \"%50s\"): casting device connection controller handle = %d to pointer failed", bdAddress.c_str(), dccHandle));
         return CC_ERR_INT_DB_CASTING_ERROR;
      }

      ETG_TRACE_USR1(("getDeviceConnectionController(bdAddress = \"%50s\"): found DCC instance, dccInstance = 0x%p", bdAddress.c_str(), *dccInstance));

      return result;
   }

   Result DbManager::createProtocol(IN const ProtocolId protocolId, IN const ProtocolName protocolName)
   {
      ENTRY

      Result result(CC_ERR_INT_NO_ERROR);
      std::map<int,const ProtocolConnectionController*>::iterator it;
      ProtocolConnectionController* pccInstance = this->getNewProtocolConnectionController(protocolId);
      ETG_TRACE_USR1(("createProtocol: protocolId = %d, protocolName = \"%50s\", pccInstance = 0x%p", ETG_CENUM(ProtocolId, protocolId), protocolName.c_str(), (void*) pccInstance));

      if (0 == pccInstance)
      {
        result = CC_ERR_INT_MEMORY_ALLOCATION_ERROR;
        ETG_TRACE_ERR(("createProtocolConnectionControllers: could not create PCC instance for protocol ID = %d (error = %d)", it->first, result));
         return result;
      }
      else
      {

         result = insertProtocolList(IN protocolId,IN protocolName,IN "",IN pccInstance,IN 0);

         if (CC_ERR_INT_NO_ERROR == result)
              {
                  pccInstance->create();
              }
         else
            {
               ETG_TRACE_ERR(("createProtocol(protocolId = %d): Insert in ProtocolList failed (error = %d)", protocolId, result));
               return result;
            }
         }
   return result;
   }

   Result DbManager::isUnusedProtocolConnectionControllerAvailable(OUT bool& available, IN const ProtocolId protocolId, IN const Uuid& uuid)
   {
      ENTRY

      ETG_TRACE_USR1(("isUnusedProtocolConnectionControllerAvailable: protocolId = %d, uuid = \"%50s\"", ETG_CENUM(ProtocolId, protocolId), uuid.c_str()));

      Result result(CC_ERR_INT_NO_ERROR);

      available = false;
      ProtocolConnectionController* pccHandle =0 ;
      ProtocolConnectionControllerInfoList::iterator it;

      for (it = _protocollist.begin(); it != _protocollist.end(); ++it)
      {
         if ((it->_sminusebydeviceid == 0) && (it->_id == protocolId))
         {
            if(BM_PROTOCOL_ID_HFP == protocolId)
            {
               TargetSwitchState multiHFPSupportTargetState;
               result = getMultiHFPSupportStatus(multiHFPSupportTargetState);

               if (CC_ERR_INT_NO_ERROR == result)
               {
                  bool used = false;
                  DeviceId deviceId = 0;
                  result = isUsedProtocolConnectionControllerAvailable(used, deviceId, protocolId);

                  if (CC_ERR_INT_NO_ERROR == result)
                  {
                     if (false == isValidTargetSwitchState(multiHFPSupportTargetState))
                     {
                        multiHFPSupportTargetState = LocalSpm::getDataProvider().getBmCoreConfiguration()._defaultmultiHFPSupport;

                        ETG_TRACE_USR1(("isUnusedProtocolConnectionControllerAvailable:MultiHFPSupport status stored in DB is not valid (using configured default value = %d)", ETG_CENUM(cc::TargetSwitchState, multiHFPSupportTargetState)));
                     }

                     ETG_TRACE_USR1(("isUnusedProtocolConnectionControllerAvailable:used = %d  multiHFPSupportTargetState = %d", used, ETG_CENUM(TargetSwitchState, multiHFPSupportTargetState)));

                     if((true == used) && (TARGET_SWITCH_STATE_SWITCHED_OFF == multiHFPSupportTargetState))
                     {
                        ETG_TRACE_ERR(("isUnusedProtocolConnectionControllerAvailable(deviceId = %d):  Maximum protocol connection controller is reached (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
                     }
                     else
                     {
                        pccHandle =it->_protocolconnectionsmhandle;
                     }
                  }
               }
            }
            else
            {
               pccHandle =it->_protocolconnectionsmhandle;
            }

            break;
         }
      }


      if (0 != pccHandle)
      {
         available = true;
      }
      else
      {
         result = CC_ERR_INT_PCC_ALREADY_ASSIGNED;
         ETG_TRACE_ERR(("isUnusedProtocolConnectionControllerAvailable(protocolId = %d, uuid = \"%50s\"): protocol connection controller is already assigned (error = %d)", ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::isUsedProtocolConnectionControllerAvailable(OUT bool& available, OUT DeviceId& deviceId, IN const ProtocolId protocolId)
   {
      ENTRY

      ETG_TRACE_USR1(("isUsedProtocolConnectionControllerAvailable: protocolId = %d", ETG_CENUM(ProtocolId, protocolId)));

      Result result(CC_ERR_INT_NO_ERROR);

      available = false;
      deviceId = 0;
      ProtocolConnectionController* pccHandle =0 ;
      ProtocolConnectionControllerInfoList::iterator it;

      for (it = _protocollist.begin(); it != _protocollist.end(); ++it)
      {
         if (it->_sminusebydeviceid != 0 && it->_id == protocolId)
         {
            pccHandle =it->_protocolconnectionsmhandle;
            deviceId = it->_sminusebydeviceid;
            break;
         }
      }

      if (0 == pccHandle)
      {
         result = CC_ERR_INT_NO_ERROR;
         ETG_TRACE_USR1(("isUsedProtocolConnectionControllerAvailable(protocolId = %d): protocol connection controller handle is not used", ETG_CENUM(ProtocolId, protocolId)));
         return result;
      }
      else
      {
         ETG_TRACE_USR1(("isUsedProtocolConnectionControllerAvailable(protocolId = %d): protocol connection controller handle is used", ETG_CENUM(ProtocolId, protocolId)));
      }

      available = true;

      return result;
   }

   Result DbManager::assignProtocolConnectionController(OUT ProtocolConnectionController** pccInstance, IN const DeviceId deviceId, IN const ProtocolId protocolId, IN const Uuid& uuid)
   {
      ENTRY

      ETG_TRACE_USR1(("assignProtocolConnectionController: deviceId = %d, protocolId = %d, uuid = \"%50s\"", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str()));

      // locks this method
      Locker locker(&_lockAssignProtocol);

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("assignProtocolConnectionController: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);

      *pccInstance = 0;

      //check if a protocol connection controller is already assigned to the given device
      result = getProtocolConnectionController(pccInstance, deviceId, protocolId, uuid);

      if (CC_ERR_INT_NO_ERROR == result)
      {
         ETG_TRACE_USR1(("assignProtocolConnectionController: protocol connection controller is already assigned to the given device"));
         //a protocol connection controller is already assigned to the given device
      }
      else if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         //no protocol connection controller handling the given protocol ID/UUID is assigned to the given device,
         //look for an unused one
         ProtocolConnectionController* pccHandle(0);
         ProtocolConnectionControllerInfoList::iterator it;

         for (it = _protocollist.begin(); it != _protocollist.end(); ++it)
         {
            if((it->_sminusebydeviceid==0) && (it->_id == protocolId))
            {
               if(BM_PROTOCOL_ID_HFP == protocolId)
               {
                  TargetSwitchState multiHFPSupportTargetState;
                  result = getMultiHFPSupportStatus(multiHFPSupportTargetState);

                  if (CC_ERR_INT_NO_ERROR == result)
                  {
                     bool available = false;
                     DeviceId deviceId = 0;
                     result = isUsedProtocolConnectionControllerAvailable(available, deviceId, protocolId);

                     if (CC_ERR_INT_NO_ERROR == result)
                     {
                        if (false == isValidTargetSwitchState(multiHFPSupportTargetState))
                        {
                           multiHFPSupportTargetState = LocalSpm::getDataProvider().getBmCoreConfiguration()._defaultmultiHFPSupport;

                           ETG_TRACE_USR1(("assignProtocolConnectionController:MultiHFPSupport status stored in DB is not valid (using configured default value = %d)", ETG_CENUM(TargetSwitchState, multiHFPSupportTargetState)));
                        }

                        ETG_TRACE_USR1(("assignProtocolConnectionController:available = %d  multiHFPSupportTargetState = %d", available, ETG_CENUM(TargetSwitchState, multiHFPSupportTargetState)));

                        if((true == available) && (TARGET_SWITCH_STATE_SWITCHED_OFF == multiHFPSupportTargetState))
                        {
                           result = CC_ERR_INT_PCC_NO_RESOURCES;
                           ETG_TRACE_ERR(("assignProtocolConnectionController(deviceId = %d):  Maximum protocol connection controller is reached (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
                           return result;
                        }
                     }
                  }
               }
               else
               {
                  result = CC_ERR_INT_NO_ERROR;
               }

               if(CC_ERR_INT_NO_ERROR == result)
               {
                  pccHandle =it->_protocolconnectionsmhandle;

                  if(BM_PROTOCOL_ID_SPP == protocolId)
                  {
                     it->_uuid =uuid;
                  }
                  else
                  {
                     it->_uuid = "";
                  }

                  it->_sminusebydeviceid=deviceId;
               }
               break;
            }
         }

         if (0 == pccHandle)
         {
            result = CC_ERR_INT_PCC_HANDLE_INVALID;
            ETG_TRACE_ERR(("assignProtocolConnectionController(deviceId = %d): protocol connection controller handle is 0 (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         if(pccHandle!=0)
         {
            result = CC_ERR_INT_NO_ERROR;
         }

         *pccInstance = pccHandle;
         (*pccInstance)->setUuid(uuid);
      }

      return result;
   }

/*
   Result DbManager::assignProtocolConnectionController(OUT ProtocolConnectionController** pccInstance, IN const BdAddress& bdAddress, IN const ProtocolId protocolId, IN const Uuid& uuid)
   {
      ENTRY

      ETG_TRACE_USR1(("assignProtocolConnectionController: bdAddress = \"%50s\", protocolId = %d, uuid = \"%50s\"", bdAddress.c_str(), ETG_CENUM(ProtocolId, protocolId), uuid.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("assignProtocolConnectionController: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);

      *pccInstance = 0;

      DeviceId deviceId(0u);

      result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("assignProtocolConnectionController(bdAddress = \"%50s\"): could not get deviceId for device with BD address = \"%50s\" (error = %d)", bdAddress.c_str(), bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = assignProtocolConnectionController(pccInstance, deviceId, protocolId, uuid);

      return result;
   }
*/
   Result DbManager::releaseProtocolConnectionController(IN const ProtocolConnectionController* pccInstance,
         IN const DisconnectedReason disconnectedReason)
   {
      ENTRY

      ETG_TRACE_USR1(("releaseProtocolConnectionController: pccInstance = 0x%p, disconnectedReason = %d",
            (const void *) pccInstance, ETG_CENUM(DisconnectedReason, disconnectedReason)));

      Locker locker(&_lockAssignProtocol);

      Result result(CC_ERR_INT_NO_ERROR);

      /* update the SMInUseByDeviceId to zero for the given SMhandle */

      ProtocolConnectionControllerInfoList::iterator it;
      for (it = _protocollist.begin(); it != _protocollist.end(); ++it)
      {
         if(it->_protocolconnectionsmhandle == pccInstance)
         {
            it->_sminusebydeviceid = 0;
            break;
         }
      }

      ETG_TRACE_USR1(("releaseProtocolConnectionController(pccInstance = 0x%p, disconnectedReason = %d): PCC instance released",
            (const void *) pccInstance, ETG_CENUM(DisconnectedReason, disconnectedReason)));

      return result;
   }

   Result DbManager::getProtocolConnectionControllers(OUT ProtocolConnectionControllerList& pccInstances, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolConnectionControllers: deviceId = %d", deviceId));

      Result result(CC_ERR_INT_NO_ERROR);

      pccInstances.clear();
      ProtocolConnectionControllerInfoList::iterator it;

      for (it = _protocollist.begin(); it != _protocollist.end(); ++it)
      {
         if (it->_sminusebydeviceid == deviceId)
         {
            ProtocolConnectionController* pccInstance = it->_protocolconnectionsmhandle;
            pccInstances.push_back(pccInstance);
         }
      }

      return result;
   }

   Result DbManager::getProtocolConnectionControllers(OUT ProtocolConnectionControllerList& pccInstances, IN const BdAddress& bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolConnectionControllers: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getProtocolConnectionControllers: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      DeviceId deviceId(0u);

      pccInstances.clear();

      result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR == result)
      {
         result = getProtocolConnectionControllers(pccInstances, deviceId);
      }
      else
      {
         ETG_TRACE_ERR(("getProtocolConnectionControllers(bdAddress = \"%50s\"): could not get device ID for device with given BD address (error = %d)", bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getProtocolLastConnectedInfo(OUT ConnectionOrderInfo& connectionOrderInfo,
         IN const DeviceId deviceId, IN const ProtocolId protocolId, IN const UuidChrArr uuid)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolLastConnectedInfo: deviceId = %d, protocolId = %d, uuid = \"%50s\"", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getProtocolLastConnectedInfo: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Query query;
      Result res(CC_ERR_INT_NO_ERROR);

      res = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "iiit", IN 0, IN protocolId,
            IN ((BM_PROTOCOL_ID_SPP == protocolId) ? 0 : 1), IN uuid);

      if (res) return res;

      unsigned long long int lastConnectedTimeStamp;
      unsigned int lastConnectedIndex;

      res = query.Get("------li", OUT &lastConnectedTimeStamp, OUT &lastConnectedIndex);

      if (res) return res;

      connectionOrderInfo._seconds = lastConnectedTimeStamp;
      connectionOrderInfo._index = lastConnectedIndex;

      return CC_ERR_INT_NO_ERROR;
   }

   Result DbManager::getMaxLastConnectedIndicator(OUT unsigned int & maxlastConnectedIndicator, IN bool useDevicesTable)
   {
      ENTRY

      ETG_TRACE_USR1(("getMaxLastConnectedIndicator: useDevicesTable = %d", useDevicesTable));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getMaxLastConnectedIndicator: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Query query;
      Result res;

      if(useDevicesTable)
      {
         res = query.Select(LTY_DEVICES_SELECT_MAX_CONNECTED_INDICATOR, 0, "");
      }
      else
      {
         res = query.Select(LTY_DEVICEPROTOCOLS_SELECT_MAX_INDICATOR, 0, "");
      }

      if (res) return res;

      res = query.Get("i", &maxlastConnectedIndicator);

      if (res) return res;

      return CC_ERR_INT_NO_ERROR;
   }

   Result DbManager::getMaxLastPairedIndicator(OUT unsigned int & maxlastPairedIndicator)
   {
      ENTRY

      ETG_TRACE_USR1(("getMaxLastPairedIndicator: entered"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getMaxLastPairedIndicator: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Query query;
      Result res;

      res = query.Select(LTY_DEVICES_SELECT_MAX_PAIRED_INDICATOR, 0, "");

      if (res) return res;

      res = query.Get("i", &maxlastPairedIndicator);

      if (res) return res;

      return CC_ERR_INT_NO_ERROR;
   }

   Result DbManager::getNumberOfDevices(OUT uint32_t& numberOfDevices)
   {
      ENTRY

      ETG_TRACE_USR1(("getNumberOfDevices"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getNumberOfDevices: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      numberOfDevices = 0u;

      result = query.Select(LTY_DEVICES_COUNT, 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getNumberOfDevices: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("i", &numberOfDevices);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getNumberOfDevices: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      ETG_TRACE_USR1(("getNumberOfDevices: numberOfDevices = %d", numberOfDevices));

      return result;
   }

   Result DbManager::getUnassignedDeviceHandle(OUT DeviceId& deviceHandle)
   {
      ENTRY

      ETG_TRACE_USR1(("getUnassignedDeviceHandle"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getUnassignedDeviceHandle: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      unsigned int MaxNumPairedDevices = LocalSpm::getDataProvider().getBmCoreConfiguration()._maxNumPairedDevices;
      unsigned int pairedDevicesCount = 0u;

      std::vector<bool> unassignedDeviceHandles(MaxNumPairedDevices);

      for (size_t idx = 0u; idx < MaxNumPairedDevices; ++idx)
      {
         unassignedDeviceHandles[idx] = true;
      }

      result = query.Select(LTY_DEVICES, 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getUnassignedDeviceHandle: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      while(1)
      {
         result = query.Get("---i", &deviceHandle);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            break;
         }

         if (++pairedDevicesCount > MaxNumPairedDevices)
         {
            ETG_TRACE_ERR(("getUnassignedDeviceHandle: Devices table has more paired devices than MaxNumPairedDevices(%d)", MaxNumPairedDevices));
            return CC_ERR_INT_DB_UNEXPECTED;
         }
         else if (DEVICE_HANDLE_TMP_VAL == deviceHandle)
         {
            //temporary value used during creation of a device db record
            continue;
         }
         else if (!((deviceHandle >= 2u) && (deviceHandle <= MaxNumPairedDevices + 1)))
         {
            ETG_TRACE_ERR(("getUnassignedDeviceHandle: Invalid Device Handle value found(%d)", deviceHandle));
            return CC_ERR_INT_DB_UNEXPECTED;
         }
         else
         {
            //Valid Device Handle values are between [2] and [MaxNumPairedDevices+1]
            if (true == unassignedDeviceHandles[deviceHandle-2])
            {
               unassignedDeviceHandles[deviceHandle-2] = false;
            }
            else
            {
               ETG_TRACE_ERR(("getUnassignedDeviceHandle: error found duplicate deviceHandle value(%d)", deviceHandle));
               return CC_ERR_INT_DB_UNEXPECTED;
            }
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         unsigned int i;
         for(i=0; i<MaxNumPairedDevices; i++)
         {
            //find the first (least) unassigned Device Handle Value
            if(true == unassignedDeviceHandles[i])
            {
               //Valid Device Handle values are between [2] and [MaxNumPairedDevices+1]
               deviceHandle = i+2;
               break;
            }
         }
         if(i< MaxNumPairedDevices)
         {
            ETG_TRACE_USR1(("getUnassignedDeviceHandle: deviceHandle = %d", deviceHandle));
            result = CC_ERR_INT_NO_ERROR;
         }
         else
         {
            ETG_TRACE_ERR(("getUnassignedDeviceHandle: Couldn't find an unassigned Device Handle"));
            result = CC_ERR_INT_DB_UNEXPECTED;
         }
      }
      else
      {
         ETG_TRACE_ERR(("getUnassignedDeviceHandle: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getProtocolConnectionControllers(OUT ProtocolConnectionControllerList& pccInstances)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolConnectionControllers"));

      Result result(CC_ERR_INT_NO_ERROR);

      pccInstances.clear();
      ProtocolConnectionControllerInfoList::iterator it;

      for (it = _protocollist.begin(); it != _protocollist.end(); ++it)
      {
         ProtocolConnectionController* pccInstance = it->_protocolconnectionsmhandle;
         pccInstances.push_back(pccInstance);
      }

      return result;
   }

   Result DbManager::getProtocolConnectionInfos(OUT ProtocolConnectionInfoMap& protocolConnectionInfo,
         OUT SppConnectionInfoMap& sppConnectionInfo, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolConnectionInfos: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getProtocolConnectionInfos: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Query query;
      Result res;

      protocolConnectionInfo.clear();
      sppConnectionInfo.clear();

      res = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "");
      if (res) return res;

      ProtocolId protocolId;
      UuidChrArr uuid;
      string uuidStr;
      RfcommDevicePathChrArr rfcommPath;
      ProtocolConnectionInfo info;

      while(1)
      {
         res = query.Get(IN "-itii----t", OUT &protocolId,
                                     OUT &uuid,
                                     OUT &info._connectionStatus,
                                     OUT &info._disconnectedReason,
                                     OUT &rfcommPath);
         if (res) break;

         if(BM_PROTOCOL_ID_SPP == protocolId)
         {
            uuidStr = uuid;
            if(SPPMAGICUUID != uuidStr)
            {
               //don't include the SPP record with Magic UUID
               info._rfcommDevicePath = rfcommPath;
               sppConnectionInfo[uuidStr] = info;
            }
         }
         else
         {
            protocolConnectionInfo[protocolId] = info;
         }
      }

      return CC_ERR_INT_NO_ERROR;
   }

   Result DbManager::getProtocolsExpectedToBeConnected(OUT ProtocolList& protocolList, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolsExpectedToBeConnected: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getProtocolsExpectedToBeConnected: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      protocolList.clear();

      result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "--------ii",
            IN 0, IN BM_LAST_EXPECTED_CONNECTION_STATUS_CONNECTED);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getProtocolsExpectedToBeConnected(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      Protocol protocol;
      UuidChrArr uuid;

      while (1)
      {
         protocol._uuid = "";

         result = query.Get(IN "-it", OUT &protocol._protocolId, OUT &uuid);

         if (result) break;

         if (BM_PROTOCOL_ID_SPP == protocol._protocolId)
         {
            protocol._uuid = uuid;
         }

         if (SPPMAGICUUID != protocol._uuid)
         {
            //don't include the SPP record with Magic UUID
            protocolList.push_back(protocol);
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getProtocolsExpectedToBeConnected(deviceId = %d): Get failed (error = %d)",
               deviceId, ETG_CENUM(CcErrorInternal, result)));

         protocolList.clear();

         return result;
      }

      std::sort(protocolList.begin(), protocolList.end(), compareProtocolIds);

      VARTRACE(protocolList);

      return result;
   }

   Result DbManager::getProtocolsLastConnected(OUT ProtocolList& protocolList, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolsLastConnected: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getProtocolsLastConnected: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      protocolList.clear();

      result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getProtocolsLastConnected(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      UuidChrArr uuid;
      std::pair<unsigned int, Protocol> protocolInfo;
      std::vector<std::pair<unsigned int, Protocol> > protocolInfoList;

      while (1)
      {
         protocolInfo.second._uuid = "";
         result = query.Get(IN "-it----i", OUT &protocolInfo.second._protocolId,
                                        OUT &uuid,
                                        OUT &protocolInfo.first);
         if (result) break;

         if(BM_PROTOCOL_ID_SPP == protocolInfo.second._protocolId)
         {
            protocolInfo.second._uuid = uuid;
         }

         if(SPPMAGICUUID != protocolInfo.second._uuid)
         {
            //don't include the SPP record with Magic UUID
            protocolInfoList.push_back(protocolInfo);
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getProtocolsLastConnected(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      std::sort(protocolInfoList.begin(), protocolInfoList.end(), compareLastConnectedIndicator<Protocol>);

      for (size_t i = 0u; i < protocolInfoList.size(); i++)
      {
         protocolList.push_back(protocolInfoList[i].second);
      }

      VARTRACE(protocolList);

      return result;
   }


   Result DbManager::getDeviceProtocolsConnectedStatus(OUT ProtocolList& protocolList, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceProtocolsConnectedStatus: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceProtocolsConnectedStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      protocolList.clear();

      result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceProtocolsConnectedStatus(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      UuidChrArr uuid;
      ConnectionStatus  connectionStatus = BM_CONNECTION_STATUS_UNKNOWN;

      while (1)
      {
         Protocol protocol;

         result = query.Get(IN "-iti", OUT &protocol._protocolId,
               OUT &uuid,
               OUT &connectionStatus);
         if (result) break;

         if(BM_PROTOCOL_ID_SPP == protocol._protocolId)
         {
            protocol._uuid = uuid;

            if(SPPMAGICUUID != protocol._uuid)
            {
               if((BM_CONNECTION_STATUS_CONNECTED == connectionStatus) || (BM_CONNECTION_STATUS_CONNECTING == connectionStatus))
               {
                  //don't include the SPP record with Magic UUID
                  protocolList.push_back(protocol);
               }
            }
         }
         else
         {
            if((BM_CONNECTION_STATUS_CONNECTED == connectionStatus) || (BM_CONNECTION_STATUS_CONNECTING == connectionStatus))
            {
               protocolList.push_back(protocol);
            }
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getDeviceProtocolsConnectedStatus(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      std::sort(protocolList.begin(), protocolList.end(), compareProtocolIds);

      VARTRACE(protocolList);

      return result;
   }

   Result DbManager::getDevicesLastConnected(OUT DeviceIdList& deviceList)
   {
      ENTRY

      ETG_TRACE_USR1(("getDevicesLastConnected"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDevicesLastConnected: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      deviceList.clear();

      result = query.Select(LTY_DEVICES, IN 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDevicesLastConnected: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      std::pair<DeviceIndicator, DeviceId> devInfo;
      std::vector<std::pair<DeviceIndicator, DeviceId> > devInfoList;

      while (1)
      {
         DeviceIndicator deviceIndicator;

         deviceIndicator._connectedIndicator = 0u;
         deviceIndicator._pairedIndicator = 0u;

         result = query.Get(IN "i------------------i--------i", OUT &devInfo.second, OUT &deviceIndicator._connectedIndicator, &deviceIndicator._pairedIndicator);
         if (result) break;

         devInfo.first = deviceIndicator;
         devInfoList.push_back(devInfo);
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getDevicesLastConnected: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      std::sort(devInfoList.begin(), devInfoList.end(), compareDeviceIndicator);

      for (size_t i = 0u; i < devInfoList.size(); i++)
      {
         deviceList.push_back(devInfoList[i].second);
      }

      VARTRACE(deviceList);

      return result;
   }


   Result DbManager::getConnectedDevices(OUT DeviceIdList& deviceList)
   {
      ENTRY

      ETG_TRACE_USR1(("getConnectedDevices"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getConnectedDevices: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      deviceList.clear();

      result = query.Select(LTY_DEVICES, IN 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getConnectedDevices: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceId deviceId(0u);
      ConnectionStatus  connectionStatus = BM_CONNECTION_STATUS_UNKNOWN;

      while (1)
      {
         result = query.Get(IN "i---------------i", OUT &deviceId, OUT &connectionStatus);
         if (result) break;

         if(BM_CONNECTION_STATUS_CONNECTED == connectionStatus)
         {
            deviceList.push_back(deviceId);
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getConnectedDevices: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      VARTRACE(deviceList);

      return result;
   }

   Result DbManager::getProtocolConnectionController(OUT ProtocolConnectionController** pccInstance, IN const DeviceId deviceId, IN const ProtocolId protocolId, IN const Uuid& uuid)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolConnectionController: deviceId = %d, protocolId = %d, uuid = \"%50s\"",
            deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str()));

      Result result(CC_ERR_INT_NO_ERROR);

      *pccInstance = 0;

      /* get the handle to SM for a device, protocolId and uuid (in case of SPP) combination */
      ProtocolConnectionControllerInfoList::iterator it;

      if (protocolId == BM_PROTOCOL_ID_SPP)
      {
         for (it = _protocollist.begin(); it != _protocollist.end(); ++it)
         {
            if ((it->_id==protocolId) && (deviceId==it->_sminusebydeviceid) && (uuid == it->_uuid))
            {
               if (0 == it->_protocolconnectionsmhandle)
               {
                  result = CC_ERR_INT_PCC_HANDLE_INVALID;

                  ETG_TRACE_ERR(("getProtocolConnectionController(deviceId = %d, protocolId = %d, uuid = \"%50s\"): protocol connection controller handle is 0 (error = %d)",
                        deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(CcErrorInternal, result)));

                  return result;
               }
               else
               {
                  *pccInstance = it->_protocolconnectionsmhandle;

                  ETG_TRACE_USR4(("getProtocolConnectionController(deviceId = %d, protocolId = %d, uuid = \"%50s\"): found PCC instance = =x%p",
                        deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), (void*)(*pccInstance)));

                  break;
               }
            }
         }
      }
      else
      {
         for (it = _protocollist.begin(); it != _protocollist.end(); ++it)
         {
            if ((it->_id == protocolId) && (deviceId == it->_sminusebydeviceid))
            {
               if (0 == it->_protocolconnectionsmhandle)
               {
                  result = CC_ERR_INT_PCC_HANDLE_INVALID;

                  ETG_TRACE_ERR(("getProtocolConnectionController(deviceId = %d, protocolId = %d, uuid = \"%50s\"): protocol connection controller handle is 0 (error = %d)",
                        deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(CcErrorInternal, result)));

                  return result;
               }
               else
               {
                  *pccInstance = it->_protocolconnectionsmhandle;

                  ETG_TRACE_USR4(("getProtocolConnectionController(deviceId = %d, protocolId = %d, uuid = \"%50s\"): found PCC instance = =x%p",
                        deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), (void*)(*pccInstance)));

                  break;
               }
            }
         }
      }

      if (0 == *pccInstance)
      {
         ETG_TRACE_USR4(("getProtocolConnectionController(deviceId = %d, protocolId = %d, uuid = \"%50s\"): no PCC instance found",
               deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str()));

         return CC_ERR_INT_DB_END_OF_LIST;
      }

      ETG_TRACE_USR1(("getProtocolConnectionController(deviceId = %d, protocolId = %d, uuid = \"%50s\"): found PCC instance, pccInstance = 0x%p", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), *pccInstance));

      return result;
   }

   Result DbManager::getProtocolConnectionController(OUT ProtocolConnectionController** pccInstance, IN const BdAddress& bdAddress, IN const ProtocolId protocolId, IN const Uuid& uuid)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolConnectionController: bdAddress = \"%50s\", protocolId = %d, uuid = \"%50s\"", bdAddress.c_str(), ETG_CENUM(ProtocolId, protocolId), uuid.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getProtocolConnectionController: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);

      *pccInstance = 0;

      DeviceId deviceId(0u);

      result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getProtocolConnectionController(bdAddress = \"%50s\"): could not get deviceId for device with BD address = \"%50s\" from DbManager (error = %d)", bdAddress.c_str(), bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = getProtocolConnectionController(OUT pccInstance, IN deviceId, IN protocolId, IN uuid);

      return result;
   }

   Result DbManager::getProtocolConnectionStatus(OUT ConnectionStatus& connectionStatus, OUT DisconnectedReason& disconnectedReason,
         IN const DeviceId deviceId, IN const ProtocolId protocolId, IN const Uuid& uuid)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolConnectionStatus: deviceId = %d, protocolId = %d, uuid = \"%50s\"", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getProtocolConnectionStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      connectionStatus = BM_CONNECTION_STATUS_UNKNOWN;
      disconnectedReason = BM_DISCONNECTED_REASON_UNKNOWN;

      result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "iiit",
            IN 0, IN protocolId,
            IN ((BM_PROTOCOL_ID_SPP == protocolId) ? 0 : 1), IN uuid.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getProtocolConnectionStatus(deviceId = %d, protocolId = %d, uuid = \"%50s\"): Select failed (error = %d)", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("---ii", OUT &connectionStatus, OUT &disconnectedReason);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getProtocolConnectionStatus(deviceId = %d, protocolId = %d, uuid = \"%50s\"): Get failed (error = %d)", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getProtocolConnectionStatus(OUT ConnectionStatus& connectionStatus, OUT DisconnectedReason& disconnectedReason,
         IN const BdAddress& bdAddress, IN const ProtocolId protocolId, IN const Uuid& uuid)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolConnectionStatus: bdAddress = \"%50s\", protocolId = %d, uuid = \"%50s\"", bdAddress.c_str(), ETG_CENUM(ProtocolId, protocolId), uuid.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getProtocolConnectionStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      DeviceId deviceId(0u);

      result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getProtocolConnectionStatus(bdAddress = \"%50s\"): could not get deviceId for device with BD address = \"%50s\" from DbManager (error = %d)", bdAddress.c_str(), bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = getProtocolConnectionStatus(OUT connectionStatus, OUT disconnectedReason, IN deviceId, IN protocolId, IN uuid);

      return result;
   }

   Result DbManager::setProtocolConnectionStatus(IN const DeviceId deviceId, IN const ProtocolId protocolId,
            IN const Uuid& uuid, IN const ConnectionStatus connectionStatus, IN const DisconnectedReason disconnectedReason,
            IN const RfcommDevicePath& rfcommDevicePath)
   {
      ENTRY

      ETG_TRACE_USR1(("setProtocolConnectionStatus: deviceId = %d, protocolId = %d, uuid = \"%50s\", connectionStatus = %d, disconnectedReason = %d, rfcommDevicePath = \"%50s\"",
            deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(ConnectionStatus, connectionStatus),
            ETG_CENUM(DisconnectedReason, disconnectedReason), rfcommDevicePath.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setProtocolConnectionStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      DisconnectedReason modDisconnectedReason(BM_DISCONNECTED_REASON_NOT_APPLICABLE);
      unsigned short int ignoreLastExpectedProtocolConnectionStatus(1u);
      Query query;

      if (BM_CONNECTION_STATUS_DISCONNECTED == connectionStatus)
      {
         modDisconnectedReason = disconnectedReason;
      }

      ConnectionStatus oldConnectionStatus;
      DisconnectedReason oldDisconnectedReason;

      result = getProtocolConnectionStatus(oldConnectionStatus, oldDisconnectedReason, deviceId, protocolId, uuid);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setProtocolConnectionStatus(deviceId = %d, protocolId = %d, uuid = \"%50s\"): could not get protocol connection status from DB (error = %d)", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setProtocolConnectionStatus(deviceId = %d, protocolId = %d, uuid = \"%50s\"): Update failed (error = %d)", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      LastExpectedConnectionStatus lastExpectedProtocolConnectionStatus(BM_LAST_EXPECTED_CONNECTION_STATUS_UNKNOWN);

      if (BM_CONNECTION_STATUS_CONNECTED == connectionStatus)
      {
         lastExpectedProtocolConnectionStatus = BM_LAST_EXPECTED_CONNECTION_STATUS_CONNECTED;
         ignoreLastExpectedProtocolConnectionStatus = 0u;
      }

      unsigned long long int lastConnectedTimeStamp(0u);
      unsigned int lastConnectedIndicator(0u);

      if(((BM_CONNECTION_STATUS_CONNECTED != oldConnectionStatus) && (BM_CONNECTION_STATUS_CONNECTED == connectionStatus))
            || (((BM_CONNECTION_STATUS_CONNECTED == oldConnectionStatus) || (BM_CONNECTION_STATUS_DISCONNECTING == oldConnectionStatus))
                  && (BM_CONNECTION_STATUS_DISCONNECTED == connectionStatus)))
      {
         //store current time in lastConnectedTimeStamp
         struct timespec lastConnectedTS;
         clock_gettime(CLOCK_REALTIME , &lastConnectedTS);
         lastConnectedTimeStamp = lastConnectedTS.tv_sec;

         //get the MAX(LastConnectedIndicator) in DeviceProtocols Table and store MAX(lastConnectedIndicator)+1
         result = getMaxLastConnectedIndicator(lastConnectedIndicator, false);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setProtocolConnectionStatus(deviceId = %d, protocolId = %d, uuid = \"%50s\"): getMaxLastConnectedIndicator failed (error = %d)", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         lastConnectedIndicator++;

         result = query.Change("------iiiiiiilii--it--------iiiiit",
               IN 0, IN connectionStatus,
               IN 0, IN modDisconnectedReason,
               IN ignoreLastExpectedProtocolConnectionStatus, IN lastExpectedProtocolConnectionStatus,
               IN 0, IN lastConnectedTimeStamp,
               IN 0, IN lastConnectedIndicator,
               IN ((BM_PROTOCOL_ID_SPP == protocolId) ? 0 : 1), IN rfcommDevicePath.c_str(),
               IN 0, IN deviceId,
               IN 0, IN protocolId,
               IN ((BM_PROTOCOL_ID_SPP == protocolId) ? 0 : 1), IN uuid.c_str());


         if( BM_PROTOCOL_ID_HFP == protocolId)
         {
            SetPrimaryDevice(deviceId,connectionStatus);
         }
         // Reset the Last Expected connection status of PAN protocol for other device except PAN connected device.
         // Because next time autoconnection will be triggered for PAN protocol to only this device
         else if((BM_PROTOCOL_ID_PAN == protocolId) && (BM_CONNECTION_STATUS_CONNECTED == connectionStatus))
         {
            DeviceIdList deviceIds;
            result = getAllDeviceIds(deviceIds);

            if (CC_ERR_INT_NO_ERROR == result)
            {
               for (size_t devIdx = 0u; devIdx < deviceIds.size(); devIdx++)
               {
                  if(deviceIds[devIdx] != deviceId)
                  {
                     result = setLastExpectedProtocolConnectionStatus(deviceIds[devIdx], protocolId, uuid, BM_LAST_EXPECTED_CONNECTION_STATUS_DISCONNECTED);

                     if (CC_ERR_INT_NO_ERROR != result)
                     {
                        ETG_TRACE_ERR(("setProtocolConnectionStatus: could not set last expected protocol connection status in DB for device ID = %d from DB (error = %d)",
                              deviceIds[devIdx], ETG_CENUM(CcErrorInternal, result)));
                     }
                  }
               }
            }
            else
            {
               ETG_TRACE_ERR(("setProtocolConnectionStatus(): could not get all device IDs from DB (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            }
         }
      }
      else
      {
         result = query.Change("------iiiiii------it--------iiiiit",
               IN 0, IN connectionStatus,
               IN 0, IN modDisconnectedReason,
               IN ignoreLastExpectedProtocolConnectionStatus, IN lastExpectedProtocolConnectionStatus,
               IN ((BM_PROTOCOL_ID_SPP == protocolId) ? 0 : 1), IN rfcommDevicePath.c_str(),
               IN 0, IN deviceId,
               IN 0, IN protocolId,
               IN ((BM_PROTOCOL_ID_SPP == protocolId) ? 0 : 1), IN uuid.c_str());
      }

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setProtocolConnectionStatus(deviceId = %d, protocolId = %d, uuid = \"%50s\"): Change failed (error = %d)",
               deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      LocalSpm::getBmCoreMainController().onProtocolConnectionStatusChanged(deviceId, Protocol(protocolId, uuid), connectionStatus, modDisconnectedReason, rfcommDevicePath);

      return result;
   }

   Result DbManager::setLastExpectedProtocolConnectionStatus(IN const DeviceId deviceId, IN const ProtocolId protocolId,
         IN const Uuid& uuid, IN const LastExpectedConnectionStatus lastExpectedConnectionStatus)
   {
      ENTRY

      ETG_TRACE_USR1(("setLastExpectedProtocolConnectionStatus: deviceId = %d, protocolId = %d, uuid = \"%50s\", lastExpectedConnectionStatus = %d",
            deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str(),
            ETG_CENUM(LastExpectedConnectionStatus, lastExpectedConnectionStatus)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setLastExpectedProtocolConnectionStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setLastExpectedProtocolConnectionStatus: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("----------ii----------------iiiiit",
            IN 0, IN lastExpectedConnectionStatus,
            IN 0, IN deviceId,
            IN 0, IN protocolId,
            IN ((BM_PROTOCOL_ID_SPP == protocolId) ? 0 : 1), IN uuid.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setLastExpectedProtocolConnectionStatus: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::resetLastExpectedProtocolConnectionStatus(IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("resetLastExpectedProtocolConnectionStatus: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("resetLastExpectedProtocolConnectionStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "----ii--ii",
            IN 0, IN BM_CONNECTION_STATUS_DISCONNECTED, IN 0, IN BM_LAST_EXPECTED_CONNECTION_STATUS_CONNECTED);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("resetLastExpectedProtocolConnectionStatus: Select failed (error = %d)",
               ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      ProtocolList protocolList;
      Protocol protocol;
      UuidChrArr uuid;
      DisconnectedReason disconnectedReason;

      while (1)
      {
         protocol._uuid = "";

         result = query.Get(IN "-it-i", OUT &protocol._protocolId, OUT &uuid, OUT &disconnectedReason);

         if (result) break;

         if (BM_PROTOCOL_ID_SPP == protocol._protocolId)
         {
            protocol._uuid = uuid;
         }

         if ((SPPMAGICUUID != protocol._uuid)
            && (BM_DISCONNECTED_REASON_AUTOMATIC != disconnectedReason)
            && (BM_DISCONNECTED_REASON_TEMPORARILY != disconnectedReason))
         {
            //don't include the SPP record with Magic UUID
            protocolList.push_back(protocol);
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("resetLastExpectedProtocolConnectionStatus(deviceId = %d): Get failed (error = %d)",
               deviceId, ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      ETG_TRACE_USR1(("resetLastExpectedProtocolConnectionStatus(deviceId = %d): resetting the last expected protocol connection status for following protocols:",
            deviceId));

      VARTRACE(protocolList);

      result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("resetLastExpectedProtocolConnectionStatus(deviceId = %d): Update failed (error = %d)",
               deviceId, ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      for (size_t idx = 0u; idx < protocolList.size(); ++idx)
      {
         result = query.Change("----------ii----------------iiiiit",
               IN 0, IN BM_LAST_EXPECTED_CONNECTION_STATUS_DISCONNECTED,
               IN 0, IN deviceId,
               IN 0, IN protocolList[idx]._protocolId,
               IN ((BM_PROTOCOL_ID_SPP == protocolList[idx]._protocolId) ? 0 : 1), IN protocolList[idx]._uuid.c_str());

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("resetLastExpectedProtocolConnectionStatus(deviceId = %d): Change failed (error = %d)",
                  deviceId, ETG_CENUM(CcErrorInternal, result)));

            return result;
         }
      }

      return CC_ERR_INT_NO_ERROR;
   }

   Result DbManager::setProtocolVersion(IN const DeviceId deviceId, IN const ProtocolId protocolId, IN const ProtocolVersion protocolVersion)
   {
      ENTRY

      ETG_TRACE_USR1(("setProtocolVersion: deviceId = %d, protocolId = %d, protocolVersion = 0x%04X", deviceId, ETG_CENUM(ProtocolId, protocolId), protocolVersion));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setProtocolVersion: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setProtocolVersion: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("--------------------ii------iiii",
            IN 0, IN static_cast<unsigned int>(protocolVersion),
            IN 0, IN deviceId,
            IN 0, IN protocolId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setProtocolVersion: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getLastExpectedProtocolConnectionStatus(OUT LastExpectedConnectionStatus& lastExpectedConnectionStatus,
         IN const DeviceId deviceId, IN const ProtocolId protocolId, IN const Uuid& uuid)
   {
      ENTRY

      ETG_TRACE_USR1(("getLastExpectedProtocolConnectionStatus: deviceId = %d, protocolId = %d, uuid = \"%50s\"", deviceId, ETG_CENUM(ProtocolId, protocolId), uuid.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getLastExpectedProtocolConnectionStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "iiit",
                  IN 0, IN protocolId,
                  IN ((BM_PROTOCOL_ID_SPP == protocolId) ? 0 : 1), IN uuid.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLastExpectedProtocolConnectionStatus: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("-----i", OUT &lastExpectedConnectionStatus);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLastExpectedProtocolConnectionStatus: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::deleteDevice(IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("deleteDevice: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("deleteDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;
      DeviceId deviceHandle;

      unsigned short int deleteAll(0u);

      if (0u == deviceId)
      {
         deleteAll = 1u;
         deviceHandle = 0;
      }
      else
      {
         result = getDeviceHandle(deviceHandle, deviceId);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("deleteDevice(deviceId = %d): Couldn't get device handle (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }
      }

      result = query.Delete(LTY_DEVICES_DELETE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("deleteDevice(deviceId = %d): Delete failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Remove("ii", IN deleteAll, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("deleteDevice(deviceId = %d): Remove failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Delete(LTY_DEVICEPROTOCOLS_DELETE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("deleteDevice(deviceId = %d): Delete failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Remove("ii", IN deleteAll, IN deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("deleteDevice(deviceId = %d): Remove failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      // update the SMInUseByDeviceId and the UUID

      ProtocolConnectionControllerInfoList::iterator it;

      for (it = _protocollist.begin(); it != _protocollist.end(); ++it)
      {
         if (deviceId == it->_sminusebydeviceid)
         {
            it->_sminusebydeviceid = 0u;
            it->_uuid = "";
         }
      }

      _db->fSync();

      // update properties
      LocalSpm::getBmCoreMainController().onDeviceDeleted(deviceHandle);

      return result;
   }

   Result DbManager::getBtStatusTargetState(OUT TargetSwitchState& btStatusTargetState)
   {
      ENTRY

      ETG_TRACE_USR1(("getBtStatusTargetState"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getBtStatusTargetState: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      btStatusTargetState = TARGET_SWITCH_STATE_SWITCHED_OFF;

      result = query.Select(LTY_GENERAL, 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getBtStatusTargetState: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("i", OUT &btStatusTargetState);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getBtStatusTargetState: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::setBtStatusTargetState(IN const TargetSwitchState btStatusTargetState)
   {
      ENTRY

      ETG_TRACE_USR1(("setBtStatusTargetState: btStatusTargetState = %d", ETG_CENUM(TargetSwitchState, btStatusTargetState)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setBtStatusTargetState: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_GENERAL_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setBtStatusTargetState: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("ii", IN 0, IN static_cast<int>(btStatusTargetState));

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setBtStatusTargetState: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getLocalBdAddress(OUT BdAddress& bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("getLocalBdAddress"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getLocalBdAddress: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      bdAddress = "";

      result = query.Select(LTY_GENERAL, 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLocalBdAddress: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      BdAddressChrArr bdaddressChrArr;
      result = query.Get("-t", OUT &bdaddressChrArr);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLocalBdAddress: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      bdAddress = bdaddressChrArr;

      return result;
   }

   Result DbManager::setLocalBdAddress(IN const BdAddress& bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("setLocalBdAddress: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setLocalBdAddress: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Query query;
      Result res = CC_ERR_INT_NO_ERROR;

      res = query.Update(LTY_GENERAL_UPDATE);
      if (res) return res;

      res = query.Change("--it",
            IN 0, IN bdAddress.c_str());
      if (res) return res;

      return CC_ERR_INT_NO_ERROR;
   }

   Result DbManager::getLocalBdName(OUT BdName& bdName)
   {
      ENTRY

      ETG_TRACE_USR1(("getLocalBdName"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getLocalBdName: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      bdName = "";

      result = query.Select(LTY_GENERAL, 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLocalBdName: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceNameChrArr bdNameChrArr;
      result = query.Get("--t", OUT &bdNameChrArr);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLocalBdName: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      bdName = bdNameChrArr;

      return result;
   }

   Result DbManager::setLocalBdName(IN const BdName& bdName)
   {
      ENTRY

      ETG_TRACE_USR1(("setLocalBdName: bdName = \"%50s\"", bdName.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setLocalBdName: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_GENERAL_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setLocalBdName: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("----it", IN 0, IN bdName.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setLocalBdName: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      _db->fSync();

      return result;
   }

   Result DbManager::getLegacyPairingPin(OUT PairingPinType& legacyPairingPin)
   {
      ENTRY

      ETG_TRACE_USR1(("getLegacyPairingPin"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getLegacyPairingPin: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      legacyPairingPin = "";

      result = query.Select(LTY_GENERAL, 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLegacyPairingPin: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      LegacyPinCodeChrArr legacyPairingPinChrArr;
      result = query.Get("---T", OUT legacyPairingPinChrArr, sizeof(legacyPairingPinChrArr));

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLegacyPairingPin: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      legacyPairingPin = legacyPairingPinChrArr;

      return result;
   }

   Result DbManager::setLegacyPairingPin(IN const PairingPinType& legacyPairingPin)
   {
      ENTRY

      ETG_TRACE_USR1(("setLegacyPairingPin: legacyPairingPin = \"%50s\"", legacyPairingPin.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setLegacyPairingPin: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_GENERAL_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setLegacyPairingPin: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("------it", IN 0, IN legacyPairingPin.c_str());

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setLegacyPairingPin: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getStandardAutoConnectionType(OUT StandardAutoConnectionType& standardAutoConnectionType)
   {
      ENTRY

      ETG_TRACE_USR1(("getStandardAutoConnectionType"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getStandardAutoConnectionType: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      standardAutoConnectionType = BM_STANDARD_AUTO_CONNECTION_UNKNOWN;

      result = query.Select(LTY_GENERAL, 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getStandardAutoConnectionType: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("----i", OUT &standardAutoConnectionType);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getStandardAutoConnectionType: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::setStandardAutoConnectionType(IN const StandardAutoConnectionType standardAutoConnectionType)
   {
      ENTRY

      ETG_TRACE_USR1(("setStandardAutoConnectionType: standardAutoConnectionType = %d", standardAutoConnectionType));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setStandardAutoConnectionType: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_GENERAL_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setStandardAutoConnectionType: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("--------ii", IN 0, IN standardAutoConnectionType);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setStandardAutoConnectionType: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::getMultiHFPSupportStatus(OUT TargetSwitchState& multiHFPSupportTargetState)
   {
      ENTRY

      ETG_TRACE_USR1(("getMultiHFPSupportStatus"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getMultiHFPSupportStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      multiHFPSupportTargetState = TARGET_SWITCH_STATE_SWITCHED_OFF;

      result = query.Select(LTY_GENERAL, 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getMultiHFPSupportStatus: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("------i", OUT &multiHFPSupportTargetState);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getMultiHFPSupportStatus: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::setMultiHFPSupportStatus(IN const int multiHFPSupportTargetState)
   {
      ENTRY

      ETG_TRACE_USR1(("setMultiHFPSupportStatus: btStatusTargetState = %d", ETG_CENUM(TargetSwitchState, multiHFPSupportTargetState)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setMultiHFPSupportStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_GENERAL_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setMultiHFPSupportStatus: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Change("------------ii", IN 0, IN multiHFPSupportTargetState);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setMultiHFPSupportStatus: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::resetProtocolsTable(void)
   {
       ENTRY

       ETG_TRACE_USR1(("resetProtocolsTable"));
       // do not destroy PCCs because SMF does not provide destroy functionality (memory leak)
       // destroyProtocolConnectionController();
       Result result(CC_ERR_INT_NO_ERROR);

       return result;
   }

   Result DbManager::resetDevicesTable(void)
   {
       ENTRY

       ETG_TRACE_USR1(("resetDevicesTable"));

       Result result(CC_ERR_INT_NO_ERROR);
       Query query;

       DeviceIdList deviceIdsLastConnected;
       result = getDevicesLastConnected(deviceIdsLastConnected);

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("resetDevicesTable: could not get devices sorted by last connection index in descending order from DB (error = %d)", ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       unsigned int lastConnectedIndicator;
       result = getMaxLastConnectedIndicator(lastConnectedIndicator, true);

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("resetDevicesTable: could not get maximum last connected indicator from DB (error = %d)", ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       ConnectionStatus oldConnectionStatus;
       DisconnectedReason oldDisconnectedReason;

       for (size_t devIdx = 0u; devIdx < deviceIdsLastConnected.size(); devIdx++)
       {
          result = getDeviceConnectionStatus(oldConnectionStatus, oldDisconnectedReason, deviceIdsLastConnected[devIdx]);

          if (CC_ERR_INT_NO_ERROR != result)
          {
             ETG_TRACE_ERR(("resetDevicesTable: could not get device connection status of device with ID = %d from DB (error = %d)", deviceIdsLastConnected[devIdx], ETG_CENUM(CcErrorInternal, result)));
             return result;
          }

          result = query.Update(LTY_DEVICES_UPDATE);

          if (CC_ERR_INT_NO_ERROR != result)
          {
             ETG_TRACE_ERR(("resetDevicesTable: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
             return result;
          }

          if (BM_CONNECTION_STATUS_DISCONNECTED != oldConnectionStatus)
          {
             lastConnectedIndicator++;

             result = query.Change("------il----------------------iiii--iiii------------------ii",
                   IN 0, IN SmHandle(0) /* DeviceConnectionSMHandle=0 */,
                   IN 0, BM_CONNECTION_STATUS_DISCONNECTED,
                   IN 0, ((true == LocalSpm::getDataProvider().getBmCoreConfiguration()._startAutoConnectionOnStartUp) ? BM_DISCONNECTED_REASON_TEMPORARILY : BM_DISCONNECTED_REASON_NORMAL_LOSS_LOCAL),
                   IN 0, lastConnectedIndicator,
                   IN 0, BM_BLOCK_STATE_UNBLOCKED,
                   IN 0, deviceIdsLastConnected[devIdx]);
          }
          else
          {
             result = query.Change("------il------------------------ii----ii------------------ii",
                   IN 0, IN SmHandle(0) /* DeviceConnectionSMHandle=0 */,
                   IN 0, ((true == LocalSpm::getDataProvider().getBmCoreConfiguration()._startAutoConnectionOnStartUp) ? BM_DISCONNECTED_REASON_TEMPORARILY : oldDisconnectedReason),
                   IN 0, BM_BLOCK_STATE_UNBLOCKED,
                   IN 0, deviceIdsLastConnected[devIdx]);
          }

          if (CC_ERR_INT_NO_ERROR != result)
          {
             ETG_TRACE_ERR(("resetDevicesTable: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
             return result;
          }
       }

       return result;
   }

   Result DbManager::resetDeviceProtocolsTable(void)
   {
       ENTRY

       ETG_TRACE_USR1(("resetDeviceProtocolsTable"));

       Result result(CC_ERR_INT_NO_ERROR);
       Query query;

       DeviceIdList deviceIdsLastConnected;
       result = getDevicesLastConnected(deviceIdsLastConnected);

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("resetDeviceProtocolsTable: could not get devices sorted by last connection index in descending order from DB (error = %d)", ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       unsigned int lastConnectedIndicator;
       result = getMaxLastConnectedIndicator(lastConnectedIndicator, false);

       if (CC_ERR_INT_NO_ERROR != result)
       {
          ETG_TRACE_ERR(("resetDeviceProtocolsTable: could not get maximum last connected indicator from DB (error = %d)", ETG_CENUM(CcErrorInternal, result)));
          return result;
       }

       DisconnectedReason oldDisconnectedReason(BM_DISCONNECTED_REASON_UNKNOWN);
       ConnectionStatus oldConnectionStatus;
       ProtocolList protocolsLastConnected;

       for (size_t devIdx = 0u; devIdx < deviceIdsLastConnected.size(); devIdx++)
       {
          result = getProtocolsLastConnected(protocolsLastConnected, deviceIdsLastConnected[devIdx]);

          if (CC_ERR_INT_NO_ERROR != result)
          {
             ETG_TRACE_ERR(("resetDeviceProtocolsTable: could not get protocols sorted by last connection index in descending order from DB (error = %d)", ETG_CENUM(CcErrorInternal, result)));
             return result;
          }

          for (size_t protIdx = 0u; protIdx < protocolsLastConnected.size(); protIdx++)
          {
             result = getProtocolConnectionStatus(oldConnectionStatus, oldDisconnectedReason, deviceIdsLastConnected[devIdx],
                   protocolsLastConnected[protIdx]._protocolId, protocolsLastConnected[protIdx]._uuid);

             if (CC_ERR_INT_NO_ERROR != result)
             {
                ETG_TRACE_ERR(("resetDeviceProtocolsTable: could not get protocol connection status from DB (error = %d)", ETG_CENUM(CcErrorInternal, result)));
                return result;
             }

             result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

             if (CC_ERR_INT_NO_ERROR != result)
             {
                ETG_TRACE_ERR(("resetDeviceProtocolsTable: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
                return result;
             }

             if (BM_CONNECTION_STATUS_DISCONNECTED != oldConnectionStatus)
             {
                lastConnectedIndicator++;

                result = query.Change("------iiii----iiiiit----ii--iiiiit",
                      IN 0, IN BM_CONNECTION_STATUS_DISCONNECTED,
                      IN 0, ((BM_PROTOCOL_ID_SPP == protocolsLastConnected[protIdx]._protocolId) ? IN BM_DISCONNECTED_REASON_NONE : IN BM_DISCONNECTED_REASON_NORMAL_LOSS_LOCAL),
                      IN 0, IN lastConnectedIndicator,
                      IN 0, BM_BLOCK_STATE_UNBLOCKED,
                      IN 0, "",
                      IN 0, IN 0,
                      IN 0, IN deviceIdsLastConnected[devIdx],
                      IN 0, IN protocolsLastConnected[protIdx]._protocolId,
                      IN ((BM_PROTOCOL_ID_SPP == protocolsLastConnected[protIdx]._protocolId) ? 0 : 1), IN protocolsLastConnected[protIdx]._uuid.c_str());
             }
             else
             {
                result = query.Change("--------ii------iiit----ii--iiiiit",
                      IN 0, IN oldDisconnectedReason,
                      IN 0, BM_BLOCK_STATE_UNBLOCKED,
                      IN 0, "",
                      IN 0, IN 0,
                      IN 0, IN deviceIdsLastConnected[devIdx],
                      IN 0, IN protocolsLastConnected[protIdx]._protocolId,
                      IN ((BM_PROTOCOL_ID_SPP == protocolsLastConnected[protIdx]._protocolId) ? 0 : 1), IN protocolsLastConnected[protIdx]._uuid.c_str());
             }

             if (CC_ERR_INT_NO_ERROR != result)
             {
                ETG_TRACE_ERR(("resetDeviceProtocolsTable: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
                return result;
             }
          }
       }

       return result;
   }

   Result DbManager::resetAllTables(void)
   {
      ENTRY

      ETG_TRACE_USR1(("resetAllTables"));

      Result result(CC_ERR_INT_NO_ERROR);

      result = resetProtocolsTable();

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("resetAllTables: resetting table Protocols failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = resetDevicesTable();

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("resetAllTables: resetting table Devices failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = resetDeviceProtocolsTable();

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("resetAllTables: resetting table DeviceProtocols failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return result;
   }

   Result DbManager::privGetDeviceBaseInfo(OUT DeviceBaseInfoList& deviceBaseInfoList, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("privGetDeviceBaseInfo: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("privGetDeviceBaseInfo: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      deviceBaseInfoList.clear();

      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("privGetDeviceBaseInfo(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceId tmpDeviceId(0u);

      do
      {
         DeviceBaseInfo deviceBaseInfo;

         //std::string could not be passed to Get function, only character arrays can be passed.
         BdAddressChrArr bdAddress;
         DeviceNameChrArr deviceName;
         unsigned long long int lastConnectedTimeStamp;
         unsigned long long int lastPairedTimeStamp;

         //DB Queries cannot work with unsigned short int (using it will lead to memory corruptions as it is expecting integers)
         //so we need to read device identification data into unsigned int
         unsigned int specificationId = 0;
         unsigned int vendorId = 0;
         unsigned int productId = 0;
         unsigned int version = 0;
         unsigned int vendorIdSource = 0;

         result = query.Get("iTTi----i--iiiiiiili-i-ii--li",
               OUT &tmpDeviceId,
               OUT bdAddress, IN sizeof(BdAddressChrArr),
               OUT deviceName, IN sizeof(DeviceNameChrArr),
               OUT &deviceBaseInfo._deviceHandle,
               OUT &deviceBaseInfo._majorDeviceClass,
               OUT &specificationId,
               OUT &vendorId,
               OUT &productId,
               OUT &version,
               OUT &vendorIdSource,
               OUT &deviceBaseInfo._connectionStatus,
               OUT &deviceBaseInfo._disconnectedReason,
               OUT &lastConnectedTimeStamp,
               OUT &deviceBaseInfo._connectionOrderInfo._index,
               OUT &deviceBaseInfo._inbandRingtoneSupport,
               OUT &deviceBaseInfo._favoriteIndex,
               OUT &deviceBaseInfo._usagePreference,
               OUT &lastPairedTimeStamp,
               OUT &deviceBaseInfo._pairingOrderInfo._index);

         if (result) break;

         deviceBaseInfo._deviceIdentification._specificationId = (unsigned short) specificationId;
         deviceBaseInfo._deviceIdentification._vendorId = (unsigned short) vendorId;
         deviceBaseInfo._deviceIdentification._productId = (unsigned short) productId;
         deviceBaseInfo._deviceIdentification._version = (unsigned short) version;
         deviceBaseInfo._deviceIdentification._vendorIdSource = (unsigned short) vendorIdSource;
         deviceBaseInfo._bdAddress = bdAddress;
         deviceBaseInfo._bdName = deviceName;
         deviceBaseInfo._connectionOrderInfo._seconds = lastConnectedTimeStamp;
         deviceBaseInfo._pairingOrderInfo._seconds = lastPairedTimeStamp;

         ProtocolInfoMap protocolInfomap;
         result = getDeviceSupportedProtocols(protocolInfomap, tmpDeviceId);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("privGetDeviceBaseInfo(deviceId = %d): could not get protocols supported by device (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         ProtocolInfoMap::iterator it;
         ProtocolInfoMap::const_iterator iter;
         for(it = deviceBaseInfo._protocolInfo.begin(); it != deviceBaseInfo._protocolInfo.end(); it++)
         {
            it->second._isSupported = false;
            for(iter = protocolInfomap.begin(); iter != protocolInfomap.end(); iter++)
            {
               if(it->first == iter->first)
               {
                  it->second._isSupported = true;
                  it->second._version = iter->second._version;
                  it->second._favoriteIndex = iter->second._favoriteIndex;
                  break;
               }
            }
         }

         // Check Project is support Carplaywireless or not
         if(true == LocalSpm::getDataProvider().getBmCoreConfiguration()._carPlayWirelessSupported)
         {
            // get a list of SPP UUIDs from DeviceProtocols table for given device
            UuidList currentUuidList;
            result = getDeviceSppUuidSupport(OUT currentUuidList, IN tmpDeviceId);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("privGetDeviceBaseInfo(deviceId = %d): could not get supported SPP UUIDs from DB (error = %d)",
                     tmpDeviceId, ETG_CENUM(CcErrorInternal, result)));
            }

            if (false == currentUuidList.empty())
            {
               UuidList::const_iterator it;

               for (it = currentUuidList.begin(); it != currentUuidList.end(); it++)
               {
                  if(0 == (strcmp((const char *)IAP2BT_SPP_UUID, it->c_str())))
                  {
                     ETG_TRACE_USR1(("privGetDeviceBaseInfo(deviceId = %d): IAP2BT SPP UUID is available", tmpDeviceId));
                     deviceBaseInfo._iAPoverBTSupported = true;
                     break;
                  }
               }
            }
         }

         RemoteConnectable remoteConnectable = true;
         result = LocalSpm::getBmCoreMainController().getDeviceRemoteConnectable(remoteConnectable, tmpDeviceId);

         if (CC_ERR_INT_NO_ERROR == result)
         {
            deviceBaseInfo._remoteConnectable = remoteConnectable;
         }
         else
         {
            ETG_TRACE_ERR(("privGetDeviceBaseInfo(deviceId = %d): could not get remoteconnectable by device (error = %d)",
                  tmpDeviceId, ETG_CENUM(CcErrorInternal, result)));
         }

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("privGetDeviceBaseInfo(deviceId = %d): could not get remoteconnectable by device (error = %d)", tmpDeviceId, ETG_CENUM(CcErrorInternal, result)));
         }

         deviceBaseInfoList.push_back(deviceBaseInfo);

      } while (deviceId == 0);

      return CC_ERR_INT_NO_ERROR;
   }

   Result DbManager::privGetDeviceBaseInfo(OUT DeviceBaseInfoList& deviceBaseInfoList, IN const BdAddress& bdAddress)
   {
      ETG_TRACE_USR1(("privGetDeviceBaseInfo: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("privGetDeviceBaseInfo(bdAddress = \"%50s\"): database access is currently not allowed",
               bdAddress.c_str()));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      deviceBaseInfoList.clear();

      DeviceId deviceId(DEVICE_ID_NOT_SET);
      Result result = this->getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("privGetDeviceBaseInfo(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      return privGetDeviceBaseInfo(deviceBaseInfoList, deviceId);
   }

   bool DbManager::compareProtocolIds(const Protocol& a, const Protocol& b)
   {
      return a._protocolId < b._protocolId;
   }

   template<class T>
   bool DbManager::compareLastConnectedIndicator(const std::pair<unsigned int, T>& a, const std::pair<unsigned int, T>& b)
   {
      return a.first > b.first;
   }

   bool DbManager::compareDeviceIndicator(const std::pair<DeviceIndicator, DeviceId>& a, const std::pair<DeviceIndicator, DeviceId>& b)
   {
      DeviceIndicator temp1 = static_cast<DeviceIndicator>(a.first);
      DeviceIndicator temp2 = static_cast<DeviceIndicator>(b.first);

      if((0 == temp1._connectedIndicator) && (0 == temp2._connectedIndicator))
      {
         return temp1._pairedIndicator > temp2._pairedIndicator;
      }
      else
      {
         return temp1._connectedIndicator > temp2._connectedIndicator;
      }
   }

   Result DbManager::setDeviceConnectionStatus(IN DeviceId deviceId, IN const ConnectionStatus connectionStatus, IN const DisconnectedReason disconnectedReason, IN const bool ignoreDisconnectedReason)
   {
      ENTRY

      ETG_TRACE_USR1(("setDeviceConnectionStatus: deviceId = %d, connectionStatus = %d, disconnectedReason = %d, ignoreDisconnectedReason = %d", deviceId, ETG_CENUM(ConnectionStatus, connectionStatus), ETG_CENUM(DisconnectedReason, disconnectedReason), ignoreDisconnectedReason));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setDeviceConnectionStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      ConnectionStatus oldConnectionStatus;
      DisconnectedReason oldDisconnectedReason;

      result = getDeviceConnectionStatus(oldConnectionStatus, oldDisconnectedReason, deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceConnectionStatus(deviceId = %d): could not get device connection status from DB (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceConnectionStatus(deviceId = %d): Update failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      unsigned long long int lastConnectedTimeStamp(0u);
      unsigned int lastConnectedIndicator(0u);

      /* set the (new) connectionStatus */
      if(((BM_CONNECTION_STATUS_CONNECTED != oldConnectionStatus) && (BM_CONNECTION_STATUS_CONNECTED == connectionStatus))
            || (((BM_CONNECTION_STATUS_CONNECTED == oldConnectionStatus) || (BM_CONNECTION_STATUS_DISCONNECTING == oldConnectionStatus))
                  && (BM_CONNECTION_STATUS_DISCONNECTED == connectionStatus)))
      {
         //store current time in lastConnectedTimeStamp
         struct timespec lastConnectedTS;
         clock_gettime(CLOCK_REALTIME , &lastConnectedTS);
         lastConnectedTimeStamp = lastConnectedTS.tv_sec;

         //get the MAX(LastConnectedIndicator) in Devices Table and store MAX(lastConnectedIndicator)+1
         result = getMaxLastConnectedIndicator(lastConnectedIndicator, true);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setDeviceConnectionStatus(deviceId = %d): could not get last connected indicator maximum from DB (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         lastConnectedIndicator++;

         if (true == ignoreDisconnectedReason)
         {
            result = query.Change("------------------------------ii--ilii--------------------ii",
                  IN 0, IN connectionStatus,
                  IN 0, IN lastConnectedTimeStamp,
                  IN 0, IN lastConnectedIndicator,
                  IN 0, IN deviceId);
         }
         else
         {
            result = query.Change("------------------------------iiiiilii--------------------ii",
                  IN 0, IN connectionStatus,
                  IN 0, IN disconnectedReason,
                  IN 0, IN lastConnectedTimeStamp,
                  IN 0, IN lastConnectedIndicator,
                  IN 0, IN deviceId);
         }

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setDeviceConnectionStatus(deviceId = %d): Change failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }
      }
      else
      {
         if (true == ignoreDisconnectedReason)
         {
            result = query.Change("------------------------------ii--------------------------ii",
                  IN 0, IN connectionStatus,
                  IN 0, IN deviceId);
         }
         else
         {
            result = query.Change("------------------------------iiii------------------------ii",
                  IN 0, IN connectionStatus,
                  IN 0, IN disconnectedReason,
                  IN 0, IN deviceId);
         }

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setDeviceConnectionStatus(deviceId = %d): Change failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         //for Connecting or Disconnecting read the current values to update the properties
         ConnectionOrderInfo orderInfo;

         result = getDeviceLastConnectedInfo(orderInfo, deviceId);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setDeviceConnectionStatus(deviceId = %d): could not get device's last connected info (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         lastConnectedIndicator = orderInfo._index;
         lastConnectedTimeStamp = orderInfo._seconds;
      }

      DeviceId deviceHandle;
      result = getDeviceHandle(deviceHandle, deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceConnectionStatus(deviceId = %d): could not get device handle (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }


      //Update Properties
      DeviceBaseInfo devBaseInfo;
      devBaseInfo._deviceHandle = deviceHandle;
      devBaseInfo._connectionStatus = connectionStatus;
      devBaseInfo._connectionOrderInfo._index = lastConnectedIndicator;
      devBaseInfo._connectionOrderInfo._seconds = lastConnectedTimeStamp;

      DeviceConnectionInfo devConnInfo;
      devConnInfo._deviceHandle = deviceHandle;
      devConnInfo._connectionStatus = connectionStatus;
      devConnInfo._connectionOrderInfo._index = lastConnectedIndicator;
      devConnInfo._connectionOrderInfo._seconds = lastConnectedTimeStamp;

      if (true == ignoreDisconnectedReason)
      {
         result = getDeviceDisconnectedReason(devBaseInfo._disconnectedReason, deviceId);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setDeviceConnectionStatus(deviceId = %d): could not get device's disconnected reason (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         devConnInfo._disconnectedReason = devBaseInfo._disconnectedReason;
      }
      else
      {
         devBaseInfo._disconnectedReason = disconnectedReason;
         devConnInfo._disconnectedReason = disconnectedReason;
      }

      result = getProtocolConnectionInfos(devConnInfo._protocolConnectionInfo, devConnInfo._sppConnectionInfo, deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceConnectionStatus(deviceId = %d): could not get protocol connection info (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      LocalSpm::getBmCoreMainController().onDeviceConnectionStatusChanged(devConnInfo);

      return result;
   }

   Result DbManager::getProtocolBlockStatusTemplateMap(OUT ProtocolBlockStatusMap& protocolBlockStatusMap, IN const BdAddress& bdAddress, IN BdName bdName)
   {
      ENTRY

      ETG_TRACE_USR1(("getProtocolBlockStatusTemplateMap"));

      Result result(CC_ERR_INT_NO_ERROR);

      BtLimitationMode btLimitationMode;
      BmResult bmResult = LocalSpm::getBmCoreMainController().getBtLimitationMode(btLimitationMode);

      if (BM_RESULT_OK == bmResult)
      {
         if (false == btLimitationMode._btLimitationModeInfoList.empty())
         {
            BtLimitationDeviceType btLimitationDeviceTypeSelector(btLimitationMode._btLimitationModeInfoList[0]._limitationMode, false);

            if ((bdAddress == btLimitationMode._btLimitationModeInfoList[0]._bdAddress)
                  || (bdName == btLimitationMode._btLimitationModeInfoList[0]._bdName))
            {
               ETG_TRACE_USR2(("getProtocolBlockStatusTemplateMap(bdAddress = \"%50s\"): BT limitation mode is set for the given device",
                     bdAddress.c_str()));
               btLimitationDeviceTypeSelector._limitedDevice = true;
            }
            else
            {
               ETG_TRACE_USR2(("getProtocolBlockStatusTemplateMap(bdAddress = \"%50s\"): BT limitation mode is set for a device different from the given one",
                     bdAddress.c_str()));
            }

            BtLimitationDeviceTypeProtocolBlockStatusMap::iterator it = _newDeviceProtocolBlockStatusTemplate.find(btLimitationDeviceTypeSelector);

            if (_newDeviceProtocolBlockStatusTemplate.end() != it)
            {
               protocolBlockStatusMap = it->second;
            }
            else
            {
               ETG_TRACE_ERR(("getProtocolBlockStatusTemplateMap(bdAddress = \"%50s\"): could not find a protocol block status map template",
                     bdAddress.c_str()));

               protocolBlockStatusMap = _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_UNKNOWN, BM_LIMITATION_COMMUNICATION_IF_USB), false)];
            }
         }
         else
         {
            ETG_TRACE_USR2(("getProtocolBlockStatusTemplateMap(bdAddress = \"%50s\"): currently no BT limitation mode is set",
                  bdAddress.c_str()));

            protocolBlockStatusMap = _newDeviceProtocolBlockStatusTemplate[BtLimitationDeviceType(LimitationMode(BM_LIMITATION_FEATURE_UNKNOWN, BM_LIMITATION_COMMUNICATION_IF_USB), false)];
         }
      }
      else
      {
         result = CC_ERR_INT_NOT_ALLOWED;
         ETG_TRACE_ERR(("getProtocolBlockStatusTemplateMap(bdAddress = \"%50s\"): could not get BT limitation mode from BM Core property handler (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::destroyProtocolConnectionController()
   {
      ENTRY

      ETG_TRACE_USR1(("destroy_protocolconnectionsmhandlemapp: destroying PCC instances"));
      ProtocolConnectionControllerInfoList::iterator it;

      for (it = _protocollist.begin(); it != _protocollist.end(); ++it)
      {
         delete it->_protocolconnectionsmhandle;
         it->_protocolconnectionsmhandle=0;
      }

      _protocollist.clear();

      return CC_ERR_INT_NO_ERROR;
   }

   void DbManager::resetProtocolConnectionController(void)
   {
      ETG_TRACE_USR1(("resetProtocolConnectionController: resetting PCC instances"));

      for (ProtocolConnectionControllerInfoList::iterator it = _protocollist.begin(); it != _protocollist.end(); ++it)
      {
         // keep it->_protocolconnectionsmhandle
         // keep it->_id
         it->_uuid.clear();
         it->_sminusebydeviceid = 0;
         // keep it->_name
      }
   }

   Result DbManager::insertProtocolList(IN const ProtocolId protocolId,IN const ProtocolName protocolName,IN const Uuid UUID,IN ProtocolConnectionController* ProtocolConnectionSMHandle,IN const int SMInUseByDeviceID)
      {
         ENTRY
         ETG_TRACE_USR1(("insertProtocolList: protocolId = %d, pccInstance = 0x%p , deviceid= %d", ETG_CENUM(ProtocolId, protocolId),  (void*) ProtocolConnectionSMHandle,SMInUseByDeviceID));

         ProtocolConnectionControllerInfo _protocols;
         _protocols._id=protocolId;
         _protocols._name =protocolName;
         _protocols._uuid =UUID;
         _protocols._protocolconnectionsmhandle=ProtocolConnectionSMHandle;
         _protocols._sminusebydeviceid=SMInUseByDeviceID;
         _protocollist.push_back(_protocols);

         return CC_ERR_INT_NO_ERROR;
      }

   ProtocolConnectionController* DbManager::getNewProtocolConnectionController(IN const ProtocolId protocolId)
   {
      ProtocolConnectionController* pccInstance = new ProtocolConnectionController(protocolId);
      return pccInstance;

   }

   Result DbManager::SetPrimaryHfpDevice(IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("SetPrimaryHfpDevice"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("SetPrimaryHfpDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      DeviceId primaryHFPdevice = 0;
      result = getPrimaryHfpDevice(primaryHFPdevice);
      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getPrimaryHfpDevice: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      if(primaryHFPdevice == deviceId)
      {
         ETG_TRACE_ERR(("SetPrimaryHfpDevice : Primary status is already updated"));
         return result;
      }

      result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("SetPrimaryHfpDevice: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceIdList deviceIds;
      deviceIds.clear();
      DeviceId DeviceID;
      ConnectionStatus Connectionstatus;

      while(1)
      {
         result = query.Get(IN "i--i----------", OUT &DeviceID,OUT &Connectionstatus);

         if (result) break;

         if (Connectionstatus == BM_CONNECTION_STATUS_CONNECTED)
         {
            deviceIds.push_back(DeviceID);
         }
         else
         {
            //do nothing
         }
      }
      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR((" Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }
      //check if the given device id is in the list
      if(std::find(deviceIds.begin(), deviceIds.end(), deviceId) != deviceIds.end())
      {
         DeviceIdList::iterator it;

         result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);
         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("SetPrimaryHfpDevice(deviceId = %d): Update failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         for (it = deviceIds.begin(); it != deviceIds.end(); ++it)
         {
            if(deviceId == *it)
            {
               result = query.Change("------------------------ii--iiii--",
                     IN 0, IN 1,
                     IN 0, IN deviceId,
                     IN 0,IN BM_PROTOCOL_ID_HFP);
               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("SetPrimaryHfpDevice: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
                  return result;
               }
               else
               {
                  setMasterHFPDevice(deviceId);
               }
            }
            else
            {
               result = query.Change("------------------------ii--iiii--",
                     IN 0, IN 0,
                     IN 0, IN *it,
                     IN 0,IN BM_PROTOCOL_ID_HFP);
               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("SetPrimaryHfpDevice: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
                  return result;
               }
            }
         }

         deviceIds.clear();
      }
      else
      {
         //Throw an error :the given deviceID is not HFP connected device
         ETG_TRACE_USR1(("SetPrimaryHfpDevice :the given deviceID is not HFP connected device"));
         result = CC_ERR_INT_GENERAL_ERROR;
      }

      return result;
   }

   Result DbManager::getSecondaryHfpDevice(OUT DeviceId& deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getSecondaryHfpDevice"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getSecondaryHfpDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getSecondaryHfpDevice: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceIdList deviceIds;
      DeviceId DeviceID, primaryDeviceId = 0;
      ConnectionStatus Connectionstatus;
      int primaryStatus;

      while(1)
      {
         result = query.Get(IN "i--i--------i-", OUT &DeviceID,OUT &Connectionstatus, OUT &primaryStatus);

         if (result) break;

         if ((Connectionstatus == BM_CONNECTION_STATUS_CONNECTED) || (Connectionstatus == BM_CONNECTION_STATUS_CONNECTING))
         {
            deviceIds.push_back(DeviceID);

            if(primaryStatus == 1)
            {
               primaryDeviceId = DeviceID;
            }
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getSecondaryHfpDevice: Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }

      //primaryDevice is available
      if(primaryDeviceId != 0)
      {
         for (DeviceIdList::iterator it = deviceIds.begin(); it != deviceIds.end(); ++it)
         {
            //find the non-primary device
            if((*it) != primaryDeviceId)
            {
               deviceId = *it;
               ETG_TRACE_USR1(("getSecondaryHfpDevice: deviceId - %d", deviceId));
               break;
            }
         }
      }
      //at least two devices are HFP connected/connecting
      else if(deviceIds.size() != 1)
      {
         bool available = false;
         DeviceId usedDeviceId = 0;
         result = isUsedProtocolConnectionControllerAvailable(available, usedDeviceId, BM_PROTOCOL_ID_HFP);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getSecondaryHfpDevice: isUsedProtocolConnectionControllerAvailable failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
         }
         else
         {
            if(available == true)
            {
               for (DeviceIdList::iterator it = deviceIds.begin(); it != deviceIds.end(); ++it)
               {
                  if(usedDeviceId != (*it))
                  {
                     deviceId = *it;
                     ETG_TRACE_USR1(("getSecondaryHfpDevice: deviceId - %d", deviceId));
                     break;
                  }
               }
            }
         }
      }

      deviceIds.clear();

      return result;
   }

   Result DbManager::getPrimaryHfpDevice(OUT DeviceId& deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getPrimaryHfpDevice"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getPrimaryHfpDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getPrimaryHfpDevice: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceId DeviceID;
      int primaryStatus;

      while(1)
      {
         result = query.Get(IN "i-----------i-", OUT &DeviceID,OUT &primaryStatus);

         if (result) break;

         if (primaryStatus == 1)
         {
            deviceId = DeviceID;
            ETG_TRACE_USR1(("getPrimaryHfpDevice: deviceId - %d", deviceId));
            return result;
         }
         else
         {
            //do nothing
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR((" Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getPrimaryStatus(IN const DeviceId deviceHandle, OUT unsigned int &primaryStatus)
   {
      ENTRY

      ETG_TRACE_USR1(("getPrimaryStatus"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getPrimaryStatus: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      DeviceId deviceId;
      result = getDeviceId(deviceId, deviceHandle);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getPrimaryStatus: getting deviceHandle failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getPrimaryStatus: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceId DeviceID;
      int PrimaryStatus;

      while(1)
      {
         result = query.Get(IN "i-----------i-", OUT &DeviceID,OUT &PrimaryStatus);

         if (result) break;

         if (DeviceID == deviceId)
         {
            primaryStatus = (unsigned int)PrimaryStatus;
            ETG_TRACE_USR1(("getPrimaryStatus: primaryStatus - %d", primaryStatus));
            return result;
         }
         else
         {
            primaryStatus = 0;
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
         primaryStatus = 0;
      }
      else
      {
         ETG_TRACE_ERR(("getPrimaryStatus: Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::SetPrimaryDevice(IN const DeviceId deviceId,IN const ConnectionStatus connectionStatus)
   {
      ENTRY

      ETG_TRACE_USR1(("SetPrimaryDevice"));
      Result result(CC_ERR_INT_NO_ERROR);

      Query query;
      Query query1;
      result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setPrimaryDevice: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceIdList deviceIds;
      deviceIds.clear();
      DeviceId DeviceID;
      ConnectionStatus Connectionstatus;
      int PrimaryStatus;
      //this loop to get the list of connected HFP device and set the primary device accordingly
      while(1)
      {
         result = query.Get(IN "i--i----------", OUT &DeviceID,OUT &Connectionstatus);

         if (result) break;

         if (Connectionstatus == BM_CONNECTION_STATUS_CONNECTED)
         {
            deviceIds.push_back(DeviceID);
         }
         else
         {
            //do nothing
         }
      }
      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR((" setPrimaryDevice:Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }

      if(deviceIds.size() != 1)
      {
         //at least two devices are HFP connected,do nothing
      }

      if(deviceIds.size() == 1 )
      {
         result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setPrimaryDevice: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         result = query.Change("------------------------ii--iiii--",
               IN 0, IN 1,
               IN 0, IN deviceIds.front(),
               IN 0,IN BM_PROTOCOL_ID_HFP
         );

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setPrimaryDevice: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }
         else
         {
            // Update the Master HFP Device for Autoconnection(connected first)
            setMasterHFPDevice(deviceIds.front());
         }
      }

      if((connectionStatus == BM_CONNECTION_STATUS_DISCONNECTED) || (connectionStatus == BM_CONNECTION_STATUS_CONNECTING))
      {
         deviceIds.clear();
         result = query1.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);
         while(1)
         {
            result = query1.Get(IN "i--i--------i-", OUT &DeviceID,OUT &Connectionstatus,OUT &PrimaryStatus);

            if (result) break;

            if (((Connectionstatus == BM_CONNECTION_STATUS_DISCONNECTED) || (connectionStatus == BM_CONNECTION_STATUS_CONNECTING)) && (PrimaryStatus == 1))
            {
               deviceIds.push_back(DeviceID);
            }
            else
            {
               //do nothing
            }
         }

         if (CC_ERR_INT_DB_END_OF_LIST == result)
         {
            result = CC_ERR_INT_NO_ERROR;
         }
         else
         {
            ETG_TRACE_ERR((" Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
         }

         if((deviceIds.size() == 1) && (deviceIds.front() == deviceId) )
         {
            result = query1.Update(LTY_DEVICEPROTOCOLS_UPDATE);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("setPrimaryDevice: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }

            result = query1.Change("------------------------ii--iiii--",
                  IN 0, IN 0,
                  IN 0, IN deviceId,
                  IN 0,IN BM_PROTOCOL_ID_HFP
            );

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("setPrimaryDevice: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
         }
      }

      return result;
   }

   Result DbManager::setMasterHFPDevice(IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("setMasterHFPDevice: DeviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setMasterHFPDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setMasterHFPDevice: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      //get all device ID where favorite index is equal to the new index
      DeviceId DeviceID = 0u;
      result = getMasterHFPDevice(DeviceID);

      if (CC_ERR_INT_NO_ERROR == result)
      {
         if((0 != DeviceID) && (DeviceID != deviceId))
         {
            result = query.Change("------------------------------------------------ii--------ii",
                  IN 0, IN 0,
                  IN 0, IN DeviceID);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("setMasterHFPDevice to null for the old device(DeviceID = %d): Change failed (error = %d)", DeviceID,
                     ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
         }

         if(DeviceID != deviceId)
         {
            result = query.Change("------------------------------------------------ii--------ii",
                  IN 0, IN 1,
                  IN 0, IN deviceId);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("setMasterHFPDevice(deviceid = %d): Change failed (error = %d)", deviceId,
                     ETG_CENUM(CcErrorInternal, result)));
            }
            else
            {
               ETG_TRACE_USR1(("setMasterHFPDevice: DeviceId is set as MasterHFPDevice - %d", deviceId));
            }
         }
         else
         {
            ETG_TRACE_USR1(("setMasterHFPDevice: DeviceId is already set as MasterHFPDevice - %d", deviceId));
         }
      }
      else
      {
         ETG_TRACE_ERR(("setMasterHFPDevice: Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getMasterHFPDevice(OUT DeviceId& deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getMasterHFPDevice"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getMasterHFPDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      /*get the device ID from the Devices table */
      result = query.Select(LTY_DEVICES, IN 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getMasterHFPDevice: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceId DeviceID;
      int primaryStatus;

      while(1)
      {
         result = query.Get(IN "i------------------------i", OUT &DeviceID, OUT &primaryStatus);

         if (result) break;

         if (primaryStatus == 1)
         {
            deviceId = DeviceID;
            ETG_TRACE_USR1(("getMasterHFPDevice: deviceId - %d", deviceId));
            return result;
         }
         else
         {
            //do nothing
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR((" Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::setCPWDevice(IN const DeviceId deviceId, IN const bool reset)
   {
      ENTRY

      ETG_TRACE_USR1(("setCPWDevice: DeviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setCPWDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setCPWDevice: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      //get all device ID where favorite index is equal to the new index
      DeviceId DeviceID = 0u;
      result = getCPWDevice(DeviceID);

      if (CC_ERR_INT_NO_ERROR == result)
      {
         if(false == reset)
         {
            if((0 != DeviceID) && (DeviceID != deviceId))
            {
               result = query.Change("--------------------------------------------------ii------ii",
                     IN 0, IN 0,
                     IN 0, IN DeviceID);

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("setCPWDevice to null for the old device(DeviceID = %d): Change failed (error = %d)", DeviceID,
                        ETG_CENUM(CcErrorInternal, result)));
                  return result;
               }
            }

            if(DeviceID != deviceId)
            {
               result = query.Change("--------------------------------------------------ii------ii",
                     IN 0, IN 1,
                     IN 0, IN deviceId);

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("setCPWDevice(deviceid = %d): Change failed (error = %d)", deviceId,
                        ETG_CENUM(CcErrorInternal, result)));
               }
               else
               {
                  ETG_TRACE_USR1(("setCPWDevice: DeviceId is set as CPWDevice - %d", deviceId));
               }
            }
            else
            {
               ETG_TRACE_USR1(("setCPWDevice: DeviceId is already set as CPWDevice - %d", deviceId));
            }
         }
         else
         {
            if(DeviceID == deviceId)
            {
               result = query.Change("--------------------------------------------------ii------ii",
                     IN 0, IN 0,
                     IN 0, IN deviceId);

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("setCPWDevice(deviceid = %d): Change failed (error = %d)", deviceId,
                        ETG_CENUM(CcErrorInternal, result)));
               }
               else
               {
                  ETG_TRACE_USR1(("setCPWDevice: DeviceId reset succuessfully - %d", deviceId));
               }
            }
            else
            {
               ETG_TRACE_USR1(("setCPWDevice: DeviceId is already reset - %d", deviceId));
            }
         }
      }
      else
      {
         ETG_TRACE_ERR(("setCPWDevice: Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getCPWDevice(OUT DeviceId& deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getCPWDevice"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getCPWDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      /*get the device ID from the Devices table */
      result = query.Select(LTY_DEVICES, IN 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getCPWDevice: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceId DeviceID;
      int CPWStatus;

      while(1)
      {
         result = query.Get(IN "i-------------------------i", OUT &DeviceID, OUT &CPWStatus);

         if (result) break;

         if (CPWStatus == 1)
         {
            deviceId = DeviceID;
            ETG_TRACE_USR1(("getCPWDevice: deviceId - %d", deviceId));
            return result;
         }
         else
         {
            //do nothing
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR((" Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::setLastConnectedPANDevice(IN const DeviceId deviceId, IN const bool reset)
   {
      ENTRY

      ETG_TRACE_USR1(("setLastConnectedPANDevice: DeviceId = %d and reset - %d", deviceId, reset));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setLastConnectedPANDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Update(LTY_DEVICES_UPDATE);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setLastConnectedPANDevice: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      //get device ID where PAN Connected flag is already set for other device
      DeviceId DeviceID = 0u;
      result = getLastConnectedPANDevice(DeviceID);

      if (CC_ERR_INT_NO_ERROR == result)
      {
         if(false == reset)
         {
            // Reset the PAN connected flag for previous connected device
            if((0 != DeviceID) && (DeviceID != deviceId))
            {
               result = query.Change("--------------------------------------------------------iiii",
                     IN 0, IN 0,
                     IN 0, IN DeviceID);

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("setLastConnectedPANDevice to null for the old device(DeviceID = %d): Change failed (error = %d)", DeviceID,
                        ETG_CENUM(CcErrorInternal, result)));
                  return result;
               }
            }

            // Set the PAN connected flag for currently connected device
            if(DeviceID != deviceId)
            {
               result = query.Change("--------------------------------------------------------iiii",
                     IN 0, IN 1,
                     IN 0, IN deviceId);

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("setLastConnectedPANDevice(deviceid = %d): Change failed (error = %d)", deviceId,
                        ETG_CENUM(CcErrorInternal, result)));
               }
               else
               {
                  ETG_TRACE_USR1(("setLastConnectedPANDevice: DeviceId is set as LastConnectedPANDevice - %d", deviceId));
               }
            }
            else
            {
               ETG_TRACE_USR1(("setLastConnectedPANDevice: DeviceId is already set as LastConnectedPANDevice - %d", deviceId));
            }
         }
         else
         {
            // Reset the PAN connected flag for the device
            if(DeviceID == deviceId)
            {
               result = query.Change("--------------------------------------------------------iiii",
                     IN 0, IN 0,
                     IN 0, IN deviceId);

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("setLastConnectedPANDevice(deviceid = %d): Change failed (error = %d)", deviceId,
                        ETG_CENUM(CcErrorInternal, result)));
               }
               else
               {
                  ETG_TRACE_USR1(("setLastConnectedPANDevice: DeviceId reset succuessfully - %d", deviceId));
               }
            }
            else
            {
               ETG_TRACE_USR1(("setLastConnectedPANDevice: DeviceId is already reset - %d", deviceId));
            }
         }
      }
      else
      {
         ETG_TRACE_ERR(("setLastConnectedPANDevice: Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getLastConnectedPANDevice(OUT DeviceId& deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getLastConnectedPANDevice"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getLastConnectedPANDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      deviceId = 0u;

      /*get the device ID from the Devices table */
      result = query.Select(LTY_DEVICES, IN 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getLastConnectedPANDevice: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      DeviceId DeviceID;
      int PANStatus;

      while(1)
      {
         result = query.Get(IN "i----------------------------i", OUT &DeviceID, OUT &PANStatus);

         if (result) break;

         // Check the device if PAN is connected or not. If it is true then update the deviceId
         if (PANStatus == 1)
         {
            deviceId = DeviceID;
            ETG_TRACE_USR1(("getLastConnectedPANDevice: deviceId - %d", deviceId));
            return result;
         }
         else
         {
            //do nothing
         }
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getLastConnectedPANDevice: Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getFavoriteIndex(OUT FavoriteIndex& favoriteIndex, IN const DeviceId deviceId, IN const FavoriteType favoriteType)
   {
      ENTRY

      ETG_TRACE_USR1(("getFavoriteIndex: DeviceId = %d ,FavoriteType= %d", deviceId,favoriteType));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getFavoriteIndex: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;


      if(favoriteType == BM_FAVORITE_TYPE_DEVICE)
      {
         /*get the device ID from the Devices table for the given deviceId*/
         result = query.Select(LTY_DEVICES, IN deviceId, "");
         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getFavoriteIndex(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }


         result = query.Get("-----------------------i", OUT &favoriteIndex);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getFavoriteIndex(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }
      }
      else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_HFP)
      {
         /*get the device ID from the Devices table for the given deviceId*/
         result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);
         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getFavoriteIndex(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }


         result = query.Get("-------------i", OUT &favoriteIndex);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getFavoriteIndex(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }
      }
      else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_AVP)
      {
         /*get the device ID from the Devices table for the given deviceId*/
         result = query.Select(LTY_DEVICEPROTOCOLS, IN deviceId, "ii", IN 0, IN BM_PROTOCOL_ID_AVP);
         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getFavoriteIndex(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }


         result = query.Get("-------------i", OUT &favoriteIndex);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getFavoriteIndex(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }


      }
      else
      {
         ETG_TRACE_ERR(("getFavoriteIndex:Invalid parameter favoriteType =%d", favoriteType));
         result =CC_ERR_INT_GENERAL_ERROR;
         return result;
      }


      return result;
   }

   Result DbManager::getFavoriteIndex(OUT FavoriteIndex &favoriteIndex, IN const BdAddress& bdAddress, IN const FavoriteType favoriteType)
   {
      ENTRY

      ETG_TRACE_USR1(("getFavoriteIndex: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getFavoriteIndex: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      DeviceId deviceId(0u);

      result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getFavoriteIndex(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      result =  getFavoriteIndex(favoriteIndex, deviceId, favoriteType);

      return result;
   }

   Result DbManager::setFavoriteIndex(IN const DeviceId deviceId, IN const FavoriteType favoriteType, IN const FavoriteIndex favoriteIndex)
   {

      ENTRY

      ETG_TRACE_USR1(("setFavoriteIndex: DeviceId = %d ,FavoriteType= %d, favoriteIndex =%d", deviceId,favoriteType,favoriteIndex));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setFavoriteIndex: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;


      if(favoriteType == BM_FAVORITE_TYPE_DEVICE)
      {

         result = query.Update(LTY_DEVICES_UPDATE);


         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setFavoriteIndex: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         result = query.Change("--------------------------------------------ii------------ii",
               IN 0, IN favoriteIndex,
               IN 0, IN deviceId);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setFavoriteIndex(deviceid = %d): Change failed (error = %d)", deviceId,
                  ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

      }
      else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_HFP)
      {
         result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);


         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setFavoriteIndex: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         result = query.Change("--------------------------iiiiii",
               IN 0, IN favoriteIndex,
               IN 0, IN deviceId,
               IN 0,IN BM_PROTOCOL_ID_HFP
         );

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setFavoriteIndex: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }
      }
      else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_AVP)
      {
         result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);


         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setFavoriteIndex: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         result = query.Change("--------------------------iiiiii",
               IN 0, IN favoriteIndex,
               IN 0, IN deviceId,
               IN 0,IN BM_PROTOCOL_ID_AVP
         );

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setFavoriteIndex: Change failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }
      }
      else
      {
         ETG_TRACE_ERR(("setFavoriteIndex:Invalid parameter favoriteType =%d", favoriteType));
         result =CC_ERR_INT_GENERAL_ERROR;
         return result;
      }


      return result;

   }
   Result DbManager::getMaximumFavoriteIndex(OUT FavoriteIndex& maxFavoriteIndex, IN const FavoriteType favoriteType)
   {
      ENTRY

      ETG_TRACE_USR1(("getMaximumFavoriteIndex: "));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getMaximumFavoriteIndex: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Query query;
      Result result(CC_ERR_INT_NO_ERROR);

      if(favoriteType == BM_FAVORITE_TYPE_DEVICE)
      {
         result = query.Select(LTY_DEVICES_SELECT_MAX_FAVORITE, 0, "");

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getMaximumFavoriteIndex: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }


         result = query.Get("i", OUT &maxFavoriteIndex);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getMaximumFavoriteIndex : Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }
      }
      else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_HFP)
      {
         result = query.Select(LTY_DEVICEPROTOCOLS_SELECT_MAX_FAVORITE, IN BM_PROTOCOL_ID_HFP,"");

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getMaximumFavoriteIndex: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }


         result = query.Get("i", OUT &maxFavoriteIndex);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getMaximumFavoriteIndex : Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }
      }
      else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_AVP)
      {

         result = query.Select(LTY_DEVICEPROTOCOLS_SELECT_MAX_FAVORITE,IN BM_PROTOCOL_ID_AVP,"");

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getMaximumFavoriteIndex: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }


         result = query.Get("i", OUT &maxFavoriteIndex);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getMaximumFavoriteIndex : Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }


      }
      else
      {
         ETG_TRACE_ERR(("getMaximumFavoriteIndex:Invalid parameter favoriteType =%d", favoriteType));
         result =CC_ERR_INT_GENERAL_ERROR;
         return result;
      }


      return result;
   }

   Result DbManager::getDevicesSortedByFavorite(OUT DeviceIdList& favoriteDeviceIds, IN const FavoriteType favoriteType)
   {
      ENTRY

      ETG_TRACE_USR1(("getDevicesSortedByFavorite: favoriteType - %d", ETG_CENUM(FavoriteType, favoriteType)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDevicesSortedByFavorite: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      favoriteDeviceIds.clear();

      if(favoriteType == BM_FAVORITE_TYPE_DEVICE)
      {
         result = query.Select(LTY_DEVICES, IN 0, "");

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getDevicesSortedByFavorite: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         std::pair<unsigned int, DeviceId> devInfo;
         std::vector<std::pair<unsigned int, DeviceId> > devInfoList;

         while (1)
         {
            result = query.Get(IN "i----------------------i", OUT &devInfo.second, OUT &devInfo.first);
            if (result) break;

            devInfoList.push_back(devInfo);
         }

         if (CC_ERR_INT_DB_END_OF_LIST == result)
         {
            result = CC_ERR_INT_NO_ERROR;
         }
         else
         {
            ETG_TRACE_ERR(("getDevicesSortedByFavorite: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

            return result;
         }

         std::sort(devInfoList.begin(), devInfoList.end(), compareLastConnectedIndicator<DeviceId>);

         for (size_t i = 0u; i < devInfoList.size(); i++)
         {
            if(devInfoList[i].first != 0)
            {
               favoriteDeviceIds.push_back(devInfoList[i].second);
            }
         }
      }
      else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_HFP)
      {
         result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getDevicesSortedByFavorite: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         std::pair<unsigned int, DeviceId> devInfo;
         std::vector<std::pair<unsigned int, DeviceId> > devInfoList;

         while (1)
         {
            result = query.Get(IN "i------------i", OUT &devInfo.second, OUT &devInfo.first);
            if (result) break;

            devInfoList.push_back(devInfo);
         }

         if (CC_ERR_INT_DB_END_OF_LIST == result)
         {
            result = CC_ERR_INT_NO_ERROR;
         }
         else
         {
            ETG_TRACE_ERR(("getDevicesSortedByFavorite: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

            return result;
         }

         std::sort(devInfoList.begin(), devInfoList.end(), compareLastConnectedIndicator<DeviceId>);

         for (size_t i = 0u; i < devInfoList.size(); i++)
         {
            if(devInfoList[i].first != 0)
            {
               favoriteDeviceIds.push_back(devInfoList[i].second);
            }
         }
      }
      else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_AVP)
      {
         result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_AVP);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("getDevicesSortedByFavorite: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         std::pair<unsigned int, DeviceId> devInfo;
         std::vector<std::pair<unsigned int, DeviceId> > devInfoList;

         while (1)
         {
            result = query.Get(IN "i------------i", OUT &devInfo.second, OUT &devInfo.first);
            if (result) break;

            devInfoList.push_back(devInfo);
         }

         if (CC_ERR_INT_DB_END_OF_LIST == result)
         {
            result = CC_ERR_INT_NO_ERROR;
         }
         else
         {
            ETG_TRACE_ERR(("getDevicesSortedByFavorite: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

            return result;
         }

         std::sort(devInfoList.begin(), devInfoList.end(), compareLastConnectedIndicator<DeviceId>);

         for (size_t i = 0u; i < devInfoList.size(); i++)
         {
            if(devInfoList[i].first != 0)
            {
               favoriteDeviceIds.push_back(devInfoList[i].second);
            }
         }
      }
      else
      {
         ETG_TRACE_ERR(("getDevicesSortedByFavorite:Invalid parameter favoriteType =%d", favoriteType));
         result =CC_ERR_INT_GENERAL_ERROR;
         return result;
      }
      VARTRACE(favoriteDeviceIds);

      return result;
   }

   Result DbManager::InsertFavoriteindex(IN const DeviceId deviceId, IN const FavoriteType favoriteType, IN  FavoriteIndex newfavoriteIndex)
   {
      ENTRY

      ETG_TRACE_USR1(("InsertFavoriteindex"));
      FavoriteIndex OldfavoriteIndex, maxFavoriteIndex, ChangedfavoriteIndex;

      Result result(CC_ERR_INT_NO_ERROR);
      Query query,queryUpdate;

      //Get old index for the given deviceID
      result = getFavoriteIndex(OldfavoriteIndex,deviceId, favoriteType);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("InsertFavoriteindex : failed to get old favorite index (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      if(newfavoriteIndex == OldfavoriteIndex)
      {
         //do  nothing
         ETG_TRACE_ERR(("InsertFavoriteindex : Old Favorite index and new favorite index are the same "));
      }
      else if (0 == OldfavoriteIndex)
      {
         //get max favorite index
         result = getMaximumFavoriteIndex(maxFavoriteIndex,favoriteType);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("InsertFavoriteindex : failed to get max favorite index (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         if (maxFavoriteIndex++ < newfavoriteIndex)
         {
            newfavoriteIndex = maxFavoriteIndex;
         }
         if (false == this->isDatabaseAccessSwitchedOn())
         {
            ETG_TRACE_ERR(("InsertFavoriteindex: database access is currently not allowed"));

            return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
         }

         if(favoriteType == BM_FAVORITE_TYPE_DEVICE)
         {
            result = query.Select(LTY_DEVICES, IN 0, "");
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get(IN "i----------------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if(newfavoriteIndex <= it->first)
               {
                  ChangedfavoriteIndex = it->first + 1;
                  setFavoriteIndex(it->second,favoriteType,ChangedfavoriteIndex);
               }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }
         else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_HFP)
         {
            result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get("i------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if(newfavoriteIndex <= it->first)
               {
                  ChangedfavoriteIndex = it->first + 1;
                  setFavoriteIndex(it->second,favoriteType, ChangedfavoriteIndex);
               }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }

         else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_AVP)
         {
            result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_AVP);
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get("i------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if(newfavoriteIndex <= it->first)
               {
                  ChangedfavoriteIndex = it->first + 1;
                  setFavoriteIndex(it->second,favoriteType, ChangedfavoriteIndex);
               }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }
         else
         {
            ETG_TRACE_ERR(("InsertFavoriteindex:Invalid parameter favoriteType =%d", favoriteType));
            result =CC_ERR_INT_GENERAL_ERROR;
            return result;
         }

      }
      else if (0 == newfavoriteIndex)
      {
         if(favoriteType == BM_FAVORITE_TYPE_DEVICE)
         {

            result = query.Select(LTY_DEVICES, IN 0, "");
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get(IN "i----------------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if(OldfavoriteIndex < it->first)
               {
                  //decrement all indices with oldIdx < idx by 1
                  ChangedfavoriteIndex = (it->first) - 1 ;
                  setFavoriteIndex(it->second,favoriteType,ChangedfavoriteIndex);
               }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }
         else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_HFP)
         {

            result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get("i------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if(OldfavoriteIndex < it->first)
            {
               //decrement all indices with oldIdx < idx by 1
               ChangedfavoriteIndex = (it->first) - 1 ;
               setFavoriteIndex(it->second,favoriteType, ChangedfavoriteIndex);
            }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }

         else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_AVP)
         {

            result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_AVP);
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get("i------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if(OldfavoriteIndex < it->first)
               {
                  //decrement all indices with oldIdx < idx by 1
                  ChangedfavoriteIndex = (it->first) - 1 ;
                  setFavoriteIndex(it->second,favoriteType,ChangedfavoriteIndex);
               }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }
         else
         {
            ETG_TRACE_ERR(("InsertFavoriteindex:Invalid parameter favoriteType =%d", favoriteType));
            result =CC_ERR_INT_GENERAL_ERROR;
            return result;
         }
      }
      else if(newfavoriteIndex<OldfavoriteIndex)
      {
         if(favoriteType == BM_FAVORITE_TYPE_DEVICE)
         {
            result = query.Select(LTY_DEVICES, IN 0, "");
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get(IN "i----------------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if((newfavoriteIndex <= it->first)&& ( it->first < OldfavoriteIndex))
               {
                  ChangedfavoriteIndex = it->first + 1;
                  setFavoriteIndex(it->second,favoriteType, ChangedfavoriteIndex);
               }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }
         else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_HFP)
         {
            result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get("i------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if((newfavoriteIndex <= it->first)&&(it->first < OldfavoriteIndex))
            {
               ChangedfavoriteIndex = it->first + 1;
               setFavoriteIndex(it->second,favoriteType, ChangedfavoriteIndex);
            }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }

         else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_AVP)
         {
            result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_AVP);
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get("i------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if((newfavoriteIndex <= it->first)&&(it->first < OldfavoriteIndex))
               {
                  ChangedfavoriteIndex = it->first + 1;
                  setFavoriteIndex(it->second,favoriteType, ChangedfavoriteIndex);
               }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }
         else
         {
            ETG_TRACE_ERR(("InsertFavoriteindex:Invalid parameter favoriteType =%d", favoriteType));
            result =CC_ERR_INT_GENERAL_ERROR;
            return result;
         }
      }
      else
      {
         result = getMaximumFavoriteIndex(maxFavoriteIndex,favoriteType);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("InsertFavoriteindex : failed to get max favorite index (error = %d)", ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         if (maxFavoriteIndex < newfavoriteIndex)
         {
            newfavoriteIndex = maxFavoriteIndex;

         }

         if(favoriteType == BM_FAVORITE_TYPE_DEVICE)
         {
            result = query.Select(LTY_DEVICES, IN 0, "");
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get(IN "i----------------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if((it->first <= newfavoriteIndex )&&(it->first > OldfavoriteIndex))
               {
                  ChangedfavoriteIndex = it->first - 1;
                  setFavoriteIndex(it->second,favoriteType, ChangedfavoriteIndex);
               }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }
         else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_HFP)
         {

            result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_HFP);
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get("i------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if((it->first <= newfavoriteIndex )&&(it->first > OldfavoriteIndex))
            {
                  ChangedfavoriteIndex = it->first - 1;
               setFavoriteIndex(it->second,favoriteType, ChangedfavoriteIndex);
            }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }

         else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_AVP)
         {

            result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii", IN 0, IN BM_PROTOCOL_ID_AVP);
            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Select failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            std::pair<unsigned int, DeviceId> devInfo;
            std::vector<std::pair<unsigned int, DeviceId> > devInfoList;
            typedef std::vector<std::pair<unsigned int, DeviceId> > deviceInfos;
            while (1)
            {
               result = query.Get("i------------i", OUT &devInfo.second, OUT &devInfo.first);
               if (result) break;

               devInfoList.push_back(devInfo);
            }

            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR(("InsertFavoriteindex: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

               return result;
            }
            for (deviceInfos::iterator it = devInfoList.begin();it !=devInfoList.end();it++)
            {
               if((it->first <= newfavoriteIndex )&&(it->first > OldfavoriteIndex))
               {
                  ChangedfavoriteIndex = it->first - 1;
                  setFavoriteIndex(it->second,favoriteType, ChangedfavoriteIndex);
               }
            }
            setFavoriteIndex(deviceId,favoriteType, newfavoriteIndex);
         }
         else
         {
            ETG_TRACE_ERR(("InsertFavoriteindex:Invalid parameter favoriteType =%d", favoriteType));
            result =CC_ERR_INT_GENERAL_ERROR;
            return result;
         }
      }
      return result;
   }
   Result DbManager::SetDeviceFavorite(IN const DeviceId deviceId,IN const FavoriteType favoriteType,IN const FavoriteIndex favoriteIndex)
   {
      ENTRY

      ETG_TRACE_USR1(("SetDeviceFavorite: DeviceId = %d ,FavoriteType= %d, favoriteIndex =%d", deviceId,favoriteType,favoriteIndex));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("SetDeviceFavorite: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;
      DeviceIdList deviceIds;
      deviceIds.clear();
      DeviceId DeviceID ;
      DeviceIdList::iterator it;
      FavoriteIndex OldfavoriteIndex;

      //Get old index for the given deviceID
      result = getFavoriteIndex(OldfavoriteIndex,deviceId, favoriteType);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("SetDeviceFavorite : failed to get old favorite index (error = %d)", ETG_CENUM(CcErrorInternal, result)));

      }

      if(favoriteIndex == OldfavoriteIndex)
      {
         //do  nothing
         ETG_TRACE_ERR(("SetDeviceFavorite : Old Favorite index and new favorite index are the same do nothhing "));
         return result;
      }
      else if(0 == favoriteIndex)
      {
         result = setFavoriteIndex(deviceId,favoriteType, favoriteIndex);
      }
      else
      {
         if(favoriteType == BM_FAVORITE_TYPE_DEVICE)
         {
            //get all device ID where favorite index is equal to the new index

            result = query.Select(LTY_DEVICES, IN 0, "----ii", IN 0, IN favoriteIndex);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("SetDeviceFavorite: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }

            while(1)
            {
               result = query.Get(IN "i", OUT &DeviceID);
               deviceIds.push_back(DeviceID);
               if (result) break;
            }
            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR((" Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
               return result;
            }

            result = query.Update(LTY_DEVICES_UPDATE);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("SetDeviceFavorite: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            for (it = deviceIds.begin(); it != deviceIds.end(); ++it)

            {
               result = query.Change("--------------------------------------------ii------------ii",
                     IN 0, IN 0,
                     IN 0, IN *it);

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("SetDeviceFavorite to null for the old favorite device(DeviceID = %d): Change failed (error = %d)", DeviceID,
                        ETG_CENUM(CcErrorInternal, result)));
                  return result;
               }
            }

            result = setFavoriteIndex(deviceId,favoriteType, favoriteIndex);
            return result;

         }
         else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_HFP)
         {
            //get all device ID where favorite index is equal to the new index

            result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii------------ii", IN 0 ,IN BM_PROTOCOL_ID_HFP,IN 0, IN favoriteIndex);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("SetDeviceFavorite: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }

            while(1)
            {
               result = query.Get(IN "i", OUT &DeviceID);
               deviceIds.push_back(DeviceID);

               if (result) break;
            }
            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR((" Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
            }

            result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("SetDeviceFavorite: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }

            for (it = deviceIds.begin(); it != deviceIds.end(); ++it)
            {
               result = query.Change("--------------------------iiiiii",
                     IN 0, IN 0,
                     IN 0, IN *it,
                     IN 0,IN BM_PROTOCOL_ID_HFP);

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("SetDeviceFavorite to null for the old favorite device(DeviceID = %d): Change failed (error = %d)", DeviceID,
                        ETG_CENUM(CcErrorInternal, result)));
                  return result;
               }
            }

            result = setFavoriteIndex(deviceId,favoriteType, favoriteIndex);
            return result;
         }
         else if(favoriteType == BM_FAVORITE_TYPE_PROTOCOL_AVP)
         {
            //get all device ID where favorite index is equal to the new index
            result = query.Select(LTY_DEVICEPROTOCOLS, IN 0, "ii------------ii",IN 0 ,IN BM_PROTOCOL_ID_AVP , IN 0, IN favoriteIndex);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("SetDeviceFavorite: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }

            while(1)
            {
               result = query.Get(IN "i", OUT &DeviceID);
               deviceIds.push_back(DeviceID);

               if (result) break;
            }
            if (CC_ERR_INT_DB_END_OF_LIST == result)
            {
               result = CC_ERR_INT_NO_ERROR;
            }
            else
            {
               ETG_TRACE_ERR((" Get failed (error = %d)",  ETG_CENUM(CcErrorInternal, result)));
            }

            result = query.Update(LTY_DEVICEPROTOCOLS_UPDATE);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("SetDeviceFavorite: Update failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            for (it = deviceIds.begin(); it != deviceIds.end(); ++it)

            {
               result = query.Change("--------------------------iiiiii",
                     IN 0, IN 0,
                     IN 0, IN *it,
                     IN 0,IN BM_PROTOCOL_ID_AVP);

               if (CC_ERR_INT_NO_ERROR != result)
               {
                  ETG_TRACE_ERR(("SetDeviceFavorite to null for the old favorite device(DeviceID = %d): Change failed (error = %d)", deviceId,
                        ETG_CENUM(CcErrorInternal, result)));
                  return result;
               }
            }

            result = setFavoriteIndex(deviceId,favoriteType, favoriteIndex);
            return result;


         }
         else
         {
            ETG_TRACE_ERR(("SetDeviceFavorite:Invalid parameter favoriteType =%d", favoriteType));
            result =CC_ERR_INT_GENERAL_ERROR;
            return result;
         }
      }

      return result;
   }

   Result DbManager::setDeviceUsagePreference(IN const DeviceId deviceId, IN const UsagePreference usagePreference)
   {
      ENTRY

      ETG_TRACE_USR1(("setDeviceUsagePreference: deviceId = %d, usagePreference = %d", deviceId, ETG_CENUM(UsagePreference, usagePreference)));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setDeviceUsagePreference: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      UsagePreference oldusagePreference = BM_UP_UNDECIDED;

      result = getDeviceUsagePreference(oldusagePreference, deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setDeviceUsagePreference(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      if(oldusagePreference != usagePreference)
      {
         result = query.Update(LTY_DEVICES_UPDATE);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setDeviceUsagePreference(deviceId = %d): Update failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         result = query.Change("----------------------------------------------ii----------ii",
               IN 0, IN usagePreference,
               IN 0, IN deviceId);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setDeviceUsagePreference(deviceId = %d): Change failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         ETG_TRACE_USR1(("setDeviceUsagePreference(deviceId = %d): Update the pairedDeviceList property", deviceId));

         LocalSpm::getBmCoreMainController().onDeviceBaseInfoChanged();
      }
      else
      {
         ETG_TRACE_USR1(("setDeviceUsagePreference: usagePreference is already set for deviceId = %d", deviceId));
      }

      return result;
   }

   Result DbManager::getDeviceUsagePreference(OUT UsagePreference& usagePreference, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceUsagePreference: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceUsagePreference: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceUsagePreference(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("------------------------i", OUT &usagePreference);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceUsagePreference(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      ETG_TRACE_USR1(("getDeviceUsagePreference: usagePreference = %d", ETG_CENUM(UsagePreference, usagePreference)));

      return result;
   }

   Result DbManager::getDeviceUsagePreference(OUT UsagePreference& usagePreference, IN const BdAddress& bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("getDeviceUsagePreference: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDeviceUsagePreference: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      DeviceId deviceId(0u);

      result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDeviceUsagePreference(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      result = getDeviceUsagePreference(usagePreference, deviceId);

      return result;
   }

   Result DbManager::setBdDeviceName(IN const DeviceId& deviceId, IN const BdName& updatedBdDeviceName)
   {
      ENTRY

      ETG_TRACE_USR1(("setBdDeviceName: DeviceID = %d, bdName = \"%50s\"", deviceId, updatedBdDeviceName.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setBdDeviceName: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      BdName currBdDeviceName = "";

      result = getBdDeviceName(currBdDeviceName, deviceId);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("setBdDeviceName(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      if(0 != currBdDeviceName.compare(updatedBdDeviceName))
      {
         result = query.Update(LTY_DEVICES_UPDATE);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setBdDeviceName(deviceId = %d): Update failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         result = query.Change("--it------------------------------------------------------ii",
                  IN 0, IN updatedBdDeviceName.c_str(),
                  IN 0, IN deviceId);

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("setBdDeviceName(deviceId = %d): Change failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
            return result;
         }

         ETG_TRACE_USR1(("setBdDeviceName(deviceId = %d): Update the pairedDeviceList property", deviceId));

         LocalSpm::getBmCoreMainController().onDeviceBaseInfoChanged();
      }
      else
      {
         ETG_TRACE_USR1(("setBdDeviceName: Bd Device Name is already same for deviceId = %d", deviceId));
      }

      return result;
   }

   Result DbManager::setBdDeviceName(IN const BdAddress& bdAddress, IN const BdName& updatedBdDeviceName)
   {
      ENTRY

      ETG_TRACE_USR1(("setBdDeviceName: BdAddress = \"%50s\", bdName = \"%50s\"", bdAddress.c_str(), updatedBdDeviceName.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("setBdDeviceName: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      DeviceId deviceId(0u);
      Result result = getDeviceId(OUT deviceId, IN bdAddress);

      if(CC_ERR_INT_NO_ERROR == result)
      {
         result = setBdDeviceName(deviceId, updatedBdDeviceName);
      }
      else
      {
         ETG_TRACE_ERR(("setBdDeviceName(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));
      }

      return result;
   }

   Result DbManager::getBdDeviceName(OUT BdName& bdDeviceName, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getBdDeviceName: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getBdDeviceName: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      DeviceNameChrArr bdDeviceNameChrArr;

      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getBdDeviceName(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("--T", OUT bdDeviceNameChrArr, IN sizeof(DeviceNameChrArr));

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getBdDeviceName(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      bdDeviceName = bdDeviceNameChrArr;

      ETG_TRACE_USR4(("getBdDeviceName: bdDeviceName = \"%50s\"", bdDeviceName.c_str()));

      return result;
   }

   Result DbManager::getBdDeviceName(OUT BdName& bdDeviceName, IN const BdAddress& bdAddress)
   {
      ENTRY

      ETG_TRACE_USR1(("getBdDeviceName: bdAddress = \"%50s\"", bdAddress.c_str()));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getBdDeviceName: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      DeviceId deviceId(0u);

      result = getDeviceId(deviceId, bdAddress);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getBdDeviceName(bdAddress = \"%50s\"): could not get device ID from DB (error = %d)",
               bdAddress.c_str(), ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      result = getBdDeviceName(bdDeviceName, deviceId);

      return result;
   }

   Result DbManager::getDevicePairingOrderInfo(OUT ConnectionOrderInfo& pairingOrderInfo, IN const DeviceId deviceId)
   {
      ENTRY

      ETG_TRACE_USR1(("getDevicePairingOrderInfo: deviceId = %d", deviceId));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getDevicePairingOrderInfo: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Select(LTY_DEVICES, IN deviceId, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDevicePairingOrderInfo(deviceId = %d): Select failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      result = query.Get("---------------------------ii", OUT &pairingOrderInfo._seconds, OUT &pairingOrderInfo._index);

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getDevicePairingOrderInfo(deviceId = %d): Get failed (error = %d)", deviceId, ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      char pairingTimestampStr[MAXNAME];
      snprintf(pairingTimestampStr, MAXNAME - 1, "%llu", pairingOrderInfo._seconds);
      ETG_TRACE_USR1(("getDevicePairingOrderInfo: _seconds = %50s _index = %u", pairingTimestampStr, pairingOrderInfo._index));

      return result;
   }

   Result DbManager::getOrderedDeviceConnectionControllers(OUT DeviceConnectionControllerList& orderedDccInstances, IN DeviceConnectionControllerList& dccInstances)
   {
      ENTRY

      ETG_TRACE_USR1(("getOrderedDeviceConnectionControllers: entered"));

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      std::vector<std::pair<DeviceIndicator, DeviceId> > devInfoList;

      orderedDccInstances.clear();

      if(0 != dccInstances.size())
      {
         for (size_t dccIndex = 0u; dccIndex < dccInstances.size(); dccIndex++)
         {
            std::pair<DeviceIndicator, DeviceId> devInfo;
            DeviceIndicator deviceIndicator;

            result = query.Select(LTY_DEVICES, IN dccInstances[dccIndex]->getDeviceId(), "");

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("getOrderedDeviceConnectionControllers: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }

            deviceIndicator._connectedIndicator = 0u;
            deviceIndicator._pairedIndicator = 0u;

            result = query.Get(IN "-------------------i--------i", OUT &deviceIndicator._connectedIndicator, OUT &deviceIndicator._pairedIndicator);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("getOrderedDeviceConnectionControllers: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            else
            {
               devInfo.first = deviceIndicator;
               devInfo.second = dccInstances[dccIndex]->getDeviceId();

               ETG_TRACE_USR1(("getOrderedDeviceConnectionControllers: connection index - %d and paired index - %d of device Id = %d",
                     deviceIndicator._connectedIndicator, deviceIndicator._pairedIndicator, devInfo.second));

               devInfoList.push_back(devInfo);
            }
         }

         std::sort(devInfoList.begin(), devInfoList.end(), compareDeviceIndicator);

         for (size_t i = 0; i < devInfoList.size(); i++)
         {
            for (size_t dccIndex = 0u; dccIndex < dccInstances.size(); dccIndex++)
            {
               if(devInfoList[i].second == dccInstances[dccIndex]->getDeviceId())
               {
                  ETG_TRACE_USR1(("getOrderedDeviceConnectionControllers: device Id = %d ordered connection index - %d",
                        devInfoList[i].second, devInfoList[i].first._connectedIndicator));

                  orderedDccInstances.push_back(dccInstances[dccIndex]);
                  break;
               }
            }
         }
      }

      ETG_TRACE_USR1(("getOrderedDeviceConnectionControllers: number of used DCC instances = %d", orderedDccInstances.size()));

      return result;
   }

   Result DbManager::getOrderedDeviceProtocolListMap(OUT DeviceProtocolListMap& orderedDeviceProtocolListMap, IN DeviceProtocolListMap& deviceProtocolListMap)
   {
      ENTRY

      ETG_TRACE_USR1(("getOrderedDeviceProtocolListMap: entered"));

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      std::vector<std::pair<DeviceIndicator, DeviceId> > devInfoList;

      orderedDeviceProtocolListMap.clear();

      if(0 != deviceProtocolListMap.size())
      {
         for (DeviceProtocolListMap::iterator it = deviceProtocolListMap.begin();
               it != deviceProtocolListMap.end(); ++it)
         {
            std::pair<DeviceIndicator, DeviceId> devInfo;
            DeviceIndicator deviceIndicator;

            result = query.Select(LTY_DEVICES, IN it->first, "");

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("getOrderedDeviceProtocolListMap: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }

            deviceIndicator._connectedIndicator = 0u;
            deviceIndicator._pairedIndicator = 0u;

            result = query.Get(IN "-------------------i--------i", OUT &deviceIndicator._connectedIndicator, OUT &deviceIndicator._pairedIndicator);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("getOrderedDeviceProtocolListMap: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
               return result;
            }
            else
            {
               devInfo.first = deviceIndicator;
               devInfo.second = it->first;

               ETG_TRACE_USR1(("getOrderedDeviceProtocolListMap: connection index - %d and paired index - %d of device Id = %d",
                     deviceIndicator._connectedIndicator, deviceIndicator._pairedIndicator, devInfo.second));

               devInfoList.push_back(devInfo);
            }
         }

         std::sort(devInfoList.begin(), devInfoList.end(), compareDeviceIndicator);

         for (size_t i = 0; i < devInfoList.size(); i++)
         {
            for (DeviceProtocolListMap::iterator it = deviceProtocolListMap.begin();
                           it != deviceProtocolListMap.end(); ++it)
            {
               if(devInfoList[i].second == it->first)
               {
                  ETG_TRACE_USR1(("orderedDeviceProtocolListMap: device Id = %d ordered connection index - %d",
                        devInfoList[i].second, devInfoList[i].first._connectedIndicator));
                  orderedDeviceProtocolListMap[it->first] = it->second;
                  break;
               }
            }
         }

         VARTRACE(orderedDeviceProtocolListMap);
      }

      return result;
   }

   Result DbManager::getOldestConnectedDevice(OUT DeviceId& deviceId, OUT ConnectionStatus &connectionStatus, OUT DisconnectedReason& disconnectedReason)
   {
      ENTRY

      ETG_TRACE_USR1(("getOldestConnectedDevice: entered"));

      if (false == this->isDatabaseAccessSwitchedOn())
      {
         ETG_TRACE_ERR(("getOldestConnectedDevice: database access is currently not allowed"));

         return CC_ERR_INT_DB_ACCESS_NOT_ALLOWED;
      }

      Result result(CC_ERR_INT_NO_ERROR);
      Query query;

      result = query.Select(LTY_DEVICES, IN 0, "");

      if (CC_ERR_INT_NO_ERROR != result)
      {
         ETG_TRACE_ERR(("getOldestConnectedDevice: Select failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));
         return result;
      }

      std::pair<DeviceIndicator, DeviceId> devInfo;
      std::vector<std::pair<DeviceIndicator, DeviceId> > devInfoList;

      while (1)
      {
         DeviceIndicator deviceIndicator;

         deviceIndicator._connectedIndicator = 0u;
         deviceIndicator._pairedIndicator = 0u;

         // read the device Id, Paired and connected Index from db and added in the list
         result = query.Get(IN "i------------------i--------i", OUT &devInfo.second, OUT &deviceIndicator._connectedIndicator, &deviceIndicator._pairedIndicator);
         if (result) break;

         devInfo.first = deviceIndicator;
         devInfoList.push_back(devInfo);
      }

      if (CC_ERR_INT_DB_END_OF_LIST == result)
      {
         result = CC_ERR_INT_NO_ERROR;
      }
      else
      {
         ETG_TRACE_ERR(("getOldestConnectedDevice: Get failed (error = %d)", ETG_CENUM(CcErrorInternal, result)));

         return result;
      }

      // sort the devices based on the last connected index. if the last connected index is same then paired index will be used.
      std::sort(devInfoList.begin(), devInfoList.end(), compareDeviceIndicator);

      size_t index = devInfoList.size();
      DeviceId tmpDeviceId = 0u;

      deviceId = 0u;

      // Get the oldest connected device if the device list is not empty
      if(index > 0)
      {
         // display the devices base on the last connected index
         DeviceIdList deviceList;

         for (size_t i = 0u; i < index; i++)
         {
            deviceList.push_back(devInfoList[i].second);
         }

         VARTRACE(deviceList);

         while(index > 0)
         {
            // get the oldest connected deviceId from the device list
            tmpDeviceId = deviceList[index - 1];

            // get the connection status for the oldest connected device
            result = getDeviceConnectionStatus(connectionStatus, disconnectedReason, tmpDeviceId);

            if ((CC_ERR_INT_NO_ERROR == result) && (BM_CONNECTION_STATUS_DISCONNECTED == connectionStatus))
            {
               deviceId = tmpDeviceId;
               break;
            }
            else
            {
               ETG_TRACE_USR4(("getOldestConnectedDevice: device - %d is not in disconnected state", tmpDeviceId));
               index--;
            }
         }

         if((CC_ERR_INT_NO_ERROR == result) && (0u == deviceId))
         {
            ETG_TRACE_USR4(("getOldestConnectedDevice: All devices are not in disconnected state so taking the least connected device"));

            index = devInfoList.size();
            deviceId = deviceList[index - 1];

            result = getDeviceConnectionStatus(connectionStatus, disconnectedReason, deviceId);
         }
      }

      ETG_TRACE_USR1(("getOldestConnectedDevice: deviceId - %d connectionStatus - %d reason - %d",
            deviceId, ETG_CENUM(ConnectionStatus, connectionStatus), ETG_CENUM(DisconnectedReason, disconnectedReason)));

      return result;
   }

   template bool DbManager::compareLastConnectedIndicator(const std::pair<unsigned int, Protocol>& a, const std::pair<unsigned int, Protocol>& b);
   template bool DbManager::compareLastConnectedIndicator(const std::pair<unsigned int, DeviceId>& a, const std::pair<unsigned int, DeviceId>& b);
}
