/*lint -save -e578 */
/* ETG definitions */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_DATAPROVIDER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DataProvider.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_DATAPROVIDER
#endif
#endif

#include "FunctionTracer.h"
#include "BmVarTrace.h"

/* others */
#include "DataProvider.h"
#include "LocalSpm.h"
#include "BmUtils.h"

#include <errno.h>
#include <string.h>
#include <vector>
#include <glib.h>
#include <iconv.h>
#include <setjmp.h>
#include <yajl/yajl_parse.h>
#include <yajl/yajl_gen.h>
#include <yajl/yajl_tree.h>
namespace bmcore
{
/*static list of all the configuration items objects*/
vector <DataProvider::ConfigItemBase*> DataProvider::configurationItems;

/*lint -save -e774 */

DataProvider::DataProvider(const ComponentId componentID) : ILocalSpm(componentID),
      _bmCoreConfiguration()
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("DataProvider: being created"));
}

DataProvider::~DataProvider()
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("~DataProvider"));
}

void DataProvider::updateConfiguration(void)
{
   ENTRY

   ETG_TRACE_USR1(("updateConfiguration"));

   const ::std::string configFile(BMCORECONFIGPATH);

   (void)readConfiguration(_bmCoreConfiguration, configFile);

   ETG_TRACE_USR1(("updateConfiguration: initial project specific BM Core configuration:"));
   this->traceBmConfiguration();

   LocalSpm::getBmCoreCallbackIfWrapper().doUpdateConfiguration(_bmCoreConfiguration);

   ETG_TRACE_USR1(("updateConfiguration: final project specific BM Core configuration:"));
   this->traceBmConfiguration();
}

Result DataProvider::getBtLocalInfo(OUT LocalInfo& btLocalInfo)
{
   Result result(CC_ERR_INT_NO_ERROR);

   btLocalInfo._moduleName = static_cast<bmcore::BtModuleName>(_bmCoreConfiguration._btModuleName);
   btLocalInfo._bdAddress = static_cast<BdAddress>(_bmCoreConfiguration._btLocalBdAddress);
   btLocalInfo._bdName = static_cast<LocalFriendlyNameType>(_bmCoreConfiguration._btLocalFriendlyName);
   getVehicleIdentification(btLocalInfo._vehicleIdentification);
   result = getProtocolInfos(btLocalInfo._protocolInfos, false);
   
   return result;
}

Result DataProvider::getProtocolInfos(OUT ProtocolInfoMap& protocolInfoMap, IN const bool includeOnlySupportedProtocols,
      IN const bool includeVersionInfo, IN const bool includeSupportedInfo)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("getProtocolInfos: includeOnlySupportedProtocols = %10s, includeVersionInfo = %10s, includeSupportedInfo = %10s",
         includeOnlySupportedProtocols ? "true" : "false", includeVersionInfo ? "true" : "false",
                                                                              includeSupportedInfo ? "true" : "false"));

   ProtocolInfo protocolInfo;
   bool isSupported = false;

   protocolInfoMap.clear();

   isSupported = (_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._maxNumInstances > 0u);
   if(!includeOnlySupportedProtocols || isSupported)
   {
      protocolInfo._name = static_cast<ProtocolName>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._name);
      if(includeVersionInfo)
      {
         protocolInfo._version = static_cast<ProtocolVersion>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._version);
      }
      if(includeSupportedInfo)
      {
         protocolInfo._isSupported = isSupported;
      }
      protocolInfoMap[BM_PROTOCOL_ID_HFP] = protocolInfo;
   }

   isSupported = (_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._maxNumInstances > 0u);
   if(!includeOnlySupportedProtocols || isSupported)
   {
      protocolInfo._name = static_cast<ProtocolName>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._name);
      if(includeVersionInfo)
      {
         protocolInfo._version = static_cast<ProtocolVersion>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._version);
      }
      if(includeSupportedInfo)
      {
         protocolInfo._isSupported = isSupported;
      }
      protocolInfoMap[BM_PROTOCOL_ID_AVP] = protocolInfo;
   }

   isSupported = (_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._maxNumInstances > 0u);
   if(!includeOnlySupportedProtocols || isSupported)
   {
      protocolInfo._name = static_cast<ProtocolName>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._name);
      if(includeVersionInfo)
      {
         protocolInfo._version = static_cast<ProtocolVersion>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._version);
      }
      if(includeSupportedInfo)
      {
         protocolInfo._isSupported = isSupported;
      }
      protocolInfoMap[BM_PROTOCOL_ID_PBDL] = protocolInfo;
   }

   isSupported = (_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._maxNumInstances> 0u);
   if(!includeOnlySupportedProtocols || isSupported)
   {
      protocolInfo._name = static_cast<ProtocolName>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._name);
      if(includeVersionInfo)
      {
         protocolInfo._version = static_cast<ProtocolVersion>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._version);
      }
      if(includeSupportedInfo)
      {
         protocolInfo._isSupported = isSupported;
      }
      protocolInfoMap[BM_PROTOCOL_ID_MSG] = protocolInfo;
   }

   isSupported = (_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._maxNumInstances > 0u);
   if(!includeOnlySupportedProtocols || isSupported)
   {
      protocolInfo._name = static_cast<ProtocolName>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._name);
      if(includeVersionInfo)
      {
         protocolInfo._version = static_cast<ProtocolVersion>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._version);
      }
      if(includeSupportedInfo)
      {
         protocolInfo._isSupported = isSupported;
      }
      protocolInfoMap[BM_PROTOCOL_ID_PAN] = protocolInfo;
   }

   isSupported = (_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._maxNumInstances > 0u);
   if(!includeOnlySupportedProtocols || isSupported)
   {
      protocolInfo._name = static_cast<ProtocolName>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._name);
      if(includeVersionInfo)
      {
         protocolInfo._version = static_cast<ProtocolVersion>(_bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._version);
      }
      if(includeSupportedInfo)
      {
         protocolInfo._isSupported = isSupported;
      }
      protocolInfoMap[BM_PROTOCOL_ID_SPP] = protocolInfo;
   }

   return CC_ERR_INT_NO_ERROR;
}

Result DataProvider::getVehicleIdentification(OUT DeviceIdentification& vehicleIdentification)
{
   ENTRY_INTERNAL

   ETG_TRACE_USR1(("getVehicleIdentification"));

  vehicleIdentification._specificationId = _bmCoreConfiguration._didSpecificationId;
  vehicleIdentification._vendorId = _bmCoreConfiguration._didVendorId;
  vehicleIdentification._vendorIdSource = _bmCoreConfiguration._didVendorIdSource;
  vehicleIdentification._productId = _bmCoreConfiguration._didProductId;
  vehicleIdentification._version = _bmCoreConfiguration._didVersion;

  return CC_ERR_INT_NO_ERROR;
}

Result DataProvider::getMaxNumProtocolInstances(OUT uint8_t& maxNumInstances, IN const ProtocolId protocolId)
{
   ENTRY

   Result result = CC_ERR_INT_NO_ERROR;

   maxNumInstances = 0u;

   if (BM_PROTOCOL_ID_HFP == protocolId)
   {
      maxNumInstances = _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._maxNumInstances;
   }
   else if (BM_PROTOCOL_ID_AVP == protocolId)
   {
      maxNumInstances = _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._maxNumInstances;
   }
   else if (BM_PROTOCOL_ID_PBDL == protocolId)
   {
      maxNumInstances = _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._maxNumInstances;
   }
   else if (BM_PROTOCOL_ID_MSG == protocolId)
   {
      maxNumInstances = _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._maxNumInstances;
   }
   else if (BM_PROTOCOL_ID_PAN == protocolId)
   {
      maxNumInstances = _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._maxNumInstances;
   }
   else if (BM_PROTOCOL_ID_SPP == protocolId)
   {
      maxNumInstances = _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._maxNumInstances;
   }
   else
   {
      ETG_TRACE_ERR(("getMaxNumProtocolInstances: unknown protocol ID"));
      result = CC_ERR_INT_GENERAL_ERROR;
   }

   return result;
}

Result DataProvider::getMasterProtocolIds(OUT ProtocolIdList& masterProtocolIds, IN const ProtocolId protocolId)
{
   ENTRY

   ETG_TRACE_USR1(("getMasterProtocolIds: protocolId = %d", ETG_CENUM(ProtocolId, protocolId)));

   Result result(CC_ERR_INT_NO_ERROR);

   masterProtocolIds.clear();

   if (true == isValidProtocolId(protocolId))
   {
      if (BM_PROTOCOL_DEPENDENCY_LEVEL_SLAVE == _bmCoreConfiguration._protocolSupportInformation[protocolId]._dependencyLevel)
      {
         if (BM_MASTER_PROTOCOLS_SELECTOR_ALL_OTHERS == _bmCoreConfiguration._protocolSupportInformation[protocolId]._masterProtocolsSelector)
         {
            ProtocolInfoMap localSupportedProtocols;
            (void) this->getProtocolInfos(localSupportedProtocols, true, false, false);

            ProtocolInfoMap::iterator it;
            for (it = localSupportedProtocols.begin(); it != localSupportedProtocols.end(); it++)
            {
               if (protocolId != it->first)
               {
                  masterProtocolIds.push_back(it->first);
               }
            }
         }
         else if (BM_MASTER_PROTOCOLS_SELECTOR_NONE == _bmCoreConfiguration._protocolSupportInformation[protocolId]._masterProtocolsSelector)
         {
            // nothing to be done here, error is set below
         }
         else
         {
            switch (_bmCoreConfiguration._protocolSupportInformation[protocolId]._masterProtocolsSelector)
            {
               case BM_MASTER_PROTOCOLS_SELECTOR_HFP:
                  masterProtocolIds.push_back(BM_PROTOCOL_ID_HFP);
                  break;
               default:
                  break;
            };

            ProtocolIdList::iterator it;
            for (it = masterProtocolIds.begin(); it != masterProtocolIds.end(); ++it)
            {
               if (protocolId == *it)
               {
                  ETG_TRACE_ERR(("getMasterProtocolIds: slave protocol cannot have itself as a master, protocol ID will be removed from master protocol ID list"));
                  break;
               }
            }

            if (masterProtocolIds.end() != it)
            {
               masterProtocolIds.erase(it);
            }
         }

         if (true == masterProtocolIds.empty())
         {
            ETG_TRACE_ERR(("getMasterProtocolIds: at least one valid master protocol has to be configured for a slave protocol"));
            result = CC_ERR_INT_GENERAL_ERROR;
         }
      }
      else
      {
         ETG_TRACE_ERR(("getMasterProtocolIds: given protocol ID is not configured as a slave protocol"));
         result = CC_ERR_INT_GENERAL_ERROR;
      }
   }
   else
   {
      ETG_TRACE_ERR(("getMasterProtocolIds: given protocol ID is not valid"));
      result = CC_ERR_INT_GENERAL_ERROR;
   }

   return result;
}

Result DataProvider::getSlaveProtocolIds(OUT ProtocolIdList& slaveProtocolIds)
{
   ENTRY

   ETG_TRACE_USR1(("getSlaveProtocolIds"));

   Result result(CC_ERR_INT_NO_ERROR);

   slaveProtocolIds.clear();

   ProtocolInfoMap localSupportedProtocols;
   (void) this->getProtocolInfos(localSupportedProtocols, true, false, false);

   ProtocolInfoMap::iterator it;
   for (it = localSupportedProtocols.begin(); it != localSupportedProtocols.end(); it++)
   {
      if (BM_PROTOCOL_DEPENDENCY_LEVEL_SLAVE == _bmCoreConfiguration._protocolSupportInformation[it->first]._dependencyLevel)
      {
         slaveProtocolIds.push_back(it->first);
      }
   }

   return result;
}

Result DataProvider::isSlaveProtocolId(OUT bool& isSlaveProtocolId, IN const ProtocolId protocolId)
{
   ETG_TRACE_USR1(("isSlaveProtocolId: protocolId = %d", ETG_CENUM(ProtocolId, protocolId)));

   Result result(CC_ERR_INT_NO_ERROR);

   isSlaveProtocolId = false;

   if (true == isValidProtocolId(protocolId))
   {
      if (BM_PROTOCOL_DEPENDENCY_LEVEL_SLAVE == _bmCoreConfiguration._protocolSupportInformation[protocolId]._dependencyLevel)
      {
         isSlaveProtocolId = true;
      }

      ETG_TRACE_USR1(("isSlaveProtocolId: given protocolId = %d is%10s configured as slave protocol ID",
            ETG_CENUM(ProtocolId, protocolId), isSlaveProtocolId ? "" : " NOT"));
   }
   else
   {
      ETG_TRACE_ERR(("isSlaveProtocolId: given protocol ID is not valid"));
      result = CC_ERR_INT_GENERAL_ERROR;
   }

   return result;
}

Result DataProvider::getDeviceConnectionProtocols(OUT ProtocolIdList& deviceConnectionProtocols)
{
   ENTRY

   ETG_TRACE_USR1(("getDeviceConnectionProtocols"));

   Result result(CC_ERR_INT_NO_ERROR);

   deviceConnectionProtocols.clear();

   if (true == _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._usedForDeviceConnection)
   {
      deviceConnectionProtocols.push_back(BM_PROTOCOL_ID_HFP);
   }

   if (true == _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._usedForDeviceConnection)
   {
      deviceConnectionProtocols.push_back(BM_PROTOCOL_ID_AVP);
   }

   if (true == _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._usedForDeviceConnection)
   {
      deviceConnectionProtocols.push_back(BM_PROTOCOL_ID_PBDL);
   }

   if (true == _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._usedForDeviceConnection)
   {
      deviceConnectionProtocols.push_back(BM_PROTOCOL_ID_MSG);
   }

   if (true == _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._usedForDeviceConnection)
   {
      deviceConnectionProtocols.push_back(BM_PROTOCOL_ID_PAN);
   }

   if (true == _bmCoreConfiguration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._usedForDeviceConnection)
   {
      deviceConnectionProtocols.push_back(BM_PROTOCOL_ID_SPP);
   }

   if (true == deviceConnectionProtocols.empty())
   {
      result = CC_ERR_INT_DP_ERROR;
   }

   VARTRACE(deviceConnectionProtocols);

   return result;
}

Result DataProvider::getHmiUserSelectableProtocols(OUT ProtocolList& hmiUserSelectableProtocols)
{
   Result result(CC_ERR_INT_NO_ERROR);

   hmiUserSelectableProtocols.clear();

   // todo: needs to be taken from configuration

   ProtocolIdList deviceConnectionProtocolIds;
   result = this->getDeviceConnectionProtocols(deviceConnectionProtocolIds);

   if (CC_ERR_INT_NO_ERROR == result)
   {
      for (size_t idx = 0; idx < deviceConnectionProtocolIds.size(); ++idx)
      {
         hmiUserSelectableProtocols.push_back(Protocol(deviceConnectionProtocolIds[idx], ""));
      }

      uint8_t maxNumPanInstances;
      result = getMaxNumProtocolInstances(maxNumPanInstances, BM_PROTOCOL_ID_PAN);

      if (0u < maxNumPanInstances)
      {
         hmiUserSelectableProtocols.push_back(Protocol(BM_PROTOCOL_ID_PAN, ""));
      }
   }

   if (true == hmiUserSelectableProtocols.empty())
   {
      result = CC_ERR_INT_DP_ERROR;
   }

   VARTRACE(hmiUserSelectableProtocols);

   return result;
}

void DataProvider::traceConfigValue(const bool data, const char *dbName)
{
   ETG_TRACE_USR1(("BM Configuration: name=%128s , value=%s", dbName, (data == true) ? "true" : "false"));
}

void DataProvider::traceConfigValue(const int data, const char *dbName)
{
   ETG_TRACE_USR1(("BM Configuration: name=%128s , value=%d", dbName, data));
}

void DataProvider::traceConfigValue(const long data, const char *dbName)
{
   char dataStr[25];
   snprintf(dataStr, 24, "%ld", data);

   ETG_TRACE_USR1(("BM Configuration: name=%128s , value=%s", dbName, dataStr));
}

void DataProvider::traceConfigValue(const float data, const char *dbName)
{
   ETG_TRACE_USR1(("BM Configuration: name=%128s , value=%f", dbName, data));
}

void DataProvider::traceConfigValue(std::string &data, const char *dbName)
{
   ETG_TRACE_USR1(("BM Configuration: name=%128s , value=\"%s\"", dbName, data.c_str()));
}

void DataProvider::traceConfigValue(const uint8_t data, const char *dbName)
{
   char dataStr[25];
   snprintf(dataStr, 24, "%hhu", data);

   ETG_TRACE_USR1(("BM Configuration: name=%128s , value=%s", dbName, dataStr));
}

void DataProvider::traceConfigValue(const uint32_t data, const char *dbName)
{
   ETG_TRACE_USR1(("BM Configuration: name=%128s , value=%u", dbName, data));
}

Result DataProvider::done()
{
   ENTRY
   return doneDone(0);
}

int DataProvider::statistics(OUT Statistics stat)
{
   stat[0]=0;

   return 0;
}

void DataProvider::traceBmConfiguration(void) const
{
   ETG_TRACE_USR1(("traceBmConfiguration: BM configuration values:"));

   for(size_t iter = 0; iter < DataProvider::configurationItems.size(); ++iter)
   {
      DataProvider::configurationItems[iter]->trace();
   }

   ETG_TRACE_USR1(("traceBmConfiguration: btModuleName = \"%50s\", btLocalFriendlyName = \"%50s\", btLocalBdAddress = \"%50s\"",
         _bmCoreConfiguration._btModuleName.c_str(), _bmCoreConfiguration._btLocalFriendlyName.c_str(),
         _bmCoreConfiguration._btLocalBdAddress.c_str()));

   ETG_TRACE_USR1(("traceBmConfiguration: didSpecificationId = 0x%04X, didVendorId = 0x%04X, didProductId = 0x%04X, didVersion = 0x%04X, didVendorIdSource = 0x%04X",
         _bmCoreConfiguration._didSpecificationId, _bmCoreConfiguration._didVendorId,
         _bmCoreConfiguration._didProductId, _bmCoreConfiguration._didVersion, _bmCoreConfiguration._didVendorIdSource));
   ETG_TRACE_USR1(("traceBmConfiguration: didClientExecutableUrl = \"%50s\", didServiceDescription = \"%50s\", didClientDocumentationUrl = \"%50s\"",
         _bmCoreConfiguration._didClientExecutableUrl.c_str(), _bmCoreConfiguration._didServiceDescription.c_str(),
         _bmCoreConfiguration._didClientDocumentationUrl.c_str()));

   ETG_TRACE_USR1(("traceBmConfiguration: carPlayWirelessSupported = %10s, androidAutoWirelessSupported = %10s, wideBandSpeechEnabled = %10s, voiceRecognitionEnabled = %10s, enhancedCallControlEnabled = %10s",
         _bmCoreConfiguration._carPlayWirelessSupported ? "true" : "false",
                                                        _bmCoreConfiguration._androidAutoWirelessSupported ? "true" : "false",
                                                                                                           _bmCoreConfiguration._wideBandSpeechEnabled ? "true" : "false",
                                                                                                                                                       _bmCoreConfiguration._voiceRecognitionEnabled ? "true" : "false",
                                                                                                                                                                                                     _bmCoreConfiguration._enhancedCallControlEnabled ? "true" : "false"));

   ETG_TRACE_USR1(("traceBmConfiguration: pbdlViaPbapEnabled = %10s, pbdlViaHfpEnabled = %10s, pbdlViaSppEnabled = %10s, pbdlViaSyncMlEnabled = %10s",
         _bmCoreConfiguration._pbdlViaPbapEnabled ? "true" : "false",
                                                  _bmCoreConfiguration._pbdlViaHfpEnabled ? "true" : "false",
                                                                                          _bmCoreConfiguration._pbdlViaSppEnabled ? "true" : "false",
                                                                                                                                  _bmCoreConfiguration._pbdlViaSyncMlEnabled ? "true" : "false"));

   ETG_TRACE_USR1(("traceBmConfiguration: avrcpBrowsingEnabled = %10s, audioCodecMp3Enabled = %10s, audioCodecAacEnabled = %10s",
         _bmCoreConfiguration._avrcpBrowsingEnabled ? "true" : "false",
                                                    _bmCoreConfiguration._audioCodecMp3Enabled ? "true" : "false",
                                                                                               _bmCoreConfiguration._audioCodecAacEnabled ? "true" : "false"));

   ETG_TRACE_USR1(("traceBmConfiguration: protocol support information:"));

   ProtocolIdList protocolIds;
   protocolIds.push_back(BM_PROTOCOL_ID_HFP);
   protocolIds.push_back(BM_PROTOCOL_ID_AVP);
   protocolIds.push_back(BM_PROTOCOL_ID_PBDL);
   protocolIds.push_back(BM_PROTOCOL_ID_MSG);
   protocolIds.push_back(BM_PROTOCOL_ID_PAN);
   protocolIds.push_back(BM_PROTOCOL_ID_SPP);

   ProtocolSupportInformation::const_iterator it;

   for (size_t idx = 0u; idx < protocolIds.size(); ++idx)
   {
      it = _bmCoreConfiguration._protocolSupportInformation.find(protocolIds[idx]);

      if (_bmCoreConfiguration._protocolSupportInformation.end() != it)
      {
         ETG_TRACE_USR1(("traceBmConfiguration: protocol ID = %d: name = %10s, version = 0x%04X, maxNumInstances = %u",
               ETG_CENUM(ProtocolId, protocolIds[idx]),
               it->second._name.c_str(),
               it->second._version,
               it->second._maxNumInstances));
         ETG_TRACE_USR1(("traceBmConfiguration: protocol ID = %d: dependencyLevel = %d, masterProtocolsSelector = %d, usedForDeviceConnection = %10s",
               ETG_CENUM(ProtocolId, protocolIds[idx]),
               ETG_CENUM(ProtocolDependencyLevel, it->second._dependencyLevel),
               ETG_CENUM(MasterProtocolsSelector, it->second._masterProtocolsSelector),
               it->second._usedForDeviceConnection ? "true" : "false"));
      }
   }

   ETG_TRACE_USR1(("traceBmConfiguration: maxNumPairedDevices = %d, maxNumConnectedDevices = %d",
         _bmCoreConfiguration._maxNumPairedDevices, _bmCoreConfiguration._maxNumConnectedDevices));

   ETG_TRACE_USR1(("traceBmConfiguration: defaultBtStatus = %d, defaultLocalPairableMode = %d, defaultLocalConnectableMode = %d",
         ETG_CENUM(cc::TargetSwitchState, _bmCoreConfiguration._defaultBtStatus),
         ETG_CENUM(cc::TargetSwitchState, _bmCoreConfiguration._defaultLocalPairableMode),
         ETG_CENUM(cc::TargetSwitchState, _bmCoreConfiguration._defaultLocalConnectableMode)));

   ETG_TRACE_USR1(("traceBmConfiguration: localPairableTimeoutSeconds = %u, localConnectableTimeoutSeconds = %u",
         _bmCoreConfiguration._localPairableTimeoutSeconds, _bmCoreConfiguration._localConnectableTimeoutSeconds));

   ETG_TRACE_USR1(("traceBmConfiguration: useFixedPinLegacyPairing = %10s, defaultFixedPinLegacyPairing = \"%50s\", pinLengthLegacyPairing = %u",
         _bmCoreConfiguration._useFixedPinLegacyPairing ? "true" : "false",
                                                        _bmCoreConfiguration._defaultFixedPinLegacyPairing.c_str(),
                                                        _bmCoreConfiguration._pinLengthLegacyPairing));

   ETG_TRACE_USR1(("traceBmConfiguration: autoConfirmRemoteLegacyPairingRequest = %10s, autoConfirmLocalLegacyPairingRequest = %10s, autoConfirmRemoteSecureSimplePairingRequest = %10s, autoConfirmLocalSecureSimplePairingRequest = %10s",
         _bmCoreConfiguration._autoConfirmRemoteLegacyPairingRequest ? "true" : "false",
                                                                     _bmCoreConfiguration._autoConfirmLocalLegacyPairingRequest ? "true" : "false",
                                                                                                                                _bmCoreConfiguration._autoConfirmRemoteSecureSimplePairingRequest ? "true" : "false",
                                                                                                                                                                                                  _bmCoreConfiguration._autoConfirmLocalSecureSimplePairingRequest ? "true" : "false"));

   ETG_TRACE_USR1(("traceBmConfiguration: allowLegacyPairingRetry = %10s",
         _bmCoreConfiguration._allowLegacyPairingRetry ? "true" : "false"));

   ETG_TRACE_USR1(("traceBmConfiguration: localProtocolConnectingDelaySeconds = %u, protocolDisconnectingTimeoutSeconds = %u, lostDeviceConnectionRetryDelayMilliSeconds = %u",
         _bmCoreConfiguration._localProtocolConnectingDelaySeconds, _bmCoreConfiguration._protocolDisconnectingTimeoutSeconds,
         _bmCoreConfiguration._lostDeviceConnectionRetryDelayMilliSeconds));

   ETG_TRACE_USR1(("traceBmConfiguration: startAutoConnectionOnStartUp = %10s",
         _bmCoreConfiguration._startAutoConnectionOnStartUp ? "true" : "false"));

   ETG_TRACE_USR1(("traceBmConfiguration: defaultStandardAutoConnectionType = %d",
         ETG_CENUM(StandardAutoConnectionType, _bmCoreConfiguration._defaultStandardAutoConnectionType)));

   ETG_TRACE_USR1(("traceBmConfiguration: linkQualityRequestTimeOut = %u", _bmCoreConfiguration._linkQualityRequestTimeOut));

   ETG_TRACE_USR1(("traceBmConfiguration: blockAllProtocolsForNonProjectionDevices = %10s",
         _bmCoreConfiguration._blockAllProtocolsForNonProjectionDevices ? "true" : "false"));
   ETG_TRACE_USR1(("traceBmConfiguration: ConnectAfterPairing = %10s",
         _bmCoreConfiguration._connectAfterPairing ? "true" : "false"));
   ETG_TRACE_USR1(("traceBmConfiguration: IapEnabled = %10s",
         _bmCoreConfiguration._iapEnabled ? "true" : "false"));
   ETG_TRACE_USR1(("traceBmConfiguration: defaultmultiHFPSupport = %d",
         ETG_CENUM(cc::TargetSwitchState, _bmCoreConfiguration._defaultmultiHFPSupport)));
   ETG_TRACE_USR1(("traceBmConfiguration: systemWideRingtoneEnabled = %10s",
         _bmCoreConfiguration._systemWideRingtoneEnabled ? "true" : "false"));
   ETG_TRACE_USR1(("traceBmConfiguration: blockDeviceRemoteConnectionsTimeoutSeconds = %u",
         _bmCoreConfiguration._blockDeviceRemoteConnectionsTimeoutSeconds));
   ETG_TRACE_USR1(("traceBmConfiguration: updateConflictDuringCPWOOBPairing = %u",
         _bmCoreConfiguration._updateConflictDuringCPWOOBPairing));
   ETG_TRACE_USR1(("traceBmConfiguration: CPWReconnectTimeoutInSecs = %u",
         _bmCoreConfiguration._CPWReconnectTimeoutInSecs));
   ETG_TRACE_USR1(("traceBmConfiguration: enableDefaultActionAtEndOfBtLimitation = %10s",
         _bmCoreConfiguration._enableDefaultActionAtEndOfBtLimitation ? "true" : "false"));
   ETG_TRACE_USR1(("traceBmConfiguration: _deleteDeviceDuringOOBTPairing = %d",
         ETG_CENUM(UserConfirmationRequired, _bmCoreConfiguration._deleteDeviceDuringOOBTPairing)));
   ETG_TRACE_USR1(("traceBmConfiguration: _serviceSearchTimeoutSeconds = %u",
         _bmCoreConfiguration._serviceSearchTimeoutSeconds));
   ETG_TRACE_USR1(("traceBmConfiguration: _defaultConnectionPageTimeoutMilliSeconds = %u",
         _bmCoreConfiguration._defaultConnectionPageTimeoutMilliSeconds));

   ETG_TRACE_USR1(("traceBmConfiguration: _wifiHealthinessIndicatorInformation.size() = %u",
         _bmCoreConfiguration._wifiHealthinessIndicatorInformation.size()));
   size_t idx = 0u;
   for (WifiHealthinessIndicatorInformation::const_iterator it = _bmCoreConfiguration._wifiHealthinessIndicatorInformation.begin();
         it != _bmCoreConfiguration._wifiHealthinessIndicatorInformation.end(); ++it)
   {
      ETG_TRACE_USR1(("traceBmConfiguration: _wifiHealthinessIndicatorInformation[ID = %d]: _wifiHealthinessIndicatorThresholdValue = %d, _connectionPageTimeoutMilliSeconds = %d",
            idx, it->_wifiHealthinessIndicatorThresholdValue, it->_connectionPageTimeoutMilliSeconds));
      idx++;
   }

   ETG_TRACE_USR1(("traceBmConfiguration: _delayAutoConnectionAtEndOfBtLimitationInSec = %u",
         _bmCoreConfiguration._delayAutoConnectionAtEndOfBtLimitationInSec));

   ETG_TRACE_USR1(("traceBmConfiguration: _sppServiceInformation.size() = %u",
         _bmCoreConfiguration._sppServiceInformation.size()));

   idx = 0u;
   for (SppServiceInformation::const_iterator it = _bmCoreConfiguration._sppServiceInformation.begin();
         it != _bmCoreConfiguration._sppServiceInformation.end(); ++it)
   {
      ETG_TRACE_USR1(("traceBmConfiguration: _sppServiceInformation[ID = %d]: maxNumInstances = %d, serviceName = %10s, localUuid = %50s, remoteUuid = %50s",
            idx, it->_maxNumInstances, it->_serviceName.c_str(), it->_localUuid.c_str(), it->_remoteUuid.c_str()));
      idx++;
   }

   ETG_TRACE_USR1(("traceBmConfiguration: _kdsInformation.size() = %u",
         _bmCoreConfiguration._kdsInformation.size()));

   idx = 0u;
   for (KdsInformation::const_iterator it = _bmCoreConfiguration._kdsInformation.begin();
         it != _bmCoreConfiguration._kdsInformation.end(); ++it)
   {
      ETG_TRACE_USR1(("traceBmConfiguration: _kdsInformation[ID = %d]: _key = 0x%X, _read = %d, _serviceName = %50s",
            idx, it->_key, it->_read, it->_serviceName.c_str()));

      ETG_TRACE_USR1(("traceBmConfiguration: _kdsInformation[ID = %d]: _byte = %d, _bit = %d, _length = %d",
            idx, it->_byte, it->_bit, it->_length));
      idx++;
   }

   ETG_TRACE_USR1(("traceBmConfiguration: btOnOffSupport = %10s",
         _bmCoreConfiguration._btOnOffSupport ? "true" : "false"));
}

bool DataProvider::readConfiguration(OUT BmCoreConfiguration& configuration, IN const ::std::string& configurationFile) const
{
   ENTRY

   ETG_TRACE_USR1(("readConfiguration: configurationFile = \"%s\"", configurationFile.c_str()));

   if (configurationFile.empty())
   {
      ETG_TRACE_ERRMEM(("readConfiguration: configuration file name is empty"));
      return false;
   }

   FILE* pFile = fopen(configurationFile.c_str(), "rb");
   if (NULL == pFile)
   {
      ETG_TRACE_ERRMEM(("readConfiguration: open file %s failed (NULL pointer returned)", configurationFile.c_str()));
      return false;
   }
   //Get configuration File size

   fseek (pFile , 0 , SEEK_END);
   const size_t  bufferSize = ftell (pFile) +1; // including NULL termination
   rewind (pFile);
   char* fileData = new char[bufferSize];
   if (NULL == fileData)
   {
      ETG_TRACE_ERRMEM(("readConfiguration: memory allocation failed (NULL pointer returned)"));
      fclose(pFile); // file open was successful, therefore close is necessary
      return false;
   }


   bool result = false;
   size_t rd = fread((void *) fileData, 1, bufferSize , pFile);
   const bool sizeOk = (0 < rd); // check if at least 1 byte was read
   const bool eofSet = (0 != feof(pFile)); // check if end-of-file indicator is set
   const bool errorSet = (0 != ferror(pFile)); // check if error indicator is set
   if(errorSet)
   {
      const int errNumber = errno;
      ETG_TRACE_ERRMEM(("readConfiguration: read file %100s failed: ERROR=%d (%s)", configurationFile.c_str(), errNumber, strerror(errNumber)));
   }

   ETG_TRACE_USR1(("readConfiguration: read result: rd=%u sizeOk=%d eofSet=%d errorSet=%d", rd, sizeOk, eofSet, errorSet));

   /* file read error handling */
   if ((false == sizeOk) || (false == eofSet) || (true == errorSet))
   {
      ETG_TRACE_FATAL(("readConfiguration: could not read configuration file %s, using connectivity's built-in default configuration values", configurationFile.c_str()));
      ETG_TRACE_ERRMEM(("readConfiguration: could not read configuration file %s, using connectivity's built-in default configuration values", configurationFile.c_str()));
   }
   else
   {
      yajl_val node;
      char errbuf[256];

      /* null plug buffers */
      errbuf[0] = 0;
      fileData[rd] = '\0';

      /* we have the whole config file in memory.  let's parse it ... */
      node = yajl_tree_parse((const char *) fileData, errbuf, sizeof(errbuf));

      /* parse error handling */
      if (node == NULL)
      {
         ETG_TRACE_FATAL(("readConfiguration: parsing content of configuration file %s failed, using connectivity's built-in default configuration values", configurationFile.c_str()));
         ETG_TRACE_ERRMEM(("readConfiguration: parsing content of configuration file %s failed, using connectivity's built-in default configuration values", configurationFile.c_str()));

         //if (strlen(errbuf))
         {
            ETG_TRACE_FATAL(("readConfiguration: yajl parser error message: %s", errbuf));
         }
      }
      else
      {
         const char * path_BtModuleName[] = {"BtModuleName", (const char *) 0 };
         const char * path_maxNumPairedDevices[] = {"maxNumPairedDevices", (const char *) 0 };
         const char * path_defaultLocalPairableMode[] = {"enableLocalPairableModeByDefault", (const char *) 0 };
         const char * path_defaultLocalConnectableMode[] = {"enableLocalConnectableModeByDefault", (const char *) 0};
         const char * path_maxNumConnectedDevices[] = {"maxNumConnectedDevices", (const char *) 0};
         const char * path_btLocalBdAddress[] = {"btLocalBdAddress", (const char *) 0};
         const char * path_didSpecificationId[] = {"didSpecificationId", (const char *) 0};
         const char * path_didVendorId[] = {"didVendorId", (const char *) 0};
         const char * path_didProductId[] = {"didProductId", (const char *) 0};
         const char * path_didVersion[] = {"didVersion", (const char *) 0};
         const char * path_didVendorIdSource[] = {"didVendorIdSource", (const char *) 0};
         const char * path_didClientExecutableUrl[] = {"didClientExecutableUrl", (const char *) 0};
         const char * path_didServiceDescription[] = {"didServiceDescription", (const char *) 0};
         const char * path_didClientDocumentationUrl[] = {"didClientDocumentationUrl", (const char *) 0};
         const char * path_wideBandSpeechEnabled[] = {"wideBandSpeechEnabled", (const char *) 0};
         const char * path_pbdlViaPbapEnabled[] = {"pbdlViaPbapEnabled", (const char *) 0};
         const char * path_pbdlViaHfpEnabled[] = {"pbdlViaHfpEnabled", (const char *) 0};
         const char * path_pbdlViaSppEnabled[] = {"pbdlViaSppEnabled", (const char *) 0};
         const char * path_pbdlViaSyncMlEnabled[] = {"pbdlViaSyncMlEnabled", (const char *) 0};
         const char * path_voiceRecognitionEnabled[] = {"voiceRecognitionEnabled", (const char *) 0};
         const char * path_enhancedCallControlEnabled[] = {"enhancedCallControlEnabled", (const char *) 0};
         const char * path_avrcpBrowsingEnabled[] = {"avrcpBrowsingEnabled", (const char *) 0};
         const char * path_audioCodecMp3Enabled[] = {"audioCodecMp3Enabled", (const char *) 0};
         const char * path_audioCodecAacEnabled[] = {"audioCodecAacEnabled", (const char *) 0};

         const char * path_HFP_VERSION[] = {"ProtocolSupportInformation","HFP","ProtocolVersion", (const char *) 0};
         const char * path_HFP_MaxINSTANCE[] = {"ProtocolSupportInformation","HFP","maxNumInstances", (const char *) 0};
         const char * path_HFP_DependencyLevel[] = {"ProtocolSupportInformation","HFP","dependencyLevel", (const char *) 0};
         const char * path_HFP_MasterProtocolsSelector[] = {"ProtocolSupportInformation","HFP","masterProtocolsSelector", (const char *) 0};
         const char * path_HFP_UsedDeviceConnection[] = {"ProtocolSupportInformation","HFP","usedForDeviceConnection", (const char *) 0};

         const char * path_AVP_VERSION[] = {"ProtocolSupportInformation","AVP","ProtocolVersion", (const char *) 0};
         const char * path_AVP_MaxINSTANCE[] = {"ProtocolSupportInformation","AVP","maxNumInstances", (const char *) 0};
         const char * path_AVP_DependencyLevel[] = {"ProtocolSupportInformation","AVP","dependencyLevel", (const char *) 0};
         const char * path_AVP_MasterProtocolsSelector[] = {"ProtocolSupportInformation","AVP","masterProtocolsSelector", (const char *) 0};
         const char * path_AVP_UsedDeviceConnection[] = {"ProtocolSupportInformation","AVP","usedForDeviceConnection", (const char *) 0};

         const char * path_PBDL_VERSION[] = {"ProtocolSupportInformation","PBDL","ProtocolVersion", (const char *) 0};
         const char * path_PBDL_MaxINSTANCE[] = {"ProtocolSupportInformation","PBDL","maxNumInstances", (const char *) 0};
         const char * path_PBDL_DependencyLevel[] = {"ProtocolSupportInformation","PBDL","dependencyLevel", (const char *) 0};
         const char * path_PBDL_MasterProtocolsSelector[] = {"ProtocolSupportInformation","PBDL","masterProtocolsSelector", (const char *) 0};
         const char * path_PBDL_UsedDeviceConnection[] = {"ProtocolSupportInformation","PBDL","usedForDeviceConnection", (const char *) 0};

         const char * path_MSG_VERSION[] = {"ProtocolSupportInformation","MSG","ProtocolVersion", (const char *) 0};
         const char * path_MSG_MaxINSTANCE[] = {"ProtocolSupportInformation","MSG","maxNumInstances", (const char *) 0};
         const char * path_MSG_DependencyLevel[] = {"ProtocolSupportInformation","MSG","dependencyLevel", (const char *) 0};
         const char * path_MSG_MasterProtocolsSelector[] = {"ProtocolSupportInformation","MSG","masterProtocolsSelector", (const char *) 0};
         const char * path_MSG_UsedDeviceConnection[] = {"ProtocolSupportInformation","MSG","usedForDeviceConnection", (const char *) 0};

         const char * path_PAN_VERSION[] = {"ProtocolSupportInformation","PAN","ProtocolVersion", (const char *) 0};
         const char * path_PAN_MaxINSTANCE[] = {"ProtocolSupportInformation","PAN","maxNumInstances", (const char *) 0};
         const char * path_PAN_DependencyLevel[] = {"ProtocolSupportInformation","PAN","dependencyLevel", (const char *) 0};
         const char * path_PAN_MasterProtocolsSelector[] = {"ProtocolSupportInformation","PAN","masterProtocolsSelector", (const char *) 0};
         const char * path_PAN_UsedDeviceConnection[] = {"ProtocolSupportInformation","PAN","usedForDeviceConnection", (const char *) 0};

         const char * path_SPP_VERSION[] = {"ProtocolSupportInformation","SPP","ProtocolVersion", (const char *) 0};
         const char * path_SPP_MaxINSTANCE[] = {"ProtocolSupportInformation","SPP","maxNumInstances", (const char *) 0};
         const char * path_SPP_DependencyLevel[] = {"ProtocolSupportInformation","SPP","dependencyLevel", (const char *) 0};
         const char * path_SPP_MasterProtocolsSelector[] = {"ProtocolSupportInformation","SPP","masterProtocolsSelector", (const char *) 0};
         const char * path_SPP_UsedDeviceConnection[] = {"ProtocolSupportInformation","SPP","usedForDeviceConnection", (const char *) 0};

         const char * path_defaultBtStatus[] = {"enableBtByDefault", (const char *) 0};
         const char * path_localPairableTimeoutSeconds[] = {"localPairableTimeoutSeconds", (const char *) 0};
         const char * path_localConnectableTimeoutSeconds[] = {"localConnectableTimeoutSeconds", (const char *) 0};
         const char * path_useFixedPinLegacyPairing[] = {"useFixedPinLegacyPairing", (const char *) 0};
         const char * path_pinLengthLegacyPairing[] = {"pinLengthLegacyPairing", (const char *) 0};
         const char * path_defaultFixedPinLegacyPairing[] = {"defaultFixedPinLegacyPairing", (const char *) 0};
         const char * path_autoConfirmRemoteLegacyPairingRequest[] = {"autoConfirmRemoteLegacyPairingRequest", (const char *) 0};
         const char * path_autoConfirmLocalLegacyPairingRequest[] = {"autoConfirmLocalLegacyPairingRequest", (const char *) 0};
         const char * path_autoConfirmRemoteSecureSimplePairingRequest[] = {"autoConfirmRemoteSecureSimplePairingRequest", (const char *) 0};
         const char * path_autoConfirmLocalSecureSimplePairingRequest[] = {"autoConfirmLocalSecureSimplePairingRequest", (const char *) 0};
         const char * path_allowLegacyPairingRetry[] = {"allowLegacyPairingRetry", (const char *) 0};
         const char * path_lostDeviceConnectionRetryDelayMilliSeconds[] = {"lostDeviceConnectionRetryDelayMilliSeconds", (const char *) 0};
         const char * path_localProtocolConnectingDelaySeconds[] = {"localProtocolConnectingDelaySeconds", (const char *) 0};
         const char * path_protocolDisconnectingTimeoutSeconds[] = {"protocolDisconnectingTimeoutSeconds", (const char *) 0};
         const char * path_defaultStandardAutoConnectionType[] = {"defaultStandardAutoConnectionType", (const char *) 0};
         const char * path_startAutoConnectionOnStartUp[] = {"startAutoConnectionOnStartUp", (const char *) 0};
         const char * path_linkQualityRequestTimeOut[] = {"linkQualityRequestTimeOut", (const char *) 0};
         const char * path_blockAllProtocolsForNonProjectionDevices[] = {"blockAllProtocolsForNonProjectionDevices", (const char *) 0};
         const char * path_ConnectAfterPairing[] = {"ConnectAfterPairing", (const char *) 0};
         const char * path_IapEnabled[] = {"IapEnabled", (const char *) 0};
         const char * path_defaultmultiHFPSupport[] = {"enableMultiHFPSupportByDefault", (const char *) 0};
         const char * path_systemWideRingtoneEnabled[] = {"systemWideRingtoneEnabled", (const char *) 0};
         const char * path_blockDeviceRemoteConnectionsTimeoutSeconds[] = {"blockDeviceRemoteConnectionsTimeoutSeconds", (const char *) 0};
         const char * path_updateConflictDuringCPWOOBPairing[] = {"updateConflictDuringCPWOOBPairing", (const char *) 0};
         const char * path_CPWReconnectTimeoutInSecs[] = {"CPWReconnectTimeoutInSecs", (const char *) 0};
         const char * path_enableDefaultActionAtEndOfLimitation[] = {"enableDefaultActionAtEndOfBtLimitation", (const char *) 0};
         const char * path_deleteDeviceDuringOOBTPairing[] = {"deleteDeviceDuringOOBTPairing", (const char *) 0};
         const char * path_serviceSearchTimeoutSeconds[] = {"serviceSearchTimeoutSeconds", (const char *) 0};
         const char * path_defaultConnectionPageTimeoutMilliSeconds[] = {"defaultConnectionPageTimeoutMilliSeconds", (const char *) 0};

         const char * path_GOOD_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE[] = {"WifiHealthinessIndicatorInformation","Good","wifiHealthinessIndicatorThresholdValue", (const char *) 0};
         const char * path_GOOD_CONNECTIONPAGETIMEOUTMILLISECONDS[] = {"WifiHealthinessIndicatorInformation","Good","connectionPageTimeoutMilliSeconds", (const char *) 0};

         const char * path_MID_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE[] = {"WifiHealthinessIndicatorInformation","Mid","wifiHealthinessIndicatorThresholdValue", (const char *) 0};
         const char * path_MID_CONNECTIONPAGETIMEOUTMILLISECONDS[] = {"WifiHealthinessIndicatorInformation","Mid","connectionPageTimeoutMilliSeconds", (const char *) 0};

         const char * path_LOW_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE[] = {"WifiHealthinessIndicatorInformation","Low","wifiHealthinessIndicatorThresholdValue", (const char *) 0};
         const char * path_LOW_CONNECTIONPAGETIMEOUTMILLISECONDS[] = {"WifiHealthinessIndicatorInformation","Low","connectionPageTimeoutMilliSeconds", (const char *) 0};

         const char * path_CRITICAL_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE[] = {"WifiHealthinessIndicatorInformation","Critical","wifiHealthinessIndicatorThresholdValue", (const char *) 0};
         const char * path_CRITICAL_CONNECTIONPAGETIMEOUTMILLISECONDS[] = {"WifiHealthinessIndicatorInformation","Critical","connectionPageTimeoutMilliSeconds", (const char *) 0};

         const char * path_delayAutoConnectionAtEndOfBtLimitationInSec[] = {"delayAutoConnectionAtEndOfBtLimitationInSec", (const char *) 0};

         const char * path_iAP2ServiceInfoMaxNumInstances[] = {"SppServiceInfo","iAP2","maxNumInstances", (const char *) 0};
         const char * path_iAP2ServiceInfoLocalUuid[] = {"SppServiceInfo","iAP2","localUuid", (const char *) 0};
         const char * path_iAP2ServiceInfoRemoteUuid[] = {"SppServiceInfo","iAP2","remoteUuid", (const char *) 0};

         const char * path_CPWServiceInfoMaxNumInstances[] = {"SppServiceInfo","CPW","maxNumInstances", (const char *) 0};
         const char * path_CPWServiceInfoLocalUuid[] = {"SppServiceInfo","CPW","localUuid", (const char *) 0};
         const char * path_CPWServiceInfoRemoteUuid[] = {"SppServiceInfo","CPW","remoteUuid", (const char *) 0};

         const char * path_AAWServiceInfoMaxNumInstances[] = {"SppServiceInfo","AAW","maxNumInstances", (const char *) 0};
         const char * path_AAWServiceInfoLocalUuid[] = {"SppServiceInfo","AAW","localUuid", (const char *) 0};
         const char * path_AAWServiceInfoRemoteUuid[] = {"SppServiceInfo","AAW","remoteUuid", (const char *) 0};

         const char * path_VehicleBtFriendlyNameRead[] = {"KDSInfo","VehicleBtFriendlyName","read", (const char *) 0};
         const char * path_VehicleBtFriendlyNameDefaultValue[] = {"KDSInfo","VehicleBtFriendlyName","default", (const char *) 0};
         const char * path_VehicleBtFriendlyNameKey[] = {"KDSInfo","VehicleBtFriendlyName","key", (const char *) 0};
         const char * path_VehicleBtFriendlyNameByte[] = {"KDSInfo","VehicleBtFriendlyName","byte", (const char *) 0};
         const char * path_VehicleBtFriendlyNameLength[] = {"KDSInfo","VehicleBtFriendlyName","length", (const char *) 0};

         const char * path_CPWKDSInfoRead[] = {"KDSInfo","CPW","read", (const char *) 0};
         const char * path_CPWKDSInfoDefault[] = {"KDSInfo","CPW","default", (const char *) 0};
         const char * path_CPWKDSInfoKey[] = {"KDSInfo","CPW","key", (const char *) 0};
         const char * path_CPWKDSInfoByte[] = {"KDSInfo","CPW","byte", (const char *) 0};
         const char * path_CPWKDSInfoBit[] = {"KDSInfo","CPW","bit", (const char *) 0};
         const char * path_CPWKDSInfoLength[] = {"KDSInfo","CPW","length", (const char *) 0};
         const char * path_PANKDSInfoRead[] = {"KDSInfo","PAN","read", (const char *) 0};
         const char * path_PANKDSInfoKey[] = {"KDSInfo","PAN","key", (const char *) 0};
         const char * path_PANKDSInfoByte[] = {"KDSInfo","PAN","byte", (const char *) 0};
         const char * path_PANKDSInfoBit[] = {"KDSInfo","PAN","bit", (const char *) 0};
         const char * path_PANKDSInfoLength[] = {"KDSInfo","PAN","length", (const char *) 0};
         const char * path_AAWKDSInfoRead[] = {"KDSInfo","AAW","read", (const char *) 0};
         const char * path_AAWKDSInfoDefault[] = {"KDSInfo","AAW","default", (const char *) 0};
         const char * path_AAWKDSInfoKey[] = {"KDSInfo","AAW","key", (const char *) 0};
         const char * path_AAWKDSInfoByte[] = {"KDSInfo","AAW","byte", (const char *) 0};
         const char * path_AAWKDSInfoBit[] = {"KDSInfo","AAW","bit", (const char *) 0};
         const char * path_AAWKDSInfoLength[] = {"KDSInfo","AAW","length", (const char *) 0};

         const char * path_VehicleBtOnOffRead[] = {"KDSInfo","VehicleBtOnOff","read", (const char *) 0};
         const char * path_VehicleBtOnOffDefault[] = {"KDSInfo","VehicleBtOnOff","default", (const char *) 0};
         const char * path_VehicleBtOnOffKey[] = {"KDSInfo","VehicleBtOnOff","key", (const char *) 0};
         const char * path_VehicleBtOnOffByte[] = {"KDSInfo","VehicleBtOnOff","byte", (const char *) 0};
         const char * path_VehicleBtOnOffBit[] = {"KDSInfo","VehicleBtOnOff","bit", (const char *) 0};
         const char * path_VehicleBtOnOffLength[] = {"KDSInfo","VehicleBtOnOff","length", (const char *) 0};

         yajl_val value = yajl_tree_get(node, path_BtModuleName, yajl_t_string);

         if (0 != value)
         {
            if (true == YAJL_IS_STRING(value))
            {
               configuration._btModuleName = YAJL_GET_STRING(value);
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string, using connectivity's built-in default configuration value (= %50s)",
                     path_BtModuleName[0], configuration._btModuleName.c_str()));
            }
         }
         else
         {
            ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s, using connectivity's built-in default configuration value (= %50s)",
                  path_BtModuleName[0], configurationFile.c_str(), configuration._btModuleName.c_str()));
         }

         value = yajl_tree_get(node, path_btLocalBdAddress, yajl_t_string);

         if (0 != value)
         {
            if (true == YAJL_IS_STRING(value))
            {
               configuration._btLocalBdAddress = YAJL_GET_STRING(value);
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string, using connectivity's built-in default configuration value (= %50s)",
                     path_btLocalBdAddress[0], configuration._btLocalBdAddress.c_str()));
            }
         }
         else
         {
            ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s, using connectivity's built-in default configuration value (= %50s)",
                  path_btLocalBdAddress[0], configurationFile.c_str(), configuration._btLocalBdAddress.c_str()));
         }

         if (NULL == yajl_tree_get(node, path_didSpecificationId, yajl_t_number))
         {
            configuration._didSpecificationId = 0x0103u;
         }
         else
         {
            configuration._didSpecificationId = (uint16_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_didSpecificationId, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_didVendorId, yajl_t_number))
         {
            configuration._didVendorId = 0x0068u;
         }
         else
         {
            configuration._didVendorId = (uint16_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_didVendorId, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_didProductId, yajl_t_number))
         {
            configuration._didProductId = 0x0008u;
         }
         else
         {
            configuration._didProductId = (uint16_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_didProductId, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_didVersion, yajl_t_number))
         {
            configuration._didVersion = 0x0101u;
         }
         else
         {
            configuration._didVersion = (uint16_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_didVersion, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_didVendorIdSource, yajl_t_number))
         {
            configuration._didVendorIdSource = 0x0001u;
         }
         else
         {
            configuration._didVendorIdSource = (uint16_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_didVendorIdSource, yajl_t_number));
         }

         value = yajl_tree_get(node, path_didClientExecutableUrl, yajl_t_string);

         if (0 != value)
         {
            if (true == YAJL_IS_STRING(value))
            {
               configuration._didClientExecutableUrl = YAJL_GET_STRING(value);
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string, using connectivity's built-in default configuration value (= %50s)",
                     path_didClientExecutableUrl[0], configuration._didClientExecutableUrl.c_str()));
            }
         }
         else
         {
            ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s, using connectivity's built-in default configuration value (= %50s)",
                  path_didClientExecutableUrl[0], configurationFile.c_str(), configuration._didClientExecutableUrl.c_str()));
         }

         value = yajl_tree_get(node, path_didServiceDescription, yajl_t_string);

         if (0 != value)
         {
            if (true == YAJL_IS_STRING(value))
            {
               configuration._didServiceDescription = YAJL_GET_STRING(value);
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string, using connectivity's built-in default configuration value (= %50s)",
                     path_didServiceDescription[0], configuration._didServiceDescription.c_str()));
            }
         }
         else
         {
            ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s, using connectivity's built-in default configuration value (= %50s)",
                  path_didServiceDescription[0], configurationFile.c_str(), configuration._didServiceDescription.c_str()));
         }

         value = yajl_tree_get(node, path_didClientDocumentationUrl, yajl_t_string);

         if (0 != value)
         {
            if (true == YAJL_IS_STRING(value))
            {
               configuration._didClientDocumentationUrl = YAJL_GET_STRING(value);
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string, using connectivity's built-in default configuration value (= %50s)",
                     path_didClientDocumentationUrl[0], configuration._didClientDocumentationUrl.c_str()));
            }
         }
         else
         {
            ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s, using connectivity's built-in default configuration value (= %50s)",
                  path_didClientDocumentationUrl[0], configurationFile.c_str(), configuration._didClientDocumentationUrl.c_str()));
         }

         if (NULL == yajl_tree_get(node, path_wideBandSpeechEnabled, yajl_t_number))
         {
            configuration._wideBandSpeechEnabled = true;
         }
         else
         {
            configuration._wideBandSpeechEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_wideBandSpeechEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_pbdlViaPbapEnabled, yajl_t_number))
         {
            configuration._pbdlViaPbapEnabled = true;
         }
         else
         {
            configuration._pbdlViaPbapEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_pbdlViaPbapEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_pbdlViaHfpEnabled, yajl_t_number))
         {
            configuration._pbdlViaHfpEnabled = false;
         }
         else
         {
            configuration._pbdlViaHfpEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_pbdlViaHfpEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_pbdlViaSppEnabled, yajl_t_number))
         {
            configuration._pbdlViaSppEnabled = false;
         }
         else
         {
            configuration._pbdlViaSppEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_pbdlViaSppEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_pbdlViaSyncMlEnabled, yajl_t_number))
         {
            configuration._pbdlViaSyncMlEnabled = false;
         }
         else
         {
            configuration._pbdlViaSyncMlEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_pbdlViaSyncMlEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_voiceRecognitionEnabled, yajl_t_number))
         {
            configuration._voiceRecognitionEnabled = true;
         }
         else
         {
            configuration._voiceRecognitionEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_voiceRecognitionEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_enhancedCallControlEnabled, yajl_t_number))
         {
            configuration._enhancedCallControlEnabled = true;
         }
         else
         {
            configuration._enhancedCallControlEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_enhancedCallControlEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_avrcpBrowsingEnabled, yajl_t_number))
         {
            configuration._avrcpBrowsingEnabled = false;
         }
         else
         {
            configuration._avrcpBrowsingEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_avrcpBrowsingEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_audioCodecMp3Enabled, yajl_t_number))
         {
            configuration._audioCodecMp3Enabled = false;
         }
         else
         {
            configuration._audioCodecMp3Enabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_audioCodecMp3Enabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_audioCodecAacEnabled, yajl_t_number))
         {
            configuration._audioCodecAacEnabled = false;
         }
         else
         {
            configuration._audioCodecAacEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_audioCodecAacEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_HFP_VERSION, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._version = 0u;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._version = (ProtocolVersion)YAJL_GET_INTEGER(yajl_tree_get(node, path_HFP_VERSION, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_HFP_MaxINSTANCE, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._maxNumInstances = 0u;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._maxNumInstances = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_HFP_MaxINSTANCE, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_HFP_DependencyLevel, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._dependencyLevel = BM_PROTOCOL_DEPENDENCY_LEVEL_MASTER;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._dependencyLevel = static_cast<ProtocolDependencyLevel>(YAJL_GET_INTEGER(yajl_tree_get(node, path_HFP_DependencyLevel, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_HFP_MasterProtocolsSelector, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._masterProtocolsSelector = BM_MASTER_PROTOCOLS_SELECTOR_NONE;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._masterProtocolsSelector = static_cast<MasterProtocolsSelector>(YAJL_GET_INTEGER(yajl_tree_get(node, path_HFP_MasterProtocolsSelector, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_HFP_UsedDeviceConnection, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._usedForDeviceConnection = true;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_HFP]._usedForDeviceConnection = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_HFP_UsedDeviceConnection, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_AVP_VERSION, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._version = 0;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._version = (ProtocolVersion)YAJL_GET_INTEGER(yajl_tree_get(node, path_AVP_VERSION, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_AVP_MaxINSTANCE, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._maxNumInstances = 0;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._maxNumInstances = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_AVP_MaxINSTANCE, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_AVP_DependencyLevel, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._dependencyLevel = BM_PROTOCOL_DEPENDENCY_LEVEL_MASTER;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._dependencyLevel = static_cast<ProtocolDependencyLevel>(YAJL_GET_INTEGER(yajl_tree_get(node, path_AVP_DependencyLevel, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_AVP_MasterProtocolsSelector, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._masterProtocolsSelector = BM_MASTER_PROTOCOLS_SELECTOR_NONE;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._masterProtocolsSelector = static_cast<MasterProtocolsSelector>(YAJL_GET_INTEGER(yajl_tree_get(node, path_AVP_MasterProtocolsSelector, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_AVP_UsedDeviceConnection, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._usedForDeviceConnection = true;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_AVP]._usedForDeviceConnection = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_AVP_UsedDeviceConnection, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_PBDL_VERSION, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._version = 0;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._version = (ProtocolVersion)YAJL_GET_INTEGER(yajl_tree_get(node, path_PBDL_VERSION, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_PBDL_MaxINSTANCE, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._maxNumInstances = 0;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._maxNumInstances = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_PBDL_MaxINSTANCE, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_PBDL_DependencyLevel, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._dependencyLevel = BM_PROTOCOL_DEPENDENCY_LEVEL_SLAVE;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._dependencyLevel = static_cast<ProtocolDependencyLevel>(YAJL_GET_INTEGER(yajl_tree_get(node, path_PBDL_DependencyLevel, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_PBDL_MasterProtocolsSelector, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._masterProtocolsSelector = BM_MASTER_PROTOCOLS_SELECTOR_HFP;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._masterProtocolsSelector = static_cast<MasterProtocolsSelector>(YAJL_GET_INTEGER(yajl_tree_get(node, path_PBDL_MasterProtocolsSelector, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_PBDL_UsedDeviceConnection, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._usedForDeviceConnection = false;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PBDL]._usedForDeviceConnection = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_PBDL_UsedDeviceConnection, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_MSG_VERSION, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._version = 0;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._version = (ProtocolVersion)YAJL_GET_INTEGER(yajl_tree_get(node, path_MSG_VERSION, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_MSG_MaxINSTANCE, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._maxNumInstances = 0;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._maxNumInstances = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_MSG_MaxINSTANCE, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_MSG_DependencyLevel, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._dependencyLevel = BM_PROTOCOL_DEPENDENCY_LEVEL_SLAVE;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._dependencyLevel = static_cast<ProtocolDependencyLevel>(YAJL_GET_INTEGER(yajl_tree_get(node, path_MSG_DependencyLevel, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_MSG_MasterProtocolsSelector, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._masterProtocolsSelector = BM_MASTER_PROTOCOLS_SELECTOR_HFP;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._masterProtocolsSelector = static_cast<MasterProtocolsSelector>(YAJL_GET_INTEGER(yajl_tree_get(node, path_MSG_MasterProtocolsSelector, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_MSG_UsedDeviceConnection, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._usedForDeviceConnection = false;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_MSG]._usedForDeviceConnection = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_MSG_UsedDeviceConnection, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_PAN_VERSION, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._version = 0;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._version = (ProtocolVersion)YAJL_GET_INTEGER(yajl_tree_get(node, path_PAN_VERSION, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_PAN_MaxINSTANCE, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._maxNumInstances = 0;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._maxNumInstances = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_PAN_MaxINSTANCE, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_PAN_DependencyLevel, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._dependencyLevel = BM_PROTOCOL_DEPENDENCY_LEVEL_STAND_ALONE;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._dependencyLevel = static_cast<ProtocolDependencyLevel>(YAJL_GET_INTEGER(yajl_tree_get(node, path_PAN_DependencyLevel, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_PAN_MasterProtocolsSelector, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._masterProtocolsSelector = BM_MASTER_PROTOCOLS_SELECTOR_NONE;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._masterProtocolsSelector = static_cast<MasterProtocolsSelector>(YAJL_GET_INTEGER(yajl_tree_get(node, path_PAN_MasterProtocolsSelector, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_PAN_UsedDeviceConnection, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._usedForDeviceConnection = false;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_PAN]._usedForDeviceConnection = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_PAN_UsedDeviceConnection, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_SPP_VERSION, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._version = 0;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._version = (ProtocolVersion)YAJL_GET_INTEGER(yajl_tree_get(node, path_SPP_VERSION, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_SPP_MaxINSTANCE, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._maxNumInstances = 0;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._maxNumInstances = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_SPP_MaxINSTANCE, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_SPP_DependencyLevel, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._dependencyLevel = BM_PROTOCOL_DEPENDENCY_LEVEL_SLAVE;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._dependencyLevel = static_cast<ProtocolDependencyLevel>(YAJL_GET_INTEGER(yajl_tree_get(node, path_SPP_DependencyLevel, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_SPP_MasterProtocolsSelector, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._masterProtocolsSelector = BM_MASTER_PROTOCOLS_SELECTOR_ALL_OTHERS;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._masterProtocolsSelector = static_cast<MasterProtocolsSelector>(YAJL_GET_INTEGER(yajl_tree_get(node, path_SPP_MasterProtocolsSelector, yajl_t_number)));
         }

         if (NULL == yajl_tree_get(node, path_SPP_UsedDeviceConnection, yajl_t_number))
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._usedForDeviceConnection = false;
         }
         else
         {
            configuration._protocolSupportInformation[BM_PROTOCOL_ID_SPP]._usedForDeviceConnection = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_SPP_UsedDeviceConnection, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_maxNumPairedDevices, yajl_t_number))
         {
            configuration._maxNumPairedDevices = 10u;
         }
         else
         {
            configuration._maxNumPairedDevices = (uint32_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_maxNumPairedDevices, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_maxNumConnectedDevices, yajl_t_number))
         {
            configuration._maxNumConnectedDevices = 1;
         }
         else
         {
            configuration._maxNumConnectedDevices = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_maxNumConnectedDevices, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_defaultBtStatus, yajl_t_number))
         {
            configuration._defaultBtStatus = TARGET_SWITCH_STATE_SWITCHED_OFF;
         }
         else if (false == (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_defaultBtStatus, yajl_t_number)))
         {
            configuration._defaultBtStatus = TARGET_SWITCH_STATE_SWITCHED_OFF;
         }
         else
         {
            configuration._defaultBtStatus = TARGET_SWITCH_STATE_SWITCHED_ON;
         }

         if (NULL == yajl_tree_get(node, path_defaultLocalPairableMode, yajl_t_number))
         {
            configuration._defaultLocalPairableMode = TARGET_SWITCH_STATE_SWITCHED_OFF;
         }
         else if (false == (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_defaultLocalPairableMode, yajl_t_number)))
         {
            configuration._defaultLocalPairableMode = TARGET_SWITCH_STATE_SWITCHED_OFF;
         }
         else
         {
            configuration._defaultLocalPairableMode = TARGET_SWITCH_STATE_SWITCHED_ON;
         }

         if (NULL == yajl_tree_get(node, path_defaultLocalConnectableMode, yajl_t_number))
         {
            configuration._defaultLocalConnectableMode = TARGET_SWITCH_STATE_SWITCHED_OFF;
         }
         else if (false == (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_defaultLocalConnectableMode, yajl_t_number)))
         {
            configuration._defaultLocalConnectableMode = TARGET_SWITCH_STATE_SWITCHED_OFF;
         }
         else
         {
            configuration._defaultLocalConnectableMode = TARGET_SWITCH_STATE_SWITCHED_ON;
         }

         if (NULL == yajl_tree_get(node, path_localConnectableTimeoutSeconds, yajl_t_number))
         {
            configuration._localConnectableTimeoutSeconds = 10u;
         }
         else
         {
            configuration._localConnectableTimeoutSeconds = (uint32_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_localConnectableTimeoutSeconds, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_localPairableTimeoutSeconds, yajl_t_number))
         {
            configuration._localPairableTimeoutSeconds = 300u;
         }
         else
         {
            configuration._localPairableTimeoutSeconds = (uint32_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_localPairableTimeoutSeconds, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_useFixedPinLegacyPairing, yajl_t_number))
         {
            configuration._useFixedPinLegacyPairing = false;
         }
         else
         {
            configuration._useFixedPinLegacyPairing = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_useFixedPinLegacyPairing, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_pinLengthLegacyPairing, yajl_t_number))
         {
            configuration._pinLengthLegacyPairing = 4;
         }
         else
         {
            configuration._pinLengthLegacyPairing = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_pinLengthLegacyPairing, yajl_t_number));
         }

         value = yajl_tree_get(node, path_defaultFixedPinLegacyPairing, yajl_t_string);

         if (0 != value)
         {
            if (true == YAJL_IS_STRING(value))
            {
               configuration._defaultFixedPinLegacyPairing = YAJL_GET_STRING(value);
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: value of parameter \"%50s\" is not a string, using connectivity's built-in default configuration value (= \"%50s\")",
                     path_defaultFixedPinLegacyPairing[0], configuration._defaultFixedPinLegacyPairing.c_str()));
            }
         }
         else
         {
            ETG_TRACE_ERR(("readConfiguration: parameter \"%50s\" does not exist in configuration file \"%100s\", using connectivity's built-in default configuration value (= \"%50s\")",
                  path_defaultFixedPinLegacyPairing[0], configurationFile.c_str(), configuration._defaultFixedPinLegacyPairing.c_str()));
         }

         if (NULL == yajl_tree_get(node, path_autoConfirmRemoteLegacyPairingRequest, yajl_t_number))
         {
            configuration._autoConfirmRemoteLegacyPairingRequest = true;
         }
         else
         {
            configuration._autoConfirmRemoteLegacyPairingRequest = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_autoConfirmRemoteLegacyPairingRequest, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_autoConfirmLocalLegacyPairingRequest, yajl_t_number))
         {
            configuration._autoConfirmLocalLegacyPairingRequest = true;
         }
         else
         {
            configuration._autoConfirmLocalLegacyPairingRequest = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_autoConfirmLocalLegacyPairingRequest, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_autoConfirmRemoteSecureSimplePairingRequest, yajl_t_number))
         {
            configuration._autoConfirmRemoteSecureSimplePairingRequest = true;
         }
         else
         {
            configuration._autoConfirmRemoteSecureSimplePairingRequest = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_autoConfirmRemoteSecureSimplePairingRequest, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_autoConfirmLocalSecureSimplePairingRequest, yajl_t_number))
         {
            configuration._autoConfirmLocalSecureSimplePairingRequest = true;
         }
         else
         {
            configuration._autoConfirmLocalSecureSimplePairingRequest = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_autoConfirmLocalSecureSimplePairingRequest, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_allowLegacyPairingRetry, yajl_t_number))
         {
            configuration._allowLegacyPairingRetry = false;
         }
         else
         {
            configuration._allowLegacyPairingRetry = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_allowLegacyPairingRetry, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_lostDeviceConnectionRetryDelayMilliSeconds, yajl_t_number))
         {
            configuration._lostDeviceConnectionRetryDelayMilliSeconds = 300u;
         }
         else
         {
            configuration._lostDeviceConnectionRetryDelayMilliSeconds = (uint32_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_lostDeviceConnectionRetryDelayMilliSeconds, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_localProtocolConnectingDelaySeconds, yajl_t_number))
         {
            configuration._localProtocolConnectingDelaySeconds = 5u;
         }
         else
         {
            configuration._localProtocolConnectingDelaySeconds = (uint32_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_localProtocolConnectingDelaySeconds, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_protocolDisconnectingTimeoutSeconds, yajl_t_number))
         {
            configuration._protocolDisconnectingTimeoutSeconds = 60u;
         }
         else
         {
            configuration._protocolDisconnectingTimeoutSeconds = (uint32_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_protocolDisconnectingTimeoutSeconds, yajl_t_number));
         }

         value = yajl_tree_get(node, path_defaultStandardAutoConnectionType, yajl_t_string);

         if (0 != value)
         {
            if (true == YAJL_IS_STRING(value))
            {
               std::string valueStr(YAJL_GET_STRING(value));

               if ("BM_STANDARD_AUTO_CONNECTION_LAST_CONNECTED_DEVICES" == valueStr)
               {
                  configuration._defaultStandardAutoConnectionType = BM_STANDARD_AUTO_CONNECTION_LAST_CONNECTED_DEVICES;
               }
               else if ("BM_STANDARD_AUTO_CONNECTION_OFF" == valueStr)
               {
                  configuration._defaultStandardAutoConnectionType = BM_STANDARD_AUTO_CONNECTION_OFF;
               }
               else if ("BM_STANDARD_AUTO_CONNECTION_UNKNOWN" == valueStr)
               {
                  configuration._defaultStandardAutoConnectionType = BM_STANDARD_AUTO_CONNECTION_UNKNOWN;
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter \"%50s\" is not valid, using connectivity's built-in default configuration value (= %d)",
                        path_defaultStandardAutoConnectionType[0], ETG_CENUM(StandardAutoConnectionType, configuration._defaultStandardAutoConnectionType)));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: value of parameter \"%50s\" is not a string, using connectivity's built-in default configuration value (= %d)",
                     path_defaultStandardAutoConnectionType[0], ETG_CENUM(StandardAutoConnectionType, configuration._defaultStandardAutoConnectionType)));
            }
         }
         else
         {
            ETG_TRACE_ERR(("readConfiguration: parameter \"%50s\" does not exist in configuration file \"%100s\", using connectivity's built-in default configuration value (= %d)",
                  path_defaultStandardAutoConnectionType[0], configurationFile.c_str(), ETG_CENUM(StandardAutoConnectionType, configuration._defaultStandardAutoConnectionType)));
         }

         if (NULL == yajl_tree_get(node, path_startAutoConnectionOnStartUp, yajl_t_number))
         {
            configuration._startAutoConnectionOnStartUp = true;
         }
         else
         {
            configuration._startAutoConnectionOnStartUp = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_startAutoConnectionOnStartUp, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_linkQualityRequestTimeOut, yajl_t_number))
         {
            configuration._linkQualityRequestTimeOut = 5u;
         }
         else
         {
            configuration._linkQualityRequestTimeOut = (uint32_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_linkQualityRequestTimeOut, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_blockAllProtocolsForNonProjectionDevices, yajl_t_number))
         {
            configuration._blockAllProtocolsForNonProjectionDevices = false;
         }
         else
         {
            configuration._blockAllProtocolsForNonProjectionDevices = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_blockAllProtocolsForNonProjectionDevices, yajl_t_number));
         }
         if (NULL == yajl_tree_get(node, path_ConnectAfterPairing, yajl_t_number))
         {
            configuration._connectAfterPairing= true;
         }
         else
         {
            configuration._connectAfterPairing = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_ConnectAfterPairing, yajl_t_number));
         }
         if (NULL == yajl_tree_get(node, path_IapEnabled, yajl_t_number))
         {
            configuration._iapEnabled= true;
         }
         else
         {
            configuration._iapEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_IapEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_defaultmultiHFPSupport, yajl_t_number))
         {
            configuration._defaultmultiHFPSupport = TARGET_SWITCH_STATE_SWITCHED_OFF;
         }
         else if (false == (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_defaultmultiHFPSupport, yajl_t_number)))
         {
            configuration._defaultmultiHFPSupport = TARGET_SWITCH_STATE_SWITCHED_OFF;
         }
         else
         {
            configuration._defaultmultiHFPSupport = TARGET_SWITCH_STATE_SWITCHED_ON;
         }

         if (NULL == yajl_tree_get(node, path_systemWideRingtoneEnabled, yajl_t_number))
         {
            configuration._systemWideRingtoneEnabled = true;
         }
         else
         {
            configuration._systemWideRingtoneEnabled = (bool) YAJL_GET_INTEGER(yajl_tree_get(node, path_systemWideRingtoneEnabled, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_blockDeviceRemoteConnectionsTimeoutSeconds, yajl_t_number))
         {
            configuration._blockDeviceRemoteConnectionsTimeoutSeconds = 0u;
         }
         else
         {
            configuration._blockDeviceRemoteConnectionsTimeoutSeconds = (uint32_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_blockDeviceRemoteConnectionsTimeoutSeconds, yajl_t_number));
         }
         if (NULL == yajl_tree_get(node, path_updateConflictDuringCPWOOBPairing, yajl_t_number))
         {
            configuration._updateConflictDuringCPWOOBPairing = false;
         }
         else
         {
            configuration._updateConflictDuringCPWOOBPairing = (bool)YAJL_GET_INTEGER(yajl_tree_get(node, path_updateConflictDuringCPWOOBPairing, yajl_t_number));
         }
         if (NULL == yajl_tree_get(node, path_CPWReconnectTimeoutInSecs, yajl_t_number))
         {
            configuration._CPWReconnectTimeoutInSecs = 60;
         }
         else
         {
            configuration._CPWReconnectTimeoutInSecs = (uint32_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_CPWReconnectTimeoutInSecs, yajl_t_number));
         }
         if (NULL == yajl_tree_get(node, path_enableDefaultActionAtEndOfLimitation, yajl_t_number))
         {
            configuration._enableDefaultActionAtEndOfBtLimitation = true;
         }
         else
         {
            configuration._enableDefaultActionAtEndOfBtLimitation = (bool)YAJL_GET_INTEGER(yajl_tree_get(node, path_enableDefaultActionAtEndOfLimitation, yajl_t_number));
         }

         value = yajl_tree_get(node, path_deleteDeviceDuringOOBTPairing, yajl_t_string);

         if (0 != value)
         {
            if (true == YAJL_IS_STRING(value))
            {
               std::string valueStr(YAJL_GET_STRING(value));

               if ("BM_USER_CONFIRMATION_NOT_REQUIRED" == valueStr)
               {
                  configuration._deleteDeviceDuringOOBTPairing = BM_USER_CONFIRMATION_NOT_REQUIRED;
               }
               else if ("BM_USER_CONFIRMATION_REQUIRED" == valueStr)
               {
                  configuration._deleteDeviceDuringOOBTPairing = BM_USER_CONFIRMATION_REQUIRED;
               }
               else if ("BM_USER_CONFIRMATION_UNKNOWN" == valueStr)
               {
                  configuration._deleteDeviceDuringOOBTPairing = BM_USER_CONFIRMATION_UNKNOWN;
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter \"%50s\" is not valid, using connectivity's built-in default configuration value (= %d)",
                        path_deleteDeviceDuringOOBTPairing[0], ETG_CENUM(UserConfirmationRequired, configuration._deleteDeviceDuringOOBTPairing)));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: value of parameter \"%50s\" is not a string, using connectivity's built-in default configuration value (= %d)",
                     path_deleteDeviceDuringOOBTPairing[0], ETG_CENUM(UserConfirmationRequired, configuration._deleteDeviceDuringOOBTPairing)));
            }
         }
         else
         {
            ETG_TRACE_ERR(("readConfiguration: parameter \"%50s\" does not exist in configuration file \"%100s\", using connectivity's built-in default configuration value (= %d)",
                  path_deleteDeviceDuringOOBTPairing[0], configurationFile.c_str(), ETG_CENUM(UserConfirmationRequired, configuration._deleteDeviceDuringOOBTPairing)));
         }

         if (NULL == yajl_tree_get(node, path_serviceSearchTimeoutSeconds, yajl_t_number))
         {
            configuration._serviceSearchTimeoutSeconds = 0u;
         }
         else
         {
            configuration._serviceSearchTimeoutSeconds = (uint32_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_serviceSearchTimeoutSeconds, yajl_t_number));
         }

         if (NULL == yajl_tree_get(node, path_defaultConnectionPageTimeoutMilliSeconds, yajl_t_number))
         {
            configuration._defaultConnectionPageTimeoutMilliSeconds = 10240u;
         }
         else
         {
            configuration._defaultConnectionPageTimeoutMilliSeconds = (PageTimeout)YAJL_GET_INTEGER(yajl_tree_get(node, path_defaultConnectionPageTimeoutMilliSeconds, yajl_t_number));
         }

         if (NULL != yajl_tree_get(node, path_GOOD_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE, yajl_t_number))
         {
            WifiHealthinessIndicatorInfo wifiHealthinessIndicatorInfo;

            wifiHealthinessIndicatorInfo._wifiHealthinessIndicatorThresholdValue = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_GOOD_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE, yajl_t_number));

            if (NULL != yajl_tree_get(node, path_GOOD_CONNECTIONPAGETIMEOUTMILLISECONDS, yajl_t_number))
            {
               wifiHealthinessIndicatorInfo._connectionPageTimeoutMilliSeconds = (PageTimeout)YAJL_GET_INTEGER(yajl_tree_get(node, path_GOOD_CONNECTIONPAGETIMEOUTMILLISECONDS, yajl_t_number));
            }

            configuration._wifiHealthinessIndicatorInformation.push_back(wifiHealthinessIndicatorInfo);
         }

         if (NULL != yajl_tree_get(node, path_MID_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE, yajl_t_number))
         {
            WifiHealthinessIndicatorInfo wifiHealthinessIndicatorInfo;

            wifiHealthinessIndicatorInfo._wifiHealthinessIndicatorThresholdValue = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_MID_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE, yajl_t_number));

            if (NULL != yajl_tree_get(node, path_MID_CONNECTIONPAGETIMEOUTMILLISECONDS, yajl_t_number))
            {
               wifiHealthinessIndicatorInfo._connectionPageTimeoutMilliSeconds = (PageTimeout)YAJL_GET_INTEGER(yajl_tree_get(node, path_MID_CONNECTIONPAGETIMEOUTMILLISECONDS, yajl_t_number));
            }

            configuration._wifiHealthinessIndicatorInformation.push_back(wifiHealthinessIndicatorInfo);
         }

         if (NULL != yajl_tree_get(node, path_LOW_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE, yajl_t_number))
         {
            WifiHealthinessIndicatorInfo wifiHealthinessIndicatorInfo;

            wifiHealthinessIndicatorInfo._wifiHealthinessIndicatorThresholdValue = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_LOW_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE, yajl_t_number));

            if (NULL != yajl_tree_get(node, path_LOW_CONNECTIONPAGETIMEOUTMILLISECONDS, yajl_t_number))
            {
               wifiHealthinessIndicatorInfo._connectionPageTimeoutMilliSeconds = (PageTimeout)YAJL_GET_INTEGER(yajl_tree_get(node, path_LOW_CONNECTIONPAGETIMEOUTMILLISECONDS, yajl_t_number));
            }

            configuration._wifiHealthinessIndicatorInformation.push_back(wifiHealthinessIndicatorInfo);
         }

         if (NULL != yajl_tree_get(node, path_CRITICAL_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE, yajl_t_number))
         {
            WifiHealthinessIndicatorInfo wifiHealthinessIndicatorInfo;

            wifiHealthinessIndicatorInfo._wifiHealthinessIndicatorThresholdValue = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_CRITICAL_WIFIHEALTLHINESSINDICATORTHRESHOLDVALUE, yajl_t_number));

            if (NULL != yajl_tree_get(node, path_CRITICAL_CONNECTIONPAGETIMEOUTMILLISECONDS, yajl_t_number))
            {
               wifiHealthinessIndicatorInfo._connectionPageTimeoutMilliSeconds = (PageTimeout)YAJL_GET_INTEGER(yajl_tree_get(node, path_CRITICAL_CONNECTIONPAGETIMEOUTMILLISECONDS, yajl_t_number));
            }

            configuration._wifiHealthinessIndicatorInformation.push_back(wifiHealthinessIndicatorInfo);
         }

         if (NULL == yajl_tree_get(node, path_delayAutoConnectionAtEndOfBtLimitationInSec, yajl_t_number))
         {
            configuration._delayAutoConnectionAtEndOfBtLimitationInSec = 0u;
         }
         else
         {
            configuration._delayAutoConnectionAtEndOfBtLimitationInSec = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_delayAutoConnectionAtEndOfBtLimitationInSec, yajl_t_number));
         }

         if (NULL != yajl_tree_get(node, path_iAP2ServiceInfoMaxNumInstances, yajl_t_number))
         {
            SppServiceInfo sppServiceInfo;

            sppServiceInfo._maxNumInstances = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_iAP2ServiceInfoMaxNumInstances, yajl_t_number));

            value = yajl_tree_get(node, path_iAP2ServiceInfoLocalUuid, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  sppServiceInfo._localUuid = YAJL_GET_STRING(value);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_iAP2ServiceInfoLocalUuid[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_iAP2ServiceInfoLocalUuid[0], configurationFile.c_str()));
            }

            value = yajl_tree_get(node, path_iAP2ServiceInfoRemoteUuid, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  sppServiceInfo._remoteUuid = YAJL_GET_STRING(value);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_iAP2ServiceInfoRemoteUuid[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_iAP2ServiceInfoRemoteUuid[0], configurationFile.c_str()));
            }

            sppServiceInfo._serviceName = "iAP2";
            configuration._sppServiceInformation.push_back(sppServiceInfo);
         }

         if (NULL != yajl_tree_get(node, path_CPWServiceInfoMaxNumInstances, yajl_t_number))
         {
            SppServiceInfo sppServiceInfo;

            sppServiceInfo._maxNumInstances = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_CPWServiceInfoMaxNumInstances, yajl_t_number));

            value = yajl_tree_get(node, path_CPWServiceInfoLocalUuid, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  sppServiceInfo._localUuid = YAJL_GET_STRING(value);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_CPWServiceInfoLocalUuid[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_CPWServiceInfoLocalUuid[0], configurationFile.c_str()));
            }

            value = yajl_tree_get(node, path_CPWServiceInfoRemoteUuid, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  sppServiceInfo._remoteUuid = YAJL_GET_STRING(value);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_CPWServiceInfoRemoteUuid[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_CPWServiceInfoRemoteUuid[0], configurationFile.c_str()));
            }

            sppServiceInfo._serviceName = "CPW";
            configuration._sppServiceInformation.push_back(sppServiceInfo);
         }

         if (NULL != yajl_tree_get(node, path_AAWServiceInfoMaxNumInstances, yajl_t_number))
         {
            SppServiceInfo sppServiceInfo;

            sppServiceInfo._maxNumInstances = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_AAWServiceInfoMaxNumInstances, yajl_t_number));

            value = yajl_tree_get(node, path_AAWServiceInfoLocalUuid, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  sppServiceInfo._localUuid = YAJL_GET_STRING(value);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_AAWServiceInfoLocalUuid[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_AAWServiceInfoLocalUuid[0], configurationFile.c_str()));
            }

            value = yajl_tree_get(node, path_AAWServiceInfoRemoteUuid, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  sppServiceInfo._remoteUuid = YAJL_GET_STRING(value);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_AAWServiceInfoRemoteUuid[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_AAWServiceInfoRemoteUuid[0], configurationFile.c_str()));
            }

            sppServiceInfo._serviceName = "AAW";
            configuration._sppServiceInformation.push_back(sppServiceInfo);
         }

         if (NULL != yajl_tree_get(node, path_VehicleBtFriendlyNameRead, yajl_t_number))
         {
            KdsInfo kdsInfo;

            kdsInfo._read = (bool)YAJL_GET_INTEGER(yajl_tree_get(node, path_VehicleBtFriendlyNameRead, yajl_t_number));

            value = yajl_tree_get(node, path_VehicleBtFriendlyNameDefaultValue, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  configuration._btLocalFriendlyName = YAJL_GET_STRING(value);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string, using connectivity's built-in default configuration value (= %50s)",
                        path_VehicleBtFriendlyNameDefaultValue[0], configuration._btLocalFriendlyName.c_str()));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s, using connectivity's built-in default configuration value (= %50s)",
                     path_VehicleBtFriendlyNameDefaultValue[0], configurationFile.c_str(), configuration._btLocalFriendlyName.c_str()));
            }

            value = yajl_tree_get(node, path_VehicleBtFriendlyNameKey, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  std::string str = YAJL_GET_STRING(value);

                  // convert the string to hex
                  kdsInfo._key = (uint16_t)std::stoi(str, 0, 16);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_VehicleBtFriendlyNameKey[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_VehicleBtFriendlyNameKey[0], configurationFile.c_str()));
            }

            if (NULL == yajl_tree_get(node, path_VehicleBtFriendlyNameByte, yajl_t_number))
            {
               kdsInfo._byte = 0u;
            }
            else
            {
               kdsInfo._byte = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_VehicleBtFriendlyNameByte, yajl_t_number));
            }

            if (NULL == yajl_tree_get(node, path_VehicleBtFriendlyNameLength, yajl_t_number))
            {
               kdsInfo._length = 0u;
            }
            else
            {
               kdsInfo._length = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_VehicleBtFriendlyNameLength, yajl_t_number));
            }

            kdsInfo._serviceName = "VehicleBtFriendlyName";
            configuration._kdsInformation.push_back(kdsInfo);
         }

         if (NULL != yajl_tree_get(node, path_CPWKDSInfoRead, yajl_t_number))
         {
            KdsInfo kdsInfo;

            kdsInfo._read = (bool)YAJL_GET_INTEGER(yajl_tree_get(node, path_CPWKDSInfoRead, yajl_t_number));

            if (NULL != yajl_tree_get(node, path_CPWKDSInfoDefault, yajl_t_number))
            {
               configuration._carPlayWirelessSupported = (bool)YAJL_GET_INTEGER(yajl_tree_get(node, path_CPWKDSInfoDefault, yajl_t_number));
            }
            else
            {
               configuration._carPlayWirelessSupported = false;
            }

            value = yajl_tree_get(node, path_CPWKDSInfoKey, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  std::string str = YAJL_GET_STRING(value);

                  // convert the string to hex
                  kdsInfo._key = (uint16_t)std::stoi(str, 0, 16);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_CPWKDSInfoKey[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_CPWKDSInfoKey[0], configurationFile.c_str()));
            }

            if (NULL == yajl_tree_get(node, path_CPWKDSInfoByte, yajl_t_number))
            {
               kdsInfo._byte = 0u;
            }
            else
            {
               kdsInfo._byte = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_CPWKDSInfoByte, yajl_t_number));
            }

            if (NULL == yajl_tree_get(node, path_CPWKDSInfoBit, yajl_t_number))
            {
               kdsInfo._bit = 0u;
            }
            else
            {
               kdsInfo._bit = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_CPWKDSInfoBit, yajl_t_number));
            }

            if (NULL == yajl_tree_get(node, path_CPWKDSInfoLength, yajl_t_number))
            {
               kdsInfo._length = 0u;
            }
            else
            {
               kdsInfo._length = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_CPWKDSInfoLength, yajl_t_number));
            }

            kdsInfo._serviceName = "CPW";
            configuration._kdsInformation.push_back(kdsInfo);
         }

         if (NULL != yajl_tree_get(node, path_PANKDSInfoRead, yajl_t_number))
         {
            KdsInfo kdsInfo;

            kdsInfo._read = (bool)YAJL_GET_INTEGER(yajl_tree_get(node, path_PANKDSInfoRead, yajl_t_number));

            value = yajl_tree_get(node, path_PANKDSInfoKey, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  std::string str = YAJL_GET_STRING(value);

                  // convert the string to hex
                  kdsInfo._key = (uint16_t)std::stoi(str, 0, 16);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_PANKDSInfoKey[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_PANKDSInfoKey[0], configurationFile.c_str()));
            }

            if (NULL == yajl_tree_get(node, path_PANKDSInfoByte, yajl_t_number))
            {
               kdsInfo._byte = 0u;
            }
            else
            {
               kdsInfo._byte = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_PANKDSInfoByte, yajl_t_number));
            }

            if (NULL == yajl_tree_get(node, path_PANKDSInfoBit, yajl_t_number))
            {
               kdsInfo._bit = 0u;
            }
            else
            {
               kdsInfo._bit = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_PANKDSInfoBit, yajl_t_number));
            }

            if (NULL == yajl_tree_get(node, path_PANKDSInfoLength, yajl_t_number))
            {
               kdsInfo._length = 0u;
            }
            else
            {
               kdsInfo._length = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_PANKDSInfoLength, yajl_t_number));
            }

            kdsInfo._serviceName = "PAN";
            configuration._kdsInformation.push_back(kdsInfo);
         }

         if (NULL != yajl_tree_get(node, path_AAWKDSInfoRead, yajl_t_number))
         {
            KdsInfo kdsInfo;

            kdsInfo._read = (bool)YAJL_GET_INTEGER(yajl_tree_get(node, path_AAWKDSInfoRead, yajl_t_number));

            if (NULL != yajl_tree_get(node, path_AAWKDSInfoDefault, yajl_t_number))
            {
               configuration._androidAutoWirelessSupported = (bool)YAJL_GET_INTEGER(yajl_tree_get(node, path_AAWKDSInfoDefault, yajl_t_number));
            }
            else
            {
               configuration._androidAutoWirelessSupported = false;
            }

            value = yajl_tree_get(node, path_AAWKDSInfoKey, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  std::string str = YAJL_GET_STRING(value);

                  // convert the string to hex
                  kdsInfo._key = (uint16_t)std::stoi(str, 0, 16);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_AAWKDSInfoKey[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_AAWKDSInfoKey[0], configurationFile.c_str()));
            }

            if (NULL == yajl_tree_get(node, path_AAWKDSInfoByte, yajl_t_number))
            {
               kdsInfo._byte = 0u;
            }
            else
            {
               kdsInfo._byte = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_AAWKDSInfoByte, yajl_t_number));
            }

            if (NULL == yajl_tree_get(node, path_AAWKDSInfoBit, yajl_t_number))
            {
               kdsInfo._bit = 0u;
            }
            else
            {
               kdsInfo._bit = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_AAWKDSInfoBit, yajl_t_number));
            }

            if (NULL == yajl_tree_get(node, path_AAWKDSInfoLength, yajl_t_number))
            {
               kdsInfo._length = 0u;
            }
            else
            {
               kdsInfo._length = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_AAWKDSInfoLength, yajl_t_number));
            }

            kdsInfo._serviceName = "AAW";
            configuration._kdsInformation.push_back(kdsInfo);
         }


         if (NULL != yajl_tree_get(node, path_VehicleBtOnOffRead, yajl_t_number))
         {
            KdsInfo kdsInfo;

            kdsInfo._read = (bool)YAJL_GET_INTEGER(yajl_tree_get(node, path_VehicleBtOnOffRead, yajl_t_number));

            if (NULL != yajl_tree_get(node, path_VehicleBtOnOffDefault, yajl_t_number))
            {
               configuration._btOnOffSupport = (bool)YAJL_GET_INTEGER(yajl_tree_get(node, path_VehicleBtOnOffDefault, yajl_t_number));
            }
            else
            {
               configuration._btOnOffSupport = true;
            }

            value = yajl_tree_get(node, path_VehicleBtOnOffKey, yajl_t_string);

            if (0 != value)
            {
               if (true == YAJL_IS_STRING(value))
               {
                  std::string str = YAJL_GET_STRING(value);

                  // convert the string to hex
                  kdsInfo._key = (uint16_t)std::stoi(str, 0, 16);
               }
               else
               {
                  ETG_TRACE_ERR(("readConfiguration: value of parameter %50s is not a string", path_VehicleBtOnOffKey[0]));
               }
            }
            else
            {
               ETG_TRACE_ERR(("readConfiguration: parameter %50s does not exist in configuration file %100s",
                     path_VehicleBtOnOffKey[0], configurationFile.c_str()));
            }

            if (NULL == yajl_tree_get(node, path_VehicleBtOnOffByte, yajl_t_number))
            {
               kdsInfo._byte = 0u;
            }
            else
            {
               kdsInfo._byte = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_VehicleBtOnOffByte, yajl_t_number));
            }

            if (NULL == yajl_tree_get(node, path_VehicleBtOnOffBit, yajl_t_number))
            {
               kdsInfo._bit = 0u;
            }
            else
            {
               kdsInfo._bit = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_VehicleBtOnOffBit, yajl_t_number));
            }

            if (NULL == yajl_tree_get(node, path_VehicleBtOnOffLength, yajl_t_number))
            {
               kdsInfo._length = 0u;
            }
            else
            {
               kdsInfo._length = (uint8_t)YAJL_GET_INTEGER(yajl_tree_get(node, path_VehicleBtOnOffLength, yajl_t_number));
            }

            kdsInfo._serviceName = "VehicleBtOnOff";
            configuration._kdsInformation.push_back(kdsInfo);
         }

         yajl_tree_free(node);

         result = true;
      }
   }

   delete[] fileData;
   fclose(pFile);

   return result;
}
}
