/**
 * @file ConnectionRequestData.cpp
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the definition of the class ConnectionRequestData
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ConnectionRequestData.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "ConnectionRequestData.h"
#include "FunctionTracer.h"

namespace bmcore
{
   ConnectionRequestData::ConnectionRequestData() :
         RequestData(BM_REQUEST_TYPE_CONNECTION, false, BM_CONNECTION_REQUEST_ORIGIN_UNKNOWN),
         _deviceId(0u), _protocolList(), _pageTimeout(0u), _delayConnection(false)
   {
      ENTRY_INTERNAL
   }

   ConnectionRequestData::ConnectionRequestData(const bool& internal, const ConnectionRequestOrigin& origin,
         const DeviceId& deviceId, const ProtocolList& protocolList, IN const PageTimeout& pageTimeout, const bool delayConnection) :
         RequestData(BM_REQUEST_TYPE_CONNECTION, internal, origin), _deviceId(deviceId), _protocolList(protocolList),
         _pageTimeout(pageTimeout), _delayConnection(delayConnection)
   {
      ENTRY_INTERNAL
   }

   ConnectionRequestData::ConnectionRequestData(const ConnectionRequestData& other) :
         RequestData(other), _deviceId(other._deviceId), _protocolList(other._protocolList),
         _pageTimeout(other._pageTimeout), _delayConnection(other._delayConnection)
   {
      ENTRY_INTERNAL
   }

   ConnectionRequestData::~ConnectionRequestData()
   {
      ENTRY_INTERNAL
   }

   void swap(ConnectionRequestData& first, ConnectionRequestData& second)
   {
      ENTRY_INTERNAL

      using std::swap;

      swap(static_cast<RequestData&>(first), static_cast<RequestData&>(second));
      swap(first._deviceId, second._deviceId);
      swap(first._protocolList, second._protocolList);
      swap(first._pageTimeout, second._pageTimeout);
      swap(first._delayConnection, second._delayConnection);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   ConnectionRequestData& ConnectionRequestData::operator=(ConnectionRequestData other)
   {
      ENTRY_INTERNAL

      swap(*this, other);

      return *this;
   }

   bool ConnectionRequestData::operator==(const ConnectionRequestData& rhs) const
   {
      ENTRY_INTERNAL

      return (RequestData::operator ==(rhs)
            && (this->_deviceId == rhs._deviceId)
            && (this->_protocolList == rhs._protocolList)
            && (this->_pageTimeout == rhs._pageTimeout)
            && (this->_delayConnection == rhs._delayConnection));
   }
}
