/**
 * @file BmVarTrace.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of variable tracing functions used by Bluetooth Connection Manager Core
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef BM_VAR_TRACE_H_
#define BM_VAR_TRACE_H_

#include "BmInterfaceTypesInternal.h"
#include "BmAllTypes.h"
#include "BtStackIfTypes.h"
#include "ProtocolConnectionController.h"

namespace bmcore
{
   #define MAXNAME 200

   #define CHECK_NULL(a) (a ? a : "NULL")

#ifdef VARIANT_S_FTR_ENABLE_ETG_PRINTF
   #define VARTRACE_ON 0    // TODO: introduced for utest; to be checked
#else
   #ifdef TARGET_BUILD
      #define VARTRACE_ON 1 // = 1: variable tracing switched on, = 0: off
   #else
      #define VARTRACE_ON 1 // = 1: variable tracing switched on, = 0: off
   #endif
#endif

   #ifdef TARGET_BUILD
      typedef unsigned short tClassType;
   #else
      typedef const char * tClassType;
   #endif

#if VARTRACE_ON
   #define VARTRACE(a) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, 3, __FILE__,__LINE__);
   #define VARTRACE_USR2(a) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, 2, __FILE__,__LINE__);
   #define VARTRACE_USR4(a) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, 4, __FILE__,__LINE__);
   #define VARTRACE2(a,b) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b, __FILE__,__LINE__);
   #define VARTRACE3(a,b,c) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b,  c, #c, __FILE__,__LINE__);
   #define VARTRACE4(a,b,c,d) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b, c, #c, d, #d, __FILE__,__LINE__);
   #define VARTRACE5(a,b,c,d,e) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b, c, #c, d, #d, e, #e, __FILE__,__LINE__);
   #define VARTRACE6(a,b,c,d,e,f) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b, c, #c, d, #d, e, #e, f, #f, __FILE__,__LINE__);
   #define VARTRACE7(a,b,c,d,e,f,g) VarTrace(ETG_DEFAULT_TRACE_CLASS, a, #a, b, #b, c, #c, d, #d, e, #e, f, #f, g, #g,__FILE__,__LINE__);

   #define VARTRACEMIN(a) VarTraceMin(ETG_DEFAULT_TRACE_CLASS, a, #a, __FILE__,__LINE__);
#else
   #define VARTRACE(a)
   #define VARTRACE_USR2(a)
   #define VARTRACE_USR4(a)
   #define VARTRACE2(a,b)
   #define VARTRACE3(a,b,c)
   #define VARTRACE4(a,b,c,d)
   #define VARTRACE5(a,b,c,d,e)
   #define VARTRACE6(a,b,c,d,e,f)
   #define VARTRACE7(a,b,c,d,e,f,g)
#endif

   const char* removePath(const char *path);

   void VarTrace(tClassType cls, ComponentState var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, CcErrorInternal var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, const char* var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, bool var,const char* name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, int var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, unsigned int var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   #ifdef __x86_64 // todo: make this better: only different to unsigned int on 64 bit machines
      void VarTrace(tClassType cls, size_t var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);
   #endif

   void VarTrace(tClassType cls, float var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, char var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, short var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, unsigned char* var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, unsigned char var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, unsigned short var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, long long var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, unsigned long long var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

//   void VarTrace(tClassType cls, std::vector <tUInt> var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, std::string var,const char *name, const unsigned char level, const char *file=NULL, const int line=-1);

   void VarTrace(tClassType cls, SwitchStatus var, const char* name, const unsigned char level, const char* file = NULL, const int line = -1);

   void VarTrace(tClassType cls, BtSystemState var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, LocalFriendlyName var, const char* name, const unsigned char level, const char* file = NULL, const int line = -1);

   void VarTrace(tClassType cls, const LocalInfo& var, const char* name, const unsigned char level, const char* file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProtocolInfo var, const char* name, const unsigned char level, const char* file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProtocolInfoMap var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, UsagePreference var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, InbandRingtoneSupport var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, AbsoluteVolumeSupport var, const char* name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, PairingStatus var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, PairingPin var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   //!Fix for CID 29997: Big parameter passed by value (PASS_BY_VALUE)
   void VarTrace(tClassType cls, const DeviceBaseInfo& var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, DeviceBaseInfoList var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, PairedDeviceList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, const DiscoveredDeviceInfo& var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, DiscoveredDeviceInfoList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, DiscoveredDeviceList var, const char* name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, DeviceIdentification var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ConnectionOrderInfo var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, BTSMajorDeviceClass var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ConnectionStatus var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, DisconnectedReason var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProtocolConnectionInfo var, const char* name, const unsigned char level, const char* file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProtocolConnectionInfoMap var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, SppConnectionInfoMap var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProtocolIdList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, DeviceIdList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, UuidList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProtocolList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, const DeviceConnectionInfo& var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, DeviceConnectionInfoList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, DeviceConnectionStatusList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   //!Fix for CID 22856: Big parameter passed by value (PASS_BY_VALUE)
   void VarTrace(tClassType cls, const RemoteDeviceInfo& var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, AutoConnectionType var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, AutoConnectionStatus var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, OverallDeviceBlockStatus var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, BlockState var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProtocolBlockStatusMap var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, DeviceBlockStatus var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, DeviceBlockStatusList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, BlockStatus var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, BmConfigData var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, BmServiceAvailability var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, BtLimitationModeInfo var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, BtLimitationModeInfoList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, BtLimitationMode var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, IssueInfo var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, IssueInfoList var,const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ConflictInfoList var, const char* name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ResetToDefaultStatus var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, LinkQuality var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, TestModeLinkQuality var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProtocolConnectionController* var,const char* name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProtocolConnectionControllerList& var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProfileUsageInfoList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProfileUsageList var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

   void VarTrace(tClassType cls, ProfileUsageInfo var,const char* name, const unsigned char level, const char *file = NULL, const int line= -1);
   
   void VarTrace(tClassType cls, DeviceProtocolListMap var, const char *name, const unsigned char level, const char *file = NULL, const int line = -1);

}

#endif // BM_VAR_TRACE_H_
