/**
 * @file BmUtils.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of utility functions used by Bluetooth Connection Manager Core
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _BM_UTILS_H_
#define _BM_UTILS_H_

#include "BmAllTypes.h"
#include "BtStackIfTypes.h"
#include <unistd.h>

namespace bmcore
{
   bool isValidBluetoothSystemState(IN const BluetoothSystemState bluetoothSystemState);

   bool isValidLimitationMode(IN const LimitationMode& limitationMode);

   bool isValidLimitationAction(IN const LimitationAction limitationAction);

   bool isValidTargetSwitchState(IN const TargetSwitchState targetSwitchState);

   bool isValidBdAddress(IN const BdAddress& bdAddress, IN const bool allowEmpty = false);

   bool isValidUuid(IN const Uuid& address, IN const bool allowEmpty = false);

   bool isValidLocalBdName(IN const LocalFriendlyNameType& localBdName);

   bool isValidLegacyPairingPin(IN const PairingPinType& legacyPairingPin, IN const bool allowEmpty = false);

   bool isValidSspPin(IN const SspPinCode& sspPin, IN const bool allowEmpty = false);

   bool isValidRequestType(IN const RequestType& requestType);

   bool isValidDeviceHandleType(IN const DeviceHandleType& deviceHandleType,
         IN const bool isBlockDeviceRequest = false);

   bool isValidStandardAutoConnectionType(IN const StandardAutoConnectionType standardAutoConnectionType);

   bool isValidTemporaryAutoConnectionType(IN const TemporaryAutoConnectionType temporaryAutoConnectionType);

   bool isValidAutoConnectionStartMode(IN const AutoConnectionStartMode autoConnectionStartMode);

   bool isValidProtocolId(IN const ProtocolId protocolId);

   bool isValidOobType(IN const OobType oobType);

   bool isValidFavoriteType(IN const FavoriteType favoriteType);

   bool isValidUsagePreference(IN const UsagePreference usagePreference);

   void convertBdAddress2LowerCase(INOUT BdAddress& bdAddress);

   Result getBmSwitchStateFromBtsBluetoothMode(OUT SwitchState& switchState,
         IN const BTSBluetoothMode btsBluetoothMode);

   Result getBmSwitchStateFromBtsLocalMode(OUT SwitchState& switchState, IN const BTSLocalMode btsLocalMode);

   Result getBmSwitchedOffReasonFromBtsBluetoothOffReason(OUT SwitchedOffReason& switchedOffReason,
         IN const BTSBluetoothOffReason btsBluetoothOffReason);

   Result getBmSwitchedOffReasonFromBtsLocalModeOffReason(OUT SwitchedOffReason& switchedOffReason,
         IN const BTSLocalModeOffReason btsOffReason);

   Result getBmSwitchStateFromBtsDiscoveringStatus(OUT SwitchState& switchState,
         IN const BTSDiscoveringStatus btsDiscoveringStatus);

   Result getBtsSspModeFromBmPairingType(OUT BTSSspMode& btsSspMode, IN const PairingType pairingType);

   Result getBmPairingTypeFromBtsSspMode(OUT PairingType& pairingType, IN const BTSSspMode btsSspMode);

   Result getBtsSupportedServicesBitFromBmProtocolId(OUT BTSSupportedServicesBit& btsSupportedServicesBit,
         IN const ProtocolId protocolId);

   Result getBmProtocolIdFromBtsSupportedServicesBit(OUT ProtocolId& protocolId,
         IN const BTSSupportedServicesBit btsSupportedServicesBit);

   Result getBtsProtocolIdFromBmProtocolId(OUT BTSProtocolId& btsProtocolId, IN const ProtocolId protocolId);

   Result getBmProtocolIdFromBtsProtocolId(OUT ProtocolId& protocolId, IN const BTSProtocolId btsProtocolId);

   Result getBmDisconnectedReasonFromBtsDisconnectReason(OUT DisconnectedReason& disconnectedReason,
         IN const BTSDisconnectReason btsDisconnectReason);
}

#endif /* _BM_UTILS_H_ */
