/**
 * @file BmTraceClasses.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the definition of all trace classes used by Bluetooth Connection Manager Core
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _BM_TRACE_CLASSES_H_
#define _BM_TRACE_CLASSES_H_

namespace bmcore
{
   // see \ai_osal_linux\components\bosch_includes\trace\mc_trace.h
   // TODO: check how to include file with TR_COMP_XXX definitions
   #define TR_COMP_CONNECTIVITY     (256 * 59)
   #define BM_OFFSET 0x48


   #ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   enum TraceClassesBmCore
   {
      TR_CLASS_BM_CORE_BMCONTROLLER                 = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x00,
      TR_CLASS_BM_CORE_UTILS                        = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x01,
      TR_CLASS_BM_CORE_IF_MESSAGES                  = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x02,
      TR_CLASS_BM_CORE_DATAPROVIDER                 = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x03,
      TR_CLASS_BM_CORE_DBMANAGER                    = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x04,
      TR_CLASS_BM_CORE_DCCONTROLLER                 = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x05,
      TR_CLASS_BM_CORE_INTERFACE                    = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x06,
      TR_CLASS_BM_CORE_LOCALSPM                     = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x07,
      TR_CLASS_BM_CORE_PAIRINGCONTROLLER            = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x08,
      TR_CLASS_BM_CORE_PCCONTROLLER                 = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x09,
      TR_CLASS_BM_CORE_APPLICATION                  = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x0A,
      TR_CLASS_BM_CORE_TEST                         = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x0B,
      TR_CLASS_BM_CORE_VARIABLE                     = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x0C,
      TR_CLASS_BM_CORE_PROPERTY                     = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x0D,
      TR_CLASS_BM_CORE_AUTO_CONNECTION_CONTROLLER   = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x0E,
      TR_CLASS_BM_CORE_RESET_TO_DEFAULT_CONTROLLER  = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x0F,
      TR_CLASS_BM_CORE_BT_LIMITATION_CONTROLLER     = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x10,
      TR_CLASS_BM_CORE_MAIN_CONTROLLER              = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x11,
      TR_CLASS_BM_CORE_CONFLICTMANAGER              = TR_COMP_CONNECTIVITY + BM_OFFSET + 0x12
   };

   #else

   #define TR_CLASS_BM_CORE_BMCONTROLLER "BM_CORE_BMCONTROLLER"
   #define TR_CLASS_BM_CORE_UTILS "BM_CORE_UTILS"
   #define TR_CLASS_BM_CORE_IF_MESSAGES "BM_CORE_IF_MESSAGES"
   #define TR_CLASS_BM_CORE_DATAPROVIDER "BM_CORE_DATAPROVIDER"
   #define TR_CLASS_BM_CORE_DBMANAGER "BM_CORE_DBMANAGER"
   #define TR_CLASS_BM_CORE_DCCONTROLLER "BM_CORE_DCCONTROLLER"
   #define TR_CLASS_BM_CORE_INTERFACE "BM_CORE_INTERFACE"
   #define TR_CLASS_BM_CORE_LOCALSPM "BM_CORE_LOCALSPM"
   #define TR_CLASS_BM_CORE_PAIRINGCONTROLLER "BM_CORE_PAIRINGCONTROLLER"
   #define TR_CLASS_BM_CORE_PCCONTROLLER "BM_CORE_PCCONTROLLER"

   #define TR_CLASS_BM_CORE_APPLICATION "BM_CORE_APPLICATION"
   #define TR_CLASS_BM_CORE_TEST "BM_CORE_TEST"
   #define TR_CLASS_BM_CORE_VARIABLE "BM_CORE_VARIABLE"
   #define TR_CLASS_BM_CORE_PROPERTY "BM_CORE_PROPERTY"
   #define TR_CLASS_BM_CORE_AUTO_CONNECTION_CONTROLLER "BM_CORE_AUTO_CONNECTION_CONTROLLER"
   #define TR_CLASS_BM_CORE_RESET_TO_DEFAULT_CONTROLLER "BM_CORE_RESET_TO_DEFAULT_CONTROLLER"
   #define TR_CLASS_BM_CORE_BT_LIMITATION_CONTROLLER "BM_CORE_BT_LIMITATION_CONTROLLER"
   #define TR_CLASS_BM_CORE_MAIN_CONTROLLER "BM_CORE_MAIN_CONTROLLER"
   #define TR_CLASS_BM_CORE_CONFLICTMANAGER "BM_CORE_CONFLICTMANAGER"

   #endif
}

#endif // _BM_TRACE_CLASSES_H_
