/**
 * @file BmMeetsBdAddressImpl.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the definition of template class MeetsBdAddress
 *
 * @copyright (c) 2017 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _BM_MEETS_BD_ADDRESS_IMPL_
#define _BM_MEETS_BD_ADDRESS_IMPL_

#include "BmMeetsBdAddress.h"

namespace bmcore
{
   template<class ItemType>
   MeetsBdAddress<ItemType>::MeetsBdAddress(const BdAddress& bdAddress) : _bdAddress(bdAddress)
   {
   }

   template<class ItemType>
   bool MeetsBdAddress<ItemType>::operator()(const ItemType& item) const
   {
      return (item._bdAddress == _bdAddress);
   }
}

#endif // _BM_MEETS_BD_ADDRESS_IMPL_
