/**
 * @file BmMeetsBdAddress.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of template class MeetsBdAddress
 *
 * @copyright (c) 2017 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _BM_MEETS_BD_ADDRESS_
#define _BM_MEETS_BD_ADDRESS_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   template<class ItemType>
   class MeetsBdAddress
   {
   public:

      explicit MeetsBdAddress(const BdAddress& bdAddress);

      bool operator()(const ItemType& item) const;

   private:
      BdAddress _bdAddress;
   };
}

#endif // _BM_MEETS_BD_ADDRESS_
