/**
 * @file BmGlobalLock.h
 *
 * @par SW-Component
 * Bluetooth Connection Manager Core
 *
 * @brief This file contains the declaration of global lock used by Bluetooth Connection Manager Core
 *
 * @copyright (c) 2016 Robert Bosch GmbH
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmCoreModule
 */

#ifndef _BM_GLOBAL_LOCK_H_
#define _BM_GLOBAL_LOCK_H_

#include "FwLock.h"

// #define BM_GLOBAL_LOCKER_BTSTACKIF
#define BM_GLOBAL_LOCKER_BTSTACKIF Locker globalLocker(::bmcore::BmGlobalLock::getInstance().getLockPtr());
// #define BM_GLOBAL_LOCKER_APP_LAYER
#define BM_GLOBAL_LOCKER_APP_LAYER Locker globalLocker(::bmcore::BmGlobalLock::getInstance().getLockPtr());
// #define BM_GLOBAL_LOCKER_INTERNAL
#define BM_GLOBAL_LOCKER_INTERNAL Locker globalLocker(::bmcore::BmGlobalLock::getInstance().getLockPtr());
// #define BM_SET_GLOBAL_SM_LOCK
#define BM_SET_GLOBAL_SM_LOCK setGlobalLock(::bmcore::BmGlobalLock::getInstance().getLockPtr());

namespace bmcore
{
   /**
    *
    */
   class BmGlobalLock
   {
   public:
      /**
       * Get instance of global lock.
       *
       * @return = reference to global lock
       */
      static BmGlobalLock& getInstance(void);

      /**
       * Get lock.
       *
       * @return = pointer to lock
       */
      inline Lock* getLockPtr(void) { return &_lock; }

      /**
       * Get lock.
       *
       * @return = pointer to lock
       */
      inline const Lock* getLockPtr(void) const { return &_lock; }

      /**
       * Get lock.
       *
       * @return = reference to lock
       */
      inline Lock& getLockRef(void) { return _lock; }

      /**
       * Get lock.
       *
       * @return = reference to lock
       */
      inline const Lock& getLockRef(void) const { return _lock; }

   private:
      /**
       * Default constructor. Private!!!
       */
      BmGlobalLock();

      /**
       * Destructor. Private!!!
       */
      virtual ~BmGlobalLock();

      LockForeverAndNonReentrant _lock; /**< lock */
   };
}

#endif /* _BM_GLOBAL_LOCK_H_ */
