#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_IF_MESSAGES
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BmCoreIfMessages.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_IF_MESSAGES
#endif
#endif

#include "BmCoreIfMessages.h"
#include "BmVarTrace.h"

namespace bmcore
{
   // *****************************************************************************************
   // ******************** Messages corresponding to BM Core IF calls *************************
   // *****************************************************************************************

   BmCoreIfMessage_SetProtocolUserAvailabilityRequest::BmCoreIfMessage_SetProtocolUserAvailabilityRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_PROFILE_USER_AVAILABILITY_REQUEST, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _protocol(),
         _available(false)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetProtocolUserAvailabilityRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetProtocolUserAvailabilityRequest::BmCoreIfMessage_SetProtocolUserAvailabilityRequest(IN const Protocol& protocol,
         IN const bool available, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_PROFILE_USER_AVAILABILITY_REQUEST, BM_RESTRICTION_GROUP_00, act, origin),
               _protocol(protocol),
               _available(available)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetProtocolUserAvailabilityRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetProtocolUserAvailabilityRequest::BmCoreIfMessage_SetProtocolUserAvailabilityRequest(IN const BmCoreIfMessage_SetProtocolUserAvailabilityRequest& other) :
      BmCoreIfMessage(other),
      _protocol(other._protocol),
      _available(other._available)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetProtocolUserAvailabilityRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetProtocolUserAvailabilityRequest::~BmCoreIfMessage_SetProtocolUserAvailabilityRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetProtocolUserAvailabilityRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_SetProtocolUserAvailabilityRequest& first, BmCoreIfMessage_SetProtocolUserAvailabilityRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._protocol, second._protocol);
      swap(first._available, second._available);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SetProtocolUserAvailabilityRequest& BmCoreIfMessage_SetProtocolUserAvailabilityRequest::operator=(BmCoreIfMessage_SetProtocolUserAvailabilityRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SetProtocolUserAvailabilityRequest::operator==(const BmCoreIfMessage_SetProtocolUserAvailabilityRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_protocol == rhs._protocol)
            && (this->_available == rhs._available));
   }

   BmCoreIfMessage* BmCoreIfMessage_SetProtocolUserAvailabilityRequest::clone(void) const
   {
      return new BmCoreIfMessage_SetProtocolUserAvailabilityRequest(*this);
   }

   void BmCoreIfMessage_SetProtocolUserAvailabilityRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] protocol = (%d, \"%50s\"), available = %10s",
            (const void*) this, ETG_CENUM(ProtocolId, _protocol._protocolId), _protocol._uuid.c_str(),
            _available ? "true" : "false"));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SetAutoConnectionTypeRequest::BmCoreIfMessage_SetAutoConnectionTypeRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_AUTO_CONNECTION_TYPE_REQUEST, BM_RESTRICTION_GROUP_03,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _autoConnectionType()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetAutoConnectionTypeRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetAutoConnectionTypeRequest::BmCoreIfMessage_SetAutoConnectionTypeRequest(IN const AutoConnectionType& autoConnectionType,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_AUTO_CONNECTION_TYPE_REQUEST, BM_RESTRICTION_GROUP_03, act, origin),
               _autoConnectionType(autoConnectionType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetAutoConnectionTypeRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetAutoConnectionTypeRequest::BmCoreIfMessage_SetAutoConnectionTypeRequest(IN const BmCoreIfMessage_SetAutoConnectionTypeRequest& other) :
      BmCoreIfMessage(other),
      _autoConnectionType(other._autoConnectionType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetAutoConnectionTypeRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetAutoConnectionTypeRequest::~BmCoreIfMessage_SetAutoConnectionTypeRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetAutoConnectionTypeRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_SetAutoConnectionTypeRequest& first, BmCoreIfMessage_SetAutoConnectionTypeRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._autoConnectionType, second._autoConnectionType);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SetAutoConnectionTypeRequest& BmCoreIfMessage_SetAutoConnectionTypeRequest::operator=(BmCoreIfMessage_SetAutoConnectionTypeRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SetAutoConnectionTypeRequest::operator==(const BmCoreIfMessage_SetAutoConnectionTypeRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_autoConnectionType == rhs._autoConnectionType));
   }

   BmCoreIfMessage* BmCoreIfMessage_SetAutoConnectionTypeRequest::clone(void) const
   {
      return new BmCoreIfMessage_SetAutoConnectionTypeRequest(*this);
   }

   void BmCoreIfMessage_SetAutoConnectionTypeRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] autoConnectionType._type = %d",
            (const void*) this, ETG_CENUM(StandardAutoConnectionType, _autoConnectionType._type)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SwitchBtStatusRequest::BmCoreIfMessage_SwitchBtStatusRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_BT_STATUS_REQUEST, BM_RESTRICTION_GROUP_03,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _targetSwitchState(TARGET_SWITCH_STATE_SWITCHED_OFF),
         _suppressAutoConnectionAfterSwitchedOn(false),
         _delayBtOnRequest(false),
         _updateLastMode(true)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchBtStatusRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchBtStatusRequest::BmCoreIfMessage_SwitchBtStatusRequest(IN const TargetSwitchState targetSwitchState,
         IN const bool suppressAutoConnectionAfterSwitchedOn, IN const bool delayBtOnRequest, IN const bool updateLastMode,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_BT_STATUS_REQUEST, BM_RESTRICTION_GROUP_03, act, origin),
         _targetSwitchState(targetSwitchState),
         _suppressAutoConnectionAfterSwitchedOn(suppressAutoConnectionAfterSwitchedOn),
         _delayBtOnRequest(delayBtOnRequest),
         _updateLastMode(updateLastMode)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchBtStatusRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchBtStatusRequest::BmCoreIfMessage_SwitchBtStatusRequest(IN const BmCoreIfMessage_SwitchBtStatusRequest& other) :
      BmCoreIfMessage(other),
      _targetSwitchState(other._targetSwitchState),
      _suppressAutoConnectionAfterSwitchedOn(other._suppressAutoConnectionAfterSwitchedOn),
      _delayBtOnRequest(other._delayBtOnRequest),
      _updateLastMode(other._updateLastMode)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchBtStatusRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchBtStatusRequest::~BmCoreIfMessage_SwitchBtStatusRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchBtStatusRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_SwitchBtStatusRequest& first, BmCoreIfMessage_SwitchBtStatusRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._targetSwitchState, second._targetSwitchState);
      swap(first._suppressAutoConnectionAfterSwitchedOn, second._suppressAutoConnectionAfterSwitchedOn);
      swap(first._delayBtOnRequest, second._delayBtOnRequest);
      swap(first._updateLastMode, second._updateLastMode);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SwitchBtStatusRequest& BmCoreIfMessage_SwitchBtStatusRequest::operator=(BmCoreIfMessage_SwitchBtStatusRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SwitchBtStatusRequest::operator==(const BmCoreIfMessage_SwitchBtStatusRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_targetSwitchState == rhs._targetSwitchState)
            && (this->_suppressAutoConnectionAfterSwitchedOn == rhs._suppressAutoConnectionAfterSwitchedOn)
            && (this->_delayBtOnRequest == rhs._delayBtOnRequest)
            && (this->_updateLastMode == rhs._updateLastMode));
   }

   BmCoreIfMessage* BmCoreIfMessage_SwitchBtStatusRequest::clone(void) const
   {
      return new BmCoreIfMessage_SwitchBtStatusRequest(*this);
   }

   void BmCoreIfMessage_SwitchBtStatusRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] targetSwitchState = %d, suppressAutoConnectionAfterSwitchedOn = %10s, delayRequest = %10s, updateLastMode = %10s",
            (const void*) this, ETG_CENUM(TargetSwitchState, _targetSwitchState),
            _suppressAutoConnectionAfterSwitchedOn ? "true" : "false",
            _delayBtOnRequest ? "true": "false",
            _updateLastMode ? "true" : "false"));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SetBtLocalFriendlyNameRequest::BmCoreIfMessage_SetBtLocalFriendlyNameRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_BT_LOCAL_FRIENDLY_NAME_REQUEST, BM_RESTRICTION_GROUP_03,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _localFriendlyName("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtLocalFriendlyNameRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetBtLocalFriendlyNameRequest::BmCoreIfMessage_SetBtLocalFriendlyNameRequest(IN const LocalFriendlyNameType& localFriendlyName,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_BT_LOCAL_FRIENDLY_NAME_REQUEST, BM_RESTRICTION_GROUP_03, act, origin),
         _localFriendlyName(localFriendlyName)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtLocalFriendlyNameRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetBtLocalFriendlyNameRequest::BmCoreIfMessage_SetBtLocalFriendlyNameRequest(IN const BmCoreIfMessage_SetBtLocalFriendlyNameRequest& other) :
      BmCoreIfMessage(other),
      _localFriendlyName(other._localFriendlyName)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtLocalFriendlyNameRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetBtLocalFriendlyNameRequest::~BmCoreIfMessage_SetBtLocalFriendlyNameRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtLocalFriendlyNameRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_SetBtLocalFriendlyNameRequest& first, BmCoreIfMessage_SetBtLocalFriendlyNameRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._localFriendlyName, second._localFriendlyName);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SetBtLocalFriendlyNameRequest& BmCoreIfMessage_SetBtLocalFriendlyNameRequest::operator=(BmCoreIfMessage_SetBtLocalFriendlyNameRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SetBtLocalFriendlyNameRequest::operator==(const BmCoreIfMessage_SetBtLocalFriendlyNameRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_localFriendlyName == rhs._localFriendlyName));
   }

   BmCoreIfMessage* BmCoreIfMessage_SetBtLocalFriendlyNameRequest::clone(void) const
   {
      return new BmCoreIfMessage_SetBtLocalFriendlyNameRequest(*this);
   }

   void BmCoreIfMessage_SetBtLocalFriendlyNameRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] _localFriendlyName = \"%50s\"",
            (const void*) this, _localFriendlyName.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SwitchLocalPairableModeRequest::BmCoreIfMessage_SwitchLocalPairableModeRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_LOCAL_PAIRABLE_MODE_REQUEST, BM_RESTRICTION_GROUP_04,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _targetSwitchState(TARGET_SWITCH_STATE_SWITCHED_OFF),
         _bdAddress("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessageSwitchLocalPairableModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchLocalPairableModeRequest::BmCoreIfMessage_SwitchLocalPairableModeRequest(IN const TargetSwitchState targetSwitchState,
         IN const BdAddress& bdAddress, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_LOCAL_PAIRABLE_MODE_REQUEST, BM_RESTRICTION_GROUP_04, act, origin),
         _targetSwitchState(targetSwitchState),
         _bdAddress(bdAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessageSwitchLocalPairableModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchLocalPairableModeRequest::BmCoreIfMessage_SwitchLocalPairableModeRequest(IN const BmCoreIfMessage_SwitchLocalPairableModeRequest& other) :
      BmCoreIfMessage(other),
      _targetSwitchState(other._targetSwitchState),
      _bdAddress(other._bdAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessageSwitchLocalPairableModeRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchLocalPairableModeRequest::~BmCoreIfMessage_SwitchLocalPairableModeRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessageSwitchLocalPairableModeRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_SwitchLocalPairableModeRequest& first, BmCoreIfMessage_SwitchLocalPairableModeRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._targetSwitchState, second._targetSwitchState);
      swap(first._bdAddress, second._bdAddress);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SwitchLocalPairableModeRequest& BmCoreIfMessage_SwitchLocalPairableModeRequest::operator=(BmCoreIfMessage_SwitchLocalPairableModeRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SwitchLocalPairableModeRequest::operator==(const BmCoreIfMessage_SwitchLocalPairableModeRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_targetSwitchState == rhs._targetSwitchState)
            && (this->_bdAddress == rhs._bdAddress));
   }

   BmCoreIfMessage* BmCoreIfMessage_SwitchLocalPairableModeRequest::clone(void) const
   {
      return new BmCoreIfMessage_SwitchLocalPairableModeRequest(*this);
   }

   void BmCoreIfMessage_SwitchLocalPairableModeRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] targetSwitchState = %d, bdAddress = \"%50s\"",
            (const void*) this, ETG_CENUM(TargetSwitchState, _targetSwitchState), _bdAddress.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SwitchLocalConnectableModeRequest::BmCoreIfMessage_SwitchLocalConnectableModeRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_LOCAL_CONNECTABLE_MODE_REQUEST, BM_RESTRICTION_GROUP_04,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _targetSwitchState(TARGET_SWITCH_STATE_SWITCHED_OFF),
         _bdAddress("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchLocalConnectableModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchLocalConnectableModeRequest::BmCoreIfMessage_SwitchLocalConnectableModeRequest(IN const TargetSwitchState targetSwitchState,
         IN const BdAddress& bdAddress, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_LOCAL_CONNECTABLE_MODE_REQUEST, BM_RESTRICTION_GROUP_04, act, origin),
         _targetSwitchState(targetSwitchState),
         _bdAddress(bdAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchLocalConnectableModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchLocalConnectableModeRequest::BmCoreIfMessage_SwitchLocalConnectableModeRequest(IN const BmCoreIfMessage_SwitchLocalConnectableModeRequest& other) :
      BmCoreIfMessage(other),
      _targetSwitchState(other._targetSwitchState),
      _bdAddress(other._bdAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchLocalConnectableModeRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchLocalConnectableModeRequest::~BmCoreIfMessage_SwitchLocalConnectableModeRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchLocalConnectableModeRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_SwitchLocalConnectableModeRequest& first, BmCoreIfMessage_SwitchLocalConnectableModeRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._targetSwitchState, second._targetSwitchState);
      swap(first._bdAddress, second._bdAddress);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SwitchLocalConnectableModeRequest& BmCoreIfMessage_SwitchLocalConnectableModeRequest::operator=(BmCoreIfMessage_SwitchLocalConnectableModeRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SwitchLocalConnectableModeRequest::operator==(const BmCoreIfMessage_SwitchLocalConnectableModeRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_targetSwitchState == rhs._targetSwitchState)
            && (this->_bdAddress == rhs._bdAddress));
   }

   BmCoreIfMessage* BmCoreIfMessage_SwitchLocalConnectableModeRequest::clone(void) const
   {
      return new BmCoreIfMessage_SwitchLocalConnectableModeRequest(*this);
   }

   void BmCoreIfMessage_SwitchLocalConnectableModeRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] targetSwitchState = %d, bdAddress = \"%50s\"",
            (const void*) this, ETG_CENUM(TargetSwitchState, _targetSwitchState), _bdAddress.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SwitchDiscoveryStatusRequest::BmCoreIfMessage_SwitchDiscoveryStatusRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_DISCOVERY_STATUS_REQUEST, BM_RESTRICTION_GROUP_04,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _targetSwitchState(TARGET_SWITCH_STATE_SWITCHED_OFF)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchDiscoveryStatusRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchDiscoveryStatusRequest::BmCoreIfMessage_SwitchDiscoveryStatusRequest(IN const TargetSwitchState targetSwitchState,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_DISCOVERY_STATUS_REQUEST, BM_RESTRICTION_GROUP_04, act, origin),
         _targetSwitchState(targetSwitchState)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchDiscoveryStatusRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchDiscoveryStatusRequest::BmCoreIfMessage_SwitchDiscoveryStatusRequest(IN const BmCoreIfMessage_SwitchDiscoveryStatusRequest& other) :
      BmCoreIfMessage(other),
      _targetSwitchState(other._targetSwitchState)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchDiscoveryStatusRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchDiscoveryStatusRequest::~BmCoreIfMessage_SwitchDiscoveryStatusRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchDiscoveryStatusRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_SwitchDiscoveryStatusRequest& first, BmCoreIfMessage_SwitchDiscoveryStatusRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._targetSwitchState, second._targetSwitchState);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SwitchDiscoveryStatusRequest& BmCoreIfMessage_SwitchDiscoveryStatusRequest::operator=(BmCoreIfMessage_SwitchDiscoveryStatusRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SwitchDiscoveryStatusRequest::operator==(const BmCoreIfMessage_SwitchDiscoveryStatusRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_targetSwitchState == rhs._targetSwitchState));
   }

   BmCoreIfMessage* BmCoreIfMessage_SwitchDiscoveryStatusRequest::clone(void) const
   {
      return new BmCoreIfMessage_SwitchDiscoveryStatusRequest(*this);
   }

   void BmCoreIfMessage_SwitchDiscoveryStatusRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] targetSwitchState = %d",
            (const void*) this, ETG_CENUM(TargetSwitchState, _targetSwitchState)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_PairingStatusUpdate::BmCoreIfMessage_PairingStatusUpdate() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_PAIRING_STATUS_UPDATE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _pairingStatus()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_PairingStatusUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_PairingStatusUpdate::BmCoreIfMessage_PairingStatusUpdate(IN const PairingStatus& pairingStatus) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_PAIRING_STATUS_UPDATE, BM_RESTRICTION_GROUP_00, 0u,
               BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _pairingStatus(pairingStatus)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_PairingStatusUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_PairingStatusUpdate::BmCoreIfMessage_PairingStatusUpdate(IN const BmCoreIfMessage_PairingStatusUpdate& other) :
         BmCoreIfMessage(other),
         _pairingStatus(other._pairingStatus)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_PairingStatusUpdate: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_PairingStatusUpdate::~BmCoreIfMessage_PairingStatusUpdate()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_PairingStatusUpdate: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_PairingStatusUpdate& first, BmCoreIfMessage_PairingStatusUpdate& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._pairingStatus, second._pairingStatus);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_PairingStatusUpdate& BmCoreIfMessage_PairingStatusUpdate::operator=(BmCoreIfMessage_PairingStatusUpdate other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_PairingStatusUpdate::operator==(const BmCoreIfMessage_PairingStatusUpdate& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_pairingStatus == rhs._pairingStatus));
   }

   BmCoreIfMessage* BmCoreIfMessage_PairingStatusUpdate::clone(void) const
   {
      return new BmCoreIfMessage_PairingStatusUpdate(*this);
   }

   void BmCoreIfMessage_PairingStatusUpdate::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      VARTRACE_USR4(_pairingStatus);
   }

   // *****************************************************************************************

   BmCoreIfMessage_PairedDeviceListUpdate::BmCoreIfMessage_PairedDeviceListUpdate() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_PAIRED_DEVICE_LIST_UPDATE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _pairedDeviceList()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_PairedDeviceListUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_PairedDeviceListUpdate::BmCoreIfMessage_PairedDeviceListUpdate(IN const PairedDeviceList& pairedDeviceList) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_PAIRED_DEVICE_LIST_UPDATE, BM_RESTRICTION_GROUP_00, 0u,
               BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _pairedDeviceList(pairedDeviceList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_PairedDeviceListUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_PairedDeviceListUpdate::BmCoreIfMessage_PairedDeviceListUpdate(IN const BmCoreIfMessage_PairedDeviceListUpdate& other) :
      BmCoreIfMessage(other),
      _pairedDeviceList(other._pairedDeviceList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_PairedDeviceListUpdate: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_PairedDeviceListUpdate::~BmCoreIfMessage_PairedDeviceListUpdate()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_PairedDeviceListUpdate: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_PairedDeviceListUpdate& first, BmCoreIfMessage_PairedDeviceListUpdate& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._pairedDeviceList, second._pairedDeviceList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_PairedDeviceListUpdate& BmCoreIfMessage_PairedDeviceListUpdate::operator=(BmCoreIfMessage_PairedDeviceListUpdate other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_PairedDeviceListUpdate::operator==(const BmCoreIfMessage_PairedDeviceListUpdate& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_pairedDeviceList == rhs._pairedDeviceList));
   }

   BmCoreIfMessage* BmCoreIfMessage_PairedDeviceListUpdate::clone(void) const
   {
      return new BmCoreIfMessage_PairedDeviceListUpdate(*this);
   }

   void BmCoreIfMessage_PairedDeviceListUpdate::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      VARTRACE_USR4(_pairedDeviceList);
   }

   // *****************************************************************************************

   BmCoreIfMessage_StartPairingRequest::BmCoreIfMessage_StartPairingRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_START_PAIRING_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _bdAddress("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartPairingRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StartPairingRequest::BmCoreIfMessage_StartPairingRequest(IN const BdAddress& bdAddress,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_START_PAIRING_REQUEST, BM_RESTRICTION_GROUP_06, act, origin),
               _bdAddress(bdAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartPairingRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StartPairingRequest::BmCoreIfMessage_StartPairingRequest(IN const BmCoreIfMessage_StartPairingRequest& other) :
      BmCoreIfMessage(other),
      _bdAddress(other._bdAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartPairingRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StartPairingRequest::~BmCoreIfMessage_StartPairingRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartPairingRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_StartPairingRequest& first, BmCoreIfMessage_StartPairingRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._bdAddress, second._bdAddress);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_StartPairingRequest& BmCoreIfMessage_StartPairingRequest::operator=(BmCoreIfMessage_StartPairingRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_StartPairingRequest::operator==(const BmCoreIfMessage_StartPairingRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_bdAddress == rhs._bdAddress));
   }

   BmCoreIfMessage* BmCoreIfMessage_StartPairingRequest::clone(void) const
   {
      return new BmCoreIfMessage_StartPairingRequest(*this);
   }

   void BmCoreIfMessage_StartPairingRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] bdAddress = \"%50s\"", (const void*) this, _bdAddress.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_CancelPairingRequest::BmCoreIfMessage_CancelPairingRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_CANCEL_PAIRING_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_CancelPairingRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_CancelPairingRequest::BmCoreIfMessage_CancelPairingRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_CANCEL_PAIRING_REQUEST, BM_RESTRICTION_GROUP_06, act, origin)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_CancelPairingRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_CancelPairingRequest::BmCoreIfMessage_CancelPairingRequest(IN const BmCoreIfMessage_CancelPairingRequest& other) :
      BmCoreIfMessage(other)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_CancelPairingRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_CancelPairingRequest::~BmCoreIfMessage_CancelPairingRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_CancelPairingRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_CancelPairingRequest& first, BmCoreIfMessage_CancelPairingRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_CancelPairingRequest& BmCoreIfMessage_CancelPairingRequest::operator=(BmCoreIfMessage_CancelPairingRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_CancelPairingRequest::operator==(const BmCoreIfMessage_CancelPairingRequest& rhs) const
   {
      return (BmCoreIfMessage::operator ==(rhs));
   }

   BmCoreIfMessage* BmCoreIfMessage_CancelPairingRequest::clone(void) const
   {
      return new BmCoreIfMessage_CancelPairingRequest(*this);
   }

   void BmCoreIfMessage_CancelPairingRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
   }

   // *****************************************************************************************

   BmCoreIfMessage_AcceptPairingRequestRequest::BmCoreIfMessage_AcceptPairingRequestRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_ACCEPT_PAIRING_REQUEST_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_AcceptPairingRequestRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_AcceptPairingRequestRequest::BmCoreIfMessage_AcceptPairingRequestRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_ACCEPT_PAIRING_REQUEST_REQUEST, BM_RESTRICTION_GROUP_06, act, origin)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_AcceptPairingRequestRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_AcceptPairingRequestRequest::BmCoreIfMessage_AcceptPairingRequestRequest(IN const BmCoreIfMessage_AcceptPairingRequestRequest& other) :
      BmCoreIfMessage(other)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_AcceptPairingRequestRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_AcceptPairingRequestRequest::~BmCoreIfMessage_AcceptPairingRequestRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_AcceptPairingRequestRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_AcceptPairingRequestRequest& first, BmCoreIfMessage_AcceptPairingRequestRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_AcceptPairingRequestRequest& BmCoreIfMessage_AcceptPairingRequestRequest::operator=(BmCoreIfMessage_AcceptPairingRequestRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_AcceptPairingRequestRequest::operator==(const BmCoreIfMessage_AcceptPairingRequestRequest& rhs) const
   {
      return (BmCoreIfMessage::operator ==(rhs));
   }

   BmCoreIfMessage* BmCoreIfMessage_AcceptPairingRequestRequest::clone(void) const
   {
      return new BmCoreIfMessage_AcceptPairingRequestRequest(*this);
   }

   void BmCoreIfMessage_AcceptPairingRequestRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
   }

   // *****************************************************************************************

   BmCoreIfMessage_RejectPairingRequestRequest::BmCoreIfMessage_RejectPairingRequestRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_REJECT_PAIRING_REQUEST_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_RejectPairingRequestRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_RejectPairingRequestRequest::BmCoreIfMessage_RejectPairingRequestRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_REJECT_PAIRING_REQUEST_REQUEST, BM_RESTRICTION_GROUP_06, act, origin)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_RejectPairingRequestRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_RejectPairingRequestRequest::BmCoreIfMessage_RejectPairingRequestRequest(IN const BmCoreIfMessage_RejectPairingRequestRequest& other) :
      BmCoreIfMessage(other)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_RejectPairingRequestRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_RejectPairingRequestRequest::~BmCoreIfMessage_RejectPairingRequestRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_RejectPairingRequestRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_RejectPairingRequestRequest& first, BmCoreIfMessage_RejectPairingRequestRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_RejectPairingRequestRequest& BmCoreIfMessage_RejectPairingRequestRequest::operator=(BmCoreIfMessage_RejectPairingRequestRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_RejectPairingRequestRequest::operator==(const BmCoreIfMessage_RejectPairingRequestRequest& rhs) const
   {
      return (BmCoreIfMessage::operator ==(rhs));
   }

   BmCoreIfMessage* BmCoreIfMessage_RejectPairingRequestRequest::clone(void) const
   {
      return new BmCoreIfMessage_RejectPairingRequestRequest(*this);
   }

   void BmCoreIfMessage_RejectPairingRequestRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
   }

   // *****************************************************************************************

   BmCoreIfMessage_SetPairingPinRequest::BmCoreIfMessage_SetPairingPinRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_PAIRING_PIN_REQUEST, BM_RESTRICTION_GROUP_03,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _pairingPin()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetPairingPinRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetPairingPinRequest::BmCoreIfMessage_SetPairingPinRequest(IN const PairingPin& pairingPin,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_PAIRING_PIN_REQUEST, BM_RESTRICTION_GROUP_03, act, origin),
               _pairingPin(pairingPin)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetPairingPinRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetPairingPinRequest::BmCoreIfMessage_SetPairingPinRequest(IN const BmCoreIfMessage_SetPairingPinRequest& other) :
      BmCoreIfMessage(other),
      _pairingPin(other._pairingPin)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetPairingPinRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetPairingPinRequest::~BmCoreIfMessage_SetPairingPinRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetPairingPinRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_SetPairingPinRequest& first, BmCoreIfMessage_SetPairingPinRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._pairingPin, second._pairingPin);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SetPairingPinRequest& BmCoreIfMessage_SetPairingPinRequest::operator=(BmCoreIfMessage_SetPairingPinRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SetPairingPinRequest::operator==(const BmCoreIfMessage_SetPairingPinRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_pairingPin == rhs._pairingPin));
   }

   BmCoreIfMessage* BmCoreIfMessage_SetPairingPinRequest::clone(void) const
   {
      return new BmCoreIfMessage_SetPairingPinRequest(*this);
   }

   void BmCoreIfMessage_SetPairingPinRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] pairingPin = \"%50s\"", (const void*) this, _pairingPin._pin.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_AddOobPairedDeviceRequest::BmCoreIfMessage_AddOobPairedDeviceRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_ADD_OOB_PAIRED_DEVICE_REQUEST, BM_RESTRICTION_GROUP_03,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _bdAddress(""), _bdName(""), _linkKey(""), _oobType(BM_OOB_TYPE_GENERIC)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_AddOobPairedDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_AddOobPairedDeviceRequest::BmCoreIfMessage_AddOobPairedDeviceRequest(IN const BdAddress& bdAddress,
         IN const BdName& bdName, IN const LinkKey& linkKey, IN const OobType oobType, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_ADD_OOB_PAIRED_DEVICE_REQUEST, BM_RESTRICTION_GROUP_03, act, origin),
               _bdAddress(bdAddress), _bdName(bdName), _linkKey(linkKey), _oobType(oobType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_AddOobPairedDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_AddOobPairedDeviceRequest::BmCoreIfMessage_AddOobPairedDeviceRequest(IN const BmCoreIfMessage_AddOobPairedDeviceRequest& other) :
      BmCoreIfMessage(other),
      _bdAddress(other._bdAddress), _bdName(other._bdName), _linkKey(other._linkKey), _oobType(other._oobType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_AddOobPairedDeviceRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_AddOobPairedDeviceRequest::~BmCoreIfMessage_AddOobPairedDeviceRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_AddOobPairedDeviceRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_AddOobPairedDeviceRequest& first, BmCoreIfMessage_AddOobPairedDeviceRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._bdAddress, second._bdAddress);
      swap(first._bdName, second._bdName);
      swap(first._linkKey, second._linkKey);
      swap(first._oobType, second._oobType);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_AddOobPairedDeviceRequest& BmCoreIfMessage_AddOobPairedDeviceRequest::operator=(BmCoreIfMessage_AddOobPairedDeviceRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_AddOobPairedDeviceRequest::operator==(const BmCoreIfMessage_AddOobPairedDeviceRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_bdAddress == rhs._bdAddress)
            && (this->_bdName == rhs._bdName)
            && (this->_linkKey == rhs._linkKey)
            && (this->_oobType == rhs._oobType));
   }

   BmCoreIfMessage* BmCoreIfMessage_AddOobPairedDeviceRequest::clone(void) const
   {
      return new BmCoreIfMessage_AddOobPairedDeviceRequest(*this);
   }

   void BmCoreIfMessage_AddOobPairedDeviceRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] bdAddress = \"%50s\", bdName = \"%50s\", linkKey = \"%50s\", oobType = %d",
            (const void*) this, _bdAddress.c_str(), _bdName.c_str(), _linkKey.c_str(),
            ETG_CENUM(OobType, _oobType)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_DeleteDeviceRequest::BmCoreIfMessage_DeleteDeviceRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_DELETE_DEVICE_REQUEST, BM_RESTRICTION_GROUP_03,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u),
         _deviceHandleType(BM_DEVICE_HANDLE_TYPE_SINGLE)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DeleteDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_DeleteDeviceRequest::BmCoreIfMessage_DeleteDeviceRequest(IN const DeviceId deviceHandle,
         IN const DeviceHandleType deviceHandleType, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_DELETE_DEVICE_REQUEST, BM_RESTRICTION_GROUP_03, act, origin),
               _deviceHandle(deviceHandle),
               _deviceHandleType(deviceHandleType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DeleteDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_DeleteDeviceRequest::BmCoreIfMessage_DeleteDeviceRequest(IN const BmCoreIfMessage_DeleteDeviceRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle),
      _deviceHandleType(other._deviceHandleType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DeleteDeviceRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_DeleteDeviceRequest::~BmCoreIfMessage_DeleteDeviceRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DeleteDeviceRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_DeleteDeviceRequest& first, BmCoreIfMessage_DeleteDeviceRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._deviceHandleType, second._deviceHandleType);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_DeleteDeviceRequest& BmCoreIfMessage_DeleteDeviceRequest::operator=(BmCoreIfMessage_DeleteDeviceRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_DeleteDeviceRequest::operator==(const BmCoreIfMessage_DeleteDeviceRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_deviceHandleType == rhs._deviceHandleType));
   }

   BmCoreIfMessage* BmCoreIfMessage_DeleteDeviceRequest::clone(void) const
   {
      return new BmCoreIfMessage_DeleteDeviceRequest(*this);
   }

   void BmCoreIfMessage_DeleteDeviceRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d, deviceHandleType = %d", (const void*) this,
            _deviceHandle, ETG_CENUM(DeviceHandleType, _deviceHandleType)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_StartAutoConnectionSequenceRequest::BmCoreIfMessage_StartAutoConnectionSequenceRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_START_AUTO_CONNECTION_SEQUENCE_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _temporaryAutoConnectionType(BM_TEMPORARY_AUTO_CONNECTION_DEFAULT)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartAutoConnectionSequenceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StartAutoConnectionSequenceRequest::BmCoreIfMessage_StartAutoConnectionSequenceRequest(IN const TemporaryAutoConnectionType autoConnectionType,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_START_AUTO_CONNECTION_SEQUENCE_REQUEST, BM_RESTRICTION_GROUP_06, act,
                     origin),
               _temporaryAutoConnectionType(autoConnectionType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartAutoConnectionSequenceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StartAutoConnectionSequenceRequest::BmCoreIfMessage_StartAutoConnectionSequenceRequest(IN const BmCoreIfMessage_StartAutoConnectionSequenceRequest& other) :
         BmCoreIfMessage(other),
        _temporaryAutoConnectionType(other._temporaryAutoConnectionType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartAutoConnectionSequenceRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StartAutoConnectionSequenceRequest::~BmCoreIfMessage_StartAutoConnectionSequenceRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartAutoConnectionSequenceRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_StartAutoConnectionSequenceRequest& first, BmCoreIfMessage_StartAutoConnectionSequenceRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._temporaryAutoConnectionType, second._temporaryAutoConnectionType);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_StartAutoConnectionSequenceRequest& BmCoreIfMessage_StartAutoConnectionSequenceRequest::operator=(BmCoreIfMessage_StartAutoConnectionSequenceRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_StartAutoConnectionSequenceRequest::operator==(const BmCoreIfMessage_StartAutoConnectionSequenceRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_temporaryAutoConnectionType == rhs._temporaryAutoConnectionType));
   }

   BmCoreIfMessage* BmCoreIfMessage_StartAutoConnectionSequenceRequest::clone(void) const
   {
      return new BmCoreIfMessage_StartAutoConnectionSequenceRequest(*this);
   }

   void BmCoreIfMessage_StartAutoConnectionSequenceRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] temporaryAutoConnectionType = %d", (const void*) this,
            ETG_CENUM(TemporaryAutoConnectionType, _temporaryAutoConnectionType)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_StopAutoConnectionSequenceRequest::BmCoreIfMessage_StopAutoConnectionSequenceRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_STOP_AUTO_CONNECTION_SEQUENCE_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopAutoConnectionSequenceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StopAutoConnectionSequenceRequest::BmCoreIfMessage_StopAutoConnectionSequenceRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_STOP_AUTO_CONNECTION_SEQUENCE_REQUEST, BM_RESTRICTION_GROUP_06, act,
                     origin)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopAutoConnectionSequenceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StopAutoConnectionSequenceRequest::BmCoreIfMessage_StopAutoConnectionSequenceRequest(IN const BmCoreIfMessage_StopAutoConnectionSequenceRequest& other) :
         BmCoreIfMessage(other)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopAutoConnectionSequenceRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StopAutoConnectionSequenceRequest::~BmCoreIfMessage_StopAutoConnectionSequenceRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopAutoConnectionSequenceRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_StopAutoConnectionSequenceRequest& first, BmCoreIfMessage_StopAutoConnectionSequenceRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_StopAutoConnectionSequenceRequest& BmCoreIfMessage_StopAutoConnectionSequenceRequest::operator=(BmCoreIfMessage_StopAutoConnectionSequenceRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_StopAutoConnectionSequenceRequest::operator==(const BmCoreIfMessage_StopAutoConnectionSequenceRequest& rhs) const
   {
      return (BmCoreIfMessage::operator ==(rhs));
   }

   BmCoreIfMessage* BmCoreIfMessage_StopAutoConnectionSequenceRequest::clone(void) const
   {
      return new BmCoreIfMessage_StopAutoConnectionSequenceRequest(*this);
   }

   void BmCoreIfMessage_StopAutoConnectionSequenceRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
   }

   // *****************************************************************************************

   BmCoreIfMessage_ConnectDeviceRequest::BmCoreIfMessage_ConnectDeviceRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_CONNECT_DEVICE_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u),
         _delayRequestProcessing(false),
         _pageTimeout(0u)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ConnectDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_ConnectDeviceRequest::BmCoreIfMessage_ConnectDeviceRequest(IN const DeviceId deviceHandle,
         IN const bool delayRequestProcessing, IN const PageTimeout pageTimeout, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_CONNECT_DEVICE_REQUEST, BM_RESTRICTION_GROUP_06, act, origin),
               _deviceHandle(deviceHandle),
               _delayRequestProcessing(delayRequestProcessing),
               _pageTimeout(pageTimeout)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ConnectDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_ConnectDeviceRequest::BmCoreIfMessage_ConnectDeviceRequest(IN const BmCoreIfMessage_ConnectDeviceRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle),
      _delayRequestProcessing(other._delayRequestProcessing),
      _pageTimeout(other._pageTimeout)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ConnectDeviceRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_ConnectDeviceRequest::~BmCoreIfMessage_ConnectDeviceRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ConnectDeviceRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_ConnectDeviceRequest& first, BmCoreIfMessage_ConnectDeviceRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._delayRequestProcessing, second._delayRequestProcessing);
      swap(first._pageTimeout, second._pageTimeout);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_ConnectDeviceRequest& BmCoreIfMessage_ConnectDeviceRequest::operator=(BmCoreIfMessage_ConnectDeviceRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_ConnectDeviceRequest::operator==(const BmCoreIfMessage_ConnectDeviceRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_delayRequestProcessing == rhs._delayRequestProcessing)
            && (this->_pageTimeout == rhs._pageTimeout));
   }

   BmCoreIfMessage* BmCoreIfMessage_ConnectDeviceRequest::clone(void) const
   {
      return new BmCoreIfMessage_ConnectDeviceRequest(*this);
   }

   void BmCoreIfMessage_ConnectDeviceRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d, delayRequestProcessing = %10s, PageTimeout = %d", (const void*) this,
            _deviceHandle, _delayRequestProcessing ? "true" : "false", _pageTimeout ));
   }

   // *****************************************************************************************

   BmCoreIfMessage_DisconnectDeviceRequest::BmCoreIfMessage_DisconnectDeviceRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_DISCONNECT_DEVICE_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u),
         _deviceHandleType(BM_DEVICE_HANDLE_TYPE_SINGLE),
         _disconnectedReason(BM_DISCONNECTED_REASON_UNKNOWN),
         _deleteDevice(false)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DisconnectDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_DisconnectDeviceRequest::BmCoreIfMessage_DisconnectDeviceRequest(IN const DeviceId deviceHandle,
         IN const DeviceHandleType deviceHandleType, IN const DisconnectedReason disconnectedReason,
         IN const bool deleteDevice, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_DISCONNECT_DEVICE_REQUEST, BM_RESTRICTION_GROUP_06, act, origin),
               _deviceHandle(deviceHandle),
               _deviceHandleType(deviceHandleType),
               _disconnectedReason(disconnectedReason),
               _deleteDevice(deleteDevice)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DisconnectDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_DisconnectDeviceRequest::BmCoreIfMessage_DisconnectDeviceRequest(IN const BmCoreIfMessage_DisconnectDeviceRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle),
      _deviceHandleType(other._deviceHandleType),
      _disconnectedReason(other._disconnectedReason),
      _deleteDevice(other._deleteDevice)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DisconnectDeviceRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_DisconnectDeviceRequest::~BmCoreIfMessage_DisconnectDeviceRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DisconnectDeviceRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_DisconnectDeviceRequest& first, BmCoreIfMessage_DisconnectDeviceRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._deviceHandleType, second._deviceHandleType);
      swap(first._disconnectedReason, second._disconnectedReason);
      swap(first._deleteDevice, second._deleteDevice);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_DisconnectDeviceRequest& BmCoreIfMessage_DisconnectDeviceRequest::operator=(BmCoreIfMessage_DisconnectDeviceRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_DisconnectDeviceRequest::operator==(const BmCoreIfMessage_DisconnectDeviceRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_deviceHandleType == rhs._deviceHandleType)
            && (this->_disconnectedReason == rhs._disconnectedReason)
            && (this->_deleteDevice == rhs._deleteDevice));
   }

   BmCoreIfMessage* BmCoreIfMessage_DisconnectDeviceRequest::clone(void) const
   {
      return new BmCoreIfMessage_DisconnectDeviceRequest(*this);
   }

   void BmCoreIfMessage_DisconnectDeviceRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d, deviceHandleType = %d, disconnectedReason = %d, deleteDevice = 10%s", (const void*) this,
            _deviceHandle, ETG_CENUM(DeviceHandleType, _deviceHandleType),
            ETG_CENUM(DisconnectedReason, _disconnectedReason), _deleteDevice ? "true" : "false"));
   }

   // *****************************************************************************************

   BmCoreIfMessage_ConnectProfilesRequest::BmCoreIfMessage_ConnectProfilesRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_CONNECT_PROFILES_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u),
         _protocolList(),
         _pageTimeout(0u)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ConnectProfilesRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_ConnectProfilesRequest::BmCoreIfMessage_ConnectProfilesRequest(IN const DeviceId deviceHandle,
         IN const ProtocolList& protocolList, IN const PageTimeout pageTimeout, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_CONNECT_PROFILES_REQUEST, BM_RESTRICTION_GROUP_06, act, origin),
               _deviceHandle(deviceHandle),
               _protocolList(protocolList),
               _pageTimeout(pageTimeout)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ConnectProfilesRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_ConnectProfilesRequest::BmCoreIfMessage_ConnectProfilesRequest(IN const BmCoreIfMessage_ConnectProfilesRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle),
      _protocolList(other._protocolList),
      _pageTimeout(other._pageTimeout)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ConnectProfilesRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_ConnectProfilesRequest::~BmCoreIfMessage_ConnectProfilesRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ConnectProfilesRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_ConnectProfilesRequest& first, BmCoreIfMessage_ConnectProfilesRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._protocolList, second._protocolList);
      swap(first._pageTimeout, second._pageTimeout);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_ConnectProfilesRequest& BmCoreIfMessage_ConnectProfilesRequest::operator=(BmCoreIfMessage_ConnectProfilesRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_ConnectProfilesRequest::operator==(const BmCoreIfMessage_ConnectProfilesRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_protocolList == rhs._protocolList)
            && (this->_pageTimeout == rhs._pageTimeout));
   }

   BmCoreIfMessage* BmCoreIfMessage_ConnectProfilesRequest::clone(void) const
   {
      return new BmCoreIfMessage_ConnectProfilesRequest(*this);
   }

   void BmCoreIfMessage_ConnectProfilesRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d", (const void*) this, _deviceHandle));
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
      // TODO: @Stefan: compiler error: 'VARTRACE_USR4' was not declared in this scope
#else
      VARTRACE_USR4(_protocolList);
#endif
      ETG_TRACE_USR4(("traceMessage: [0x%p] pageTimeout = %d", (const void*) this, _pageTimeout));
   }

   // *****************************************************************************************

   BmCoreIfMessage_DisconnectProfilesRequest::BmCoreIfMessage_DisconnectProfilesRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_DISCONNECT_PROFILES_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u),
         _protocolList()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DisconnectProfilesRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_DisconnectProfilesRequest::BmCoreIfMessage_DisconnectProfilesRequest(IN const DeviceId deviceHandle,
         IN const ProtocolList& protocolList, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_DISCONNECT_PROFILES_REQUEST, BM_RESTRICTION_GROUP_06, act, origin),
               _deviceHandle(deviceHandle),
               _protocolList(protocolList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DisconnectProfilesRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_DisconnectProfilesRequest::BmCoreIfMessage_DisconnectProfilesRequest(IN const BmCoreIfMessage_DisconnectProfilesRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle),
      _protocolList(other._protocolList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DisconnectProfilesRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_DisconnectProfilesRequest::~BmCoreIfMessage_DisconnectProfilesRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DisconnectProfilesRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_DisconnectProfilesRequest& first, BmCoreIfMessage_DisconnectProfilesRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._protocolList, second._protocolList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_DisconnectProfilesRequest& BmCoreIfMessage_DisconnectProfilesRequest::operator=(BmCoreIfMessage_DisconnectProfilesRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_DisconnectProfilesRequest::operator==(const BmCoreIfMessage_DisconnectProfilesRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_protocolList == rhs._protocolList));
   }

   BmCoreIfMessage* BmCoreIfMessage_DisconnectProfilesRequest::clone(void) const
   {
      return new BmCoreIfMessage_DisconnectProfilesRequest(*this);
   }

   void BmCoreIfMessage_DisconnectProfilesRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d", (const void*) this, _deviceHandle));
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
      // TODO: @Stefan: compiler error: 'VARTRACE_USR4' was not declared in this scope
#else
      VARTRACE_USR4(_protocolList);
#endif
   }

   // *****************************************************************************************

   BmCoreIfMessage_BlockDeviceRequest::BmCoreIfMessage_BlockDeviceRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BLOCK_DEVICE_REQUEST, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u),
         _deviceHandleType(BM_DEVICE_HANDLE_TYPE_SINGLE)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BlockDeviceRequest::BmCoreIfMessage_BlockDeviceRequest(IN const DeviceId deviceHandle,
         IN const DeviceHandleType deviceHandleType, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BLOCK_DEVICE_REQUEST, BM_RESTRICTION_GROUP_00, act, origin),
               _deviceHandle(deviceHandle),
               _deviceHandleType(deviceHandleType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BlockDeviceRequest::BmCoreIfMessage_BlockDeviceRequest(IN const BmCoreIfMessage_BlockDeviceRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle),
      _deviceHandleType(other._deviceHandleType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockDeviceRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BlockDeviceRequest::~BmCoreIfMessage_BlockDeviceRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockDeviceRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BlockDeviceRequest& first, BmCoreIfMessage_BlockDeviceRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._deviceHandleType, second._deviceHandleType);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BlockDeviceRequest& BmCoreIfMessage_BlockDeviceRequest::operator=(BmCoreIfMessage_BlockDeviceRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BlockDeviceRequest::operator==(const BmCoreIfMessage_BlockDeviceRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_deviceHandleType == rhs._deviceHandleType));
   }

   BmCoreIfMessage* BmCoreIfMessage_BlockDeviceRequest::clone(void) const
   {
      return new BmCoreIfMessage_BlockDeviceRequest(*this);
   }

   void BmCoreIfMessage_BlockDeviceRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d, deviceHandleType = %d", (const void*) this,
            _deviceHandle, ETG_CENUM(DeviceHandleType, _deviceHandleType)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_UnblockDeviceRequest::BmCoreIfMessage_UnblockDeviceRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BLOCK_DEVICE_REQUEST, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u),
         _deviceHandleType(BM_DEVICE_HANDLE_TYPE_SINGLE)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UnblockDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_UnblockDeviceRequest::BmCoreIfMessage_UnblockDeviceRequest(IN const DeviceId deviceHandle,
         IN const DeviceHandleType deviceHandleType, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_UNBLOCK_DEVICE_REQUEST, BM_RESTRICTION_GROUP_00, act, origin),
               _deviceHandle(deviceHandle),
               _deviceHandleType(deviceHandleType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UnblockDeviceRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_UnblockDeviceRequest::BmCoreIfMessage_UnblockDeviceRequest(IN const BmCoreIfMessage_UnblockDeviceRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle),
      _deviceHandleType(other._deviceHandleType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UnblockDeviceRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_UnblockDeviceRequest::~BmCoreIfMessage_UnblockDeviceRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UnblockDeviceRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_UnblockDeviceRequest& first, BmCoreIfMessage_UnblockDeviceRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._deviceHandleType, second._deviceHandleType);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_UnblockDeviceRequest& BmCoreIfMessage_UnblockDeviceRequest::operator=(BmCoreIfMessage_UnblockDeviceRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_UnblockDeviceRequest::operator==(const BmCoreIfMessage_UnblockDeviceRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_deviceHandleType == rhs._deviceHandleType));
   }

   BmCoreIfMessage* BmCoreIfMessage_UnblockDeviceRequest::clone(void) const
   {
      return new BmCoreIfMessage_UnblockDeviceRequest(*this);
   }

   void BmCoreIfMessage_UnblockDeviceRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d, deviceHandleType = %d", (const void*) this,
            _deviceHandle, ETG_CENUM(DeviceHandleType, _deviceHandleType)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BlockProfilesRequest::BmCoreIfMessage_BlockProfilesRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BLOCK_PROFILES_REQUEST, BM_RESTRICTION_GROUP_03,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u),
         _protocolList(),
         _ignoreStopAutoconnection(false)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockProfilesRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BlockProfilesRequest::BmCoreIfMessage_BlockProfilesRequest(IN const DeviceId deviceHandle,
         IN const ProtocolList& protocolList, IN const bool ignoreStopAutoconnection, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BLOCK_PROFILES_REQUEST, BM_RESTRICTION_GROUP_03, act, origin),
               _deviceHandle(deviceHandle),
               _protocolList(protocolList),
               _ignoreStopAutoconnection(ignoreStopAutoconnection)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockProfilesRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BlockProfilesRequest::BmCoreIfMessage_BlockProfilesRequest(IN const BmCoreIfMessage_BlockProfilesRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle),
      _protocolList(other._protocolList),
      _ignoreStopAutoconnection(other._ignoreStopAutoconnection)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockProfilesRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BlockProfilesRequest::~BmCoreIfMessage_BlockProfilesRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockProfilesRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BlockProfilesRequest& first, BmCoreIfMessage_BlockProfilesRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._protocolList, second._protocolList);
      swap(first._ignoreStopAutoconnection, second._ignoreStopAutoconnection);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BlockProfilesRequest& BmCoreIfMessage_BlockProfilesRequest::operator=(BmCoreIfMessage_BlockProfilesRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BlockProfilesRequest::operator==(const BmCoreIfMessage_BlockProfilesRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_protocolList == rhs._protocolList)
            && (this->_ignoreStopAutoconnection == rhs._ignoreStopAutoconnection));
   }

   BmCoreIfMessage* BmCoreIfMessage_BlockProfilesRequest::clone(void) const
   {
      return new BmCoreIfMessage_BlockProfilesRequest(*this);
   }

   void BmCoreIfMessage_BlockProfilesRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d, ignoreStopAutoconectionStatus = %10s", (const void*) this, _deviceHandle, _ignoreStopAutoconnection ? "true" : "false"));

#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
      // TODO: @Stefan: compiler error: 'VARTRACE_USR4' was not declared in this scope
#else
      VARTRACE_USR4(_protocolList);
#endif
   }

   // *****************************************************************************************

   BmCoreIfMessage_UnblockProfilesRequest::BmCoreIfMessage_UnblockProfilesRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_UNBLOCK_PROFILES_REQUEST, BM_RESTRICTION_GROUP_03,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u),
         _protocolList()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UnblockProfilesRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_UnblockProfilesRequest::BmCoreIfMessage_UnblockProfilesRequest(IN const DeviceId deviceHandle,
         IN const ProtocolList& protocolList, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_UNBLOCK_PROFILES_REQUEST, BM_RESTRICTION_GROUP_03, act, origin),
               _deviceHandle(deviceHandle),
               _protocolList(protocolList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UnblockProfilesRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_UnblockProfilesRequest::BmCoreIfMessage_UnblockProfilesRequest(IN const BmCoreIfMessage_UnblockProfilesRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle),
      _protocolList(other._protocolList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UnblockProfilesRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_UnblockProfilesRequest::~BmCoreIfMessage_UnblockProfilesRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UnblockProfilesRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_UnblockProfilesRequest& first, BmCoreIfMessage_UnblockProfilesRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._protocolList, second._protocolList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_UnblockProfilesRequest& BmCoreIfMessage_UnblockProfilesRequest::operator=(BmCoreIfMessage_UnblockProfilesRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_UnblockProfilesRequest::operator==(const BmCoreIfMessage_UnblockProfilesRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_protocolList == rhs._protocolList));
   }

   BmCoreIfMessage* BmCoreIfMessage_UnblockProfilesRequest::clone(void) const
   {
      return new BmCoreIfMessage_UnblockProfilesRequest(*this);
   }

   void BmCoreIfMessage_UnblockProfilesRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d", (const void*) this, _deviceHandle));
#ifdef VARIANT_S_FTR_ENABLE_64_BIT_SUPPORT
      // TODO: @Stefan: compiler error: 'VARTRACE_USR4' was not declared in this scope
#else
      VARTRACE_USR4(_protocolList);
#endif
   }

   // *****************************************************************************************

   BmCoreIfMessage_DeviceConnectionStatusListUpdate::BmCoreIfMessage_DeviceConnectionStatusListUpdate() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_DEVICE_CONNECTION_STATUS_LIST_UPDATE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _deviceConnectionStatusList()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DeviceConnectionStatusListUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_DeviceConnectionStatusListUpdate::BmCoreIfMessage_DeviceConnectionStatusListUpdate(IN const DeviceConnectionStatusList& deviceConnectionStatusList) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_DEVICE_CONNECTION_STATUS_LIST_UPDATE, BM_RESTRICTION_GROUP_00, 0u,
               BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _deviceConnectionStatusList(deviceConnectionStatusList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DeviceConnectionStatusListUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_DeviceConnectionStatusListUpdate::BmCoreIfMessage_DeviceConnectionStatusListUpdate(IN const BmCoreIfMessage_DeviceConnectionStatusListUpdate& other) :
      BmCoreIfMessage(other),
      _deviceConnectionStatusList(other._deviceConnectionStatusList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DeviceConnectionStatusListUpdate: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_DeviceConnectionStatusListUpdate::~BmCoreIfMessage_DeviceConnectionStatusListUpdate()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DeviceConnectionStatusListUpdate: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_DeviceConnectionStatusListUpdate& first, BmCoreIfMessage_DeviceConnectionStatusListUpdate& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceConnectionStatusList, second._deviceConnectionStatusList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_DeviceConnectionStatusListUpdate& BmCoreIfMessage_DeviceConnectionStatusListUpdate::operator=(BmCoreIfMessage_DeviceConnectionStatusListUpdate other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_DeviceConnectionStatusListUpdate::operator==(const BmCoreIfMessage_DeviceConnectionStatusListUpdate& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceConnectionStatusList == rhs._deviceConnectionStatusList));
   }

   BmCoreIfMessage* BmCoreIfMessage_DeviceConnectionStatusListUpdate::clone(void) const
   {
      return new BmCoreIfMessage_DeviceConnectionStatusListUpdate(*this);
   }

   void BmCoreIfMessage_DeviceConnectionStatusListUpdate::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      VARTRACE_USR4(_deviceConnectionStatusList);
   }

   // *****************************************************************************************

   BmCoreIfMessage_SetFavoriteRequest::BmCoreIfMessage_SetFavoriteRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_FAVORITE_REQUEST, BM_RESTRICTION_GROUP_01,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u), _favoriteType(BM_FAVORITE_TYPE_DEVICE), _favoriteIndex(0u)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetFavoriteRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetFavoriteRequest::BmCoreIfMessage_SetFavoriteRequest(IN const DeviceId deviceHandle,
         IN const FavoriteType favoriteType, IN const FavoriteIndex favoriteIndex, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_FAVORITE_REQUEST, BM_RESTRICTION_GROUP_01, act, origin),
         _deviceHandle(deviceHandle), _favoriteType(favoriteType), _favoriteIndex(favoriteIndex)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetFavoriteRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetFavoriteRequest::BmCoreIfMessage_SetFavoriteRequest(IN const BmCoreIfMessage_SetFavoriteRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle), _favoriteType(other._favoriteType), _favoriteIndex(other._favoriteIndex)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetFavoriteRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SetFavoriteRequest::~BmCoreIfMessage_SetFavoriteRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetFavoriteRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_SetFavoriteRequest& first, BmCoreIfMessage_SetFavoriteRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._favoriteType, second._favoriteType);
      swap(first._favoriteIndex, second._favoriteIndex);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SetFavoriteRequest& BmCoreIfMessage_SetFavoriteRequest::operator=(BmCoreIfMessage_SetFavoriteRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SetFavoriteRequest::operator==(const BmCoreIfMessage_SetFavoriteRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_favoriteType == rhs._favoriteType)
            && (this->_favoriteIndex == rhs._favoriteIndex));
   }

   BmCoreIfMessage* BmCoreIfMessage_SetFavoriteRequest::clone(void) const
   {
      return new BmCoreIfMessage_SetFavoriteRequest(*this);
   }

   void BmCoreIfMessage_SetFavoriteRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d, favoriteType = %d, favoriteIndex = %u",
            (const void*) this, _deviceHandle, ETG_CENUM(FavoriteType, _favoriteType), _favoriteIndex));
   }

   // *****************************************************************************************

   BmCoreIfMessage_ClearFavoriteRequest::BmCoreIfMessage_ClearFavoriteRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_CLEAR_FAVORITE_REQUEST, BM_RESTRICTION_GROUP_01,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u), _favoriteType(BM_FAVORITE_TYPE_DEVICE)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ClearFavoriteRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_ClearFavoriteRequest::BmCoreIfMessage_ClearFavoriteRequest(IN const DeviceId deviceHandle,
         IN const FavoriteType favoriteType, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_CLEAR_FAVORITE_REQUEST, BM_RESTRICTION_GROUP_01, act, origin),
         _deviceHandle(deviceHandle), _favoriteType(favoriteType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ClearFavoriteRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_ClearFavoriteRequest::BmCoreIfMessage_ClearFavoriteRequest(IN const BmCoreIfMessage_ClearFavoriteRequest& other) :
      BmCoreIfMessage(other),
      _deviceHandle(other._deviceHandle), _favoriteType(other._favoriteType)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ClearFavoriteRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_ClearFavoriteRequest::~BmCoreIfMessage_ClearFavoriteRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ClearFavoriteRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_ClearFavoriteRequest& first, BmCoreIfMessage_ClearFavoriteRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._favoriteType, second._favoriteType);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_ClearFavoriteRequest& BmCoreIfMessage_ClearFavoriteRequest::operator=(BmCoreIfMessage_ClearFavoriteRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_ClearFavoriteRequest::operator==(const BmCoreIfMessage_ClearFavoriteRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_favoriteType == rhs._favoriteType));
   }

   BmCoreIfMessage* BmCoreIfMessage_ClearFavoriteRequest::clone(void) const
   {
      return new BmCoreIfMessage_ClearFavoriteRequest(*this);
   }

   void BmCoreIfMessage_ClearFavoriteRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d, favoriteType = %d",
            (const void*) this, _deviceHandle, ETG_CENUM(FavoriteType, _favoriteType)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_StartServiceSearchRequest::BmCoreIfMessage_StartServiceSearchRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_START_SERVICE_SEARCH_REQUEST, BM_RESTRICTION_GROUP_02,
            0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartServiceSearchRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StartServiceSearchRequest::BmCoreIfMessage_StartServiceSearchRequest(IN const DeviceId deviceHandle,
         IN const ActType act,IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_START_SERVICE_SEARCH_REQUEST, BM_RESTRICTION_GROUP_02, act, origin),
               _deviceHandle(deviceHandle)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartServiceSearchRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StartServiceSearchRequest::BmCoreIfMessage_StartServiceSearchRequest(IN const BmCoreIfMessage_StartServiceSearchRequest& other) :
         BmCoreIfMessage(other),
         _deviceHandle(other._deviceHandle)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartServiceSearchRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StartServiceSearchRequest::~BmCoreIfMessage_StartServiceSearchRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartServiceSearchRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_StartServiceSearchRequest& first, BmCoreIfMessage_StartServiceSearchRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);

   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_StartServiceSearchRequest& BmCoreIfMessage_StartServiceSearchRequest::operator=(BmCoreIfMessage_StartServiceSearchRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_StartServiceSearchRequest::operator==(const BmCoreIfMessage_StartServiceSearchRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle));
   }

   BmCoreIfMessage* BmCoreIfMessage_StartServiceSearchRequest::clone(void) const
   {
      return new BmCoreIfMessage_StartServiceSearchRequest(*this);
   }

   void BmCoreIfMessage_StartServiceSearchRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d",
            (const void*) this, _deviceHandle));
   }

   // *****************************************************************************************

   BmCoreIfMessage_StopServiceSearchRequest::BmCoreIfMessage_StopServiceSearchRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_STOP_SERVICE_SEARCH_REQUEST, BM_RESTRICTION_GROUP_02,
            0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _deviceHandle(0u)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopServiceSearchRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StopServiceSearchRequest::BmCoreIfMessage_StopServiceSearchRequest(IN const DeviceId deviceHandle,
         IN const ActType act,IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_STOP_SERVICE_SEARCH_REQUEST, BM_RESTRICTION_GROUP_02, act, origin),
               _deviceHandle(deviceHandle)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopServiceSearchRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StopServiceSearchRequest::BmCoreIfMessage_StopServiceSearchRequest(IN const BmCoreIfMessage_StopServiceSearchRequest& other) :
         BmCoreIfMessage(other),
         _deviceHandle(other._deviceHandle)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopServiceSearchRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_StopServiceSearchRequest::~BmCoreIfMessage_StopServiceSearchRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopServiceSearchRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_StopServiceSearchRequest& first, BmCoreIfMessage_StopServiceSearchRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);

   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_StopServiceSearchRequest& BmCoreIfMessage_StopServiceSearchRequest::operator=(BmCoreIfMessage_StopServiceSearchRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_StopServiceSearchRequest::operator==(const BmCoreIfMessage_StopServiceSearchRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle));
   }

   BmCoreIfMessage* BmCoreIfMessage_StopServiceSearchRequest::clone(void) const
   {
      return new BmCoreIfMessage_StopServiceSearchRequest(*this);
   }

   void BmCoreIfMessage_StopServiceSearchRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d",
            (const void*) this, _deviceHandle));
   }

        // *****************************************************************************************
   BmCoreIfMessage_UpdateLinkQualityRequest::BmCoreIfMessage_UpdateLinkQualityRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_UPDATE_LINK_QUALITY_REQUEST, BM_RESTRICTION_GROUP_04,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UpdateLinkQualityRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_UpdateLinkQualityRequest::BmCoreIfMessage_UpdateLinkQualityRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_UPDATE_LINK_QUALITY_REQUEST, BM_RESTRICTION_GROUP_04, act, origin)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UpdateLinkQualityRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_UpdateLinkQualityRequest::BmCoreIfMessage_UpdateLinkQualityRequest(IN const BmCoreIfMessage_UpdateLinkQualityRequest& other) :
      BmCoreIfMessage(other)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UpdateLinkQualityRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_UpdateLinkQualityRequest::~BmCoreIfMessage_UpdateLinkQualityRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_UpdateLinkQualityRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_UpdateLinkQualityRequest& first, BmCoreIfMessage_UpdateLinkQualityRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_UpdateLinkQualityRequest& BmCoreIfMessage_UpdateLinkQualityRequest::operator=(BmCoreIfMessage_UpdateLinkQualityRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_UpdateLinkQualityRequest::operator==(const BmCoreIfMessage_UpdateLinkQualityRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs)));
   }

   BmCoreIfMessage* BmCoreIfMessage_UpdateLinkQualityRequest::clone(void) const
   {
      return new BmCoreIfMessage_UpdateLinkQualityRequest(*this);
   }

   void BmCoreIfMessage_UpdateLinkQualityRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
   }

   // *****************************************************************************************

   BmCoreIfMessage_BlockStatusUpdate::BmCoreIfMessage_BlockStatusUpdate() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BLOCK_STATUS_UPDATE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _blockStatus()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockStatusUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BlockStatusUpdate::BmCoreIfMessage_BlockStatusUpdate(IN const BlockStatus& blockStatus) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BLOCK_STATUS_UPDATE, BM_RESTRICTION_GROUP_00, 0u,
               BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _blockStatus(blockStatus)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockStatusUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BlockStatusUpdate::BmCoreIfMessage_BlockStatusUpdate(IN const BmCoreIfMessage_BlockStatusUpdate& other) :
         BmCoreIfMessage(other),
         _blockStatus(other._blockStatus)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockStatusUpdate: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BlockStatusUpdate::~BmCoreIfMessage_BlockStatusUpdate()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BlockStatusUpdate: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BlockStatusUpdate& first, BmCoreIfMessage_BlockStatusUpdate& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._blockStatus, second._blockStatus);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BlockStatusUpdate& BmCoreIfMessage_BlockStatusUpdate::operator=(BmCoreIfMessage_BlockStatusUpdate other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BlockStatusUpdate::operator==(const BmCoreIfMessage_BlockStatusUpdate& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_blockStatus == rhs._blockStatus));
   }

   BmCoreIfMessage* BmCoreIfMessage_BlockStatusUpdate::clone(void) const
   {
      return new BmCoreIfMessage_BlockStatusUpdate(*this);
   }

   void BmCoreIfMessage_BlockStatusUpdate::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      VARTRACE_USR4(_blockStatus);
   }

   // *****************************************************************************************

   BmCoreIfMessage_SetBtLimitationModeRequest::BmCoreIfMessage_SetBtLimitationModeRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_BT_LIMITATION_MODE_REQUEST, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _bdAddress(""),
         _bdName(""),
         _limitationMode(BM_LIMITATION_FEATURE_UNKNOWN, BM_LIMITATION_COMMUNICATION_IF_LAST),
         _limitationAction(BM_LIMITATION_ACTION_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtLimitationModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetBtLimitationModeRequest::BmCoreIfMessage_SetBtLimitationModeRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_BT_LIMITATION_MODE_REQUEST, BM_RESTRICTION_GROUP_00, act, origin),
         _bdAddress(""),
         _bdName(""),
         _limitationMode(BM_LIMITATION_FEATURE_UNKNOWN, BM_LIMITATION_COMMUNICATION_IF_LAST),
         _limitationAction(BM_LIMITATION_ACTION_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtLimitationModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetBtLimitationModeRequest::BmCoreIfMessage_SetBtLimitationModeRequest(IN const BdAddress& bdAddress, IN const BdName& bdName,
         IN const LimitationMode& limitationMode, IN const LimitationAction limitationAction, IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) : BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_BT_LIMITATION_MODE_REQUEST, BM_RESTRICTION_GROUP_00, act, origin),
         _bdAddress(bdAddress),
         _bdName(bdName),
         _limitationMode(limitationMode),
         _limitationAction(limitationAction)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtLimitationModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetBtLimitationModeRequest::BmCoreIfMessage_SetBtLimitationModeRequest(IN const BmCoreIfMessage_SetBtLimitationModeRequest& other) :
      BmCoreIfMessage(other),
      _bdAddress(other._bdAddress),
      _bdName(other._bdName),
      _limitationMode(other._limitationMode),
      _limitationAction(other._limitationAction)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtLimitationModeRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetBtLimitationModeRequest::~BmCoreIfMessage_SetBtLimitationModeRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtLimitationModeRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_SetBtLimitationModeRequest& first, BmCoreIfMessage_SetBtLimitationModeRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._bdAddress, second._bdAddress);
      swap(first._bdName, second._bdName);
      swap(first._limitationMode, second._limitationMode);
      swap(first._limitationAction, second._limitationAction);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SetBtLimitationModeRequest& BmCoreIfMessage_SetBtLimitationModeRequest::operator=(BmCoreIfMessage_SetBtLimitationModeRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SetBtLimitationModeRequest::operator==(const BmCoreIfMessage_SetBtLimitationModeRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_bdAddress == rhs._bdAddress)
            && (this->_bdName == rhs._bdName)
            && (this->_limitationMode == rhs._limitationMode)
            && (this->_limitationAction == rhs._limitationAction));
   }

   BmCoreIfMessage* BmCoreIfMessage_SetBtLimitationModeRequest::clone(void) const
   {
      return new BmCoreIfMessage_SetBtLimitationModeRequest(*this);
   }

   void BmCoreIfMessage_SetBtLimitationModeRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] bdAddress = \"%50s\", bdName = \"%50s\", limitationFeature = %d, limitationCommunicationIf = %d, limitationAction = %d",
            (const void*) this, _bdAddress.c_str(), _bdName.c_str(), ETG_CENUM(LimitationFeature, _limitationMode._limitationFeature),
            ETG_CENUM(LimitationCommunicationIf, _limitationMode._limitationCommunicationIf),
            ETG_CENUM(LimitationAction, _limitationAction)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_ReplaceBtLimitationModeRequest::BmCoreIfMessage_ReplaceBtLimitationModeRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_REPLACE_BT_LIMITATION_MODE_REQUEST, BM_RESTRICTION_GROUP_06, 0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
               _newBdAddress(""), _newBdName(""), _newLimitationMode(BM_LIMITATION_FEATURE_UNKNOWN, BM_LIMITATION_COMMUNICATION_IF_LAST),
               _newLimitationAction(BM_LIMITATION_ACTION_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ReplaceBtLimitationModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_ReplaceBtLimitationModeRequest::BmCoreIfMessage_ReplaceBtLimitationModeRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_REPLACE_BT_LIMITATION_MODE_REQUEST, BM_RESTRICTION_GROUP_06, act, origin),
         _newBdAddress(""), _newBdName(""), _newLimitationMode(BM_LIMITATION_FEATURE_UNKNOWN, BM_LIMITATION_COMMUNICATION_IF_LAST),
         _newLimitationAction(BM_LIMITATION_ACTION_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ReplaceBtLimitationModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_ReplaceBtLimitationModeRequest::BmCoreIfMessage_ReplaceBtLimitationModeRequest(IN const BtLimitationModeInfo& limitationModeToBeReplaced,
         IN const BdAddress& bdAddress, IN const BdName& bdName, IN const LimitationMode& limitationMode, IN const LimitationAction limitationAction,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_REPLACE_BT_LIMITATION_MODE_REQUEST, BM_RESTRICTION_GROUP_06, act, origin),
         _limitationModeToBeReplaced(limitationModeToBeReplaced), _newBdAddress(bdAddress), _newBdName(bdName), _newLimitationMode(limitationMode),
         _newLimitationAction(limitationAction)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ReplaceBtLimitationModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_ReplaceBtLimitationModeRequest::BmCoreIfMessage_ReplaceBtLimitationModeRequest(IN const BmCoreIfMessage_ReplaceBtLimitationModeRequest& other) :
      BmCoreIfMessage(other), _limitationModeToBeReplaced(other._limitationModeToBeReplaced), _newBdAddress(other._newBdAddress), _newBdName(other._newBdName),
      _newLimitationMode(other._newLimitationMode), _newLimitationAction(other._newLimitationAction)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ReplaceBtLimitationModeRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_ReplaceBtLimitationModeRequest::~BmCoreIfMessage_ReplaceBtLimitationModeRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ReplaceBtLimitationModeRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_ReplaceBtLimitationModeRequest& first, BmCoreIfMessage_ReplaceBtLimitationModeRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._limitationModeToBeReplaced, second._limitationModeToBeReplaced);
      swap(first._newBdAddress, second._newBdAddress);
      swap(first._newBdName, second._newBdName);
      swap(first._newLimitationMode, second._newLimitationMode);
      swap(first._newLimitationAction, second._newLimitationAction);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_ReplaceBtLimitationModeRequest& BmCoreIfMessage_ReplaceBtLimitationModeRequest::operator=(BmCoreIfMessage_ReplaceBtLimitationModeRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_ReplaceBtLimitationModeRequest::operator==(const BmCoreIfMessage_ReplaceBtLimitationModeRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_limitationModeToBeReplaced == rhs._limitationModeToBeReplaced)
            && (this->_newBdAddress == rhs._newBdAddress)
            && (this->_newBdName == rhs._newBdName)
            && (this->_newLimitationMode == rhs._newLimitationMode)
            && (this->_newLimitationAction == rhs._newLimitationAction));
   }

   BmCoreIfMessage* BmCoreIfMessage_ReplaceBtLimitationModeRequest::clone(void) const
   {
      return new BmCoreIfMessage_ReplaceBtLimitationModeRequest(*this);
   }

   void BmCoreIfMessage_ReplaceBtLimitationModeRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] _limitationModeToBeReplaced: bdAddress = \"%50s\", bdName = \"%50s\", limitationFeature = %d, limitationCommunicationIf = %d, limitationAction = %d",
            (const void*) this, _limitationModeToBeReplaced._bdAddress.c_str(), _limitationModeToBeReplaced._bdName.c_str(),
            ETG_CENUM(LimitationFeature, _limitationModeToBeReplaced._limitationMode._limitationFeature),
            ETG_CENUM(LimitationCommunicationIf, _limitationModeToBeReplaced._limitationMode._limitationCommunicationIf),
            ETG_CENUM(LimitationAction, _limitationModeToBeReplaced._limitationState)));

      ETG_TRACE_USR4(("traceMessage: [0x%p] bdAddress = \"%50s\", bdName = \"%50s\", limitationFeature = %d, limitationCommunicationIf = %d, limitationAction = %d",
            (const void*) this, _newBdAddress.c_str(), _newBdName.c_str(), ETG_CENUM(LimitationFeature, _newLimitationMode._limitationFeature),
            ETG_CENUM(LimitationCommunicationIf, _newLimitationMode._limitationCommunicationIf), ETG_CENUM(LimitationAction, _newLimitationAction)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtLimitationModeUpdate::BmCoreIfMessage_BtLimitationModeUpdate() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BT_LIMITATION_MODE_UPDATE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _btLimitationMode()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtLimitationModeUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtLimitationModeUpdate::BmCoreIfMessage_BtLimitationModeUpdate(IN const BtLimitationMode& btLimitationMode) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BT_LIMITATION_MODE_UPDATE, BM_RESTRICTION_GROUP_00, 0u,
               BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _btLimitationMode(btLimitationMode)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtLimitationModeUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtLimitationModeUpdate::BmCoreIfMessage_BtLimitationModeUpdate(IN const BmCoreIfMessage_BtLimitationModeUpdate& other) :
      BmCoreIfMessage(other),
      _btLimitationMode(other._btLimitationMode)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtLimitationModeUpdate: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtLimitationModeUpdate::~BmCoreIfMessage_BtLimitationModeUpdate()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtLimitationModeUpdate: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtLimitationModeUpdate& first, BmCoreIfMessage_BtLimitationModeUpdate& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btLimitationMode, second._btLimitationMode);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtLimitationModeUpdate& BmCoreIfMessage_BtLimitationModeUpdate::operator=(BmCoreIfMessage_BtLimitationModeUpdate other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtLimitationModeUpdate::operator==(const BmCoreIfMessage_BtLimitationModeUpdate& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btLimitationMode == rhs._btLimitationMode));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtLimitationModeUpdate::clone(void) const
   {
      return new BmCoreIfMessage_BtLimitationModeUpdate(*this);
   }

   void BmCoreIfMessage_BtLimitationModeUpdate::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      VARTRACE_USR4(_btLimitationMode);
   }

   // *****************************************************************************************

   BmCoreIfMessage_NotifyUserDecisionRequest::BmCoreIfMessage_NotifyUserDecisionRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_NOTIFY_USER_DECISION_REQUEST, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT), _userDecisionInfo(BM_CONFLICT_TRIGGER_NONE, BM_USER_DECISION_NONE)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_NotifyUserDecisionRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_NotifyUserDecisionRequest::BmCoreIfMessage_NotifyUserDecisionRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_NOTIFY_USER_DECISION_REQUEST, BM_RESTRICTION_GROUP_00, act, origin),
         _userDecisionInfo(BM_CONFLICT_TRIGGER_NONE, BM_USER_DECISION_NONE)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_NotifyUserDecisionRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_NotifyUserDecisionRequest::BmCoreIfMessage_NotifyUserDecisionRequest(IN const BmCoreIfMessage_NotifyUserDecisionRequest& other) :
      BmCoreIfMessage(other), _userDecisionInfo(other._userDecisionInfo)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_NotifyUserDecisionRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_NotifyUserDecisionRequest::~BmCoreIfMessage_NotifyUserDecisionRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_NotifyUserDecisionRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_NotifyUserDecisionRequest& first, BmCoreIfMessage_NotifyUserDecisionRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._userDecisionInfo, second._userDecisionInfo);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_NotifyUserDecisionRequest& BmCoreIfMessage_NotifyUserDecisionRequest::operator=(BmCoreIfMessage_NotifyUserDecisionRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_NotifyUserDecisionRequest::operator==(const BmCoreIfMessage_NotifyUserDecisionRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_userDecisionInfo == rhs._userDecisionInfo));
   }

   BmCoreIfMessage* BmCoreIfMessage_NotifyUserDecisionRequest::clone(void) const
   {
      return new BmCoreIfMessage_NotifyUserDecisionRequest(*this);
   }

   void BmCoreIfMessage_NotifyUserDecisionRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] _userDecisionInfo = (_conflictTrigger = %d, _userDecision = %d)",
            (const void*) this, ETG_CENUM(ConflictTrigger, _userDecisionInfo._conflictTrigger),
            ETG_CENUM(UserDecision, _userDecisionInfo._userDecision)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SetPrimaryHfpDeviceRequest::BmCoreIfMessage_SetPrimaryHfpDeviceRequest() :
            BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_PRIMARY_HFP_DEVICE_REQUEST, BM_RESTRICTION_GROUP_00,
                  0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
            _deviceHandle(0u)
      {
         ETG_TRACE_USR1(("BmCoreIfMessage_SetPrimaryHfpDeviceRequest: [0x%p] creating BM Core IF message object", (void*) this));
      }

   BmCoreIfMessage_SetPrimaryHfpDeviceRequest::BmCoreIfMessage_SetPrimaryHfpDeviceRequest(IN const DeviceId deviceHandle,
            IN const BmCoreIfMsgOrigin origin) :
            BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_PRIMARY_HFP_DEVICE_REQUEST, BM_RESTRICTION_GROUP_00, 0u, origin),
            _deviceHandle(deviceHandle)
      {
         ETG_TRACE_USR1(("BmCoreIfMessage_SetPrimaryHfpDeviceRequest: [0x%p] creating BM Core IF message object", (void*) this));
      }

   BmCoreIfMessage_SetPrimaryHfpDeviceRequest::BmCoreIfMessage_SetPrimaryHfpDeviceRequest(IN const BmCoreIfMessage_SetPrimaryHfpDeviceRequest& other) :
         BmCoreIfMessage(other),
         _deviceHandle(other._deviceHandle)
      {
         ETG_TRACE_USR1(("BmCoreIfMessage_SetPrimaryHfpDeviceRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
      }

   BmCoreIfMessage_SetPrimaryHfpDeviceRequest::~BmCoreIfMessage_SetPrimaryHfpDeviceRequest()
      {
         ETG_TRACE_USR1(("BmCoreIfMessage_SetPrimaryHfpDeviceRequest: [0x%p] destroying BM Core IF message object", (void*) this));
      }

      void swap(BmCoreIfMessage_SetPrimaryHfpDeviceRequest& first, BmCoreIfMessage_SetPrimaryHfpDeviceRequest& second)
      {
         using std::swap;

         swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
         swap(first._deviceHandle, second._deviceHandle);
      }

      //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
      BmCoreIfMessage_SetPrimaryHfpDeviceRequest& BmCoreIfMessage_SetPrimaryHfpDeviceRequest::operator=(BmCoreIfMessage_SetPrimaryHfpDeviceRequest other)
      {
         swap(*this, other);

         return *this;
      }

      bool BmCoreIfMessage_SetPrimaryHfpDeviceRequest::operator==(const BmCoreIfMessage_SetPrimaryHfpDeviceRequest& rhs) const
      {
         return ((BmCoreIfMessage::operator ==(rhs))
               && (this->_deviceHandle == rhs._deviceHandle));
      }

      BmCoreIfMessage* BmCoreIfMessage_SetPrimaryHfpDeviceRequest::clone(void) const
      {
         return new BmCoreIfMessage_SetPrimaryHfpDeviceRequest(*this);
      }

      void BmCoreIfMessage_SetPrimaryHfpDeviceRequest::traceMessage(void) const
      {
         BmCoreIfMessage::traceMessage();
         ETG_TRACE_USR4(("traceMessage: [0x%p] _deviceHandle = %d",(const void*) this, _deviceHandle));
      }

      // *****************************************************************************************

   // *****************************************************************************************

   BmCoreIfMessage_SwitchTestModeRequest::BmCoreIfMessage_SwitchTestModeRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_TEST_MODE_REQUEST, BM_RESTRICTION_GROUP_05,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _targetSwitchState(TARGET_SWITCH_STATE_SWITCHED_OFF),
         _bdAddress("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchTestModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchTestModeRequest::BmCoreIfMessage_SwitchTestModeRequest(IN const TargetSwitchState targetSwitchState,
         IN const BdAddress& bdAddress, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_TEST_MODE_REQUEST, BM_RESTRICTION_GROUP_05, act, origin),
         _targetSwitchState(targetSwitchState),
         _bdAddress(bdAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchTestModeRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchTestModeRequest::BmCoreIfMessage_SwitchTestModeRequest(IN const BmCoreIfMessage_SwitchTestModeRequest& other) :
      BmCoreIfMessage(other),
      _targetSwitchState(other._targetSwitchState),
      _bdAddress(other._bdAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchTestModeRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchTestModeRequest::~BmCoreIfMessage_SwitchTestModeRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchTestModeRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_SwitchTestModeRequest& first, BmCoreIfMessage_SwitchTestModeRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._targetSwitchState, second._targetSwitchState);
      swap(first._bdAddress, second._bdAddress);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SwitchTestModeRequest& BmCoreIfMessage_SwitchTestModeRequest::operator=(BmCoreIfMessage_SwitchTestModeRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SwitchTestModeRequest::operator==(const BmCoreIfMessage_SwitchTestModeRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_targetSwitchState == rhs._targetSwitchState)
            && (this->_bdAddress == rhs._bdAddress));
   }

   BmCoreIfMessage* BmCoreIfMessage_SwitchTestModeRequest::clone(void) const
   {
      return new BmCoreIfMessage_SwitchTestModeRequest(*this);
   }

   void BmCoreIfMessage_SwitchTestModeRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] targetSwitchState = %d, bdAddress = \"%50s\"",
            (const void*) this, ETG_CENUM(TargetSwitchState, _targetSwitchState), _bdAddress.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SwitchMultiHFPSupportRequest::BmCoreIfMessage_SwitchMultiHFPSupportRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_MULTI_HFP_SUPPORT_REQUEST, BM_RESTRICTION_GROUP_00,
         0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _targetSwitchState(TARGET_SWITCH_STATE_SWITCHED_OFF)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchMultiHFPSupportRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchMultiHFPSupportRequest::BmCoreIfMessage_SwitchMultiHFPSupportRequest(IN const TargetSwitchState targetSwitchState,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SWITCH_MULTI_HFP_SUPPORT_REQUEST, BM_RESTRICTION_GROUP_00, act, origin),
         _targetSwitchState(targetSwitchState)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchMultiHFPSupportRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchMultiHFPSupportRequest::BmCoreIfMessage_SwitchMultiHFPSupportRequest(IN const BmCoreIfMessage_SwitchMultiHFPSupportRequest& other) :
               BmCoreIfMessage(other),
               _targetSwitchState(other._targetSwitchState)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchMultiHFPSupportRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SwitchMultiHFPSupportRequest::~BmCoreIfMessage_SwitchMultiHFPSupportRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SwitchMultiHFPSupportRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_SwitchMultiHFPSupportRequest& first, BmCoreIfMessage_SwitchMultiHFPSupportRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._targetSwitchState, second._targetSwitchState);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SwitchMultiHFPSupportRequest& BmCoreIfMessage_SwitchMultiHFPSupportRequest::operator=(BmCoreIfMessage_SwitchMultiHFPSupportRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SwitchMultiHFPSupportRequest::operator==(const BmCoreIfMessage_SwitchMultiHFPSupportRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_targetSwitchState == rhs._targetSwitchState));
   }

   BmCoreIfMessage* BmCoreIfMessage_SwitchMultiHFPSupportRequest::clone(void) const
   {
      return new BmCoreIfMessage_SwitchMultiHFPSupportRequest(*this);
   }

   void BmCoreIfMessage_SwitchMultiHFPSupportRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] targetSwitchState = %d",
            (const void*) this, ETG_CENUM(TargetSwitchState, _targetSwitchState)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SetDeviceUsagePreferenceRequest::BmCoreIfMessage_SetDeviceUsagePreferenceRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_DEVICE_USAGEPREFERENCE_REQUEST, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
               _deviceHandle(0u),
               _usagePreference(BM_UP_UNDECIDED)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetDeviceUsagePreferenceRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetDeviceUsagePreferenceRequest::BmCoreIfMessage_SetDeviceUsagePreferenceRequest(IN const DeviceId deviceHandle,
         IN const UsagePreference usagePreference, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_DEVICE_USAGEPREFERENCE_REQUEST, BM_RESTRICTION_GROUP_00, act, origin),
         _deviceHandle(deviceHandle),
         _usagePreference(usagePreference)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetDeviceUsagePreferenceRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetDeviceUsagePreferenceRequest::BmCoreIfMessage_SetDeviceUsagePreferenceRequest(IN const BmCoreIfMessage_SetDeviceUsagePreferenceRequest& other) :
         BmCoreIfMessage(other),
         _deviceHandle(other._deviceHandle),
         _usagePreference(other._usagePreference)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetDeviceUsagePreferenceRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetDeviceUsagePreferenceRequest::~BmCoreIfMessage_SetDeviceUsagePreferenceRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetDeviceUsagePreferenceRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_SetDeviceUsagePreferenceRequest& first, BmCoreIfMessage_SetDeviceUsagePreferenceRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._usagePreference, second._usagePreference);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SetDeviceUsagePreferenceRequest& BmCoreIfMessage_SetDeviceUsagePreferenceRequest::operator=(BmCoreIfMessage_SetDeviceUsagePreferenceRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SetDeviceUsagePreferenceRequest::operator==(const BmCoreIfMessage_SetDeviceUsagePreferenceRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_usagePreference == rhs._usagePreference));
   }

   BmCoreIfMessage* BmCoreIfMessage_SetDeviceUsagePreferenceRequest::clone(void) const
   {
      return new BmCoreIfMessage_SetDeviceUsagePreferenceRequest(*this);
   }

   void BmCoreIfMessage_SetDeviceUsagePreferenceRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] _deviceHandle = %d _usagePreference = %d",
            (const void*) this, _deviceHandle, ETG_CENUM(UsagePreference, _usagePreference)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_ResetToDefaultRequest::BmCoreIfMessage_ResetToDefaultRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_RESET_TO_DEFAULT_REQUEST, BM_RESTRICTION_GROUP_02,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT),
         _factorySettingsChanged(true)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ResetToDefaultRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_ResetToDefaultRequest::BmCoreIfMessage_ResetToDefaultRequest(IN const bool factorySettingsChanged,
         IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_RESET_TO_DEFAULT_REQUEST, BM_RESTRICTION_GROUP_02, act, origin),
               _factorySettingsChanged(factorySettingsChanged)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ResetToDefaultRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_ResetToDefaultRequest::BmCoreIfMessage_ResetToDefaultRequest(IN const BmCoreIfMessage_ResetToDefaultRequest& other) :
         BmCoreIfMessage(other),
         _factorySettingsChanged(other._factorySettingsChanged)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ResetToDefaultRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_ResetToDefaultRequest::~BmCoreIfMessage_ResetToDefaultRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_ResetToDefaultRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_ResetToDefaultRequest& first, BmCoreIfMessage_ResetToDefaultRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._factorySettingsChanged, second._factorySettingsChanged);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_ResetToDefaultRequest& BmCoreIfMessage_ResetToDefaultRequest::operator=(BmCoreIfMessage_ResetToDefaultRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_ResetToDefaultRequest::operator==(const BmCoreIfMessage_ResetToDefaultRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_factorySettingsChanged == rhs._factorySettingsChanged));
   }

   BmCoreIfMessage* BmCoreIfMessage_ResetToDefaultRequest::clone(void) const
   {
      return new BmCoreIfMessage_ResetToDefaultRequest(*this);
   }

   void BmCoreIfMessage_ResetToDefaultRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] factorySettingsChanged = %10s",
            (const void*) this, _factorySettingsChanged ? "true" : "false"));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SetBtProfilesUsageRequest::BmCoreIfMessage_SetBtProfilesUsageRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_BT_PROFILEUSAGE_INFO_REQUEST, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_CLIENT), _BTProfileUsageInfoListReq()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtProfilesUsageRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetBtProfilesUsageRequest::BmCoreIfMessage_SetBtProfilesUsageRequest(IN const ActType act,
         IN const BmCoreIfMsgOrigin origin) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_BT_PROFILEUSAGE_INFO_REQUEST, BM_RESTRICTION_GROUP_00, act, origin),
         _BTProfileUsageInfoListReq()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtProfilesUsageRequest: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetBtProfilesUsageRequest::BmCoreIfMessage_SetBtProfilesUsageRequest(IN const BmCoreIfMessage_SetBtProfilesUsageRequest& other) :
      BmCoreIfMessage(other), _BTProfileUsageInfoListReq(other._BTProfileUsageInfoListReq)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtProfilesUsageRequest: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetBtProfilesUsageRequest::~BmCoreIfMessage_SetBtProfilesUsageRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetBtProfilesUsageRequest: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_SetBtProfilesUsageRequest& first, BmCoreIfMessage_SetBtProfilesUsageRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._BTProfileUsageInfoListReq, second._BTProfileUsageInfoListReq);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SetBtProfilesUsageRequest& BmCoreIfMessage_SetBtProfilesUsageRequest::operator=(BmCoreIfMessage_SetBtProfilesUsageRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SetBtProfilesUsageRequest::operator==(const BmCoreIfMessage_SetBtProfilesUsageRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_BTProfileUsageInfoListReq == rhs._BTProfileUsageInfoListReq));
   }

   /*BmCoreIfMessage* BmCoreIfMessage_SetBtProfilesUsageRequest::clone(void) const
   {
      return new BmCoreIfMessage_SetBtProfilesUsageRequest(*this);
   }*/

   void BmCoreIfMessage_SetBtProfilesUsageRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      //VARTRACE_USR4(_BTProfileUsageInfoListReq._btProfileUsageInfoList);
   }

   // *****************************************************************************************

   // *****************************************************************************************
   // ******************** Messages corresponding to BT Stack IF callbacks ********************
   // *****************************************************************************************

   BmCoreIfMessage_BtsFbConnectionInitialized::BmCoreIfMessage_BtsFbConnectionInitialized() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_FB_CONNECTION_INITIALIZED, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(BTS_REQ_SUCCESS)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsFbConnectionInitialized: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsFbConnectionInitialized::BmCoreIfMessage_BtsFbConnectionInitialized(IN const BTSRequestResult requestResult,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_FB_CONNECTION_INITIALIZED, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsFbConnectionInitialized: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsFbConnectionInitialized::BmCoreIfMessage_BtsFbConnectionInitialized(IN const BmCoreIfMessage_BtsFbConnectionInitialized& other) :
         BmCoreIfMessage(other),
         _requestResult(other._requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsFbConnectionInitialized: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsFbConnectionInitialized::~BmCoreIfMessage_BtsFbConnectionInitialized()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsFbConnectionInitialized: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsFbConnectionInitialized& first, BmCoreIfMessage_BtsFbConnectionInitialized& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._requestResult, second._requestResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsFbConnectionInitialized& BmCoreIfMessage_BtsFbConnectionInitialized::operator=(BmCoreIfMessage_BtsFbConnectionInitialized other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsFbConnectionInitialized::operator==(const BmCoreIfMessage_BtsFbConnectionInitialized& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_requestResult == rhs._requestResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsFbConnectionInitialized::clone(void) const
   {
      return new BmCoreIfMessage_BtsFbConnectionInitialized(*this);
   }

   void BmCoreIfMessage_BtsFbConnectionInitialized::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] requestResult = %d",
            (const void*) this, ETG_CENUM(BTSRequestResult, _requestResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsLocalVersionInfo::BmCoreIfMessage_BtsLocalVersionInfo() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_LOCAL_VERSION_INFO, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsVersionInfo()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLocalVersionInfo: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsLocalVersionInfo::BmCoreIfMessage_BtsLocalVersionInfo(IN const BTSLocalVersionInfo& btsVersionInfo,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_LOCAL_VERSION_INFO, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsVersionInfo(btsVersionInfo)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLocalVersionInfo: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsLocalVersionInfo::BmCoreIfMessage_BtsLocalVersionInfo(IN const BmCoreIfMessage_BtsLocalVersionInfo& other) :
         BmCoreIfMessage(other),
         _btsVersionInfo(other._btsVersionInfo)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLocalVersionInfo: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsLocalVersionInfo::~BmCoreIfMessage_BtsLocalVersionInfo()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLocalVersionInfo: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsLocalVersionInfo& first, BmCoreIfMessage_BtsLocalVersionInfo& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsVersionInfo, second._btsVersionInfo);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsLocalVersionInfo& BmCoreIfMessage_BtsLocalVersionInfo::operator=(BmCoreIfMessage_BtsLocalVersionInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsLocalVersionInfo::operator==(const BmCoreIfMessage_BtsLocalVersionInfo& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsVersionInfo == rhs._btsVersionInfo));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsLocalVersionInfo::clone(void) const
   {
      return new BmCoreIfMessage_BtsLocalVersionInfo(*this);
   }

   void BmCoreIfMessage_BtsLocalVersionInfo::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsStackType = %d, btsStackVersion = \"%50s\", btsModuleName = \"%50s\", btsBtVersion = %d, btsFwVersion = \"%50s\"",
            (const void*) this, ETG_CENUM(BTSInterfaceType, _btsVersionInfo.stackType),
            _btsVersionInfo.stackVersion.c_str(), _btsVersionInfo.moduleName.c_str(),
            ETG_CENUM(BTSBtCoreVersion, _btsVersionInfo.btVersion), _btsVersionInfo.fwVersion.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsSwitchBluetoothOnOffResult::BmCoreIfMessage_BtsSwitchBluetoothOnOffResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SWITCH_BLUETOOTH_ON_OFF_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(BTS_REQ_SUCCESS)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSwitchBluetoothOnOffResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSwitchBluetoothOnOffResult::BmCoreIfMessage_BtsSwitchBluetoothOnOffResult(IN const BTSRequestResult requestResult,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SWITCH_BLUETOOTH_ON_OFF_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSwitchBluetoothOnOffResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSwitchBluetoothOnOffResult::BmCoreIfMessage_BtsSwitchBluetoothOnOffResult(IN const BmCoreIfMessage_BtsSwitchBluetoothOnOffResult& other) :
         BmCoreIfMessage(other),
         _requestResult(other._requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSwitchBluetoothOnOffResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSwitchBluetoothOnOffResult::~BmCoreIfMessage_BtsSwitchBluetoothOnOffResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSwitchBluetoothOnOffResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsSwitchBluetoothOnOffResult& first, BmCoreIfMessage_BtsSwitchBluetoothOnOffResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._requestResult, second._requestResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsSwitchBluetoothOnOffResult& BmCoreIfMessage_BtsSwitchBluetoothOnOffResult::operator=(BmCoreIfMessage_BtsSwitchBluetoothOnOffResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsSwitchBluetoothOnOffResult::operator==(const BmCoreIfMessage_BtsSwitchBluetoothOnOffResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_requestResult == rhs._requestResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsSwitchBluetoothOnOffResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsSwitchBluetoothOnOffResult(*this);
   }

   void BmCoreIfMessage_BtsSwitchBluetoothOnOffResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] requestResult = %d",
            (const void*) this, ETG_CENUM(BTSRequestResult, _requestResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus::BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_CURRENT_BLUETOOTH_ON_OFF_STATUS, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
            _bluetoothMode(BTS_BT_MODE_LAST),
            _bluetoothOffReason(),
            _adapterMode(BTS_ADAPTER_MODE_LAST),
            _localDeviceAddress("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus::BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus(IN const BTSBluetoothMode bluetoothMode,
         IN const BTSBluetoothOffReason bluetoothOffReason, IN const BTSAdapterMode adapterMode,
         IN const BTSBDAddress& localDeviceAddress, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_CURRENT_BLUETOOTH_ON_OFF_STATUS, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _bluetoothMode(bluetoothMode),
         _bluetoothOffReason(bluetoothOffReason),
         _adapterMode(adapterMode),
         _localDeviceAddress(localDeviceAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus::BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus(IN const BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus& other) :
         BmCoreIfMessage(other),
         _bluetoothMode(other._bluetoothMode),
         _bluetoothOffReason(other._bluetoothOffReason),
         _adapterMode(other._adapterMode),
         _localDeviceAddress(other._localDeviceAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus::~BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus& first, BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._bluetoothMode, second._bluetoothMode);
      swap(first._bluetoothOffReason, second._bluetoothOffReason);
      swap(first._adapterMode, second._adapterMode);
      swap(first._localDeviceAddress, second._localDeviceAddress);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus& BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus::operator=(BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus::operator==(const BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_bluetoothMode == rhs._bluetoothMode)
            && (this->_bluetoothOffReason == rhs._bluetoothOffReason)
            && (this->_adapterMode == rhs._adapterMode)
            && (this->_localDeviceAddress == rhs._localDeviceAddress));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus::clone(void) const
   {
      return new BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus(*this);
   }

   void BmCoreIfMessage_BtsCurrentBluetoothOnOffStatus::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] bluetoothMode = %d, bluetoothOffReason = %d, adapterMode = %d, localDeviceAddress = \"%50s\"",
            (const void*) this, ETG_CENUM(BTSBluetoothMode, _bluetoothMode), ETG_CENUM(BTSBluetoothOffReason, _bluetoothOffReason),
            ETG_CENUM(BTSAdapterMode, _adapterMode), _localDeviceAddress.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsBluetoothHardwareOnOffResult::BmCoreIfMessage_BtsBluetoothHardwareOnOffResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_BLUETOOTH_HARDWARE_ON_OFF_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsResult(BTS_REQ_SUCCESS)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsBluetoothHardwareOnOffResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsBluetoothHardwareOnOffResult::BmCoreIfMessage_BtsBluetoothHardwareOnOffResult(IN const BTSRequestResult btsResult,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_BLUETOOTH_HARDWARE_ON_OFF_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsResult(btsResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsBluetoothHardwareOnOffResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsBluetoothHardwareOnOffResult::BmCoreIfMessage_BtsBluetoothHardwareOnOffResult(IN const BmCoreIfMessage_BtsBluetoothHardwareOnOffResult& other) :
         BmCoreIfMessage(other),
         _btsResult(other._btsResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsBluetoothHardwareOnOffResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsBluetoothHardwareOnOffResult::~BmCoreIfMessage_BtsBluetoothHardwareOnOffResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsBluetoothHardwareOnOffResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsBluetoothHardwareOnOffResult& first, BmCoreIfMessage_BtsBluetoothHardwareOnOffResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsResult, second._btsResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsBluetoothHardwareOnOffResult& BmCoreIfMessage_BtsBluetoothHardwareOnOffResult::operator=(BmCoreIfMessage_BtsBluetoothHardwareOnOffResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsBluetoothHardwareOnOffResult::operator==(const BmCoreIfMessage_BtsBluetoothHardwareOnOffResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsResult == rhs._btsResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsBluetoothHardwareOnOffResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsBluetoothHardwareOnOffResult(*this);
   }

   void BmCoreIfMessage_BtsBluetoothHardwareOnOffResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsResult = %d",
            (const void*) this, ETG_CENUM(BTSRequestResult, _btsResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsSetLocalBtNameResult::BmCoreIfMessage_BtsSetLocalBtNameResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SET_LOCAL_BT_NAME_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(BTS_REQ_SUCCESS)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSetLocalBtNameResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSetLocalBtNameResult::BmCoreIfMessage_BtsSetLocalBtNameResult(IN const BTSRequestResult requestResult,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SET_LOCAL_BT_NAME_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSetLocalBtNameResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSetLocalBtNameResult::BmCoreIfMessage_BtsSetLocalBtNameResult(IN const BmCoreIfMessage_BtsSetLocalBtNameResult& other) :
         BmCoreIfMessage(other),
         _requestResult(other._requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSetLocalBtNameResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSetLocalBtNameResult::~BmCoreIfMessage_BtsSetLocalBtNameResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSetLocalBtNameResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsSetLocalBtNameResult& first, BmCoreIfMessage_BtsSetLocalBtNameResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._requestResult, second._requestResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsSetLocalBtNameResult& BmCoreIfMessage_BtsSetLocalBtNameResult::operator=(BmCoreIfMessage_BtsSetLocalBtNameResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsSetLocalBtNameResult::operator==(const BmCoreIfMessage_BtsSetLocalBtNameResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_requestResult == rhs._requestResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsSetLocalBtNameResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsSetLocalBtNameResult(*this);
   }

   void BmCoreIfMessage_BtsSetLocalBtNameResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] requestResult = %d",
            (const void*) this, ETG_CENUM(BTSRequestResult, _requestResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsCurrentLocalBtName::BmCoreIfMessage_BtsCurrentLocalBtName() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_CURRENT_LOCAL_BT_NAME, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _adapterName("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentLocalBtName: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsCurrentLocalBtName::BmCoreIfMessage_BtsCurrentLocalBtName(IN const BTSDeviceName& adapterName) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_CURRENT_LOCAL_BT_NAME, BM_RESTRICTION_GROUP_00, 0u,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _adapterName(adapterName)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentLocalBtName: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsCurrentLocalBtName::BmCoreIfMessage_BtsCurrentLocalBtName(IN const BmCoreIfMessage_BtsCurrentLocalBtName& other) :
         BmCoreIfMessage(other),
         _adapterName(other._adapterName)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentLocalBtName: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsCurrentLocalBtName::~BmCoreIfMessage_BtsCurrentLocalBtName()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentLocalBtName: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsCurrentLocalBtName& first, BmCoreIfMessage_BtsCurrentLocalBtName& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._adapterName, second._adapterName);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsCurrentLocalBtName& BmCoreIfMessage_BtsCurrentLocalBtName::operator=(BmCoreIfMessage_BtsCurrentLocalBtName other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsCurrentLocalBtName::operator==(const BmCoreIfMessage_BtsCurrentLocalBtName& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_adapterName == rhs._adapterName));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsCurrentLocalBtName::clone(void) const
   {
      return new BmCoreIfMessage_BtsCurrentLocalBtName(*this);
   }

   void BmCoreIfMessage_BtsCurrentLocalBtName::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] adapterName = \"%100s\"",
            (const void*) this, _adapterName.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsSetLocalAdapterModesResult::BmCoreIfMessage_BtsSetLocalAdapterModesResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SET_LOCAL_ADAPTER_MODES_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(BTS_REQ_SUCCESS)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSetLocalAdapterModesResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSetLocalAdapterModesResult::BmCoreIfMessage_BtsSetLocalAdapterModesResult(IN const BTSRequestResult requestResult,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SET_LOCAL_ADAPTER_MODES_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSetLocalAdapterModesResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSetLocalAdapterModesResult::BmCoreIfMessage_BtsSetLocalAdapterModesResult(IN const BmCoreIfMessage_BtsSetLocalAdapterModesResult& other) :
         BmCoreIfMessage(other),
         _requestResult(other._requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSetLocalAdapterModesResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSetLocalAdapterModesResult::~BmCoreIfMessage_BtsSetLocalAdapterModesResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSetLocalAdapterModesResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsSetLocalAdapterModesResult& first, BmCoreIfMessage_BtsSetLocalAdapterModesResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._requestResult, second._requestResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsSetLocalAdapterModesResult& BmCoreIfMessage_BtsSetLocalAdapterModesResult::operator=(BmCoreIfMessage_BtsSetLocalAdapterModesResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsSetLocalAdapterModesResult::operator==(const BmCoreIfMessage_BtsSetLocalAdapterModesResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_requestResult == rhs._requestResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsSetLocalAdapterModesResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsSetLocalAdapterModesResult(*this);
   }

   void BmCoreIfMessage_BtsSetLocalAdapterModesResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] requestResult = %d",
            (const void*) this, ETG_CENUM(BTSRequestResult, _requestResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsCurrentDiscoverableMode::BmCoreIfMessage_BtsCurrentDiscoverableMode() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_CURRENT_DISCOVERABLE_MODE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
            _discoverableMode(BTS_MODE_DISABLED),
            _offReason(BTS_MODE_OFF_REASON_APP_REQUESTED)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentDiscoverableMode: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsCurrentDiscoverableMode::BmCoreIfMessage_BtsCurrentDiscoverableMode(IN const BTSLocalMode discoverableMode,
         IN const BTSLocalModeOffReason offReason, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_CURRENT_DISCOVERABLE_MODE, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _discoverableMode(discoverableMode),
         _offReason(offReason)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentDiscoverableMode: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsCurrentDiscoverableMode::BmCoreIfMessage_BtsCurrentDiscoverableMode(IN const BmCoreIfMessage_BtsCurrentDiscoverableMode& other) :
         BmCoreIfMessage(other),
         _discoverableMode(other._discoverableMode),
         _offReason(other._offReason)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentDiscoverableMode: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsCurrentDiscoverableMode::~BmCoreIfMessage_BtsCurrentDiscoverableMode()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentDiscoverableMode: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsCurrentDiscoverableMode& first, BmCoreIfMessage_BtsCurrentDiscoverableMode& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._discoverableMode, second._discoverableMode);
      swap(first._offReason, second._offReason);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsCurrentDiscoverableMode& BmCoreIfMessage_BtsCurrentDiscoverableMode::operator=(BmCoreIfMessage_BtsCurrentDiscoverableMode other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsCurrentDiscoverableMode::operator==(const BmCoreIfMessage_BtsCurrentDiscoverableMode& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_discoverableMode == rhs._discoverableMode)
            && (this->_offReason == rhs._offReason));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsCurrentDiscoverableMode::clone(void) const
   {
      return new BmCoreIfMessage_BtsCurrentDiscoverableMode(*this);
   }

   void BmCoreIfMessage_BtsCurrentDiscoverableMode::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] discoverableMode = %d, offReason = %d",
            (const void*) this, ETG_CENUM(BTSLocalMode, _discoverableMode),
            ETG_CENUM(BTSLocalModeOffReason, _offReason)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsCurrentConnectableMode::BmCoreIfMessage_BtsCurrentConnectableMode() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_CURRENT_CONNECTABLE_MODE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
            _connectableMode(BTS_MODE_DISABLED),
            _offReason(BTS_MODE_OFF_REASON_APP_REQUESTED)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentConnectableMode: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsCurrentConnectableMode::BmCoreIfMessage_BtsCurrentConnectableMode(IN const BTSLocalMode connectableMode,
         IN const BTSLocalModeOffReason offReason, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_CURRENT_CONNECTABLE_MODE, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _connectableMode(connectableMode),
         _offReason(offReason)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentConnectableMode: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsCurrentConnectableMode::BmCoreIfMessage_BtsCurrentConnectableMode(IN const BmCoreIfMessage_BtsCurrentConnectableMode& other) :
         BmCoreIfMessage(other),
         _connectableMode(other._connectableMode),
         _offReason(other._offReason)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentConnectableMode: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsCurrentConnectableMode::~BmCoreIfMessage_BtsCurrentConnectableMode()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsCurrentConnectableMode: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsCurrentConnectableMode& first, BmCoreIfMessage_BtsCurrentConnectableMode& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._connectableMode, second._connectableMode);
      swap(first._offReason, second._offReason);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsCurrentConnectableMode& BmCoreIfMessage_BtsCurrentConnectableMode::operator=(BmCoreIfMessage_BtsCurrentConnectableMode other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsCurrentConnectableMode::operator==(const BmCoreIfMessage_BtsCurrentConnectableMode& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_connectableMode == rhs._connectableMode)
            && (this->_offReason == rhs._offReason));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsCurrentConnectableMode::clone(void) const
   {
      return new BmCoreIfMessage_BtsCurrentConnectableMode(*this);
   }

   void BmCoreIfMessage_BtsCurrentConnectableMode::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] connectableMode = %d, offReason = %d",
            (const void*) this, ETG_CENUM(BTSLocalMode, _connectableMode), ETG_CENUM(BTSLocalModeOffReason, _offReason)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsStartDiscoveryResult::BmCoreIfMessage_BtsStartDiscoveryResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_START_DISCOVERY_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(BTS_REQ_SUCCESS)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartDiscoveryResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsStartDiscoveryResult::BmCoreIfMessage_BtsStartDiscoveryResult(IN const BTSRequestResult requestResult,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_START_DISCOVERY_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartDiscoveryResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsStartDiscoveryResult::BmCoreIfMessage_BtsStartDiscoveryResult(IN const BmCoreIfMessage_BtsStartDiscoveryResult& other) :
         BmCoreIfMessage(other),
         _requestResult(other._requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartDiscoveryResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsStartDiscoveryResult::~BmCoreIfMessage_BtsStartDiscoveryResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StartDiscoveryResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsStartDiscoveryResult& first, BmCoreIfMessage_BtsStartDiscoveryResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._requestResult, second._requestResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsStartDiscoveryResult& BmCoreIfMessage_BtsStartDiscoveryResult::operator=(BmCoreIfMessage_BtsStartDiscoveryResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsStartDiscoveryResult::operator==(const BmCoreIfMessage_BtsStartDiscoveryResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_requestResult == rhs._requestResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsStartDiscoveryResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsStartDiscoveryResult(*this);
   }

   void BmCoreIfMessage_BtsStartDiscoveryResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] requestResult = %d",
            (const void*) this, ETG_CENUM(BTSRequestResult, _requestResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsStopDiscoveryResult::BmCoreIfMessage_BtsStopDiscoveryResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_STOP_DISCOVERY_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(BTS_REQ_SUCCESS)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopDiscoveryResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsStopDiscoveryResult::BmCoreIfMessage_BtsStopDiscoveryResult(IN const BTSRequestResult requestResult,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_STOP_DISCOVERY_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopDiscoveryResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsStopDiscoveryResult::BmCoreIfMessage_BtsStopDiscoveryResult(IN const BmCoreIfMessage_BtsStopDiscoveryResult& other) :
         BmCoreIfMessage(other),
         _requestResult(other._requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopDiscoveryResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsStopDiscoveryResult::~BmCoreIfMessage_BtsStopDiscoveryResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_StopDiscoveryResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsStopDiscoveryResult& first, BmCoreIfMessage_BtsStopDiscoveryResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._requestResult, second._requestResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsStopDiscoveryResult& BmCoreIfMessage_BtsStopDiscoveryResult::operator=(BmCoreIfMessage_BtsStopDiscoveryResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsStopDiscoveryResult::operator==(const BmCoreIfMessage_BtsStopDiscoveryResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_requestResult == rhs._requestResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsStopDiscoveryResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsStopDiscoveryResult(*this);
   }

   void BmCoreIfMessage_BtsStopDiscoveryResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] requestResult = %d",
            (const void*) this, ETG_CENUM(BTSRequestResult, _requestResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsDiscoveringStatus::BmCoreIfMessage_BtsDiscoveringStatus() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DISCOVERING_STATUS, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _discoveringStatus(BTS_DISCOVERING_OFF)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DiscoveringStatusUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsDiscoveringStatus::BmCoreIfMessage_BtsDiscoveringStatus(IN const BTSDiscoveringStatus discoveringStatus,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DISCOVERING_STATUS, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _discoveringStatus(discoveringStatus)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DiscoveringStatusUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsDiscoveringStatus::BmCoreIfMessage_BtsDiscoveringStatus(IN const BmCoreIfMessage_BtsDiscoveringStatus& other) :
         BmCoreIfMessage(other),
         _discoveringStatus(other._discoveringStatus)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DiscoveringStatusUpdate: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsDiscoveringStatus::~BmCoreIfMessage_BtsDiscoveringStatus()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DiscoveringStatusUpdate: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsDiscoveringStatus& first, BmCoreIfMessage_BtsDiscoveringStatus& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._discoveringStatus, second._discoveringStatus);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsDiscoveringStatus& BmCoreIfMessage_BtsDiscoveringStatus::operator=(BmCoreIfMessage_BtsDiscoveringStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsDiscoveringStatus::operator==(const BmCoreIfMessage_BtsDiscoveringStatus& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_discoveringStatus == rhs._discoveringStatus));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsDiscoveringStatus::clone(void) const
   {
      return new BmCoreIfMessage_BtsDiscoveringStatus(*this);
   }

   void BmCoreIfMessage_BtsDiscoveringStatus::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] discoveringStatus = %d",
            (const void*) this, ETG_CENUM(BTSDiscoveringStatus, _discoveringStatus)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsDiscoveredDeviceFound::BmCoreIfMessage_BtsDiscoveredDeviceFound() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DISCOVERED_DEVICE_FOUND, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _discoveredDevice()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DiscoveredDeviceFoundUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsDiscoveredDeviceFound::BmCoreIfMessage_BtsDiscoveredDeviceFound(IN const BTSDiscoveredDeviceInfo& discoveredDevice,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DISCOVERED_DEVICE_FOUND, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _discoveredDevice(discoveredDevice)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DiscoveredDeviceFoundUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsDiscoveredDeviceFound::BmCoreIfMessage_BtsDiscoveredDeviceFound(IN const BmCoreIfMessage_BtsDiscoveredDeviceFound& other) :
         BmCoreIfMessage(other),
         _discoveredDevice(other._discoveredDevice)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DiscoveredDeviceFoundUpdate: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsDiscoveredDeviceFound::~BmCoreIfMessage_BtsDiscoveredDeviceFound()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_DiscoveredDeviceFoundUpdate: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsDiscoveredDeviceFound& first, BmCoreIfMessage_BtsDiscoveredDeviceFound& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._discoveredDevice, second._discoveredDevice);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsDiscoveredDeviceFound& BmCoreIfMessage_BtsDiscoveredDeviceFound::operator=(BmCoreIfMessage_BtsDiscoveredDeviceFound other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsDiscoveredDeviceFound::operator==(const BmCoreIfMessage_BtsDiscoveredDeviceFound& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_discoveredDevice == rhs._discoveredDevice));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsDiscoveredDeviceFound::clone(void) const
   {
      return new BmCoreIfMessage_BtsDiscoveredDeviceFound(*this);
   }

   void BmCoreIfMessage_BtsDiscoveredDeviceFound::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] discoveredDevice: bdAddress = \"%50s\", bdName = \"%50s\", rssi = %d",
            (const void*) this, _discoveredDevice.address.c_str(), _discoveredDevice.name.c_str(), _discoveredDevice.rssi));
      ETG_TRACE_USR4(("traceMessage: [0x%p] discoveredDevice: majorDeviceClass = %d, minorDeviceClass = %d",
            (const void*) this, ETG_CENUM(BTSMajorDeviceClass, _discoveredDevice.majorDeviceClass),
            ETG_CENUM(BTSMinorDeviceClass, _discoveredDevice.minorDeviceClass)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsPairingFinished::BmCoreIfMessage_BtsPairingFinished() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_PAIRING_FINISHED, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsResult(BTS_REQ_LAST),
         _btsLinkKeyType(BTS_LINK_KEY_TYPE_LAST),
         _btsLinkKey(""),
         _btsDLinkKey(""),
         _btsMajorServiceClass(),
         _btsMajorDeviceClass(BTS_COD_MAJORDC_LAST),
         _btsMinorDeviceClass(BTS_COD_MINORDC_LAST),
         _btsBdName("")
/*
         _deviceBaseInfo()
*/
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsPairingFinished: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsPairingFinished::BmCoreIfMessage_BtsPairingFinished(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSLinkKeyType btsLinkKeyType, IN const BTSLinkKey& btsLinkKey,
         IN const BTSDLinkKey& btsDLinkKey, IN const BTSMajorServiceClass& btsMajorServiceClass,
         IN const BTSMajorDeviceClass btsMajorDeviceClass, IN const BTSMinorDeviceClass btsMinorDeviceClass,
         IN const BTSDeviceName& btsBdName, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_PAIRING_FINISHED, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(btsBdAddress),
         _btsResult(btsResult),
         _btsLinkKeyType(btsLinkKeyType),
         _btsLinkKey(btsLinkKey),
         _btsDLinkKey(btsDLinkKey),
         _btsMajorServiceClass(btsMajorServiceClass),
         _btsMajorDeviceClass(btsMajorDeviceClass),
         _btsMinorDeviceClass(btsMinorDeviceClass),
         _btsBdName(btsBdName)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsPairingFinished: [0x%p] creating BM Core IF message object", (void*) this));
   }
/*
   BmCoreIfMessage_BtsPairingFinished::BmCoreIfMessage_BtsPairingFinished(IN const DeviceBaseInfo& deviceBaseInfo,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_PAIRING_FINISHED, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _deviceBaseInfo(deviceBaseInfo)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsPairingFinished: [0x%p] creating BM Core IF message object", (void*) this));
   }
*/
   BmCoreIfMessage_BtsPairingFinished::BmCoreIfMessage_BtsPairingFinished(IN const BmCoreIfMessage_BtsPairingFinished& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsResult(other._btsResult),
         _btsLinkKeyType(other._btsLinkKeyType),
         _btsLinkKey(other._btsLinkKey),
         _btsDLinkKey(other._btsDLinkKey),
         _btsMajorServiceClass(other._btsMajorServiceClass),
         _btsMajorDeviceClass(other._btsMajorDeviceClass),
         _btsMinorDeviceClass(other._btsMinorDeviceClass),
         _btsBdName(other._btsBdName)
/*
         _deviceBaseInfo(other._deviceBaseInfo)
*/
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsPairingFinished: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsPairingFinished::~BmCoreIfMessage_BtsPairingFinished()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsPairingFinished: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsPairingFinished& first, BmCoreIfMessage_BtsPairingFinished& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsResult, second._btsResult);
      swap(first._btsLinkKeyType, second._btsLinkKeyType);
      swap(first._btsLinkKey, second._btsLinkKey);
      swap(first._btsDLinkKey, second._btsDLinkKey);
      swap(first._btsMajorServiceClass, second._btsMajorServiceClass);
      swap(first._btsMajorDeviceClass, second._btsMajorDeviceClass);
      swap(first._btsMinorDeviceClass, second._btsMinorDeviceClass);
      swap(first._btsBdName, second._btsBdName);
/*
      swap(first._deviceBaseInfo, second._deviceBaseInfo);
*/
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsPairingFinished& BmCoreIfMessage_BtsPairingFinished::operator=(BmCoreIfMessage_BtsPairingFinished other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsPairingFinished::operator==(const BmCoreIfMessage_BtsPairingFinished& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsResult == rhs._btsResult)
            && (this->_btsLinkKeyType == rhs._btsLinkKeyType)
            && (this->_btsLinkKey == rhs._btsLinkKey)
            && (this->_btsDLinkKey == rhs._btsDLinkKey)
            && (this->_btsMajorServiceClass == rhs._btsMajorServiceClass)
            && (this->_btsMajorDeviceClass == rhs._btsMajorDeviceClass)
            && (this->_btsMinorDeviceClass == rhs._btsMinorDeviceClass)
            && (this->_btsBdName == rhs._btsBdName));
/*
            && (this->_deviceBaseInfo == rhs._deviceBaseInfo));
*/
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsPairingFinished::clone(void) const
   {
      return new BmCoreIfMessage_BtsPairingFinished(*this);
   }

   void BmCoreIfMessage_BtsPairingFinished::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();

      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsResult = %d, btsLinkKeyType = %d, btsLinkKey = \"%50s\", btsMajorDeviceClass = %d, btsMinorDeviceClass = %d",
            (const void*) this, _btsBdAddress.c_str(), ETG_CENUM(BTSRequestResult, _btsResult),
            ETG_CENUM(BTSLinkKeyType, _btsLinkKeyType), _btsLinkKey.c_str(),
            ETG_CENUM(BTSMajorDeviceClass, _btsMajorDeviceClass), ETG_CENUM(BTSMinorDeviceClass, _btsMinorDeviceClass)));
/*
      VARTRACE_USR4(_deviceBaseInfo);
*/
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsSupportedServices::BmCoreIfMessage_BtsSupportedServices() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SUPPORTED_SERVICES, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsResult(BTS_REQ_LAST),
         _btsSupportedServices(),
         _btsServiceInfoList()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSupportedServices: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSupportedServices::BmCoreIfMessage_BtsSupportedServices(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSSupportedServices& btsSupportedServices,
         IN const BTSServiceInfoList& btsServiceInfoList, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SUPPORTED_SERVICES, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(btsBdAddress),
         _btsResult(btsResult),
         _btsSupportedServices(btsSupportedServices),
         _btsServiceInfoList(btsServiceInfoList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSupportedServices: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSupportedServices::BmCoreIfMessage_BtsSupportedServices(IN const BmCoreIfMessage_BtsSupportedServices& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsResult(other._btsResult),
         _btsSupportedServices(other._btsSupportedServices),
         _btsServiceInfoList(other._btsServiceInfoList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSupportedServices: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSupportedServices::~BmCoreIfMessage_BtsSupportedServices()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSupportedServices: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsSupportedServices& first, BmCoreIfMessage_BtsSupportedServices& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsResult, second._btsResult);
      swap(first._btsSupportedServices, second._btsSupportedServices);
      swap(first._btsServiceInfoList, second._btsServiceInfoList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsSupportedServices& BmCoreIfMessage_BtsSupportedServices::operator=(BmCoreIfMessage_BtsSupportedServices other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsSupportedServices::operator==(const BmCoreIfMessage_BtsSupportedServices& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsResult == rhs._btsResult)
            && (this->_btsSupportedServices == rhs._btsSupportedServices)
            && (this->_btsServiceInfoList == rhs._btsServiceInfoList));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsSupportedServices::clone(void) const
   {
      return new BmCoreIfMessage_BtsSupportedServices(*this);
   }

   void BmCoreIfMessage_BtsSupportedServices::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsResult = %d",
            (const void*) this, _btsBdAddress.c_str(), ETG_CENUM(BTSRequestResult, _btsResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsSppCapabilities::BmCoreIfMessage_BtsSppCapabilities() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SPP_CAPABILITIES, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsResult(BTS_REQ_LAST),
         _btsSppCapabilities()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSppCapabilities: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSppCapabilities::BmCoreIfMessage_BtsSppCapabilities(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSSppCapabilityList& btsSppCapabilities, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SPP_CAPABILITIES, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(btsBdAddress),
         _btsResult(btsResult),
         _btsSppCapabilities(btsSppCapabilities)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSppCapabilities: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSppCapabilities::BmCoreIfMessage_BtsSppCapabilities(IN const BmCoreIfMessage_BtsSppCapabilities& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsResult(other._btsResult),
         _btsSppCapabilities(other._btsSppCapabilities)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSppCapabilities: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSppCapabilities::~BmCoreIfMessage_BtsSppCapabilities()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSppCapabilities: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsSppCapabilities& first, BmCoreIfMessage_BtsSppCapabilities& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsResult, second._btsResult);
      swap(first._btsSppCapabilities, second._btsSppCapabilities);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsSppCapabilities& BmCoreIfMessage_BtsSppCapabilities::operator=(BmCoreIfMessage_BtsSppCapabilities other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsSppCapabilities::operator==(const BmCoreIfMessage_BtsSppCapabilities& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsResult == rhs._btsResult)
            && (this->_btsSppCapabilities == rhs._btsSppCapabilities));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsSppCapabilities::clone(void) const
   {
      return new BmCoreIfMessage_BtsSppCapabilities(*this);
   }

   void BmCoreIfMessage_BtsSppCapabilities::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsResult = %d",
            (const void*) this, _btsBdAddress.c_str(), ETG_CENUM(BTSRequestResult, _btsResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords::BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_REMOTE_DEVICE_ID_SERVICE_RECORDS, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _bdAddress(""),
         _result(BTS_REQ_LAST),
         _deviceIdServiceRecordList()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords::BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSDeviceIdServiceRecordList& btsDeviceIdServiceRecords,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_REMOTE_DEVICE_ID_SERVICE_RECORDS, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _bdAddress(btsBdAddress),
         _result(btsResult),
         _deviceIdServiceRecordList(btsDeviceIdServiceRecords)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords::BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords(IN const BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords& other) :
         BmCoreIfMessage(other),
         _bdAddress(other._bdAddress),
         _result(other._result),
         _deviceIdServiceRecordList(other._deviceIdServiceRecordList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords::~BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords& first, BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._bdAddress, second._bdAddress);
      swap(first._result, second._result);
      swap(first._deviceIdServiceRecordList, second._deviceIdServiceRecordList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords& BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords::operator=(BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords::operator==(const BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_bdAddress == rhs._bdAddress)
            && (this->_result == rhs._result)
            && (this->_deviceIdServiceRecordList == rhs._deviceIdServiceRecordList));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords::clone(void) const
   {
      return new BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords(*this);
   }

   void BmCoreIfMessage_BtsRemoteDeviceIdServiceRecords::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] bdAddress = \"%50s\", result = %d",
            (const void*) this, _bdAddress.c_str(), ETG_CENUM(BTSRequestResult, _result)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsDeviceCapabilities::BmCoreIfMessage_BtsDeviceCapabilities() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DEVICE_CAPABILITIES, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _bdAddress(""),
         _deviceCapabilities()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDeviceCapabilities: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsDeviceCapabilities::BmCoreIfMessage_BtsDeviceCapabilities(IN const BTSBDAddress& bdAddress,
         IN const BTSDeviceCapabilities& deviceCapabilities, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DEVICE_CAPABILITIES, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _bdAddress(bdAddress),
         _deviceCapabilities(deviceCapabilities)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDeviceCapabilities: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsDeviceCapabilities::BmCoreIfMessage_BtsDeviceCapabilities(IN const BmCoreIfMessage_BtsDeviceCapabilities& other) :
         BmCoreIfMessage(other),
         _bdAddress(other._bdAddress),
         _deviceCapabilities(other._deviceCapabilities)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDeviceCapabilities: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsDeviceCapabilities::~BmCoreIfMessage_BtsDeviceCapabilities()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDeviceCapabilities: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsDeviceCapabilities& first, BmCoreIfMessage_BtsDeviceCapabilities& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._bdAddress, second._bdAddress);
      swap(first._deviceCapabilities, second._deviceCapabilities);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsDeviceCapabilities& BmCoreIfMessage_BtsDeviceCapabilities::operator=(BmCoreIfMessage_BtsDeviceCapabilities other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsDeviceCapabilities::operator==(const BmCoreIfMessage_BtsDeviceCapabilities& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_bdAddress == rhs._bdAddress)
            && (this->_deviceCapabilities == rhs._deviceCapabilities));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsDeviceCapabilities::clone(void) const
   {
      return new BmCoreIfMessage_BtsDeviceCapabilities(*this);
   }

   void BmCoreIfMessage_BtsDeviceCapabilities::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] bdAddress = \"%50s\", inbandRingtoneSupported = %10s",
            (const void*) this, _bdAddress.c_str(), _deviceCapabilities.inbandRingtoneSupported ? "true" : "false"));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsRemoteServiceSearchResult::BmCoreIfMessage_BtsRemoteServiceSearchResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_REMOTE_SERVICE_SEARCH_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsSupportedServicesResult(BTS_REQ_LAST),
         _btsSppCapabilitiesResult(BTS_REQ_LAST),
         _btsDeviceIdServiceRecordsResult(BTS_REQ_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteServiceSearchResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteServiceSearchResult::BmCoreIfMessage_BtsRemoteServiceSearchResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsSupportedServicesResult, IN const BTSRequestResult btsSppCapabilitiesResult,
         IN const BTSRequestResult btsDeviceIdServiceRecordsResult, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_REMOTE_SERVICE_SEARCH_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(btsBdAddress),
         _btsSupportedServicesResult(btsSupportedServicesResult),
         _btsSppCapabilitiesResult(btsSppCapabilitiesResult),
         _btsDeviceIdServiceRecordsResult(btsDeviceIdServiceRecordsResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteServiceSearchResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteServiceSearchResult::BmCoreIfMessage_BtsRemoteServiceSearchResult(IN const BmCoreIfMessage_BtsRemoteServiceSearchResult& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsSupportedServicesResult(other._btsSupportedServicesResult),
         _btsSppCapabilitiesResult(other._btsSppCapabilitiesResult),
         _btsDeviceIdServiceRecordsResult(other._btsDeviceIdServiceRecordsResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteServiceSearchResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteServiceSearchResult::~BmCoreIfMessage_BtsRemoteServiceSearchResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteServiceSearchResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsRemoteServiceSearchResult& first, BmCoreIfMessage_BtsRemoteServiceSearchResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsSupportedServicesResult, second._btsSupportedServicesResult);
      swap(first._btsSppCapabilitiesResult, second._btsSppCapabilitiesResult);
      swap(first._btsDeviceIdServiceRecordsResult, second._btsDeviceIdServiceRecordsResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsRemoteServiceSearchResult& BmCoreIfMessage_BtsRemoteServiceSearchResult::operator=(BmCoreIfMessage_BtsRemoteServiceSearchResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsRemoteServiceSearchResult::operator==(const BmCoreIfMessage_BtsRemoteServiceSearchResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsSupportedServicesResult == rhs._btsSupportedServicesResult)
            && (this->_btsSppCapabilitiesResult == rhs._btsSppCapabilitiesResult)
            && (this->_btsDeviceIdServiceRecordsResult == rhs._btsDeviceIdServiceRecordsResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsRemoteServiceSearchResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsRemoteServiceSearchResult(*this);
   }

   void BmCoreIfMessage_BtsRemoteServiceSearchResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsSupportedServicesResult = %d, btsSppCapabilitiesResult = %d, btsDeviceIdServiceRecordsResult = %d",
            (const void*) this, _btsBdAddress.c_str(), ETG_CENUM(BTSRequestResult, _btsSupportedServicesResult),
            ETG_CENUM(BTSRequestResult, _btsSppCapabilitiesResult),
            ETG_CENUM(BTSRequestResult, _btsDeviceIdServiceRecordsResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsRemoteNameResult::BmCoreIfMessage_BtsRemoteNameResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_REMOTE_NAME_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsBdName(""),
         _btsResult(BTS_REQ_LAST)

   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteNameResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteNameResult::BmCoreIfMessage_BtsRemoteNameResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSDeviceName& btsBdName, IN const BTSRequestResult btsResult, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_REMOTE_NAME_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(btsBdAddress),
         _btsBdName(btsBdName),
         _btsResult(btsResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteNameResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteNameResult::BmCoreIfMessage_BtsRemoteNameResult(IN const BmCoreIfMessage_BtsRemoteNameResult& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsBdName(other._btsBdName),
         _btsResult(other._btsResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteNameResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteNameResult::~BmCoreIfMessage_BtsRemoteNameResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteNameResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsRemoteNameResult& first, BmCoreIfMessage_BtsRemoteNameResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsBdName, second._btsBdName);
      swap(first._btsResult, second._btsResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsRemoteNameResult& BmCoreIfMessage_BtsRemoteNameResult::operator=(BmCoreIfMessage_BtsRemoteNameResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsRemoteNameResult::operator==(const BmCoreIfMessage_BtsRemoteNameResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsBdName == rhs._btsBdName)
            && (this->_btsResult == rhs._btsResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsRemoteNameResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsRemoteNameResult(*this);
   }

   void BmCoreIfMessage_BtsRemoteNameResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsBdName = \"%50s\", btsResult = %d",
            (const void*) this, _btsBdAddress.c_str(), _btsBdName.c_str(), ETG_CENUM(BTSRequestResult, _btsResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsRemoteNameStatusUpdate::BmCoreIfMessage_BtsRemoteNameStatusUpdate() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_REMOTE_NAME_STATUS_UPDATE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),_btsBdAddress(""), _btsBdName("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteNameStatusUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteNameStatusUpdate::BmCoreIfMessage_BtsRemoteNameStatusUpdate(IN const BTSBDAddress& btsBdAddress,
         IN const BTSDeviceName& btsBdName, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_REMOTE_NAME_STATUS_UPDATE, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF), _btsBdAddress(btsBdAddress), _btsBdName(btsBdName)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteNameStatusUpdate: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteNameStatusUpdate::BmCoreIfMessage_BtsRemoteNameStatusUpdate(IN const BmCoreIfMessage_BtsRemoteNameStatusUpdate& other) :
         BmCoreIfMessage(other), _btsBdAddress(other._btsBdAddress), _btsBdName(other._btsBdName)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteNameStatusUpdate: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsRemoteNameStatusUpdate::~BmCoreIfMessage_BtsRemoteNameStatusUpdate()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteNameStatusUpdate: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsRemoteNameStatusUpdate& first, BmCoreIfMessage_BtsRemoteNameStatusUpdate& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsBdName, second._btsBdName);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsRemoteNameStatusUpdate& BmCoreIfMessage_BtsRemoteNameStatusUpdate::operator=(BmCoreIfMessage_BtsRemoteNameStatusUpdate other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsRemoteNameStatusUpdate::operator==(const BmCoreIfMessage_BtsRemoteNameStatusUpdate& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsBdName == rhs._btsBdName));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsRemoteNameStatusUpdate::clone(void) const
   {
      return new BmCoreIfMessage_BtsRemoteNameStatusUpdate(*this);
   }

   void BmCoreIfMessage_BtsRemoteNameStatusUpdate::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsBdName = \"%50s\"",
            (const void*) this, _btsBdAddress.c_str(), _btsBdName.c_str()));
   }


   // *****************************************************************************************

   BmCoreIfMessage_BtsStartPairingResult::BmCoreIfMessage_BtsStartPairingResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_START_PAIRING_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsResult(BTS_REQ_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStartPairingResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsStartPairingResult::BmCoreIfMessage_BtsStartPairingResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const ActType act) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_START_PAIRING_RESULT, BM_RESTRICTION_GROUP_00, act,
                     BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _btsBdAddress(btsBdAddress),
               _btsResult(btsResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStartPairingResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsStartPairingResult::BmCoreIfMessage_BtsStartPairingResult(IN const BmCoreIfMessage_BtsStartPairingResult& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsResult(other._btsResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStartPairingResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsStartPairingResult::~BmCoreIfMessage_BtsStartPairingResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStartPairingResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsStartPairingResult& first, BmCoreIfMessage_BtsStartPairingResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsResult, second._btsResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsStartPairingResult& BmCoreIfMessage_BtsStartPairingResult::operator=(BmCoreIfMessage_BtsStartPairingResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsStartPairingResult::operator==(const BmCoreIfMessage_BtsStartPairingResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsResult == rhs._btsResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsStartPairingResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsStartPairingResult(*this);
   }

   void BmCoreIfMessage_BtsStartPairingResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsResult = %d",
            (const void*) this, _btsBdAddress.c_str(), ETG_CENUM(BTSRequestResult, _btsResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsPinCodeRequested::BmCoreIfMessage_BtsPinCodeRequested() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_PIN_CODE_REQUESTED, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsBdName(""),
         _btsPairingOriginator(BTS_PAIR_CONNECT_INITIATED_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsPinCodeRequested: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsPinCodeRequested::BmCoreIfMessage_BtsPinCodeRequested(IN const BTSBDAddress& btsBdAddress,
         IN const BTSDeviceName& btsBdName, IN const BTSPairConnectOriginator btsPairingOriginator,
         IN const ActType act) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_PIN_CODE_REQUESTED, BM_RESTRICTION_GROUP_06, act,
                     BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _btsBdAddress(btsBdAddress),
               _btsBdName(btsBdName),
               _btsPairingOriginator(btsPairingOriginator)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsPinCodeRequested: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsPinCodeRequested::BmCoreIfMessage_BtsPinCodeRequested(IN const BmCoreIfMessage_BtsPinCodeRequested& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsBdName(other._btsBdName),
         _btsPairingOriginator(other._btsPairingOriginator)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsPinCodeRequested: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsPinCodeRequested::~BmCoreIfMessage_BtsPinCodeRequested()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsPinCodeRequested: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsPinCodeRequested& first, BmCoreIfMessage_BtsPinCodeRequested& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsBdName, second._btsBdName);
      swap(first._btsPairingOriginator, second._btsPairingOriginator);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsPinCodeRequested& BmCoreIfMessage_BtsPinCodeRequested::operator=(BmCoreIfMessage_BtsPinCodeRequested other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsPinCodeRequested::operator==(const BmCoreIfMessage_BtsPinCodeRequested& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsBdName == rhs._btsBdName)
            && (this->_btsPairingOriginator == rhs._btsPairingOriginator));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsPinCodeRequested::clone(void) const
   {
      return new BmCoreIfMessage_BtsPinCodeRequested(*this);
   }

   void BmCoreIfMessage_BtsPinCodeRequested::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsBdName = \"%50s\", btsPairingOriginator = %d",
            (const void*) this, _btsBdAddress.c_str(), _btsBdName.c_str(),
            ETG_CENUM(BTSPairConnectOriginator, _btsPairingOriginator)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsSecureSimplePairingRequested::BmCoreIfMessage_BtsSecureSimplePairingRequested() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SECURE_SIMPLE_PAIRING_REQUESTED, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsBdName(""),
         _btsSspMode(BTS_SSP_LAST),
         _btsNumericValue(""),
         _btsPairingOriginator(BTS_PAIR_CONNECT_INITIATED_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSecureSimplePairingRequested: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSecureSimplePairingRequested::BmCoreIfMessage_BtsSecureSimplePairingRequested(IN const BTSBDAddress& btsBdAddress,
         IN const BTSDeviceName& btsBdName, IN const BTSSspMode btsSspMode, IN const BTSNumericValue& btsNumericValue,
         IN const BTSPairConnectOriginator btsPairingOriginator, IN const ActType act) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_SECURE_SIMPLE_PAIRING_REQUESTED, BM_RESTRICTION_GROUP_06, act,
                     BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _btsBdAddress(btsBdAddress),
               _btsBdName(btsBdName),
               _btsSspMode(btsSspMode),
               _btsNumericValue(btsNumericValue),
               _btsPairingOriginator(btsPairingOriginator)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSecureSimplePairingRequested: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSecureSimplePairingRequested::BmCoreIfMessage_BtsSecureSimplePairingRequested(IN const BmCoreIfMessage_BtsSecureSimplePairingRequested& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsBdName(other._btsBdName),
         _btsSspMode(other._btsSspMode),
         _btsNumericValue(other._btsNumericValue),
         _btsPairingOriginator(other._btsPairingOriginator)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSecureSimplePairingRequested: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsSecureSimplePairingRequested::~BmCoreIfMessage_BtsSecureSimplePairingRequested()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsSecureSimplePairingRequested: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsSecureSimplePairingRequested& first, BmCoreIfMessage_BtsSecureSimplePairingRequested& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsBdName, second._btsBdName);
      swap(first._btsSspMode, second._btsSspMode);
      swap(first._btsNumericValue, second._btsNumericValue);
      swap(first._btsPairingOriginator, second._btsPairingOriginator);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsSecureSimplePairingRequested& BmCoreIfMessage_BtsSecureSimplePairingRequested::operator=(BmCoreIfMessage_BtsSecureSimplePairingRequested other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsSecureSimplePairingRequested::operator==(const BmCoreIfMessage_BtsSecureSimplePairingRequested& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsBdName == rhs._btsBdName)
            && (this->_btsSspMode == rhs._btsSspMode)
            && (this->_btsNumericValue == rhs._btsNumericValue)
            && (this->_btsPairingOriginator == rhs._btsPairingOriginator));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsSecureSimplePairingRequested::clone(void) const
   {
      return new BmCoreIfMessage_BtsSecureSimplePairingRequested(*this);
   }

   void BmCoreIfMessage_BtsSecureSimplePairingRequested::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsBdName = \"%50s\", btsSspMode = %d, btsNumericValue = \"%50s\", btsPairingOriginator = %d",
            (const void*) this, _btsBdAddress.c_str(), _btsBdName.c_str(),
            ETG_CENUM(BTSSspMode, _btsSspMode), _btsNumericValue.c_str(),
            ETG_CENUM(BTSPairConnectOriginator, _btsPairingOriginator)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsLinkKeyRequested::BmCoreIfMessage_BtsLinkKeyRequested() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_LINK_KEY_REQUESTED, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLinkKeyRequested: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsLinkKeyRequested::BmCoreIfMessage_BtsLinkKeyRequested(IN const BTSBDAddress& btsBdAddress,
         IN const ActType act) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_LINK_KEY_REQUESTED, BM_RESTRICTION_GROUP_00, act,
                     BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _btsBdAddress(btsBdAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLinkKeyRequested: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsLinkKeyRequested::BmCoreIfMessage_BtsLinkKeyRequested(IN const BmCoreIfMessage_BtsLinkKeyRequested& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLinkKeyRequested: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsLinkKeyRequested::~BmCoreIfMessage_BtsLinkKeyRequested()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLinkKeyRequested: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsLinkKeyRequested& first, BmCoreIfMessage_BtsLinkKeyRequested& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsLinkKeyRequested& BmCoreIfMessage_BtsLinkKeyRequested::operator=(BmCoreIfMessage_BtsLinkKeyRequested other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsLinkKeyRequested::operator==(const BmCoreIfMessage_BtsLinkKeyRequested& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsLinkKeyRequested::clone(void) const
   {
      return new BmCoreIfMessage_BtsLinkKeyRequested(*this);
   }

   void BmCoreIfMessage_BtsLinkKeyRequested::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\"", (const void*) this, _btsBdAddress.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsConnectProtocolResult::BmCoreIfMessage_BtsConnectProtocolResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_CONNECT_PROTOCOL_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsResult(BTS_REQ_LAST),
         _btsProtocolId(BTS_PROTO_LAST),
         _btsSppUuid(""),
         _btsMasInstance("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsConnectProtocolResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsConnectProtocolResult::BmCoreIfMessage_BtsConnectProtocolResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid,
         IN const BTSMasInstanceName& btsMasInstance, IN const ActType act) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_CONNECT_PROTOCOL_RESULT, BM_RESTRICTION_GROUP_00, act,
                     BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _btsBdAddress(btsBdAddress),
               _btsResult(btsResult),
               _btsProtocolId(btsProtocolId),
               _btsSppUuid(btsSppUuid),
               _btsMasInstance(btsMasInstance)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsConnectProtocolResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsConnectProtocolResult::BmCoreIfMessage_BtsConnectProtocolResult(IN const BmCoreIfMessage_BtsConnectProtocolResult& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsResult(other._btsResult),
         _btsProtocolId(other._btsProtocolId),
         _btsSppUuid(other._btsSppUuid),
         _btsMasInstance(other._btsMasInstance)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsConnectProtocolResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsConnectProtocolResult::~BmCoreIfMessage_BtsConnectProtocolResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsConnectProtocolResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsConnectProtocolResult& first, BmCoreIfMessage_BtsConnectProtocolResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsResult, second._btsResult);
      swap(first._btsProtocolId, second._btsProtocolId);
      swap(first._btsSppUuid, second._btsSppUuid);
      swap(first._btsMasInstance, second._btsMasInstance);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsConnectProtocolResult& BmCoreIfMessage_BtsConnectProtocolResult::operator=(BmCoreIfMessage_BtsConnectProtocolResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsConnectProtocolResult::operator==(const BmCoreIfMessage_BtsConnectProtocolResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsResult == rhs._btsResult)
            && (this->_btsProtocolId == rhs._btsProtocolId)
            && (this->_btsSppUuid == rhs._btsSppUuid)
            && (this->_btsMasInstance == rhs._btsMasInstance));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsConnectProtocolResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsConnectProtocolResult(*this);
   }

   void BmCoreIfMessage_BtsConnectProtocolResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsResult = %d, btsProtocolId = %d, btsSppUuid = \"%50s\", btsMasInstance = \"%50s\"",
            (const void*) this, _btsBdAddress.c_str(), ETG_CENUM(BTSRequestResult, _btsResult),
            ETG_CENUM(BTSProtocolId, _btsProtocolId), _btsSppUuid.c_str(), _btsMasInstance.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsRemoteProtocolConnectRequest::BmCoreIfMessage_BtsRemoteProtocolConnectRequest() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_REMOTE_PROTOCOL_CONNECT_REQUEST, BM_RESTRICTION_GROUP_06,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsProtocolId(BTS_PROTO_LAST),
         _btsSppUuid("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteProtocolConnectRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsRemoteProtocolConnectRequest::BmCoreIfMessage_BtsRemoteProtocolConnectRequest(IN const BTSBDAddress& btsBdAddress,
         IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid, IN const ActType act) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_REMOTE_PROTOCOL_CONNECT_REQUEST, BM_RESTRICTION_GROUP_06, act,
                     BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _btsBdAddress(btsBdAddress),
               _btsProtocolId(btsProtocolId),
               _btsSppUuid(btsSppUuid)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteProtocolConnectRequest: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsRemoteProtocolConnectRequest::BmCoreIfMessage_BtsRemoteProtocolConnectRequest(IN const BmCoreIfMessage_BtsRemoteProtocolConnectRequest& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsProtocolId(other._btsProtocolId),
         _btsSppUuid(other._btsSppUuid)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteProtocolConnectRequest: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsRemoteProtocolConnectRequest::~BmCoreIfMessage_BtsRemoteProtocolConnectRequest()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsRemoteProtocolConnectRequest: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsRemoteProtocolConnectRequest& first, BmCoreIfMessage_BtsRemoteProtocolConnectRequest& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsProtocolId, second._btsProtocolId);
      swap(first._btsSppUuid, second._btsSppUuid);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsRemoteProtocolConnectRequest& BmCoreIfMessage_BtsRemoteProtocolConnectRequest::operator=(BmCoreIfMessage_BtsRemoteProtocolConnectRequest other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsRemoteProtocolConnectRequest::operator==(const BmCoreIfMessage_BtsRemoteProtocolConnectRequest& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsProtocolId == rhs._btsProtocolId)
            && (this->_btsSppUuid == rhs._btsSppUuid));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsRemoteProtocolConnectRequest::clone(void) const
   {
      return new BmCoreIfMessage_BtsRemoteProtocolConnectRequest(*this);
   }

   void BmCoreIfMessage_BtsRemoteProtocolConnectRequest::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsProtocolId = %d, btsSppUuid = \"%50s\"",
            (const void*) this, _btsBdAddress.c_str(), ETG_CENUM(BTSProtocolId, _btsProtocolId), _btsSppUuid.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsDisconnectProtocolResult::BmCoreIfMessage_BtsDisconnectProtocolResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DISCONNECT_PROTOCOL_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsResult(BTS_REQ_LAST),
         _btsProtocolId(BTS_PROTO_LAST),
         _btsSppUuid(""),
         _btsMasInstance("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDisconnectProtocolResult: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsDisconnectProtocolResult::BmCoreIfMessage_BtsDisconnectProtocolResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid,
         IN const BTSMasInstanceName& btsMasInstance, IN const ActType act) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DISCONNECT_PROTOCOL_RESULT, BM_RESTRICTION_GROUP_00, act,
                     BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _btsBdAddress(btsBdAddress),
               _btsResult(btsResult),
               _btsProtocolId(btsProtocolId),
               _btsSppUuid(btsSppUuid),
               _btsMasInstance(btsMasInstance)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDisconnectProtocolResult: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsDisconnectProtocolResult::BmCoreIfMessage_BtsDisconnectProtocolResult(IN const BmCoreIfMessage_BtsDisconnectProtocolResult& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsResult(other._btsResult),
         _btsProtocolId(other._btsProtocolId),
         _btsSppUuid(other._btsSppUuid),
         _btsMasInstance(other._btsMasInstance)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDisconnectProtocolResult: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsDisconnectProtocolResult::~BmCoreIfMessage_BtsDisconnectProtocolResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDisconnectProtocolResult: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsDisconnectProtocolResult& first, BmCoreIfMessage_BtsDisconnectProtocolResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsResult, second._btsResult);
      swap(first._btsProtocolId, second._btsProtocolId);
      swap(first._btsSppUuid, second._btsSppUuid);
      swap(first._btsMasInstance, second._btsMasInstance);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsDisconnectProtocolResult& BmCoreIfMessage_BtsDisconnectProtocolResult::operator=(BmCoreIfMessage_BtsDisconnectProtocolResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsDisconnectProtocolResult::operator==(const BmCoreIfMessage_BtsDisconnectProtocolResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsResult == rhs._btsResult)
            && (this->_btsProtocolId == rhs._btsProtocolId)
            && (this->_btsSppUuid == rhs._btsSppUuid)
            && (this->_btsMasInstance == rhs._btsMasInstance));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsDisconnectProtocolResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsDisconnectProtocolResult(*this);
   }

   void BmCoreIfMessage_BtsDisconnectProtocolResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsResult = %d, btsProtocolId = %d, btsSppUuid = \"%50s\", btsMasInstance = \"%50s\"",
            (const void*) this, _btsBdAddress.c_str(), ETG_CENUM(BTSRequestResult, _btsResult),
            ETG_CENUM(BTSProtocolId, _btsProtocolId), _btsSppUuid.c_str(), _btsMasInstance.c_str()));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsDisconnectDeviceResult::BmCoreIfMessage_BtsDisconnectDeviceResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DISCONNECT_DEVICE_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsResult(BTS_REQ_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDisconnectDeviceResult: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsDisconnectDeviceResult::BmCoreIfMessage_BtsDisconnectDeviceResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const ActType act) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DISCONNECT_DEVICE_RESULT, BM_RESTRICTION_GROUP_00, act,
                     BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _btsBdAddress(btsBdAddress),
               _btsResult(btsResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDisconnectDeviceResult: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsDisconnectDeviceResult::BmCoreIfMessage_BtsDisconnectDeviceResult(IN const BmCoreIfMessage_BtsDisconnectDeviceResult& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsResult(other._btsResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDisconnectDeviceResult: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsDisconnectDeviceResult::~BmCoreIfMessage_BtsDisconnectDeviceResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDisconnectDeviceResult: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsDisconnectDeviceResult& first, BmCoreIfMessage_BtsDisconnectDeviceResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsResult, second._btsResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsDisconnectDeviceResult& BmCoreIfMessage_BtsDisconnectDeviceResult::operator=(BmCoreIfMessage_BtsDisconnectDeviceResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsDisconnectDeviceResult::operator==(const BmCoreIfMessage_BtsDisconnectDeviceResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsResult == rhs._btsResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsDisconnectDeviceResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsDisconnectDeviceResult(*this);
   }

   void BmCoreIfMessage_BtsDisconnectDeviceResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsResult = %d", (const void*) this,
            _btsBdAddress.c_str(), ETG_CENUM(BTSRequestResult, _btsResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsProtocolConnectionStatus::BmCoreIfMessage_BtsProtocolConnectionStatus() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_PROTOCOL_CONNECTION_STATUS, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsConnectionStatus(BTS_CONN_LAST),
         _btsDisconnectReason(BTS_DISCONNECT_REASON_LAST),
         _btsProtocolId(BTS_PROTO_LAST),
         _btsSppUuid(""),
         _btsMasInstance(""),
         _btsRfCommDevice("")
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsProtocolConnectionStatus: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsProtocolConnectionStatus::BmCoreIfMessage_BtsProtocolConnectionStatus(IN const BTSBDAddress& btsBdAddress,
         IN const BTSConnectionStatus btsConnectionStatus, IN const BTSDisconnectReason btsDisconnectReason,
         IN const BTSProtocolId btsProtocolId, IN const BTSUuid& btsSppUuid,
         IN const BTSMasInstanceName& btsMasInstance, IN const BTSDeviceName& btsRfCommDevice, IN const ActType act) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_PROTOCOL_CONNECTION_STATUS, BM_RESTRICTION_GROUP_00, act,
                     BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _btsBdAddress(btsBdAddress),
               _btsConnectionStatus(btsConnectionStatus),
               _btsDisconnectReason(btsDisconnectReason),
               _btsProtocolId(btsProtocolId),
               _btsSppUuid(btsSppUuid),
               _btsMasInstance(btsMasInstance),
               _btsRfCommDevice(btsRfCommDevice)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsProtocolConnectionStatus: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsProtocolConnectionStatus::BmCoreIfMessage_BtsProtocolConnectionStatus(IN const BmCoreIfMessage_BtsProtocolConnectionStatus& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsConnectionStatus(other._btsConnectionStatus),
         _btsDisconnectReason(other._btsDisconnectReason),
         _btsProtocolId(other._btsProtocolId),
         _btsSppUuid(other._btsSppUuid),
         _btsMasInstance(other._btsMasInstance),
         _btsRfCommDevice(other._btsRfCommDevice)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsProtocolConnectionStatus: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsProtocolConnectionStatus::~BmCoreIfMessage_BtsProtocolConnectionStatus()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsProtocolConnectionStatus: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsProtocolConnectionStatus& first, BmCoreIfMessage_BtsProtocolConnectionStatus& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsConnectionStatus, second._btsConnectionStatus);
      swap(first._btsDisconnectReason, second._btsDisconnectReason);
      swap(first._btsProtocolId, second._btsProtocolId);
      swap(first._btsSppUuid, second._btsSppUuid);
      swap(first._btsMasInstance, second._btsMasInstance);
      swap(first._btsRfCommDevice, second._btsRfCommDevice);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsProtocolConnectionStatus& BmCoreIfMessage_BtsProtocolConnectionStatus::operator=(BmCoreIfMessage_BtsProtocolConnectionStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsProtocolConnectionStatus::operator==(const BmCoreIfMessage_BtsProtocolConnectionStatus& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsConnectionStatus == rhs._btsConnectionStatus)
            && (this->_btsDisconnectReason == rhs._btsDisconnectReason)
            && (this->_btsProtocolId == rhs._btsProtocolId)
            && (this->_btsSppUuid == rhs._btsSppUuid)
            && (this->_btsMasInstance == rhs._btsMasInstance)
            && (this->_btsRfCommDevice == rhs._btsRfCommDevice));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsProtocolConnectionStatus::clone(void) const
   {
      return new BmCoreIfMessage_BtsProtocolConnectionStatus(*this);
   }

   void BmCoreIfMessage_BtsProtocolConnectionStatus::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();

      std::string helperString("traceMessage: [0x%p] btsSppUuid = \"");
      helperString += _btsSppUuid;
      helperString += "\"";
      helperString += ", btsMasInstance = \"";
      helperString += _btsMasInstance;
      helperString += "\"";
      helperString += ", btsRfCommDevice = \"";
      helperString += _btsRfCommDevice;
      helperString += "\"";

      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsProtocolId = %d, %100s, btsConnectionStatus = %d, btsDisconnectReason = %d",
            (const void*) this, _btsBdAddress.c_str(), ETG_CENUM(BTSProtocolId, _btsProtocolId), helperString.c_str(),
            ETG_CENUM(BTSConnectionStatus, _btsConnectionStatus), ETG_CENUM(BTSDisconnectReason, _btsDisconnectReason)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsDeviceConnectionStatus::BmCoreIfMessage_BtsDeviceConnectionStatus() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DEVICE_CONNECTION_STATUS, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _btsBdAddress(""),
         _btsConnectionStatus(BTS_CONN_LAST),
         _btsDisconnectReason(BTS_DISCONNECT_REASON_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDeviceConnectionStatus: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsDeviceConnectionStatus::BmCoreIfMessage_BtsDeviceConnectionStatus(IN const BTSBDAddress& btsBdAddress,
         IN const BTSConnectionStatus btsConnectionStatus, IN const BTSDisconnectReason btsDisconnectReason,
         IN const ActType act) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_DEVICE_CONNECTION_STATUS, BM_RESTRICTION_GROUP_00, act,
                     BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _btsBdAddress(btsBdAddress),
               _btsConnectionStatus(btsConnectionStatus),
               _btsDisconnectReason(btsDisconnectReason)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDeviceConnectionStatus: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsDeviceConnectionStatus::BmCoreIfMessage_BtsDeviceConnectionStatus(IN const BmCoreIfMessage_BtsDeviceConnectionStatus& other) :
         BmCoreIfMessage(other),
         _btsBdAddress(other._btsBdAddress),
         _btsConnectionStatus(other._btsConnectionStatus),
         _btsDisconnectReason(other._btsDisconnectReason)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDeviceConnectionStatus: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsDeviceConnectionStatus::~BmCoreIfMessage_BtsDeviceConnectionStatus()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsDeviceConnectionStatus: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsDeviceConnectionStatus& first, BmCoreIfMessage_BtsDeviceConnectionStatus& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btsBdAddress, second._btsBdAddress);
      swap(first._btsConnectionStatus, second._btsConnectionStatus);
      swap(first._btsDisconnectReason, second._btsDisconnectReason);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsDeviceConnectionStatus& BmCoreIfMessage_BtsDeviceConnectionStatus::operator=(BmCoreIfMessage_BtsDeviceConnectionStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsDeviceConnectionStatus::operator==(const BmCoreIfMessage_BtsDeviceConnectionStatus& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btsBdAddress == rhs._btsBdAddress)
            && (this->_btsConnectionStatus == rhs._btsConnectionStatus)
            && (this->_btsDisconnectReason == rhs._btsDisconnectReason));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsDeviceConnectionStatus::clone(void) const
   {
      return new BmCoreIfMessage_BtsDeviceConnectionStatus(*this);
   }

   void BmCoreIfMessage_BtsDeviceConnectionStatus::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();

      ETG_TRACE_USR4(("traceMessage: [0x%p] btsBdAddress = \"%50s\", btsConnectionStatus = %d, btsDisconnectReason = %d",
            (const void*) this, _btsBdAddress.c_str(), ETG_CENUM(BTSConnectionStatus, _btsConnectionStatus),
            ETG_CENUM(BTSDisconnectReason, _btsDisconnectReason)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsLinkQualityResult::BmCoreIfMessage_BtsLinkQualityResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_LINK_QUALITY_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _bdAddress(""),
         _btsResult(BTS_REQ_LAST),
         _btsRssi(127),
         _btsLinkQuality(0xFFu)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLinkQualityResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsLinkQualityResult::BmCoreIfMessage_BtsLinkQualityResult(IN const BTSBDAddress& btsBdAddress,
         IN const BTSRequestResult btsResult, IN const BTSRssi btsRssi, IN const BTSLinkQuality btsLinkQuality,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_LINK_QUALITY_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _bdAddress(btsBdAddress),
         _btsResult(btsResult),
         _btsRssi(btsRssi),
         _btsLinkQuality(btsLinkQuality)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLinkQualityResult: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsLinkQualityResult::BmCoreIfMessage_BtsLinkQualityResult(IN const BmCoreIfMessage_BtsLinkQualityResult& other) :
         BmCoreIfMessage(other),
         _bdAddress(other._bdAddress),
         _btsResult(other._btsResult),
         _btsRssi(other._btsRssi),
         _btsLinkQuality(other._btsLinkQuality)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLinkQualityResult: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsLinkQualityResult::~BmCoreIfMessage_BtsLinkQualityResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsLinkQualityResult: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsLinkQualityResult& first, BmCoreIfMessage_BtsLinkQualityResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._bdAddress, second._bdAddress);
      swap(first._btsResult, second._btsResult);
      swap(first._btsRssi, second._btsRssi);
      swap(first._btsLinkQuality, second._btsLinkQuality);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsLinkQualityResult& BmCoreIfMessage_BtsLinkQualityResult::operator=(BmCoreIfMessage_BtsLinkQualityResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsLinkQualityResult::operator==(const BmCoreIfMessage_BtsLinkQualityResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_bdAddress == rhs._bdAddress)
            && (this->_btsResult == rhs._btsResult)
            && (this->_btsRssi == rhs._btsRssi)
            && (this->_btsLinkQuality == rhs._btsLinkQuality));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsLinkQualityResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsLinkQualityResult(*this);
   }

   void BmCoreIfMessage_BtsLinkQualityResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] bdAddress = \"%50s\", btsResult = %d, btsRssi = %d, btsLinkQuality = %d",
            (const void*) this, _bdAddress.c_str(), ETG_CENUM(BTSRequestResult, _btsResult),
            _btsRssi, _btsLinkQuality));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsStartTestModeResult::BmCoreIfMessage_BtsStartTestModeResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_START_TEST_MODE_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(BTS_REQ_SUCCESS)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStartTestModeResult: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsStartTestModeResult::BmCoreIfMessage_BtsStartTestModeResult(IN const BTSRequestResult requestResult,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_START_TEST_MODE_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStartTestModeResult: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsStartTestModeResult::BmCoreIfMessage_BtsStartTestModeResult(IN const BmCoreIfMessage_BtsStartTestModeResult& other) :
         BmCoreIfMessage(other),
         _requestResult(other._requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStartTestModeResult: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsStartTestModeResult::~BmCoreIfMessage_BtsStartTestModeResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStartTestModeResult: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsStartTestModeResult& first, BmCoreIfMessage_BtsStartTestModeResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._requestResult, second._requestResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsStartTestModeResult& BmCoreIfMessage_BtsStartTestModeResult::operator=(BmCoreIfMessage_BtsStartTestModeResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsStartTestModeResult::operator==(const BmCoreIfMessage_BtsStartTestModeResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_requestResult == rhs._requestResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsStartTestModeResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsStartTestModeResult(*this);
   }

   void BmCoreIfMessage_BtsStartTestModeResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] requestResult = %d",
            (const void*) this, ETG_CENUM(BTSRequestResult, _requestResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsStopTestModeResult::BmCoreIfMessage_BtsStopTestModeResult() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_STOP_TEST_MODE_RESULT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(BTS_REQ_SUCCESS)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStopTestModeResult: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsStopTestModeResult::BmCoreIfMessage_BtsStopTestModeResult(IN const BTSRequestResult requestResult,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_STOP_TEST_MODE_RESULT, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStopTestModeResult: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsStopTestModeResult::BmCoreIfMessage_BtsStopTestModeResult(IN const BmCoreIfMessage_BtsStopTestModeResult& other) :
         BmCoreIfMessage(other),
         _requestResult(other._requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStopTestModeResult: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsStopTestModeResult::~BmCoreIfMessage_BtsStopTestModeResult()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsStopTestModeResult: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsStopTestModeResult& first, BmCoreIfMessage_BtsStopTestModeResult& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._requestResult, second._requestResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsStopTestModeResult& BmCoreIfMessage_BtsStopTestModeResult::operator=(BmCoreIfMessage_BtsStopTestModeResult other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsStopTestModeResult::operator==(const BmCoreIfMessage_BtsStopTestModeResult& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_requestResult == rhs._requestResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsStopTestModeResult::clone(void) const
   {
      return new BmCoreIfMessage_BtsStopTestModeResult(*this);
   }

   void BmCoreIfMessage_BtsStopTestModeResult::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] requestResult = %d",
            (const void*) this, ETG_CENUM(BTSRequestResult, _requestResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsTestModeStatus::BmCoreIfMessage_BtsTestModeStatus() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_TEST_MODE_STATUS, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _deviceAddress(""),
         _connectionStatus(BTS_CONN_LAST)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsTestModeStatus: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsTestModeStatus::BmCoreIfMessage_BtsTestModeStatus(IN const BTSBDAddress& deviceAddress,
         IN const BTSConnectionStatus connectionStatus, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_TEST_MODE_STATUS, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _deviceAddress(deviceAddress),
         _connectionStatus(connectionStatus)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsTestModeStatus: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsTestModeStatus::BmCoreIfMessage_BtsTestModeStatus(IN const BmCoreIfMessage_BtsTestModeStatus& other) :
         BmCoreIfMessage(other),
         _deviceAddress(other._deviceAddress),
         _connectionStatus(other._connectionStatus)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsTestModeStatus: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtsTestModeStatus::~BmCoreIfMessage_BtsTestModeStatus()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsTestModeStatus: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtsTestModeStatus& first, BmCoreIfMessage_BtsTestModeStatus& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceAddress, second._deviceAddress);
      swap(first._connectionStatus, second._connectionStatus);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsTestModeStatus& BmCoreIfMessage_BtsTestModeStatus::operator=(BmCoreIfMessage_BtsTestModeStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsTestModeStatus::operator==(const BmCoreIfMessage_BtsTestModeStatus& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceAddress == rhs._deviceAddress)
            && (this->_connectionStatus == rhs._connectionStatus));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsTestModeStatus::clone(void) const
   {
      return new BmCoreIfMessage_BtsTestModeStatus(*this);
   }

   void BmCoreIfMessage_BtsTestModeStatus::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceAddress = \"%50s\", connectionStatus = %d",
            (const void*) this, _deviceAddress.c_str(), ETG_CENUM(BTSConnectionStatus, _connectionStatus)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsFbWblInitialized::BmCoreIfMessage_BtsFbWblInitialized() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_FB_WBL_INITIALIZED, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(BTS_REQ_SUCCESS)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsFbWblInitialized: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsFbWblInitialized::BmCoreIfMessage_BtsFbWblInitialized(IN const BTSRequestResult requestResult,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_FB_WBL_INITIALIZED, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _requestResult(requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsFbWblInitialized: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsFbWblInitialized::BmCoreIfMessage_BtsFbWblInitialized(IN const BmCoreIfMessage_BtsFbWblInitialized& other) :
         BmCoreIfMessage(other),
         _requestResult(other._requestResult)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsFbWblInitialized: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsFbWblInitialized::~BmCoreIfMessage_BtsFbWblInitialized()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsFbWblInitialized: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsFbWblInitialized& first, BmCoreIfMessage_BtsFbWblInitialized& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._requestResult, second._requestResult);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsFbWblInitialized& BmCoreIfMessage_BtsFbWblInitialized::operator=(BmCoreIfMessage_BtsFbWblInitialized other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsFbWblInitialized::operator==(const BmCoreIfMessage_BtsFbWblInitialized& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_requestResult == rhs._requestResult));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsFbWblInitialized::clone(void) const
   {
      return new BmCoreIfMessage_BtsFbWblInitialized(*this);
   }

   void BmCoreIfMessage_BtsFbWblInitialized::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] requestResult = %d",
            (const void*) this, ETG_CENUM(BTSRequestResult, _requestResult)));
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsWblServiceAvailability::BmCoreIfMessage_BtsWblServiceAvailability() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_WBL_SERVICE_AVAILABILITY, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF), _wblServiceAvailable(false)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblServiceAvailability: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblServiceAvailability::BmCoreIfMessage_BtsWblServiceAvailability(IN const bool wblServiceAvailable,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_WBL_SERVICE_AVAILABILITY, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
               _wblServiceAvailable(wblServiceAvailable)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblServiceAvailability: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblServiceAvailability::BmCoreIfMessage_BtsWblServiceAvailability(IN const BmCoreIfMessage_BtsWblServiceAvailability& other) :
         BmCoreIfMessage(other),
         _wblServiceAvailable(other._wblServiceAvailable)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblServiceAvailability: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblServiceAvailability::~BmCoreIfMessage_BtsWblServiceAvailability()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblServiceAvailability: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsWblServiceAvailability& first, BmCoreIfMessage_BtsWblServiceAvailability& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._wblServiceAvailable, second._wblServiceAvailable);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsWblServiceAvailability& BmCoreIfMessage_BtsWblServiceAvailability::operator=(BmCoreIfMessage_BtsWblServiceAvailability other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsWblServiceAvailability::operator==(const BmCoreIfMessage_BtsWblServiceAvailability& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs)) && (this->_wblServiceAvailable == rhs._wblServiceAvailable));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsWblServiceAvailability::clone(void) const
   {
      return new BmCoreIfMessage_BtsWblServiceAvailability(*this);
   }

   void BmCoreIfMessage_BtsWblServiceAvailability::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsWblLastIntendedMode::BmCoreIfMessage_BtsWblLastIntendedMode() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_WBL_LAST_INTENDED_MODE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _lastIntendedModeList()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblLastIntendedMode: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblLastIntendedMode::BmCoreIfMessage_BtsWblLastIntendedMode(IN const BTSWblLastIntendedModeList& lastIntendedModeList,
         IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_WBL_LAST_INTENDED_MODE, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF),
         _lastIntendedModeList(lastIntendedModeList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblLastIntendedMode: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblLastIntendedMode::BmCoreIfMessage_BtsWblLastIntendedMode(IN const BmCoreIfMessage_BtsWblLastIntendedMode& other) :
         BmCoreIfMessage(other),
         _lastIntendedModeList(other._lastIntendedModeList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblLastIntendedMode: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblLastIntendedMode::~BmCoreIfMessage_BtsWblLastIntendedMode()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblLastIntendedMode: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsWblLastIntendedMode& first, BmCoreIfMessage_BtsWblLastIntendedMode& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._lastIntendedModeList, second._lastIntendedModeList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsWblLastIntendedMode& BmCoreIfMessage_BtsWblLastIntendedMode::operator=(BmCoreIfMessage_BtsWblLastIntendedMode other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsWblLastIntendedMode::operator==(const BmCoreIfMessage_BtsWblLastIntendedMode& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_lastIntendedModeList == rhs._lastIntendedModeList));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsWblLastIntendedMode::clone(void) const
   {
      return new BmCoreIfMessage_BtsWblLastIntendedMode(*this);
   }

   void BmCoreIfMessage_BtsWblLastIntendedMode::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsWblSupportedFrequencies::BmCoreIfMessage_BtsWblSupportedFrequencies() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_WBL_SUPPORTED_FREQUENCIES, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF), _supportedFrequenciesList()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblSupportedFrequencies: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblSupportedFrequencies::BmCoreIfMessage_BtsWblSupportedFrequencies
   (IN const BTSWblSupportedRestrictionEntryList& supportedFrequenciesList, IN const ActType act) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_WBL_SUPPORTED_FREQUENCIES, BM_RESTRICTION_GROUP_00, act,
               BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF), _supportedFrequenciesList(supportedFrequenciesList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblSupportedFrequencies: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblSupportedFrequencies::BmCoreIfMessage_BtsWblSupportedFrequencies(IN const BmCoreIfMessage_BtsWblSupportedFrequencies& other) :
         BmCoreIfMessage(other), _supportedFrequenciesList(other._supportedFrequenciesList)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblSupportedFrequencies: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblSupportedFrequencies::~BmCoreIfMessage_BtsWblSupportedFrequencies()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblSupportedFrequencies: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsWblSupportedFrequencies& first, BmCoreIfMessage_BtsWblSupportedFrequencies& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._supportedFrequenciesList, second._supportedFrequenciesList);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsWblSupportedFrequencies& BmCoreIfMessage_BtsWblSupportedFrequencies::operator=(BmCoreIfMessage_BtsWblSupportedFrequencies other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsWblSupportedFrequencies::operator==(const BmCoreIfMessage_BtsWblSupportedFrequencies& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_supportedFrequenciesList == rhs._supportedFrequenciesList));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsWblSupportedFrequencies::clone(void) const
   {
      return new BmCoreIfMessage_BtsWblSupportedFrequencies(*this);
   }

   void BmCoreIfMessage_BtsWblSupportedFrequencies::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtsWblHealthinessIndicator::BmCoreIfMessage_BtsWblHealthinessIndicator() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_WBL_HEALTHINESS_INDICATOR, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF), _wblHealthinessIndicator()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblSupportedFrequencies: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblHealthinessIndicator::BmCoreIfMessage_BtsWblHealthinessIndicator
   (IN const BTSWblHealthinessIndicator& wblHealthinessIndicator, IN const ActType act) :
   BmCoreIfMessage(BM_CORE_IF_MSG_ID_BTS_WBL_HEALTHINESS_INDICATOR, BM_RESTRICTION_GROUP_00, act,
         BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF), _wblHealthinessIndicator(wblHealthinessIndicator)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblHealthinessIndicator: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblHealthinessIndicator::BmCoreIfMessage_BtsWblHealthinessIndicator(IN const BmCoreIfMessage_BtsWblHealthinessIndicator& other) :
         BmCoreIfMessage(other), _wblHealthinessIndicator(other._wblHealthinessIndicator)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblHealthinessIndicator: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_BtsWblHealthinessIndicator::~BmCoreIfMessage_BtsWblHealthinessIndicator()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtsWblHealthinessIndicator: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_BtsWblHealthinessIndicator& first, BmCoreIfMessage_BtsWblHealthinessIndicator& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._wblHealthinessIndicator, second._wblHealthinessIndicator);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtsWblHealthinessIndicator& BmCoreIfMessage_BtsWblHealthinessIndicator::operator=(BmCoreIfMessage_BtsWblHealthinessIndicator other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtsWblHealthinessIndicator::operator==(const BmCoreIfMessage_BtsWblHealthinessIndicator& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_wblHealthinessIndicator == rhs._wblHealthinessIndicator));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtsWblHealthinessIndicator::clone(void) const
   {
      return new BmCoreIfMessage_BtsWblHealthinessIndicator(*this);
   }

   void BmCoreIfMessage_BtsWblHealthinessIndicator::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
   }

   // *****************************************************************************************

   BmCoreIfMessage_BtSystemState::BmCoreIfMessage_BtSystemState() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_BT_SYSTEM_STATE_UPDATE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_INTERNAL), _btSystemState(BM_BT_SYSTEM_STATE_OFF)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtSystemState: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtSystemState::BmCoreIfMessage_BtSystemState(IN const BtSystemState btSystemState,
		   IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
		   BmCoreIfMessage(BM_CORE_IF_MSG_ID_BT_SYSTEM_STATE_UPDATE, BM_RESTRICTION_GROUP_00, act, origin),
		   _btSystemState(btSystemState)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtSystemState: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtSystemState::BmCoreIfMessage_BtSystemState(IN const BmCoreIfMessage_BtSystemState& other) :
         BmCoreIfMessage(other), _btSystemState(other._btSystemState)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtSystemState: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_BtSystemState::~BmCoreIfMessage_BtSystemState()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_BtSystemState: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_BtSystemState& first, BmCoreIfMessage_BtSystemState& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._btSystemState, second._btSystemState);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_BtSystemState& BmCoreIfMessage_BtSystemState::operator=(BmCoreIfMessage_BtSystemState other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_BtSystemState::operator==(const BmCoreIfMessage_BtSystemState& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_btSystemState == rhs._btSystemState));
   }

   BmCoreIfMessage* BmCoreIfMessage_BtSystemState::clone(void) const
   {
      return new BmCoreIfMessage_BtSystemState(*this);
   }

   void BmCoreIfMessage_BtSystemState::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] btSystemState = %d", (const void*) this,
    		  ETG_CENUM(BluetoothSystemState, _btSystemState._bluetoothSystemState)));
   }

   // *****************************************************************************************

   // *****************************************************************************************
   // ******************** Messages corresponding to BM Core internal calls *******************
   // *****************************************************************************************

   BmCoreIfMessage_TerminateMessageHandlerThread::BmCoreIfMessage_TerminateMessageHandlerThread() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_TERMINATE_MESSAGE_HANDLER_THREAD, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_INTERNAL)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_TerminateMessageHandlerThread: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_TerminateMessageHandlerThread::BmCoreIfMessage_TerminateMessageHandlerThread(IN const BmCoreIfMessage_TerminateMessageHandlerThread& other) :
      BmCoreIfMessage(other)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_TerminateMessageHandlerThread: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_TerminateMessageHandlerThread::~BmCoreIfMessage_TerminateMessageHandlerThread()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_TerminateMessageHandlerThread: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_TerminateMessageHandlerThread& first, BmCoreIfMessage_TerminateMessageHandlerThread& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_TerminateMessageHandlerThread& BmCoreIfMessage_TerminateMessageHandlerThread::operator=(BmCoreIfMessage_TerminateMessageHandlerThread other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_TerminateMessageHandlerThread::operator==(const BmCoreIfMessage_TerminateMessageHandlerThread& rhs) const
   {
      return (BmCoreIfMessage::operator ==(rhs));
   }

   BmCoreIfMessage* BmCoreIfMessage_TerminateMessageHandlerThread::clone(void) const
   {
      return new BmCoreIfMessage_TerminateMessageHandlerThread(*this);
   }

   // *****************************************************************************************

   BmCoreIfMessage_SetDeviceRemoteConnectable::BmCoreIfMessage_SetDeviceRemoteConnectable() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_DEVICE_REMOTE_CONNECTABLE, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_INTERNAL), _deviceHandle(0u), _remoteConnectable(true)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetDeviceRemoteConnectable: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetDeviceRemoteConnectable::BmCoreIfMessage_SetDeviceRemoteConnectable(IN const DeviceId deviceHandle,
         IN const RemoteConnectable remoteConnectable, IN const ActType act, IN const BmCoreIfMsgOrigin origin) :
               BmCoreIfMessage(BM_CORE_IF_MSG_ID_SET_DEVICE_REMOTE_CONNECTABLE, BM_RESTRICTION_GROUP_00, act, origin),
               _deviceHandle(deviceHandle), _remoteConnectable(remoteConnectable)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetDeviceRemoteConnectable: [0x%p] creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetDeviceRemoteConnectable::BmCoreIfMessage_SetDeviceRemoteConnectable(IN const BmCoreIfMessage_SetDeviceRemoteConnectable& other) :
         BmCoreIfMessage(other), _deviceHandle(other._deviceHandle), _remoteConnectable(other._remoteConnectable)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetDeviceRemoteConnectable: [0x%p] copy-creating BM Core IF message object", (void*) this));
   }

   BmCoreIfMessage_SetDeviceRemoteConnectable::~BmCoreIfMessage_SetDeviceRemoteConnectable()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SetDeviceRemoteConnectable: [0x%p] destroying BM Core IF message object", (void*) this));
   }

   void swap(BmCoreIfMessage_SetDeviceRemoteConnectable& first, BmCoreIfMessage_SetDeviceRemoteConnectable& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._deviceHandle, second._deviceHandle);
      swap(first._remoteConnectable, second._remoteConnectable);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SetDeviceRemoteConnectable& BmCoreIfMessage_SetDeviceRemoteConnectable::operator=(BmCoreIfMessage_SetDeviceRemoteConnectable other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SetDeviceRemoteConnectable::operator==(const BmCoreIfMessage_SetDeviceRemoteConnectable& rhs) const
   {
      return ((BmCoreIfMessage::operator ==(rhs))
            && (this->_deviceHandle == rhs._deviceHandle)
            && (this->_remoteConnectable == rhs._remoteConnectable));
   }

   BmCoreIfMessage* BmCoreIfMessage_SetDeviceRemoteConnectable::clone(void) const
   {
      return new BmCoreIfMessage_SetDeviceRemoteConnectable(*this);
   }

   void BmCoreIfMessage_SetDeviceRemoteConnectable::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] deviceHandle = %d, remoteConnectable = %10s", (const void*) this,
            _deviceHandle, _remoteConnectable ? "true" : "false"));
   }

   // *****************************************************************************************

   BmCoreIfMessage_SmTimeout::BmCoreIfMessage_SmTimeout() :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SM_TIMEOUT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _message()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SmTimeout: [0x%p] creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SmTimeout::BmCoreIfMessage_SmTimeout(IN const char* message) :
         BmCoreIfMessage(BM_CORE_IF_MSG_ID_SM_TIMEOUT, BM_RESTRICTION_GROUP_00,
               0u, BM_CORE_IF_MSG_ORIGIN_INTERNAL),
         _message()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SmTimeout: [0x%p] creating BM Core IF message object",
            (void*) this));
      if(0 != message)
      {
         _message = message;
      }
   }

   BmCoreIfMessage_SmTimeout::BmCoreIfMessage_SmTimeout(IN const BmCoreIfMessage_SmTimeout& other) :
         BmCoreIfMessage(other),
         _message(other._message)
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SmTimeout: [0x%p] copy-creating BM Core IF message object",
            (void*) this));
   }

   BmCoreIfMessage_SmTimeout::~BmCoreIfMessage_SmTimeout()
   {
      ETG_TRACE_USR1(("BmCoreIfMessage_SmTimeout: [0x%p] destroying BM Core IF message object",
            (void*) this));
   }

   void swap(BmCoreIfMessage_SmTimeout& first, BmCoreIfMessage_SmTimeout& second)
   {
      using std::swap;

      swap(static_cast<BmCoreIfMessage&>(first), static_cast<BmCoreIfMessage&>(second));
      swap(first._message, second._message);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   BmCoreIfMessage_SmTimeout& BmCoreIfMessage_SmTimeout::operator=(BmCoreIfMessage_SmTimeout other)
   {
      swap(*this, other);

      return *this;
   }

   bool BmCoreIfMessage_SmTimeout::operator==(const BmCoreIfMessage_SmTimeout& rhs) const
   {
      return (BmCoreIfMessage::operator ==(rhs)
            && (this->_message == rhs._message));
   }

   BmCoreIfMessage* BmCoreIfMessage_SmTimeout::clone(void) const
   {
      return new BmCoreIfMessage_SmTimeout(*this);
   }

   void BmCoreIfMessage_SmTimeout::traceMessage(void) const
   {
      BmCoreIfMessage::traceMessage();
      ETG_TRACE_USR4(("traceMessage: [0x%p] message = %s", (const void*) this, _message.c_str()));
   }
}
